/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.steps.ExtraStepStore;
import esecurity.validator.steps.MultipleValidationStep;
import esecurity.validator.steps.SingleValidationStep;
import esecurity.validator.steps.SingleValidationStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationStep;
import esecurity.validator.steps.ValidationStepStore;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.steps.core.StepValidationLevel;
import esecurity.validator.x509status.X509StatusService;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;

public class Validator {
    private Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private LinkedList<ValidationStep> lstConstraint = new LinkedList();
    private LinkedList<ValidationStep> lstExtraConstraint = new LinkedList();
    private ValidatorConfig config = null;
    private CertDB cdb_epc;
    private CertDB cdb_grp;
    private X509StatusService statusService;

    public Validator(ValidatorConfig config, Logger callerLogger) throws CapiException {
        this.config = config;
        if (callerLogger != null) {
            this.logger = callerLogger;
        }
        ServiceLoader<ValidationStepStore> storesService = ServiceLoader.load(ValidationStepStore.class, Validator.class.getClassLoader());
        for (ValidationStepStore store : storesService) {
            this.lstConstraint.addAll(store.getSteps());
        }
        try {
            Collections.sort(this.lstConstraint);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage());
        }
        ServiceLoader<ExtraStepStore> extraStoresService = ServiceLoader.load(ExtraStepStore.class, ExtraStepStore.class.getClassLoader());
        for (ExtraStepStore store : extraStoresService) {
            this.lstExtraConstraint.addAll(store.getSteps());
        }
        try {
            Collections.sort(this.lstExtraConstraint);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage());
        }
        String name = config.getElement("certdb.file");
        String pwd = config.getElement("certdb.pwd");
        String name_grp = config.getElement("certdb_grp.file");
        String pwd_grp = config.getElement("certdb_grp.pwd");
        try {
            this.cdb_epc = CertDB.getInstance(name, pwd, false, true);
        }
        catch (CertDBException e) {
            throw new CapiException("Unable to initialize the cdb", 1003, e);
        }
        if (name_grp != null) {
            try {
                this.cdb_grp = CertDB.getInstance(name, pwd, false, true);
            }
            catch (CertDBException e) {
                throw new CapiException("Unable to initialize graphometric cdb", 1003, e);
            }
        }
        this.statusService = X509StatusService.getInstance(config, this.logger);
        this.logger.info("validator initialized");
    }

    public ValidatedDocument validate(InputHandler input, ValidationProfile profile, ValidationDate validationDate) {
        return this.validate(input, profile, validationDate, null);
    }

    public ValidatedDocument validate(InputHandler input, ValidationProfile profile, ValidationDate validationDate, EventHandlerSelector fileSelector) {
        File tmpDir = null;
        try {
            tmpDir = TmpFileUtils.createTempDirectory("vrf", null);
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        TransientDocument doc = ParserUtils.parseDoc(input, fileSelector, this.config.getNetConfiguration(), this.config.getTimeZone(), tmpDir);
        return this.validate(doc, profile, validationDate);
    }

    public ValidatedCertificate validate(Certificate cert, ValidationProfile profile, ValidationDate validationDate) {
        boolean alteredCertificate = false;
        if (cert.getValidatedChain() == null) {
            ArrayList<CertDBItem> chain = new ArrayList<CertDBItem>();
            try {
                this.buildCertificateChain(null, cert, chain);
            }
            catch (CapiException ex) {
                if (ex.getErrorCode() == 30007) {
                    alteredCertificate = true;
                }
                this.logger.error("Errore nella costruzione della catena di certificati", (Throwable)ex);
            }
            List<CertDBItem> completeChain = this.completeChainWithSignerCertificate(chain, cert);
            cert.setValidatedChain(completeChain.toArray(new CertDBItem[completeChain.size()]));
        }
        ValidatedCertificate vCertificate = ValidatedCertificate.newInstance(cert);
        vCertificate.setCertCorrupted(alteredCertificate);
        ValidationContextParameters parms = this.prepareStepParam(null, null, vCertificate, profile, validationDate);
        ValidatedCertificate certificate = this.validateCert(vCertificate, parms);
        if (certificate.getIssuer() != null) {
            this.getMessagesFromIssuer(certificate, certificate.getIssuer(), parms.getConfig().getMessageFactory(), profile);
        }
        return certificate;
    }

    public ValidatedDocument validate(TransientDocument inputDoc, ValidationProfile profile, ValidationDate validationDate) {
        return this.generateValidatedDocument(inputDoc, null, profile, validationDate);
    }

    private ValidatedDocument generateValidatedDocument(TransientDocument inputDoc, ValidatedDocument parentDoc, ValidationProfile profile, ValidationDate validationDate) {
        ValidatedDocument validatedDoc = new ValidatedDocument();
        validatedDoc.setInternalDocument(inputDoc);
        validatedDoc.setId(inputDoc.getId());
        validatedDoc.setSigned(inputDoc.isSigned());
        LinkedList<ValidatedSigner> signers = this.generateValidatedSigner(validatedDoc, inputDoc, profile, validationDate);
        validatedDoc.setSigners(signers);
        validatedDoc.setParent(parentDoc);
        this.checkDocConstraints(validatedDoc, inputDoc, inputDoc.getSignerInfo());
        validationDate = this.getValidationDateForNextStep(signers, validationDate);
        for (TransientDocument subdoc : inputDoc.getRefsDocs()) {
            ValidatedDocument subVDoc = this.generateValidatedDocument(subdoc, validatedDoc, profile, validationDate);
            validatedDoc.addSubResult(subVDoc);
            this.checkDocConstraints(subVDoc, subdoc, inputDoc.getSignerInfo());
        }
        return validatedDoc;
    }

    private ValidationDate getValidationDateForNextStep(List<ValidatedSigner> signers, ValidationDate validationDate) {
        ValidationDate vd = validationDate;
        if (signers != null && signers.size() > 0) {
            for (ValidatedSigner signer : signers) {
                ValidationDate thisVd = signer.getVerificationDate();
                if (thisVd == null || thisVd.getDateSource() == null || !thisVd.getDateSource().equals((Object)DateSource.TIMESTAMP)) continue;
                vd = thisVd;
            }
        }
        return vd;
    }

    private void checkDocConstraints(ValidatedDocument validatedDoc, TransientDocument inputDoc, List<SignatureInformation> sis) {
        if (!inputDoc.isSigned()) {
            for (ValidationStep contraint : this.lstExtraConstraint) {
                LinkedList<ValidatorMessage> messages = new LinkedList<ValidatorMessage>();
                ValidationContextParameters parms = this.prepareStepParam(inputDoc, null, null, null, null);
                if (contraint instanceof SingleValidationStep) {
                    ValidatorMessage message = ((SingleValidationStep)((Object)contraint)).check(parms);
                    if (message != null) {
                        messages.add(message);
                    }
                } else {
                    messages.addAll(((MultipleValidationStep)((Object)contraint)).checks(parms));
                }
                if (messages.isEmpty()) continue;
                validatedDoc.setMessages(messages);
            }
        } else {
            for (ValidationStep contraint : this.lstConstraint) {
                if (contraint.getType() != ValidationType.DOCUMENT) continue;
                LinkedList<ValidatorMessage> messages = new LinkedList<ValidatorMessage>();
                for (SignatureInformation si : sis) {
                    ValidationContextParameters parms = this.prepareStepParam(inputDoc, si, null, null, null);
                    if (contraint instanceof SingleValidationStep) {
                        ValidatorMessage message = ((SingleValidationStep)((Object)contraint)).check(parms);
                        if (message != null) {
                            messages.add(message);
                        }
                    } else {
                        messages.addAll(((MultipleValidationStep)((Object)contraint)).checks(parms));
                    }
                    if (messages.isEmpty()) continue;
                    validatedDoc.setMessages(messages);
                }
            }
        }
    }

    private LinkedList<ValidatedSigner> generateValidatedSigner(ValidatedDocument vDoc, TransientDocument doc, ValidationProfile profile, ValidationDate validationDate) {
        LinkedList<ValidatedSigner> ret = new LinkedList<ValidatedSigner>();
        for (SignatureInformation si : doc.getSignerInfo()) {
            ret.add(this.createValidatedSigner(vDoc, doc, si, profile, validationDate));
        }
        return ret;
    }

    private ValidationContextParameters prepareStepParam(TransientDocument doc, SignatureInformation si, ValidatedCertificate cert, ValidationProfile profile, ValidationDate validationDate) {
        ValidationContextParameters parm = new ValidationContextParameters();
        parm.setValidator(this);
        parm.setConfig(this.config);
        parm.setDoc(doc);
        parm.setSignature(si);
        parm.setCertDB(this.cdb_epc);
        if (cert != null) {
            parm.setSignerCertificate(cert);
        }
        parm.setTimeZone(this.config.getTimeZone());
        parm.setValidationDate(validationDate);
        parm.setProfile(profile);
        return parm;
    }

    private ValidatedSigner createValidatedSigner(ValidatedDocument vDoc, TransientDocument doc, SignatureInformation si, ValidationProfile profile, ValidationDate validationDate) {
        ValidatedSigner signer = new ValidatedSigner();
        signer.setContainerFormat(si.getContainerFormat());
        signer.setFormat(si.getFormat());
        signer.setRefDocs(si.getRefDocs());
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            df.setTimeZone(Constants.DEFAULT_TIMEZONE);
            signer.setSignatureDate(df.parse(si.getSignatureDate()));
        }
        catch (ParseException ex) {
            this.logger.error("Signature date parsing error: " + ex.getMessage());
        }
        signer.setSignerName(si.getSignerName());
        signer.setSignatureInformation(si);
        ValidatedCertificate cert = null;
        try {
            cert = this.validateCertForSigner(doc, si);
        }
        catch (CapiException ex) {
            cert = null;
            this.logger.error("user certificate not found");
        }
        ValidationContextParameters parms = this.prepareStepParam(doc, si, cert, profile, validationDate);
        for (RefCertificate certRef : doc.getCerts()) {
            if (certRef.getCapiCertificate() != null) {
                parms.getLstCert().add(certRef.getCapiCertificate().getInternalCert());
                continue;
            }
            try {
                Certificate capi_cert = new Certificate(certRef.getContent());
                parms.getLstCert().add(capi_cert.getInternalCert());
            }
            catch (CapiException ex) {
                this.logger.error("Errore parsing certificato verr\u00e0 ignorato");
            }
        }
        for (RefOcsp ocspRef : doc.getOcspresps()) {
            try {
                BasicOCSPResp resp = new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)DERSequence.fromByteArray((byte[])ocspRef.getContent())));
                parms.getLstOcsp().add(resp);
            }
            catch (Exception ex) {
                this.logger.error("Errore parsing ocsp verr\u00e0 ignorato");
            }
        }
        StepValidationLevel step = new StepValidationLevel();
        step.check(parms);
        if (parms.getLevelValidation() != null) {
            signer.setLevel(parms.getLevelValidation().getLevel());
        } else {
            signer.setLevel(SignatureLevel.BES);
        }
        signer.setVerificationDate(parms.getCalculatedValidationDate());
        if (cert != null) {
            ArrayList<CertDBItem> chain = new ArrayList<CertDBItem>();
            try {
                this.buildCertificateChain(parms.getLevelValidation(), cert.getCert(), chain);
            }
            catch (CapiException ex) {
                if (ex.getErrorCode() == 30007) {
                    cert.setCertCorrupted(true);
                }
                this.logger.error("Errore nella costruzione della catena di certificati", (Throwable)ex);
            }
            List<CertDBItem> completeChain = this.completeChainWithSignerCertificate(chain, cert.getCert());
            parms.getSignerCertificate().getCert().setValidatedChain(completeChain.toArray(new CertDBItem[completeChain.size()]));
        }
        if ((cert = this.validateCert(cert, parms)) != null && cert.getIssuer() != null) {
            this.getMessagesFromIssuer(cert, cert.getIssuer(), parms.getConfig().getMessageFactory(), profile);
        }
        signer.setCert(cert);
        for (ValidationStep constraint : this.lstConstraint) {
            if (constraint.getType() != ValidationType.SIGNATURE || !this.isUsableStep(constraint, parms)) continue;
            LinkedList<ValidatorMessage> messages = new LinkedList<ValidatorMessage>();
            if (constraint instanceof SingleValidationStep) {
                ValidatorMessage message = ((SingleValidationStep)((Object)constraint)).check(parms);
                if (message != null && (message.getProfile() == ValidationProfile.ALL_PROFILES || message.getProfile() == profile)) {
                    messages.add(message);
                }
            } else {
                messages.addAll(((MultipleValidationStep)((Object)constraint)).checks(parms));
            }
            StepsUtils.filterMessageByProfile(messages, parms.getProfile());
            if (messages.isEmpty()) continue;
            signer.setMessages(messages);
        }
        if (si.getCounterSignaturesInformation() != null && si.getCounterSignaturesInformation().size() > 0) {
            for (SignatureInformation csi : si.getCounterSignaturesInformation()) {
                ValidatedSigner counterSigner = this.createValidatedSigner(vDoc, doc, csi, profile, validationDate);
                signer.addCounterSigner(counterSigner);
            }
        }
        if (si.getTimeStampTokens() != null && si.getTimeStampTokens().size() > 0) {
            for (SignatureInformation tst : si.getTimeStampTokens()) {
                ValidatedSigner tstSigner = this.createValidatedSigner(vDoc, doc, tst, profile, validationDate);
                signer.addTimeStamp(tstSigner);
            }
        }
        return signer;
    }

    private List<CertDBItem> completeChainWithSignerCertificate(List<CertDBItem> chain, Certificate signingCertificate) {
        ArrayList<CertDBItem> completeChain = new ArrayList<CertDBItem>();
        try {
            if (chain.isEmpty() || !chain.get(0).getCertificate().equals(signingCertificate)) {
                CertDBItem myCert = this.cdb_epc.contains(signingCertificate.getInternalCert().getEncoded());
                if (myCert == null || !signingCertificate.getBasicConstraints()) {
                    myCert = new CertDBItem(null, signingCertificate.getInternalCert().getEncoded());
                    myCert.setSource(6);
                }
                completeChain.add(myCert);
            }
        }
        catch (CapiException | CertificateEncodingException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        completeChain.addAll(chain);
        return completeChain;
    }

    private ValidatedCertificate validateCertForSigner(TransientDocument input, SignatureInformation si) throws CapiException {
        RefCertificate cert = null;
        for (RefCertificate current : input.getCerts()) {
            if (!current.getId().equals(si.getRefsCertId())) continue;
            cert = current;
            break;
        }
        if (cert != null) {
            return ValidatedCertificate.newInstance(new Certificate(cert.getContent()));
        }
        return null;
    }

    private boolean isUsableStep(ValidationStep step, ValidationContextParameters parms) {
        StepContext context = SingleValidationStepImpl.retrieveAnnotationContext(step);
        StepOrder order = SingleValidationStepImpl.retrieveAnnotationOrder(step);
        boolean applica = false;
        if (order == null || order.order() != 0) {
            if (context != null) {
                if (parms.getSignature() != null) {
                    for (ValidationSignatureFormats tagert : context.formats()) {
                        if (tagert.getFormat() != null && tagert.getFormat() == parms.getSignature().getFormat()) {
                            applica = true;
                            continue;
                        }
                        if (tagert.getFormat() != null || tagert != ValidationSignatureFormats.ALL_SIGNATURE_FORMATS) continue;
                        applica = true;
                    }
                }
            } else {
                applica = true;
            }
        }
        return applica;
    }

    private ValidatedCertificate validateCert(ValidatedCertificate cert, ValidationContextParameters parms) {
        for (ValidationStep contraint : this.lstConstraint) {
            if (contraint.getType() != ValidationType.CERTIFICATE || !this.isUsableStep(contraint, parms)) continue;
            LinkedList<ValidatorMessage> messages = new LinkedList<ValidatorMessage>();
            if (contraint instanceof SingleValidationStep) {
                ValidatorMessage message = ((SingleValidationStep)((Object)contraint)).check(parms);
                if (message != null && (message.getProfile() == ValidationProfile.ALL_PROFILES || message.getProfile() == parms.getProfile())) {
                    messages.add(message);
                }
            } else {
                messages.addAll(((MultipleValidationStep)((Object)contraint)).checks(parms));
            }
            StepsUtils.filterMessageByProfile(messages, parms.getProfile());
            if (cert == null || messages.isEmpty()) continue;
            cert.setMessages(messages);
        }
        return cert;
    }

    private void getMessagesFromIssuer(ValidatedCertificate certificate, ValidatedCertificate issuer, MessageFactory messageFactory, ValidationProfile validationProfile) {
        if (issuer.hasMessage(ValidatorMessageEnum.EC0001_CERT_NOT_VALID) && !certificate.hasMessage(ValidatorMessageEnum.EC0001_CERT_NOT_VALID)) {
            certificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0001_CERT_NOT_VALID, validationProfile, new Object[0]));
        }
        if (issuer.hasMessage(ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID) && !certificate.hasMessage(ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID)) {
            certificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID, validationProfile, new Object[0]));
        }
        if (issuer.hasMessage(ValidatorMessageEnum.EC0006_CERT_SUSPENDED) && !certificate.hasMessage(ValidatorMessageEnum.EC0006_CERT_SUSPENDED)) {
            certificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0006_CERT_SUSPENDED, validationProfile, new Object[0]));
        }
        if (issuer.hasMessage(ValidatorMessageEnum.EC0007_CERT_REVOKED) && !certificate.hasMessage(ValidatorMessageEnum.EC0007_CERT_REVOKED)) {
            certificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0007_CERT_REVOKED, validationProfile, new Object[0]));
        }
        if (issuer.hasMessage(ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN) && !certificate.hasMessage(ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN)) {
            certificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN, validationProfile, new Object[0]));
        }
    }

    public void updateValidationDate(ValidatedDocument doc, ValidationProfile profile, ValidationDate validationDate) {
        for (ValidatedSigner signer : doc.getSigners()) {
            this.updateValidationDate(doc, signer, profile, validationDate);
        }
        this.checkDocConstraints(doc, doc.getInternalDocument(), doc.getInternalDocument().getSignerInfo());
        validationDate = this.getValidationDateForNextStep(doc.getSigners(), validationDate);
        for (ValidatedDocument subVDoc : doc.getSubResults()) {
            this.updateValidationDate(subVDoc, profile, validationDate);
        }
    }

    private void updateValidationDate(ValidatedDocument doc, ValidatedSigner signer, ValidationProfile profile, ValidationDate validationDate) {
        ValidatedCertificate cert = signer.getCert();
        ValidationContextParameters parm = this.prepareStepParam(doc.getInternalDocument(), signer.getSignatureInformation(), cert, profile, validationDate);
        for (RefCertificate certRef : doc.getInternalDocument().getCerts()) {
            if (certRef.getCapiCertificate() != null) {
                parm.getLstCert().add(certRef.getCapiCertificate().getInternalCert());
                continue;
            }
            try {
                Certificate capi_cert = new Certificate(certRef.getContent());
                parm.getLstCert().add(capi_cert.getInternalCert());
            }
            catch (CapiException ex) {
                this.logger.error("Errore parsing certificato verr\u00e0 ignorato");
            }
        }
        for (RefOcsp ocspRef : doc.getInternalDocument().getOcspresps()) {
            try {
                BasicOCSPResp resp = new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)DERSequence.fromByteArray((byte[])ocspRef.getContent())));
                parm.getLstOcsp().add(resp);
            }
            catch (Exception ex) {
                this.logger.error("Errore parsing ocsp verr\u00e0 ignorato");
            }
        }
        StepValidationLevel step = new StepValidationLevel();
        step.check(parm);
        signer.setVerificationDate(parm.getCalculatedValidationDate());
        if (cert != null) {
            cert.getMessages().clear();
            if (cert.getCert().getValidatedChain() == null) {
                ArrayList<CertDBItem> chain = new ArrayList<CertDBItem>();
                try {
                    this.buildCertificateChain(parm.getLevelValidation(), cert.getCert(), chain);
                }
                catch (CapiException ex) {
                    if (ex.getErrorCode() == 30007) {
                        cert.setCertCorrupted(true);
                    }
                    this.logger.error("Errore nella costruzione della catena di certificati", (Throwable)ex);
                }
                List<CertDBItem> completeChain = this.completeChainWithSignerCertificate(chain, cert.getCert());
                parm.getSignerCertificate().getCert().setValidatedChain(completeChain.toArray(new CertDBItem[completeChain.size()]));
            }
        }
        if ((cert = this.validateCert(cert, parm)) != null && cert.getIssuer() != null) {
            this.getMessagesFromIssuer(cert, cert.getIssuer(), parm.getConfig().getMessageFactory(), profile);
        }
        signer.getMessages().clear();
        for (ValidationStep contraint : this.lstConstraint) {
            if (contraint.getType() != ValidationType.SIGNATURE || !this.isUsableStep(contraint, parm)) continue;
            LinkedList<ValidatorMessage> messages = new LinkedList<ValidatorMessage>();
            if (contraint instanceof SingleValidationStep) {
                ValidatorMessage message = ((SingleValidationStep)((Object)contraint)).check(parm);
                if (message != null) {
                    messages.add(message);
                }
            } else {
                messages.addAll(((MultipleValidationStep)((Object)contraint)).checks(parm));
            }
            if (messages.isEmpty()) continue;
            signer.setMessages(messages);
        }
        if (signer.getCounterSigners() != null) {
            for (ValidatedSigner counterSigner : signer.getCounterSigners()) {
                this.updateValidationDate(doc, counterSigner, profile, validationDate);
            }
        }
        if (signer.getTimeStamps() != null) {
            for (ValidatedSigner tstSigner : signer.getTimeStamps()) {
                this.updateValidationDate(doc, tstSigner, profile, validationDate);
            }
        }
    }

    private void buildCertificateChain(LevelValidation levelValidation, Certificate certificate, List<CertDBItem> chain) throws CapiException {
        try {
            if (levelValidation != null && levelValidation.getLevel().compareTo(SignatureLevel.T) > 0) {
                CertDBItem[] tmpChain = levelValidation.getChain(certificate.getInternalCert());
                chain.addAll(Arrays.asList(tmpChain));
                X509Certificate root = levelValidation.getChainRootCertificate(certificate.getInternalCert());
                this.cdb_epc.onLineVerify(this.config.getNetConfiguration(), root.getEncoded(), new ArrayList<CertDBItem>());
            } else {
                this.cdb_epc.onLineVerify(this.config.getNetConfiguration(), certificate.getInternalCert().getEncoded(), chain);
            }
        }
        catch (CertificateEncodingException ex) {
            throw new CapiException("Error during certificate chain building", 30002, ex);
        }
    }

    public X509StatusService getStatusService() {
        return this.statusService;
    }
}

