/*
 * Decompiled with CFR 0.152.
 */
package esecurity.enroll;

import esecurity.enroll.bean.CertificateFields;
import esecurity.enroll.bean.GeneralNames;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.slf4j.Logger;

public class CSRUtils {
    private Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static PKCS10CertificationRequest generateCertificateRequest(Provider signature_provider, KeyPair rsaKeyPair, CertificateFields certFields, GeneralNames[] subjectAlternativeName) throws IOException, NoSuchAlgorithmException, OperatorCreationException, CapiException {
        PKCS10CertificationRequest objRet = null;
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        org.bouncycastle.asn1.x509.GeneralNames subjectAltNames = CSRUtils.generateSAN(subjectAlternativeName);
        if (subjectAltNames != null) {
            extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        }
        SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)rsaKeyPair.getPublic().getEncoded()));
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(certFields.getX500Name(), pki);
        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(64));
        builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
        if (certFields.getChallengePassword() != null) {
            DERPrintableString pw = new DERPrintableString(certFields.getChallengePassword());
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, (ASN1Encodable)new DERSet((ASN1Encodable)pw));
        }
        JcaContentSignerBuilder cs = null;
        cs = rsaKeyPair.getPublic().getAlgorithm().equals("RSA") ? new JcaContentSignerBuilder("SHA256withRSA") : new JcaContentSignerBuilder("SHA256withECDSA");
        cs.setProvider(signature_provider);
        objRet = builder.build(cs.build(rsaKeyPair.getPrivate()));
        return objRet;
    }

    private static org.bouncycastle.asn1.x509.GeneralNames generateSAN(GeneralNames[] subjectAlternativeName) throws CapiException {
        org.bouncycastle.asn1.x509.GeneralNames subjectAltNames = null;
        if (subjectAlternativeName != null && subjectAlternativeName.length > 0) {
            ArrayList<GeneralName> general_names = new ArrayList<GeneralName>();
            for (GeneralNames name : subjectAlternativeName) {
                GeneralName name2 = null;
                try {
                    if (name.getName().equals("otherName") || name.getName().equals("0")) {
                        name2 = new GeneralName(0, name.getValue());
                    } else if (name.getName().equals("rfc822Name") || name.getName().equals("1")) {
                        name2 = new GeneralName(1, name.getValue());
                    } else if (name.getName().equals("dNSName") || name.getName().equals("2")) {
                        name2 = new GeneralName(2, name.getValue());
                    } else if (name.getName().equals("x400Address") || name.getName().equals("3")) {
                        name2 = new GeneralName(3, name.getValue());
                    } else if (name.getName().equals("directoryName") || name.getName().equals("4")) {
                        name2 = new GeneralName(4, name.getValue());
                    } else if (name.getName().equals("ediPartyName") || name.getName().equals("5")) {
                        name2 = new GeneralName(5, name.getValue());
                    } else if (name.getName().equals("uniformResourceIdentifier") || name.getName().equals("6")) {
                        name2 = new GeneralName(6, name.getValue());
                    } else if (name.getName().equals("iPAddress") || name.getName().equals("7")) {
                        name2 = new GeneralName(7, name.getValue());
                    } else if (name.getName().equals("registeredID") || name.getName().equals("8")) {
                        name2 = new GeneralName(8, name.getValue());
                    }
                    if (name2 == null) {
                        throw new CapiException("Unsupported subject name: " + name.getName(), 1003);
                    }
                }
                catch (Exception ex) {
                    String msg = String.format("Unable to generate GeneralName from (%s, %s)", name.getName(), name.getValue());
                    throw new CapiException(msg, 1003, ex);
                }
                general_names.add(name2);
            }
            subjectAltNames = new org.bouncycastle.asn1.x509.GeneralNames(general_names.toArray(new GeneralName[general_names.size()]));
        }
        return subjectAltNames;
    }
}

