/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts.util;

import esecurity.dts.util.Connection;
import esecurity.dts.util.DTMPException;
import esecurity.dts.util.DTMProtocol;
import it.actalis.ellips.capi.core.CapiException;
import java.io.IOException;

public class DTMPThread
extends Thread {
    private String serverAddr;
    private int serverPort;
    private byte[] dataIn = null;
    private byte[] dataOut = null;
    private byte flag;
    private IOException ioExc = null;
    private DTMPException dtmpExc = null;
    private CapiException capiExc = null;

    public DTMPThread(String serverAddr, int serverPort, byte[] dataIn) {
        this.serverAddr = serverAddr;
        this.serverPort = serverPort;
        this.setData(dataIn);
        this.setDaemon(true);
    }

    public void setData(byte[] dataIn) {
        this.dataIn = dataIn;
    }

    @Override
    public void run() {
        try {
            this.dtmpOperation(this.dataIn);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dtmpOperation(byte[] tsReq) throws IOException {
        try (Connection conn = null;){
            conn = new Connection(this.serverAddr, this.serverPort);
            DTMProtocol p = new DTMProtocol(tsReq, 0);
            byte[] out = p.toByteArray();
            conn.write(out, true);
            p.read(conn);
            this.flag = p.getFlag();
            this.dataOut = p.getData();
            if (this.flag == 6) {
                throw new DTMPException(new String(this.dataOut));
            }
        }
    }

    public byte[] getData() throws DTMPException, IOException, CapiException {
        if (this.ioExc != null) {
            throw this.ioExc;
        }
        if (this.dtmpExc != null) {
            throw this.dtmpExc;
        }
        if (this.capiExc != null) {
            throw this.capiExc;
        }
        return this.dataOut;
    }
}

