/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts;

import esecurity.dts.DTSClient;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.tsa.TSAData;

public class DTSClientFactory {
    public static DTSClient createDTSClient(TSAData tsaData, NetworkConfig networkConfig, String requestedUrl) throws IllegalParamException {
        if (tsaData.getDtsClient() == null || tsaData.getDtsClient().isEmpty()) {
            throw new IllegalParamException("TSAData dtsClient null or empty");
        }
        String clazz = tsaData.getDtsClient();
        try {
            Class<?> dtsClient = Class.forName(clazz, false, DTSClient.class.getClassLoader());
            return (DTSClient)dtsClient.getConstructor(TSAData.class, NetworkConfig.class, String.class).newInstance(tsaData, networkConfig, requestedUrl);
        }
        catch (Exception e) {
            throw new IllegalParamException("Classloader fails for class:" + clazz + " " + e.getMessage());
        }
    }
}

