/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf.report;

import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.Version;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ReportMessageEnum;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.core.qc.PdsLocation;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pdf.report.CertificateDetailsInfo;
import it.actalis.ellips.capi.pdf.report.PDFReportPage;
import it.actalis.ellips.capi.pdf.report.PDFReportParams;
import it.actalis.ellips.capi.pdf.report.PageLink;
import it.actalis.ellips.capi.pdf.report.SummaryPageLink;
import it.actalis.ellips.capi.pdf.report.SummaryTableRow;
import it.actalis.ellips.capi.pdf.report.ValidatedSignerReport;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.Constants;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.slf4j.Logger;

public class PDFReport {
    private static final Color GREEN_BORDER = new Color(42, 134, 59);
    private static final Color GREEN_BACKGROUND = new Color(239, 249, 236);
    private static final Color RED_BORDER = new Color(213, 29, 45);
    private static final Color RED_BACKGROUND = new Color(253, 238, 242);
    private static final Color YELLOW_BORDER = new Color(244, 154, 33);
    private static final Color YELLOW_BACKGROUND = new Color(254, 246, 232);
    private static final Color BLUE_BORDER = new Color(41, 113, 174);
    private static final Color BLUE_BACKGROUND = new Color(206, 232, 255);
    private static final Color GRAY_BACKGROUND = new Color(210, 212, 209);
    private static final Color TEXT_COLOR = new Color(57, 59, 60);
    private static final Color TEXT_BLUE = new Color(57, 117, 194);
    private static final Color WHITE = new Color(255, 255, 255);
    private static final Color LIGHT_GRAY = new Color(231, 230, 230);
    private static final PDColor PD_BLUE = new PDColor(new float[]{(float)TEXT_BLUE.getRed() / 255.0f, (float)TEXT_BLUE.getGreen() / 255.0f, (float)TEXT_BLUE.getBlue() / 255.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
    private final PDRectangle PAGE_FORMAT = PDRectangle.A4;
    private final boolean IS_LANDSCAPE = false;
    private PDFont LATO_TEXT_FONT;
    private PDFont LATO_BOLD_TEXT_FONT;
    private static final float FONT_SIZE = 9.0f;
    private static final float TITLE_FONT_SIZE = 12.0f;
    private static final float DETAILS_FONT_SIZE = 12.0f;
    private static final float DETAILS_LINE_HEIGHT = 15.0f;
    private static final int SUMMARY_TABLE_MAX_ENTRY_FIRST_PAGE = 16;
    private static final float SUMMARY_TABLE_MAX_ENTRY = 18.0f;
    private final float MARGIN = 20.0f;
    private final float MARGIN_BOTTOM = 40.0f;
    private final float LEFT = 20.0f;
    private final float TOP = this.PAGE_FORMAT.getHeight() - 60.0f;
    private final float ROW_STEP = 15.0f;
    private final float COLUMN_STEP = 5.0f;
    private float cursorPosX = 0.0f;
    private float cursorPosY = 0.0f;
    private ValidatedDocument validatedDoc = null;
    private PDDocument pdfDoc = null;
    private String appName = "";
    private boolean showCapiVer = false;
    private boolean isFEAActivated = false;
    private InputStream reportLogo;
    private String validatedDocName = "";
    private MessageFactory msgfactory = null;
    private Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private SimpleDateFormat df = null;
    private LinkedList<ValidatedSignerReport> allDocsSigners = null;
    private LinkedList<ValidatedSignerReport> allDocsTimestamps = null;
    private int summaryPageNumber = 0;
    private static final int[] COL_WIDTH = new int[]{50, 50, 175, 175, 85, 30, 0, 0};
    private final HashMap<String, PDFReportPage> pageMap = new HashMap();
    private final Map<String, SummaryPageLink> linkInfos = new HashMap<String, SummaryPageLink>();
    private static final String APPENDIX_LINK_INDEX = "appendix";
    private int pageCount = 0;

    public PDFReport(PDFReportParams reportParams) {
        this.appName = reportParams.appName;
        if (!Util.isNullOrEmpty((String)reportParams.validatedDocName)) {
            if (reportParams.validatedDocName.contains(File.separator)) {
                if (reportParams.validatedDocName.endsWith(File.separator)) {
                    reportParams.validatedDocName = reportParams.validatedDocName.substring(0, reportParams.validatedDocName.length() - 1);
                }
                if (reportParams.validatedDocName.contains(File.separator)) {
                    reportParams.validatedDocName = reportParams.validatedDocName.substring(reportParams.validatedDocName.lastIndexOf(File.separator) + 1);
                }
            }
            this.validatedDocName = reportParams.validatedDocName;
        }
        this.logger = reportParams.logger;
        this.showCapiVer = reportParams.showCapiVer;
        this.isFEAActivated = reportParams.isFEAActivated;
        this.reportLogo = reportParams.reportLogo;
        try {
            this.msgfactory = new MessageFactory(reportParams.language, "reportDictionary");
        }
        catch (VolException ex) {
            this.logger.error("unable to setup the language for message factory: " + ex.getMessage());
        }
        this.df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
        try {
            this.validatedDoc = reportParams.validatedDoc;
            this.allDocsSigners = this.getAllDocSigners(this.validatedDoc, 1, reportParams.currentDocumentOnly);
            this.allDocsTimestamps = this.getAllDocTimestamps(this.validatedDoc, 1, reportParams.currentDocumentOnly);
            this.pdfDoc = new PDDocument();
            InputStream fontFile = this.getClass().getResourceAsStream("/font/Lato-Regular.ttf");
            InputStream boldFontFile = this.getClass().getResourceAsStream("/font/Lato-Bold.ttf");
            if (fontFile != null && boldFontFile != null) {
                this.LATO_TEXT_FONT = PDType0Font.load((PDDocument)this.pdfDoc, (InputStream)fontFile);
                this.LATO_BOLD_TEXT_FONT = PDType0Font.load((PDDocument)this.pdfDoc, (InputStream)boldFontFile);
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
        }
    }

    private LinkedList<ValidatedSignerReport> getAllDocSigners(ValidatedDocument document, int iLevel, boolean currentDocOnly) {
        LinkedList<ValidatedSignerReport> retList = new LinkedList<ValidatedSignerReport>();
        for (ValidatedSigner signer : document.getSignersOnly()) {
            ValidatedSignerReport sigRep = new ValidatedSignerReport(signer, iLevel);
            retList.add(sigRep);
        }
        if (currentDocOnly) {
            return retList;
        }
        for (ValidatedDocument subDoc : document.getSubResults()) {
            retList.addAll(this.getAllDocSigners(subDoc, ++iLevel, currentDocOnly));
        }
        return retList;
    }

    private LinkedList<ValidatedSignerReport> getAllDocTimestamps(ValidatedDocument document, int iLevel, boolean currentDocOnly) {
        LinkedList<ValidatedSignerReport> retList = new LinkedList<ValidatedSignerReport>();
        for (ValidatedSigner ts : document.getTimeStampsOnly()) {
            ValidatedSignerReport sigRep = new ValidatedSignerReport(ts, iLevel);
            retList.add(sigRep);
        }
        if (currentDocOnly) {
            return retList;
        }
        for (ValidatedDocument subDoc : document.getSubResults()) {
            retList.addAll(this.getAllDocTimestamps(subDoc, iLevel++, currentDocOnly));
        }
        return retList;
    }

    private float resetXPos() {
        this.cursorPosX = 20.0f;
        return this.cursorPosX;
    }

    private float resetYPos() {
        this.cursorPosY = this.TOP;
        return this.cursorPosY;
    }

    private float prevXPos() {
        return this.prevXPos(5.0f);
    }

    private float prevXPos(float step) {
        if (this.cursorPosX - step >= 20.0f) {
            this.cursorPosX -= step;
        }
        return this.cursorPosX;
    }

    private float nextXPos() {
        return this.nextXPos(5.0f);
    }

    private float nextXPos(float step) {
        if (this.cursorPosX + step <= this.PAGE_FORMAT.getWidth() - 20.0f) {
            this.cursorPosX += step;
        }
        return this.cursorPosX;
    }

    private float prevYPos() {
        return this.prevYPos(15.0f);
    }

    private float prevYPos(float step) {
        if (this.cursorPosY + step <= this.PAGE_FORMAT.getHeight() - 40.0f) {
            this.cursorPosY += step;
        }
        return this.cursorPosY;
    }

    private float nextYPos() {
        return this.nextYPos(15.0f);
    }

    private float nextYPos(float step) {
        if (this.cursorPosY - step >= 40.0f) {
            this.cursorPosY -= step;
        }
        return this.cursorPosY;
    }

    public boolean createPdfReportFull() {
        this.resetXPos();
        this.cursorPosY = this.TOP - 7.5f - this.LATO_TEXT_FONT.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 12.0f / 4.0f;
        return this.createPdfReportFullSignatureFile();
    }

    private boolean createPdfReportFullSignatureFile() {
        try {
            boolean bSummaryOk = this.addSummary();
            boolean bDetailsOk = this.addDetails();
            boolean bAppendixOk = this.addAppendix();
            this.linkPages();
            return bSummaryOk && bDetailsOk && bAppendixOk;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return false;
        }
    }

    private boolean addSummary() {
        try {
            PDFReportPage page = this.appendPageWithHeaderAndPageNumber();
            if (this.reportLogo != null) {
                page.getContentStream().drawForm(this.loadPdfImage(this.reportLogo, this.cursorPosX, this.cursorPosY - 30.0f, 1.5, 1.5));
            }
            this.cursorPosY = page.getPDPage().getMediaBox().getHeight() - 70.0f;
            ArrayList<SummaryTableRow> summaryTableRows = new ArrayList<SummaryTableRow>();
            this.summaryPageNumber = 1;
            for (ValidatedSignerReport signerReport : this.allDocsTimestamps) {
                ++this.summaryPageNumber;
                this.printSummaryRow(signerReport.getSigner(), summaryTableRows, String.format("%d", signerReport.getTreeLevel()));
            }
            for (ValidatedSignerReport signerReport : this.allDocsSigners) {
                ++this.summaryPageNumber;
                this.printSummaryRow(signerReport.getSigner(), summaryTableRows, String.format("%d", signerReport.getTreeLevel()));
            }
            this.drawSummary(summaryTableRows, page);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    private void printSummaryRow(ValidatedSigner signer, List<SummaryTableRow> summaryTableRows, String treeLevel) {
        int page = this.summaryPageNumber;
        int signerMaxChar = 35;
        int caMaxChar = 40;
        String signerName = signer.getSignerName();
        if (signerName != null) {
            if (signerName.equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                signerName = "";
            }
            if (signerName.length() > 35) {
                signerName = signerName.substring(0, 35) + "...";
            }
        }
        String[] CAname = null;
        try {
            if (signer.getCert() != null) {
                CAname = signer.getCert().getCert().getIssuerDNAttribute("commonname");
            }
        }
        catch (CapiException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        String issuerName = "";
        if (CAname != null && CAname.length > 0 && (issuerName = CAname[0]).length() > 40) {
            issuerName = issuerName.substring(0, 40) + "...";
        }
        summaryTableRows.add(new SummaryTableRow(signer, treeLevel, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0069_SIGNATURE, new Object[0]), signerName, issuerName, this.getSignerLevel(signer).name(), page++, 0, "SIGN"));
        for (ValidatedSigner ts : signer.getTimeStamps()) {
            String tsSignerName = ts.getSignerName();
            if (tsSignerName != null && tsSignerName.equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                tsSignerName = "";
            }
            if (tsSignerName.length() > 35) {
                tsSignerName = tsSignerName.substring(0, 35) + "...";
            }
            String TSTCAname = "";
            if (signer.getCert() != null && signer.getCert().getIssuer() != null && signer.getCert().getIssuer().getCert() != null && (TSTCAname = signer.getCert().getIssuer().getCert().getName()).length() > 40) {
                TSTCAname = TSTCAname.substring(0, 40) + "...";
            }
            ++this.summaryPageNumber;
            summaryTableRows.add(new SummaryTableRow(ts, treeLevel, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0070_TIMESTAMP, new Object[0]), tsSignerName, TSTCAname, this.getSignerLevel(ts).name(), page++, 1, "TST"));
        }
        for (int iSub = 0; iSub < signer.getCounterSigners().size(); ++iSub) {
            String subTreeLevel = String.format("%s.%d", treeLevel, iSub + 1);
            ++this.summaryPageNumber;
            this.printSummaryRow((ValidatedSigner)signer.getCounterSigners().get(iSub), summaryTableRows, subTreeLevel);
        }
    }

    private boolean addDetails() {
        boolean bRet = true;
        for (ValidatedSignerReport signerReport : this.allDocsTimestamps) {
            bRet &= this.addDetailPage(signerReport.getSigner());
        }
        for (ValidatedSignerReport signerReport : this.allDocsSigners) {
            bRet &= this.addDetailPage(signerReport.getSigner());
        }
        return bRet;
    }

    private void adjustSummaryLink(String linkInfoKey) throws IOException {
        SummaryPageLink linkInfo = this.linkInfos.get(linkInfoKey);
        String pageString = Integer.toString(this.pdfDoc.getNumberOfPages());
        linkInfo.getLink().setDestinationPage(pageString);
        float textTWidth = this.LATO_BOLD_TEXT_FONT.getStringWidth(pageString) / 1000.0f * 9.0f;
        linkInfo.setxPos(linkInfo.getxPos() - textTWidth);
        linkInfo.getLink().getRectangle().setLowerLeftX(linkInfo.getLink().getRectangle().getLowerLeftX() - textTWidth);
    }

    private boolean addDetailPage(ValidatedSigner signer) {
        try (PDFReportPage page = this.appendPageWithHeaderAndPageNumber();){
            this.adjustSummaryLink(Integer.toString(signer.hashCode()));
            String signerName = signer.getSignerName();
            if (signerName != null && signerName.equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                signerName = "";
            }
            this.cursorPosY = page.getPDPage().getMediaBox().getHeight() - 50.0f;
            this.writeText(page, signerName, this.LATO_TEXT_FONT, 16.0f, this.resetXPos(), this.cursorPosY);
            this.nextYPos();
            this.nextYPos();
            String resultText = signer.getFormat().equals((Object)SignatureFormat.TST) ? this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0062_RESULT_MARK, new Object[0]) : this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0063_RESULT_SIGNATURE, new Object[0]);
            float textWidth = this.calculateTextWidth(resultText, this.LATO_TEXT_FONT, 14.0f);
            this.writeText(page, resultText, this.LATO_TEXT_FONT, 14.0f, this.cursorPosX, this.cursorPosY);
            this.drawResultImage(this.getSignerLevel(signer).name(), page, this.cursorPosX + textWidth + 20.0f, this.cursorPosY - 2.0f);
            page.getContentStream().setNonStrokingColor(TEXT_COLOR);
            this.nextYPos();
            if (this.isFEAActivated) {
                this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0061_FEA_ACTIVE, new Object[0]), this.LATO_BOLD_TEXT_FONT, 9.0f, this.cursorPosX, this.cursorPosY - 12.0f);
            }
            this.writeSignerMessages(signer.getMessages(), page);
            if (signer.getCert() != null) {
                this.writeSignerMessages(signer.getCert().getMessages(), page);
            }
            if (signer.getFormat().equals((Object)SignatureFormat.TST)) {
                boolean found = false;
                for (ValidatorMessage vm : signer.getMessages()) {
                    if (!ValidatorMessageEnum.IS0013_MARK_DETAILS.getCode().equals(vm.getMessageCode())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.resetXPos();
                    String tsSignerName = signer.getSignerName();
                    if (tsSignerName != null && tsSignerName.equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                        tsSignerName = "";
                    }
                    this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0026_TIMESTAMP_DETAILS, new Object[0]), this.LATO_BOLD_TEXT_FONT, 9.0f, this.cursorPosX, this.nextYPos());
                    this.nextXPos();
                    this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0027_TIMESTAMP_ISSUING_DATE, new Object[0]) + ": " + this.df.format(signer.getSignatureDate()), this.LATO_TEXT_FONT, 9.0f, this.cursorPosX, this.nextYPos());
                    this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0028_TSA, new Object[0]) + ": " + tsSignerName, this.LATO_TEXT_FONT, 9.0f, this.cursorPosX, this.nextYPos());
                    if (signer.getCert() != null) {
                        this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0029_HASH_ALGORTHM, new Object[0]) + ": " + signer.getCert().getCert().getInternalCert().getSigAlgName(), this.LATO_TEXT_FONT, 9.0f, this.cursorPosX, this.nextYPos());
                        this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0030_EIDAS_COMPLIANT, new Object[0]) + ": " + (signer.getCert().getCert().isCompliant() ? "YES" : "NO"), this.LATO_TEXT_FONT, 9.0f, this.cursorPosX, this.nextYPos());
                    }
                    this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0031_ACCURACY, new Object[0]) + ": " + this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0032_MILLISECONDS, new Object[0]), this.LATO_TEXT_FONT, 9.0f, this.cursorPosX, this.nextYPos());
                    this.nextYPos();
                }
            }
            this.resetXPos();
            this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0012_CERTIFICATE_DETAILS, new Object[0]), this.LATO_BOLD_TEXT_FONT, 12.0f, this.cursorPosX, this.nextYPos());
            this.nextYPos();
            if (signer.getCert() != null) {
                this.writeCertificateDetails(page, signer);
            } else {
                this.nextXPos();
                if (signer.getFormat().equals((Object)SignatureFormat.TST)) {
                    this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0048_TIMESTAMP_WITHOUT_CERTIFICATE, new Object[0]), this.LATO_TEXT_FONT, 12.0f, this.cursorPosX, this.nextYPos());
                }
            }
            for (ValidatedSigner ts : signer.getTimeStamps()) {
                this.addDetailPage(ts);
            }
            for (ValidatedSigner counterSigner : signer.getCounterSigners()) {
                this.addDetailPage(counterSigner);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        catch (Exception e1) {
            this.logger.error(e1.getMessage());
            return false;
        }
        return true;
    }

    private void writeCertificateDetails(PDFReportPage page, ValidatedSigner signer) throws CapiException, IOException {
        PDFReportPage currentPage = page;
        this.nextYPos();
        ArrayList<CertificateDetailsInfo> certDetailsInfos = new ArrayList<CertificateDetailsInfo>();
        certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0013_CN, new Object[0]) + ": ", signer.getCert().getCert().getSubjectCommonName()));
        certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0014_SERIAL, new Object[0]) + ": ", signer.getCert().getCertSerial()));
        if (signer.getCert().getCert().getSubjectOrganization() != null && signer.getCert().getCert().getSubjectOrganization().length > 0) {
            certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0015_ORGANIZATION, new Object[0]) + ": ", signer.getCert().getCert().getSubjectOrganization()[0]));
        }
        if (signer.getCert().getCert().getSubjectCountry() != null && signer.getCert().getCert().getSubjectCountry().length > 0) {
            certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0016_NATION, new Object[0]) + ": ", signer.getCert().getCert().getSubjectCountry()[0]));
        }
        if (signer.getCert().getCert().getSubjectSerialNumber() != null && signer.getCert().getCert().getSubjectSerialNumber().length > 0) {
            certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0017_NATIONALID, new Object[0]) + ": ", signer.getCert().getCert().getSubjectSerialNumber()[0]));
        }
        certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0008_ISSUER, new Object[0]) + ": ", signer.getCert().getCertIssuer()));
        certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0019_KEYUSAGE, new Object[0]) + ": ", signer.getCert().getCert().keyUsageToString(signer.getCert().getCert().getKeyUsage())));
        String policiesLabel = this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0020_POLICIES, new Object[0]) + ": ";
        String[] policies = signer.getCert().getCert().getPolicies(',');
        StringBuilder sb = new StringBuilder();
        for (String policie : policies) {
            sb.append(policie);
        }
        certDetailsInfos.add(new CertificateDetailsInfo(policiesLabel, sb.toString()));
        certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0021_VALIDITY, new Object[0]) + ": ", String.format("%s %s %s %s", this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0022_FROM, new Object[0]), signer.getCert().getCert().getValidityNotBefore("dd/MM/yyyy HH:mm:ss zzz", "UTC"), this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0023_TO, new Object[0]), signer.getCert().getCert().getValidityNotAfter("dd/MM/yyyy HH:mm:ss zzz", "UTC"))));
        if (signer.getCert().getCert().isSSCD()) {
            certDetailsInfos.add(new CertificateDetailsInfo("", this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0037_QC_SSCD, new Object[0])));
        }
        if (signer.getCert().getCert().getQcStatementLimitValue() != null) {
            certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0035_QC_LIMIT, new Object[0]) + ": ", signer.getCert().getCert().getQcStatementLimitValue()));
        }
        if (signer.getCert().getCert().getQcStatementRetention() != null) {
            certDetailsInfos.add(new CertificateDetailsInfo(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0036_QC_RETENTION, new Object[0]) + ": ", signer.getCert().getCert().getQcStatementRetention() + " " + this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0034_YEARS, new Object[0])));
        }
        if (signer.getCert().getCert().getQcStatementType() != null) {
            for (String qcType : signer.getCert().getCert().getQcStatementType()) {
                if (qcType.endsWith("0.4.0.1862.1.6.1")) {
                    certDetailsInfos.add(new CertificateDetailsInfo("", this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0039_QC_TYPE_0_4_0_1862_1_6_1, new Object[0])));
                    continue;
                }
                if (qcType.endsWith("0.4.0.1862.1.6.2")) {
                    certDetailsInfos.add(new CertificateDetailsInfo("", this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0040_QC_TYPE_0_4_0_1862_1_6_2, new Object[0])));
                    continue;
                }
                if (!qcType.endsWith("0.4.0.1862.1.6.3")) continue;
                certDetailsInfos.add(new CertificateDetailsInfo("", this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0041_QC_TYPE_0_4_0_1862_1_6_3, new Object[0])));
            }
        }
        ArrayList<PDFReportPage> pageToClose = new ArrayList<PDFReportPage>();
        for (CertificateDetailsInfo cdi : certDetailsInfos) {
            if (!this.isCertificateDetailTextFits(page, cdi.getKey(), cdi.getValue())) {
                currentPage = this.addNewCertificateDetailsPage();
                pageToClose.add(currentPage);
            }
            this.writeCertificateDetail(cdi.getKey(), cdi.getValue(), currentPage);
        }
        if (signer.getCert().getCert().getQcPdsLocation() != null) {
            if (this.cursorPosY - 15.0f * (float)(signer.getCert().getCert().getQcPdsLocation().size() + 1) < 40.0f) {
                currentPage = this.addNewCertificateDetailsPage();
                pageToClose.add(currentPage);
            }
            this.writeText(currentPage, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0038_QC_PKI, new Object[0]) + ": ", this.LATO_BOLD_TEXT_FONT, 12.0f, this.cursorPosX, this.cursorPosY);
            this.nextYPos();
            this.nextXPos();
            for (PdsLocation pdsLocation : signer.getCert().getCert().getQcPdsLocation()) {
                this.writeText(currentPage, "- (" + pdsLocation.getLanguage() + ") " + pdsLocation.getUrl(), this.LATO_TEXT_FONT, 12.0f, this.cursorPosX, this.cursorPosY);
                this.nextYPos();
            }
            this.prevXPos();
        }
        for (PDFReportPage pg : pageToClose) {
            pg.close();
        }
    }

    private PDFReportPage addNewCertificateDetailsPage() throws IOException {
        PDFReportPage page = this.appendPageWithHeaderAndPageNumber();
        this.cursorPosY = page.getPDPage().getMediaBox().getHeight() - 70.0f;
        return page;
    }

    private boolean isCertificateDetailTextFits(PDFReportPage page, String key, String value) throws IOException {
        float textWidth = this.calculateTextWidth(key, this.LATO_BOLD_TEXT_FONT, 12.0f);
        List<String> lines = this.wrapText(value, this.LATO_TEXT_FONT, 12.0f, page.getPDPage().getMediaBox().getWidth() - this.cursorPosX - textWidth - 20.0f);
        float finalCursorPosY = this.cursorPosY - 15.0f * (float)lines.size();
        return finalCursorPosY >= 40.0f;
    }

    private void writeCertificateDetail(String key, String value, PDFReportPage page) throws IOException {
        float textWidth = this.calculateTextWidth(key, this.LATO_BOLD_TEXT_FONT, 12.0f);
        this.writeText(page, key, this.LATO_BOLD_TEXT_FONT, 12.0f, this.cursorPosX, this.cursorPosY);
        int lines = this.writeMultipleLineText(page, value, this.LATO_TEXT_FONT, 12.0f, this.cursorPosX + textWidth, this.cursorPosY, page.getPDPage().getMediaBox().getWidth() - this.cursorPosX - textWidth - 20.0f, 15.0f);
        this.nextYPos(15.0f * (float)lines);
    }

    private void writeSignerMessages(List<ValidatorMessage> messageList, PDFReportPage page) throws IOException {
        for (ValidatorMessage msg : messageList) {
            this.nextYPos(45.0f);
            this.resetXPos();
            this.drawResult(msg, page);
            this.nextXPos(20.0f);
            int lines = this.writeMultipleLineText(page, msg.getMessage(), this.LATO_BOLD_TEXT_FONT, 12.0f, this.cursorPosX, this.cursorPosY, this.PAGE_FORMAT.getWidth() - this.cursorPosX - 20.0f, 15.0f);
            this.nextYPos(15.0f * (float)lines);
            this.nextYPos(10.0f);
            for (ValidatorMessage note : msg.getNotes()) {
                this.writeSignerNotes(note, page);
            }
        }
    }

    private void writeSignerNotes(ValidatorMessage note, PDFReportPage page) {
        int lines = this.writeMultipleLineText(page, note.getMessage(), this.LATO_TEXT_FONT, 12.0f, this.cursorPosX, this.cursorPosY, this.PAGE_FORMAT.getWidth() - this.cursorPosX - 20.0f, 15.0f);
        this.nextXPos(20.0f);
        this.nextYPos(15.0f * (float)lines);
        for (ValidatorMessage subNote : note.getNotes()) {
            this.writeSignerNotes(subNote, page);
        }
        this.prevXPos(20.0f);
    }

    private void drawResult(ValidatorMessage msg, PDFReportPage page) throws IOException {
        int fixedMargin = 5;
        switch (msg.getLevel()) {
            case INFO: {
                if (this.isFEAActivated) {
                    page.getContentStream().drawForm(this.loadPdfImage("/report/successBlue.pdf", this.cursorPosX, this.cursorPosY - (float)fixedMargin, 0.05, 0.05));
                    break;
                }
                page.getContentStream().drawForm(this.loadPdfImage("/report/success.pdf", this.cursorPosX, this.cursorPosY - (float)fixedMargin, 0.05, 0.05));
                break;
            }
            case ERROR: {
                page.getContentStream().drawForm(this.loadPdfImage("/report/error.pdf", this.cursorPosX, this.cursorPosY - (float)fixedMargin, 0.35, 0.35));
                break;
            }
            case WARNING: {
                page.getContentStream().drawForm(this.loadPdfImage("/report/warning.pdf", this.cursorPosX, this.cursorPosY - (float)fixedMargin, 0.05, 0.05));
            }
        }
    }

    private PDFormXObject loadPdfImage(String img, float xPos, float yPos, double sx, double sy) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(img);
        return this.loadPdfImage(is, xPos, yPos, sx, sy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFormXObject loadPdfImage(InputStream img, float xPos, float yPos, double sx, double sy) throws IOException {
        ScratchFile SCRATCH_FILE_TEMP = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
        RandomAccess pdfFileBuffer = SCRATCH_FILE_TEMP.createBuffer(img);
        PDFParser parser = new PDFParser((RandomAccessRead)pdfFileBuffer, SCRATCH_FILE_TEMP);
        PDPage sourcePage = parser.parse().getPage(0);
        InputStream srcIS = sourcePage.getContents();
        PDFormXObject xform = new PDFormXObject(this.pdfDoc);
        OutputStream os = xform.getStream().createOutputStream();
        try {
            IOUtils.copy((InputStream)srcIS, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((Closeable)os);
            IOUtils.closeQuietly((Closeable)srcIS);
        }
        xform.setResources(sourcePage.getResources());
        xform.setBBox(sourcePage.getBBox());
        AffineTransform transform = AffineTransform.getTranslateInstance(xPos, yPos);
        transform.scale(sx, sy);
        xform.setMatrix(transform);
        return xform;
    }

    private boolean addAppendix() {
        try (PDFReportPage page = this.appendPageWithHeaderAndPageNumber();){
            this.resetXPos();
            this.resetYPos();
            this.adjustSummaryLink(APPENDIX_LINK_INDEX);
            this.nextYPos(50.0f);
            this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0004_APPENDIX_A, new Object[0]), this.LATO_TEXT_FONT, 16.0f, this.cursorPosX, this.cursorPosY);
            this.nextYPos();
            page.getContentStream().setNonStrokingColor(LIGHT_GRAY);
            page.getContentStream().moveTo(this.cursorPosX, this.cursorPosY);
            page.getContentStream().lineTo(this.PAGE_FORMAT.getWidth() - 20.0f, this.cursorPosY);
            page.getContentStream().fill();
            page.getContentStream().setNonStrokingColor(TEXT_COLOR);
            this.nextYPos();
            this.nextYPos();
            this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0042_ROOT_AUTHORITIES_CERTIFICATES, new Object[0]), this.LATO_TEXT_FONT, 16.0f, this.cursorPosX, this.cursorPosY);
            this.nextYPos();
            HashMap<String, ValidatedCertificate> rootCertificates = new HashMap<String, ValidatedCertificate>();
            for (ValidatedSignerReport signerReport : this.allDocsSigners) {
                this.getAllRootCertificates(signerReport.getSigner(), rootCertificates);
            }
            for (ValidatedCertificate rootCert : rootCertificates.values()) {
                this.nextYPos(42.0f);
                this.writeText(page, rootCert.getCertName(), this.LATO_BOLD_TEXT_FONT, 13.0f, this.cursorPosX, this.cursorPosY);
                this.nextYPos(28.0f);
                this.writeCertificateDetail(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0014_SERIAL, new Object[0]) + ": ", rootCert.getCertSerial(), page);
                if (rootCert.getCert().getSubjectOrganization() != null && rootCert.getCert().getSubjectOrganization().length > 0) {
                    this.writeCertificateDetail(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0015_ORGANIZATION, new Object[0]) + ": ", rootCert.getCert().getSubjectOrganization()[0], page);
                }
                if (rootCert.getCert().getSubjectCountry() != null && rootCert.getCert().getSubjectCountry().length > 0) {
                    this.writeCertificateDetail(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0016_NATION, new Object[0]) + ": ", rootCert.getCert().getSubjectCountry()[0], page);
                }
                if (rootCert.getCert().getSubjectSerialNumber() != null && rootCert.getCert().getSubjectSerialNumber().length > 0) {
                    this.writeCertificateDetail(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0017_NATIONALID, new Object[0]) + ": ", rootCert.getCert().getSubjectSerialNumber()[0], page);
                }
                this.writeCertificateDetail(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0019_KEYUSAGE, new Object[0]) + ": ", rootCert.getCert().keyUsageToString(rootCert.getCert().getKeyUsage()), page);
                this.writeCertificateDetail(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0008_ISSUER, new Object[0]) + ": ", rootCert.getCert().getIssuerDN(), page);
                String validity = String.format("%s %s %s %s", this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0022_FROM, new Object[0]), rootCert.getCert().getValidityNotBefore("dd/MM/yyyy HH:mm:ss zzz", "UTC"), this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0023_TO, new Object[0]), rootCert.getCert().getValidityNotAfter("dd/MM/yyyy HH:mm:ss zzz", "UTC"));
                this.writeCertificateDetail(this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0021_VALIDITY, new Object[0]) + ": ", validity, page);
                this.nextYPos();
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        catch (Exception e1) {
            this.logger.error(e1.getMessage());
            return false;
        }
        return true;
    }

    private void getAllRootCertificates(ValidatedSigner signer, HashMap<String, ValidatedCertificate> rootCertificates) {
        ValidatedCertificate cert = signer.getCert();
        if (cert != null) {
            while (cert.getIssuer() != null) {
                cert = cert.getIssuer();
                rootCertificates.put(cert.getCertSerial(), cert);
            }
        }
        for (ValidatedSigner counterSigner : signer.getCounterSigners()) {
            this.getAllRootCertificates(counterSigner, rootCertificates);
        }
        for (ValidatedSigner timeStamp : signer.getTimeStamps()) {
            this.getAllRootCertificates(timeStamp, rootCertificates);
        }
    }

    private void drawSummary(List<SummaryTableRow> summaryTableRows, PDFReportPage page) throws IOException {
        float rowHeight = 40.0f;
        float cellMargin = 5.0f;
        page.getContentStream().setFont(this.LATO_TEXT_FONT, 9.0f);
        float xPos = 25.0f;
        float yPos = this.cursorPosY;
        this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0001_FILENAME, new Object[0]), this.LATO_BOLD_TEXT_FONT, 9.0f, 25.0f, yPos);
        int nLines = this.writeMultipleLineText(page, !Util.isNullOrEmpty((String)this.validatedDocName) ? this.validatedDocName : this.validatedDoc.getShortName(), this.LATO_TEXT_FONT, 9.0f, 120.0f, yPos, this.PAGE_FORMAT.getWidth() - 120.0f);
        for (int i = 0; i < nLines; ++i) {
            yPos -= 20.0f;
        }
        this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0002_VERIFICATION_DATE, new Object[0]), this.LATO_BOLD_TEXT_FONT, 9.0f, 25.0f, yPos);
        this.writeText(page, this.df.format(((ValidatedSigner)this.validatedDoc.getSigners().get(0)).getVerificationDate().getDate()), this.LATO_TEXT_FONT, 9.0f, 120.0f, yPos);
        if (this.showCapiVer) {
            String capiVer = this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0060_VERIFIER_VER, new Object[0]);
            this.writeText(page, capiVer, this.LATO_BOLD_TEXT_FONT, 9.0f, 357.0f, yPos);
            float textWidth = this.LATO_BOLD_TEXT_FONT.getStringWidth(capiVer) / 1000.0f * 9.0f;
            this.writeText(page, String.format("%s", Version.getVersion()), this.LATO_TEXT_FONT, 9.0f, 377.0f + textWidth, yPos);
        }
        yPos -= 20.0f;
        if (this.isFEAActivated) {
            this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0061_FEA_ACTIVE, new Object[0]), this.LATO_BOLD_TEXT_FONT, 9.0f, 25.0f, yPos);
            yPos -= 40.0f;
        } else {
            yPos -= 20.0f;
        }
        this.drawSignaturesTable(page, 25.0f, yPos, 40.0f, summaryTableRows);
    }

    private void drawSignaturesTable(PDFReportPage page, float leftXPos, float yPos, float rowHeight, List<SummaryTableRow> summaryTableRows) throws IOException {
        String[] tableHeader = new String[]{this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0006_SIGNATURE_TREE_LEVEL, new Object[0]), this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0068_TYPE, new Object[0]), this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0007_SIGNER, new Object[0]), this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0008_ISSUER, new Object[0]), this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0010_RESULT, new Object[0]), this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0009_PAGE, new Object[0]), "0", ""};
        this.drawSummaryTableHeader(page, tableHeader, leftXPos, yPos);
        yPos -= rowHeight / 2.0f + 5.0f;
        int currentRowInPage = 0;
        for (SummaryTableRow tableRow : summaryTableRows) {
            if (this.isSummaryTableFull(currentRowInPage)) {
                currentRowInPage = 0;
                page = this.appendPageWithHeaderAndPageNumber();
                yPos = page.getPDPage().getMediaBox().getHeight() - 70.0f;
                this.drawSummaryTableHeader(page, tableHeader, leftXPos, yPos);
                yPos -= rowHeight / 2.0f + 5.0f;
            }
            this.drawSummaryTableRow(page, tableRow, leftXPos, yPos);
            this.drawSummaryTableRowSeparator(page, yPos -= 15.0f);
            yPos -= rowHeight / 2.0f;
            ++currentRowInPage;
        }
        this.drawSummaryTableAppendixRow(page, leftXPos, yPos);
    }

    private boolean isSummaryTableFull(int rowCount) {
        return rowCount != 0 && (this.pageCount == 1 && rowCount % 16 == 0 || this.pageCount > 1 && (float)rowCount % 18.0f == 0.0f);
    }

    private void drawSummaryTableHeader(PDFReportPage page, String[] tableHeader, float xPos, float yPos) throws IOException {
        this.drawHeaderBackgroud(xPos, yPos, page);
        this.writeText(page, tableHeader[0], this.LATO_BOLD_TEXT_FONT, 9.0f, xPos, yPos + 2.0f);
        this.writeText(page, tableHeader[1], this.LATO_BOLD_TEXT_FONT, 9.0f, xPos += (float)COL_WIDTH[0], yPos + 2.0f);
        this.writeText(page, tableHeader[2], this.LATO_BOLD_TEXT_FONT, 9.0f, xPos += (float)COL_WIDTH[1], yPos + 2.0f);
        this.writeText(page, tableHeader[3], this.LATO_BOLD_TEXT_FONT, 9.0f, xPos += (float)COL_WIDTH[2], yPos + 2.0f);
        this.writeText(page, tableHeader[4], this.LATO_BOLD_TEXT_FONT, 9.0f, xPos += (float)COL_WIDTH[3], yPos + 2.0f);
        this.writeText(page, tableHeader[5], this.LATO_BOLD_TEXT_FONT, 9.0f, xPos += (float)COL_WIDTH[4], yPos + 2.0f);
    }

    private void drawSummaryTableRowSeparator(PDFReportPage page, float yPos) throws IOException {
        page.getContentStream().setNonStrokingColor(LIGHT_GRAY);
        page.getContentStream().moveTo(20.0f, yPos);
        page.getContentStream().lineTo(this.PAGE_FORMAT.getWidth(), yPos);
        page.getContentStream().fill();
        page.getContentStream().setNonStrokingColor(TEXT_COLOR);
    }

    private void drawSummaryTableRow(PDFReportPage page, SummaryTableRow tableRow, float xPos, float yPos) throws IOException {
        String counterLevel = "";
        for (int iC = 0; iC < tableRow.getIndentationLevel(); ++iC) {
            counterLevel = counterLevel + " >";
        }
        this.writeText(page, counterLevel + " " + tableRow.getLevel(), this.LATO_TEXT_FONT, 7.0f, xPos, yPos);
        this.writeText(page, tableRow.getTypeName(), this.LATO_TEXT_FONT, 7.0f, xPos += (float)COL_WIDTH[0], yPos);
        xPos += (float)COL_WIDTH[1];
        if ("TST".equals(tableRow.getType())) {
            page.getContentStream().drawForm(this.loadPdfImage("/report/mark.pdf", xPos, yPos - 7.0f, 1.25, 1.25));
        } else {
            page.getContentStream().drawForm(this.loadPdfImage("/report/sign.pdf", xPos, yPos - 7.0f, 1.25, 1.25));
        }
        this.writeMultipleLineText(page, tableRow.getSigner(), this.LATO_TEXT_FONT, 7.0f, xPos + 25.0f, yPos, (float)(COL_WIDTH[2] - 20));
        this.writeText(page, tableRow.getCa(), this.LATO_TEXT_FONT, 7.0f, xPos += (float)COL_WIDTH[2], yPos);
        this.drawResultImage(tableRow.getResult(), page, xPos += (float)COL_WIDTH[3], yPos - 3.0f);
        xPos += (float)COL_WIDTH[4];
        float textHeight = this.LATO_BOLD_TEXT_FONT.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 9.0f;
        this.linkInfos.put(Integer.toString(tableRow.getValidatedSigner().hashCode()), new SummaryPageLink(page, new PageLink(new PDRectangle(xPos += (float)COL_WIDTH[5], yPos - 2.0f, 0.0f, textHeight), page, ""), xPos, yPos));
        page.getContentStream().setNonStrokingColor(TEXT_COLOR);
    }

    private void drawSummaryTableAppendixRow(PDFReportPage page, float xPos, float yPos) {
        this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0004_APPENDIX_A, new Object[0]), this.LATO_BOLD_TEXT_FONT, 9.0f, xPos += (float)COL_WIDTH[0], yPos);
        xPos += (float)COL_WIDTH[1];
        xPos += (float)COL_WIDTH[2];
        xPos += (float)COL_WIDTH[3];
        xPos += (float)COL_WIDTH[4];
        float textHeight = this.LATO_BOLD_TEXT_FONT.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 9.0f;
        this.linkInfos.put(APPENDIX_LINK_INDEX, new SummaryPageLink(page, new PageLink(new PDRectangle(xPos += (float)COL_WIDTH[5], yPos - 2.0f, 0.0f, textHeight), page, ""), xPos, yPos));
    }

    private void drawResultImage(String level, PDFReportPage page, float xPos, float yPos) throws IOException {
        if (MessageLevel.INFO.name().equals(level)) {
            if (this.isFEAActivated) {
                this.drawOutcomeBackground(xPos, yPos, 40.0f, 12.0f, BLUE_BACKGROUND, BLUE_BORDER, page);
                page.getContentStream().setNonStrokingColor(BLUE_BORDER);
            } else {
                this.drawOutcomeBackground(xPos, yPos, 40.0f, 12.0f, GREEN_BACKGROUND, GREEN_BORDER, page);
                page.getContentStream().setNonStrokingColor(GREEN_BORDER);
            }
            this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0064_RESULT_VALID, new Object[0]), this.LATO_TEXT_FONT, 7.0f, xPos + 7.0f, yPos + 3.0f);
        } else if (MessageLevel.ERROR.name().equals(level)) {
            this.drawOutcomeBackground(xPos, yPos, 55.0f, 12.0f, RED_BACKGROUND, RED_BORDER, page);
            page.getContentStream().setNonStrokingColor(RED_BORDER);
            this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0065_RESULT_INVALID, new Object[0]), this.LATO_TEXT_FONT, 7.0f, xPos + 7.0f, yPos + 3.0f);
        } else if (MessageLevel.WARNING.name().equals(level)) {
            this.drawOutcomeBackground(xPos, yPos, 58.0f, 12.0f, YELLOW_BACKGROUND, YELLOW_BORDER, page);
            page.getContentStream().setNonStrokingColor(YELLOW_BORDER);
            this.writeText(page, this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0066_RESULT_WARNING, new Object[0]), this.LATO_TEXT_FONT, 7.0f, xPos + 7.0f, yPos + 3.0f);
        }
    }

    private void drawHeaderBackgroud(float xPos, float yPos, PDFReportPage page) throws IOException {
        PDPageContentStream contentStream = page.getContentStream();
        contentStream.setNonStrokingColor(GRAY_BACKGROUND);
        contentStream.addRect(xPos - 5.0f, yPos - 5.0f, this.PAGE_FORMAT.getWidth() - 20.0f, 20.0f);
        contentStream.fill();
        float cx = xPos;
        float cy = yPos + 10.0f;
        float r = 5.0f;
        float k = 0.5522848f;
        contentStream.setNonStrokingColor(WHITE);
        contentStream.moveTo(cx - r, cy);
        contentStream.curveTo(cx - r, cy + 0.5522848f * r, cx - 0.5522848f * r, cy + r, cx, cy + r);
        contentStream.lineTo(cx, cy + r + 5.0f);
        contentStream.lineTo(cx - r - 5.0f, cy + 5.0f + r);
        contentStream.lineTo(cx - r - 5.0f, cy);
        contentStream.lineTo(cx - r, cy);
        contentStream.fill();
        cx = xPos - 10.0f + (this.PAGE_FORMAT.getWidth() - 20.0f);
        contentStream.moveTo(cx, cy + r);
        contentStream.curveTo(cx + 0.5522848f * r, cy + r, cx + r, cy + 0.5522848f * r, cx + r, cy);
        contentStream.lineTo(cx + r + 5.0f, cy);
        contentStream.lineTo(cx + r + 5.0f, cy + r + 5.0f);
        contentStream.lineTo(cx, cy + r + 5.0f);
        contentStream.lineTo(cx, cy + r);
        contentStream.fill();
        contentStream.setNonStrokingColor(TEXT_COLOR);
    }

    private void drawOutcomeBackground(float xPos, float yPos, float width, float height, Color backgroundColor, Color borderColor, PDFReportPage page) throws IOException {
        float k = 0.5522848f;
        float r = Math.min(width, height) / 2.0f;
        float centerLeftX = xPos + r;
        float centerY = yPos + r;
        float centerRightX = xPos + width - r;
        PDPageContentStream contentStream = page.getContentStream();
        contentStream.setStrokingColor(borderColor);
        contentStream.setNonStrokingColor(backgroundColor);
        contentStream.moveTo(centerLeftX, yPos);
        contentStream.curveTo(centerLeftX - 0.5522848f * r, centerY - r, centerLeftX - r, centerY - 0.5522848f * r, centerLeftX - r, centerY);
        contentStream.curveTo(centerLeftX - r, centerY + 0.5522848f * r, centerLeftX - 0.5522848f * r, centerY + r, centerLeftX, centerY + r);
        contentStream.lineTo(centerRightX, centerY + r);
        contentStream.curveTo(centerRightX + 0.5522848f * r, centerY + r, centerRightX + r, centerY + 0.5522848f * r, centerRightX + r, centerY);
        contentStream.curveTo(centerRightX + r, centerY - 0.5522848f * r, centerRightX + 0.5522848f * r, centerY - r, centerRightX, centerY - r);
        contentStream.closeAndFillAndStroke();
        contentStream.setNonStrokingColor(TEXT_COLOR);
    }

    private void writeText(PDFReportPage page, String message, PDFont font, float fontSize, float posx, float posy) {
        if ((message = PDFReport.stripHTML(message)).isEmpty()) {
            return;
        }
        int maxCharLn = 90;
        if (message.length() > 90) {
            float width = this.PAGE_FORMAT.getWidth() - 20.0f;
            int nLines = this.writeMultipleLineText(page, message, font, fontSize, posx, posy, width);
            for (int iLn = 0; iLn < nLines - 1; ++iLn) {
                posy -= 15.0f;
                this.nextYPos();
            }
            return;
        }
        try {
            PDPageContentStream contentStream = page.getContentStream();
            contentStream.beginText();
            contentStream.moveTextPositionByAmount(posx, posy);
            contentStream.setFont(font, fontSize);
            contentStream.drawString(message);
            contentStream.endText();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }

    private static String stripHTML(String text) {
        String retStr = text;
        retStr = retStr.replace("<br>", "");
        retStr = retStr.replace("<BR>", "");
        retStr = retStr.replace("<link>", "");
        retStr = retStr.replace("<LINK>", "");
        retStr = retStr.replace("</link>", "");
        retStr = retStr.replace("</LINK>", "");
        return retStr;
    }

    private int writeMultipleLineText(PDFReportPage page, String message, PDFont font, float fontSize, float posx, float posy, float width) {
        return this.writeMultipleLineText(page, message, font, fontSize, posx, posy, width, 1.5f * fontSize);
    }

    private int writeMultipleLineText(PDFReportPage page, String message, PDFont font, float fontSize, float posx, float posy, float width, float leading) {
        try {
            List<String> lines = this.wrapText(message, font, fontSize, width);
            this.writeMultipleLineText(page, lines, font, fontSize, posx, posy, leading);
            return lines.size();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return 0;
        }
    }

    private void writeMultipleLineText(PDFReportPage page, List<String> lines, PDFont font, float fontSize, float posx, float posy, float leading) throws IOException {
        PDPageContentStream contentStream = page.getContentStream();
        contentStream.beginText();
        contentStream.setFont(font, fontSize);
        contentStream.moveTextPositionByAmount(posx, posy);
        for (String line : lines) {
            contentStream.drawString(line);
            contentStream.moveTextPositionByAmount(0.0f, -leading);
        }
        contentStream.endText();
    }

    private List<String> wrapText(String message, PDFont font, float fontSize, float width) throws IOException {
        message = PDFReport.stripHTML(message);
        ArrayList<String> lines = new ArrayList<String>();
        int lastSpace = -1;
        while (message.length() > 0) {
            String subString;
            float size;
            int spaceIndex = message.indexOf(32, lastSpace + 1);
            if (spaceIndex < 0 && (spaceIndex = message.indexOf(46, lastSpace + 1)) < 0) {
                spaceIndex = message.length();
            }
            if ((size = fontSize * font.getStringWidth(subString = message.substring(0, spaceIndex)) / 1000.0f) > width) {
                if (lastSpace < 0) {
                    lastSpace = spaceIndex;
                }
                while (fontSize * font.getStringWidth(message.substring(0, lastSpace)) / 1000.0f > width) {
                    --lastSpace;
                }
                subString = message.substring(0, lastSpace);
                lines.add(subString);
                message = message.substring(lastSpace).trim();
                lastSpace = -1;
                continue;
            }
            if (spaceIndex == message.length()) {
                lines.add(message);
                message = "";
                continue;
            }
            lastSpace = spaceIndex;
        }
        return lines;
    }

    public PDDocument getPDFDoc() {
        return this.pdfDoc;
    }

    private MessageLevel getSignerLevel(ValidatedSigner signer) {
        if (!signer.isValid()) {
            return MessageLevel.ERROR;
        }
        if (signer.hasBeanWarnings()) {
            return MessageLevel.WARNING;
        }
        return MessageLevel.INFO;
    }

    private float calculateTextWidth(String text, PDFont font, float fontSize) throws IOException {
        return font.getStringWidth(text) / 1000.0f * fontSize;
    }

    private PDFReportPage appendPageWithHeaderAndPageNumber() throws IOException {
        PDFReportPage page = new PDFReportPage(this.pdfDoc);
        ++this.pageCount;
        this.pageMap.put(Integer.toString(this.pageCount), page);
        this.insertHeader(page);
        this.insertPageNumber(page);
        return page;
    }

    private void insertHeader(PDFReportPage page) throws IOException {
        float titleHeight;
        float titleWidth;
        if (!Util.isNullOrEmpty((String)this.appName)) {
            String verifier = this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0067_VERIFIER, new Object[0]) + " " + this.appName;
            titleWidth = this.LATO_BOLD_TEXT_FONT.getStringWidth(verifier) / 1000.0f * 12.0f;
            titleHeight = this.LATO_BOLD_TEXT_FONT.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 12.0f;
            page.getContentStream().setNonStrokingColor(TEXT_COLOR);
            this.writeText(page, verifier, this.LATO_BOLD_TEXT_FONT, 12.0f, page.getPDPage().getMediaBox().getWidth() - titleWidth - 20.0f, page.getPDPage().getMediaBox().getHeight() - 10.0f - titleHeight);
        }
        String repTitle = this.msgfactory.getMessage((EsecurityMessage)ReportMessageEnum.R0005_REPORT_TITLE, new Object[0]).toUpperCase();
        titleWidth = this.LATO_TEXT_FONT.getStringWidth(repTitle) / 1000.0f * 12.0f;
        titleHeight = this.LATO_TEXT_FONT.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 12.0f;
        page.getContentStream().setNonStrokingColor(TEXT_COLOR);
        this.writeText(page, repTitle, this.LATO_TEXT_FONT, 12.0f, page.getPDPage().getMediaBox().getWidth() - titleWidth - 20.0f, page.getPDPage().getMediaBox().getHeight() - titleHeight - 10.0f - titleHeight);
    }

    private void insertPageNumber(PDFReportPage page) throws IOException {
        page.getContentStream().setNonStrokingColor(TEXT_COLOR);
        this.writeText(page, Integer.toString(this.pdfDoc.getNumberOfPages()), this.LATO_TEXT_FONT, 10.0f, this.PAGE_FORMAT.getWidth() - 20.0f, 20.0f);
    }

    private void linkPages() {
        PDBorderStyleDictionary pdbsd = new PDBorderStyleDictionary();
        pdbsd.setStyle("U");
        pdbsd.setWidth(2.0f);
        for (SummaryPageLink summaryPageLink : this.linkInfos.values()) {
            PageLink link = summaryPageLink.getLink();
            try {
                summaryPageLink.getPage().getContentStream().setNonStrokingColor(TEXT_BLUE);
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.writeText(summaryPageLink.getPage(), link.getDestinationPage(), this.LATO_BOLD_TEXT_FONT, 9.0f, summaryPageLink.getxPos(), summaryPageLink.getyPos());
            PDAnnotationLink annotationLink = new PDAnnotationLink();
            annotationLink.setBorderStyle(pdbsd);
            annotationLink.setRectangle(link.getRectangle());
            annotationLink.setColor(PD_BLUE);
            PDActionGoTo actionGoTo = new PDActionGoTo();
            PDPageXYZDestination pageDestination = new PDPageXYZDestination();
            pageDestination.setPage(this.pageMap.get(link.getDestinationPage()).getPDPage());
            actionGoTo.setDestination((PDDestination)pageDestination);
            annotationLink.setAction((PDAction)actionGoTo);
            try {
                link.getSourcePage().getPDPage().getAnnotations().add(annotationLink);
                annotationLink.constructAppearances();
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        for (SummaryPageLink summaryPageLink : this.linkInfos.values()) {
            try {
                summaryPageLink.getPage().close();
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

