/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pdf.AdditionalDictionaryInfo;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class AutenticaBinding
implements AdditionalDictionaryInfo {
    private String SP_signed;
    private byte[] Imprt_SP;
    private String versione;
    private long[] byte_range = null;
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public AutenticaBinding(String pdf_revision) throws CapiException {
        File in_file = new File(pdf_revision);
        FileInputStream is = null;
        if (in_file.exists()) {
            try {
                is = new FileInputStream(in_file);
                long dimenzione = in_file.length();
                this.byte_range = new long[2];
                this.byte_range[0] = 0L;
                this.byte_range[1] = dimenzione;
                this.Imprt_SP = Util.digestStreams((String)Constants.SHA256, (InputStream[])new InputStream[]{is});
                this.SP_signed = in_file.getName();
            }
            catch (IOException e) {
                throw new CapiException("Impossibile leggere il file", 4000);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
        throw new CapiException("File not Found", 1002);
    }

    AutenticaBinding(String SP_signed, byte[] Imprt_SP, String versione, long[] byte_range) {
        this.SP_signed = SP_signed;
        this.Imprt_SP = Imprt_SP;
        this.versione = versione;
        this.byte_range = byte_range;
    }

    public String getSP_signed() {
        return this.SP_signed;
    }

    void setSP_signed(String SP_signed) {
        this.SP_signed = SP_signed;
    }

    public byte[] getImprt_SP() {
        return this.Imprt_SP;
    }

    void setImprt_SP(byte[] Imprt_SP) {
        this.Imprt_SP = Imprt_SP;
    }

    public String getVersione() {
        return this.versione;
    }

    void setVersione(String versione) {
        this.versione = versione;
    }

    public long[] getByte_range() {
        return this.byte_range;
    }

    void setByte_range(long[] byte_range) {
        this.byte_range = byte_range;
    }

    @Override
    public COSDictionary getDictionary(long[] arr_byte_range) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public COSDictionary getDictionary() {
        COSDictionary objReturn = new COSDictionary();
        objReturn.setItem(COSName.getPDFName((String)"version"), (COSBase)new COSString("1.0.0"));
        String s_SP_signed = this.SP_signed;
        objReturn.setString("SP_signed", s_SP_signed);
        objReturn.setString("Imprt_SP", new String(Base64.encode((byte[])this.Imprt_SP)));
        if (this.byte_range.length == 2) {
            COSArray a_byte_range = new COSArray();
            a_byte_range.add((COSBase)COSInteger.get((long)this.byte_range[0]));
            a_byte_range.add((COSBase)COSInteger.get((long)this.byte_range[1]));
            objReturn.setItem("byte_range", (COSBase)a_byte_range);
        }
        return objReturn;
    }
}

