/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import esecurity.dts.TimeStampToken;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CRLException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.TempFileOutputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pades.PadesSignatureOptions;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.pades.enums.PadesCertificationLevel;
import it.actalis.ellips.capi.pades.enums.PdfProfile;
import it.actalis.ellips.capi.pdf.AutenticaBinding;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.pdf.FeaInfo;
import it.actalis.ellips.capi.pdf.GraphometricInfo;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResource;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;

public class PadesSignatureGenerator
extends SignatureGenerator<PadesSignatureOptions, PadesSignatureOptions> {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final byte[] EOF_MARKER_NO_EOL = new byte[]{37, 37, 69, 79, 70};
    private static final byte[] EOF_MARKER_UNX = new byte[]{37, 37, 69, 79, 70, 10};
    private static final byte[] EOF_MARKER_WIN = new byte[]{37, 37, 69, 79, 70, 13, 10};
    private static final int BUFFER_SIZE = 8192;
    private static final int EXTRA_BUFFER_SIZE = EOF_MARKER_WIN.length - 1;
    org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions sig_options;

    private PDDocument loadDoc(PadesSignatureOptions option, ScratchFile SCRATCH_FILE_TEMP, RandomAccessRead pdfFileBuffer) throws IOException, CapiException {
        String decryptPassword = null;
        PDFParser parser = null;
        if (option.getOwnerPassword() == null) {
            logger.debug("[initialize] decrypting password is null...");
        } else {
            logger.debug("[initialize] decrypting password is not null...");
            decryptPassword = option.getOwnerPassword();
        }
        parser = decryptPassword != null ? new PDFParser(pdfFileBuffer, decryptPassword, null, null, SCRATCH_FILE_TEMP) : new PDFParser(pdfFileBuffer, SCRATCH_FILE_TEMP);
        PDDocument document = parser.parse();
        if (document.getCurrentAccessPermission() != null && !document.getCurrentAccessPermission().canModify() && !document.getCurrentAccessPermission().canModifyAnnotations()) {
            throw new CapiException("Cannot decrypt PDF, the password is incorrect", 50004);
        }
        return document;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerSign(PadesSignatureOptions option) throws CapiException {
        ScratchFile SCRATCH_FILE_TEMP = null;
        PDDocument document = null;
        OutputStream os = null;
        InputStream is = null;
        InputHandler reopenhandler = null;
        OutputHandler temp_handler = null;
        java.io.File tempf = null;
        try {
            long eofPosition;
            SCRATCH_FILE_TEMP = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
            is = option.getInput().getInputAsNewStream();
            Long document_size = option.getInput().getTotalSize();
            os = option.getOutput().getAsOutputStream();
            RandomAccess pdfFileBuffer = SCRATCH_FILE_TEMP.createBuffer(is);
            if (document_size == null) {
                document_size = pdfFileBuffer.length();
            }
            if ((eofPosition = this.findEOFPosition((RandomAccessRead)pdfFileBuffer)) != -1L && eofPosition != document_size) {
                File tmpFile = TmpFileUtils.createTempFile((String)"toSign", (String)".pdf");
                try (FileOutputStream fos = new FileOutputStream((java.io.File)tmpFile);
                     InputStream originalStream = option.getInput().getInputAsNewStream();){
                    int readed;
                    byte[] buffer = new byte[8192];
                    long totalByte = eofPosition;
                    while ((readed = originalStream.read(buffer)) > 0 && totalByte > 0L) {
                        if ((totalByte -= (long)readed) < 0L) {
                            readed = (int)((long)readed + totalByte);
                        }
                        fos.write(buffer, 0, readed);
                    }
                }
                Util.closeQuietly((Closeable)SCRATCH_FILE_TEMP);
                SCRATCH_FILE_TEMP = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
                pdfFileBuffer = SCRATCH_FILE_TEMP.createBuffer((InputStream)new FileInputStream((java.io.File)tmpFile));
                document_size = eofPosition;
            }
            if (!this.checkPdf((RandomAccessRead)pdfFileBuffer)) throw new IOException("Il file che stato sottoposto alla firma non \u00e8 di tipo PDF");
            document = this.loadDoc(option, SCRATCH_FILE_TEMP, (RandomAccessRead)pdfFileBuffer);
            boolean bGray_apparance = false;
            if (option.isPreservePdfA()) {
                List outputIntent = document.getDocumentCatalog().getOutputIntents();
                for (PDOutputIntent oi : outputIntent) {
                    if (oi.getInfo() != null && oi.getInfo().contains("Dot Gain")) {
                        logger.debug("OutputIntent{}", (Object)oi.getInfo());
                        bGray_apparance = true;
                        break;
                    }
                    if (oi.getInfo() == null || oi.getInfo().contains("sRGB")) continue;
                    throw new CapiException("PDFA OutputIntent not supported.", 50023);
                }
            }
            LinkedList<PDSignatureField> emptySignatureFields = new LinkedList<PDSignatureField>();
            if (document.getDocumentCatalog().getAcroForm() != null) {
                if (PadesUtils.isBlockedPdf(document)) {
                    if (!logger.isDebugEnabled()) throw new CapiException("Document is certified and no changes are allowed.", 50026);
                    logger.debug("Document certified and no changes allowed");
                    throw new CapiException("Document is certified and no changes are allowed.", 50026);
                }
                for (PDField filed : document.getDocumentCatalog().getAcroForm().getFields()) {
                    emptySignatureFields.addAll(PadesUtils.parseEmptyField(filed));
                }
            }
            this.prepareSignature(document, option, document_size, emptySignatureFields, bGray_apparance);
            if (option.getSignatureLevel().compareTo((Enum)SignatureLevel.T) > 0 || option.isIncludeCertificateChain()) {
                temp_handler = DataHandlerBuilder.get().setTemp("PDF_UPDATE", ".tmp").buildOutput();
                ((TempFileOutputHandler)temp_handler).setDeleteOnClose(false);
                document.saveIncremental(temp_handler.getAsOutputStream());
                Util.closeQuietly((Closeable)SCRATCH_FILE_TEMP);
                Util.closeQuietly((Closeable)document);
                tempf = ((TempFileOutputHandler)temp_handler).getFile();
                reopenhandler = DataHandlerBuilder.get().setFile(tempf).buildInput();
                SCRATCH_FILE_TEMP = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
                pdfFileBuffer = SCRATCH_FILE_TEMP.createBuffer(reopenhandler.getInputAsNewStream());
                document = this.loadDoc(option, SCRATCH_FILE_TEMP, (RandomAccessRead)pdfFileBuffer);
                LinkedList<PadesSignatureInformation> signatures = PadesUtils.retrieveNotEmptySignatures(document);
                String index = "" + (signatures.size() - 1);
                option.setSignaturePath(index);
                this.updateSignature(reopenhandler, document, option);
                option.setSignaturePath("");
                document.saveIncremental(os);
            } else {
                document.saveIncremental(os);
            }
            os.flush();
        }
        catch (InvalidPasswordException ex) {
            try {
                throw new CapiException(ex.getMessage(), 50004, (Throwable)ex);
                catch (IOException ex2) {
                    if (ex2.getCause() != null && ex2.getCause() instanceof TSAException) {
                        throw (TSAException)ex2.getCause();
                    }
                    if (ex2.getCause() == null) throw new CapiException("Pades generation IOException: " + ex2.getMessage(), 50040);
                    if (!(ex2.getCause() instanceof CapiException)) throw new CapiException("Pades generation IOException: " + ex2.getMessage(), 50040);
                    throw (CapiException)ex2.getCause();
                }
                catch (URISyntaxException ex3) {
                    throw new CapiException("Pades generation URISyntaxException: " + ex3.getMessage(), 50040);
                }
                catch (KeyStoreException ex4) {
                    throw new CapiException("Pades generation KeyStoreException: " + ex4.getMessage(), 50040);
                }
                catch (NoSuchAlgorithmException ex5) {
                    throw new CapiException("Pades generation NoSuchAlgorithmException: " + ex5.getMessage(), 50040);
                }
                catch (UnrecoverableKeyException ex6) {
                    throw new CapiException("Pades generation UnrecoverableKeyException: " + ex6.getMessage(), 50040);
                }
                catch (KeyManagementException ex7) {
                    throw new CapiException("Pades generation KeyManagementException: " + ex7.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(SCRATCH_FILE_TEMP);
                Util.closeQuietly(document);
                Util.closeQuietly(reopenhandler);
                Util.closeQuietly(temp_handler);
                if (tempf != null && tempf.exists()) {
                    tempf.delete();
                }
                IOUtils.closeQuietly((Closeable)this.sig_options);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)SCRATCH_FILE_TEMP);
        Util.closeQuietly((Closeable)document);
        Util.closeQuietly(reopenhandler);
        Util.closeQuietly((Closeable)temp_handler);
        if (tempf != null && tempf.exists()) {
            tempf.delete();
        }
        IOUtils.closeQuietly((Closeable)this.sig_options);
    }

    private void prepareSignature(PDDocument document, PadesSignatureOptions options, Long document_size, List<PDSignatureField> emptySignatureFields, boolean bGray_apparance) throws CapiException, IOException {
        LinkedList<PadesSignatureInformation> signatures = PadesUtils.retrieveNotEmptySignatures(document);
        if ((signatures != null && signatures.size() == 0 || options.getApparence() != null) && document.getDocumentCatalog().getAcroForm() != null && document.getDocumentCatalog().getAcroForm().getNeedAppearances()) {
            document.getDocumentCatalog().getAcroForm().getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        Certificate x509Cert = this.retrieveCertCapi(options);
        if (x509Cert == null) {
            throw new CapiException("Internal error: unable to get signer X509 certificate", 1003);
        }
        String name = x509Cert.getName();
        signature.setName(name);
        if (name != null) {
            name = name.toUpperCase();
        }
        String organization = null;
        String[] organizations = x509Cert.getSubjectDNAttribute("organization");
        if (organizations != null && organizations.length > 0) {
            organization = organizations[0].toUpperCase();
        }
        String title = null;
        String[] titles = x509Cert.getSubjectDNAttribute("title");
        if (titles != null && titles.length > 0) {
            title = titles[0];
        }
        if (options.getReason() != null) {
            signature.setReason(options.getReason());
        }
        if (options.getLocation() != null) {
            signature.setLocation(options.getLocation());
        }
        if (options.getProfile() == PdfProfile.PADES) {
            signature.setSubFilter(PDSignature.SUBFILTER_ETSI_CADES_DETACHED);
        }
        Calendar cal = Calendar.getInstance();
        if (options.getSigningTime() != null) {
            cal.setTime(options.getSigningTime());
        }
        signature.setSignDate(cal);
        if (options.getAdditionalDictionaryInfo() != null) {
            long[] byte_range;
            if (options.getAdditionalDictionaryInfo() instanceof GraphometricInfo) {
                byte_range = new long[]{0L, document_size};
                COSDictionary graph = options.getAdditionalDictionaryInfo().getDictionary(byte_range);
                signature.getCOSObject().setItem("biometric_data", (COSBase)graph);
            } else if (options.getAdditionalDictionaryInfo() instanceof AutenticaBinding) {
                signature.getCOSObject().setItem("binding_dictionary", (COSBase)options.getAdditionalDictionaryInfo().getDictionary());
            } else if (options.getAdditionalDictionaryInfo() instanceof FeaInfo) {
                byte_range = new long[]{0L, document_size};
                COSDictionary feaInfo = options.getAdditionalDictionaryInfo().getDictionary(byte_range);
                signature.getCOSObject().setItem("fea_dictionary", (COSBase)feaInfo);
            } else {
                for (COSName cname : options.getAdditionalDictionaryInfo().getDictionary().keySet()) {
                    COSBase item = options.getAdditionalDictionaryInfo().getDictionary().getItem(cname);
                    signature.getCOSObject().setItem(cname, item);
                }
            }
        }
        if (options.getAssignedCertificationLevel() != PadesCertificationLevel.NOT_CERTIFIED) {
            COSDictionary sigRefDic = new COSDictionary();
            sigRefDic.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"SigRef"));
            sigRefDic.setItem(COSName.getPDFName((String)"TransformMethod"), (COSBase)COSName.getPDFName((String)"DocMDP"));
            COSDictionary transformParams = new COSDictionary();
            transformParams.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"TransformParams"));
            transformParams.setItem(COSName.getPDFName((String)"V"), (COSBase)COSName.getPDFName((String)"1.2"));
            transformParams.setInt("P", options.getAssignedCertificationLevel().getLiv());
            transformParams.setDirect(true);
            sigRefDic.setItem(COSName.getPDFName((String)"TransformParams"), (COSBase)transformParams);
            sigRefDic.setDirect(true);
            COSArray refArr = new COSArray();
            refArr.add((COSBase)sigRefDic);
            refArr.setDirect(true);
            signature.getCOSObject().setItem(COSName.getPDFName((String)"Reference"), (COSBase)refArr);
        }
        CapiPDFApparence apparence = options.getApparence();
        if (options.getFieldName() != null) {
            PDSignatureField emptyPDsig = null;
            for (int i = 0; i < emptySignatureFields.size(); ++i) {
                emptyPDsig = emptySignatureFields.get(i);
                COSString currSigName = (COSString)emptyPDsig.getCOSObject().getDictionaryObject(COSName.T);
                String tmp = "";
                if (currSigName != null && currSigName.getString() != null) {
                    tmp = currSigName.getString();
                }
                if (!options.getFieldName().equalsIgnoreCase(tmp)) continue;
                logger.debug("[addSigner] found emptySignatureFields to fill ");
                try {
                    emptyPDsig.getCOSObject().setNeedToBeUpdated(true);
                    if (emptyPDsig.getWidgets().size() > 0) {
                        if (((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle() != null) {
                            if (((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getWidth() != 0.0f || ((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getHeight() != 0.0f) {
                                emptyPDsig.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
                                if (apparence == null) {
                                    apparence = new CapiPDFApparence();
                                    apparence.setFontSize(8);
                                }
                                apparence.setPosX(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getLowerLeftX());
                                apparence.setPosY(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getUpperRightY());
                                apparence.setWidth(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getWidth());
                                apparence.setHeight(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getHeight());
                                apparence.setPage(document.getPages().indexOf(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getPage()) + 1);
                                options.setApparence(apparence);
                                break;
                            }
                            emptyPDsig.setValue(signature);
                            break;
                        }
                        emptyPDsig.setValue(signature);
                        break;
                    }
                    emptyPDsig.setValue(signature);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (apparence != null) {
            if (Util.isNullOrEmpty((String)apparence.getName())) {
                apparence.setName(name);
                apparence.setOrganization(organization);
                apparence.setTitle(title);
            }
            if (apparence.getPage() <= 0) {
                throw new CapiException("Invalid page index", 1006);
            }
            apparence.setFieldName(options.getFieldName());
            apparence.setPDFASignature(options.isPreservePdfA());
            apparence.setGray(bGray_apparance);
            apparence.setSigningTimeCal(cal);
            apparence.setLocation(options.getLocation());
            apparence.setReason(options.getReason());
            apparence.setPdDocument(document);
            options.setApparence(apparence);
        }
        this.sig_options = new org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions();
        if (apparence != null) {
            logger.debug("Adding visible Signature ....");
            try {
                this.sig_options.setVisualSignature(PadesUtils.createVisualSignature(apparence));
                this.sig_options.setPage(apparence.getPage() - 1);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (document.getDocumentId() == null) {
            try {
                int bytesRead;
                MessageDigest digestEngine = MessageDigest.getInstance("SHA-256", ProvUtils.bcProvider);
                byte[] dataBuffer = new byte[4096];
                if (options.getSigningTime() == null) {
                    options.setSigningTime(new Date());
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(options.getSigningTime().toString().getBytes());
                while ((bytesRead = inputStream.read(dataBuffer)) >= 0) {
                    digestEngine.update(dataBuffer, 0, bytesRead);
                }
                byte[] documentIdBytes = digestEngine.digest();
                document.setDocumentId(Long.valueOf(this.toLong(documentIdBytes)));
            }
            catch (NoSuchAlgorithmException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        document.addSignature(signature, (SignatureInterface)new SignatureInterfaceImpl(options), this.sig_options);
    }

    private long toLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, 0, 8);
        buffer.flip();
        return buffer.getLong();
    }

    protected void innerAddSign(PadesSignatureOptions option) throws CapiException {
        this.innerSign(option);
    }

    protected void innerUpdateSign(PadesSignatureOptions option) throws CapiException {
        ScratchFile SCRATCH_FILE_TEMP = null;
        PDDocument document = null;
        OutputStream os = null;
        InputStream is = null;
        Closeable temp_handler = null;
        try {
            SCRATCH_FILE_TEMP = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
            is = option.getInput().getInputAsNewStream();
            os = option.getOutput().getAsOutputStream();
            RandomAccess pdfFileBuffer = SCRATCH_FILE_TEMP.createBuffer(is);
            document = this.loadDoc(option, SCRATCH_FILE_TEMP, (RandomAccessRead)pdfFileBuffer);
            LinkedList<PDSignatureField> emptySignatureFields = new LinkedList<PDSignatureField>();
            if (document.getDocumentCatalog().getAcroForm() != null) {
                if (PadesUtils.isBlockedPdf(document)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Document certified and no changes allowed");
                    }
                    throw new CapiException("Document is certified and no changes are allowed.", 50026);
                }
                for (PDField filed : document.getDocumentCatalog().getAcroForm().getFields()) {
                    emptySignatureFields.addAll(PadesUtils.parseEmptyField(filed));
                }
            }
            this.updateSignature(option.getInput(), document, option);
            COSDictionary root = (COSDictionary)document.getDocument().getTrailer().getDictionaryObject(COSName.ROOT);
            COSDictionary extensions = new COSDictionary();
            COSDictionary ADBE = new COSDictionary();
            extensions.setItem("ADBE", (COSBase)ADBE);
            root.setItem("Extensions", (COSBase)extensions);
            ADBE.setName("BaseVersion", "1.7");
            ADBE.setInt("ExtensionLevel", 5);
            document.saveIncremental(os);
        }
        catch (IOException ex) {
            try {
                if (ex.getCause() != null && ex.getCause() instanceof TSAException) {
                    throw (TSAException)ex.getCause();
                }
                if (ex.getCause() != null && ex.getCause() instanceof CapiException) {
                    throw (CapiException)ex.getCause();
                }
                throw new CapiException("Pades generation Exception :" + ex.getMessage(), 50040);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(SCRATCH_FILE_TEMP);
                Util.closeQuietly(document);
                Util.closeQuietly(temp_handler);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)SCRATCH_FILE_TEMP);
        Util.closeQuietly((Closeable)document);
        Util.closeQuietly(temp_handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSignature(InputHandler ih, PDDocument document, PadesSignatureOptions options) throws CapiException {
        LinkedList<PadesSignatureInformation> signatures = PadesUtils.retrieveNotEmptySignatures(document);
        try {
            int index = Integer.parseInt(options.getSignaturePath());
            if (index >= signatures.size()) {
                throw new CRLException("Pades Signature index invalid", 50040);
            }
            PadesSignatureInformation sign = signatures.get(index);
            sign.verify(ih);
            LTResourceResolver resolver = this.getLTResourceResolver(options, options.isIncludeCertificateChain());
            if (resolver == null) {
                throw new CRLException("Ubable to upgrade Bes Signature", 50040);
            }
            if (sign.getSignatureTimeStampToken() == null && options.getSignatureLevel().compareTo((Enum)SignatureLevel.BES) > 0) {
                throw new CapiException("Unable Update to LT LTA signature without mark", 50040);
            }
            if (sign.getSignatureTimeStampToken() == null && !options.isIncludeCertificateChain()) return;
            this.addDigitalSecureStore(document, sign, resolver);
            if (SignatureLevel.LTA != options.getSignatureLevel()) return;
        }
        catch (NumberFormatException ex) {
            throw new CapiException("Pades Signature index invalid", 50040, (Throwable)ex);
        }
        catch (CertificateEncodingException ex) {
            throw new CapiException("Unable To parse Cert", 50040, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CapiException("Unable To generate Dss", 50040, (Throwable)ex);
        }
        catch (java.security.cert.CRLException ex) {
            throw new CapiException("Unable To parse CRL", 50040, (Throwable)ex);
        }
        catch (CertificateException ex) {
            throw new CapiException("Unable To parse Cert", 50040, (Throwable)ex);
        }
    }

    private void addDigitalSecureStore(PDDocument document, PadesSignatureInformation sign, LTResourceResolver resolver) throws CapiException, CertificateEncodingException, IOException, java.security.cert.CRLException, CertificateException {
        if (sign.getCerts() != null && !sign.getCerts().isEmpty()) {
            return;
        }
        COSDictionary dic = null;
        Certificate signerCert = sign.getSignerCertificate();
        Date tsaTokenDate = null;
        LinkedList<X509Certificate> lstCertToAdd = new LinkedList<X509Certificate>();
        LTResource resolvedTsaResource = null;
        if (sign.getSignatureTimeStampToken() != null) {
            TimeStampToken tsaToken = new TimeStampToken(sign.getSignatureTimeStampToken());
            Certificate tsaCert = tsaToken.getTSACert();
            tsaTokenDate = tsaToken.getDate();
            resolvedTsaResource = resolver.resolve(tsaCert.getInternalCert(), tsaTokenDate);
            if (!lstCertToAdd.contains(tsaCert.getInternalCert())) {
                lstCertToAdd.add(tsaCert.getInternalCert());
            }
            for (X509Certificate tsaResCert : resolvedTsaResource.getCerts()) {
                if (lstCertToAdd.contains(tsaResCert)) continue;
                lstCertToAdd.add(tsaResCert);
            }
        }
        LTResource resolvedResource = resolver.resolve(signerCert.getInternalCert(), tsaTokenDate);
        for (X509Certificate tsaResCert : resolvedResource.getCerts()) {
            if (lstCertToAdd.contains(tsaResCert)) continue;
            lstCertToAdd.add(tsaResCert);
        }
        if (!lstCertToAdd.contains(signerCert.getInternalCert())) {
            lstCertToAdd.add(signerCert.getInternalCert());
        }
        PadesDssInfo info = null;
        COSDictionary trailer = document.getDocument().getTrailer();
        if (trailer == null) {
            throw new CapiException("no trailer", 50040);
        }
        COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
        if (root == null) {
            throw new CapiException("no root", 50040);
        }
        if (sign.getPadesDssInfo() == null) {
            dic = new COSDictionary();
            root.setItem("DSS", (COSBase)dic);
            root.setNeedToBeUpdated(true);
            info = new PadesDssInfo(document, dic);
        } else {
            info = sign.getPadesDssInfo();
            root.setNeedToBeUpdated(true);
        }
        for (X509Certificate cert : lstCertToAdd) {
            info.addCertificate(cert, null);
        }
        for (OCSPResponse ocsp : resolvedResource.getOcsps()) {
            info.addOcsp(ocsp, sign.getVri());
        }
        for (CRL crl : resolvedResource.getCrls()) {
            info.addCrl(crl, sign.getVri());
        }
        if (resolvedTsaResource != null) {
            for (OCSPResponse ocsp : resolvedTsaResource.getOcsps()) {
                info.addOcsp(ocsp, null);
            }
            for (CRL crl : resolvedTsaResource.getCrls()) {
                info.addCrl(crl, null);
            }
        }
    }

    private boolean checkPdf(RandomAccessRead rar) throws IOException {
        boolean bRet = false;
        byte[] data = new byte[5];
        int nRead = rar.read(data, 0, data.length);
        if (nRead != -1) {
            String str = new String(data);
            bRet = str.startsWith("%FDF-") || str.startsWith("%PDF-");
        }
        rar.seek(0L);
        return bRet;
    }

    private long findEOFPosition(RandomAccessRead pdfFileBuffer) {
        try {
            long pdfFilelength;
            long eofId = pdfFilelength = pdfFileBuffer.length();
            pdfFileBuffer.seek(pdfFilelength);
            byte[] extraBuffer = null;
            int loop = 0;
            while ((long)(8192 * loop) < pdfFilelength) {
                int bufferLength = pdfFilelength - (long)(8192 * loop) < 8192L ? (int)pdfFilelength - 8192 * loop : 8192;
                pdfFileBuffer.rewind(bufferLength);
                byte[] buffer = new byte[bufferLength + EXTRA_BUFFER_SIZE];
                pdfFileBuffer.read(buffer, 0, bufferLength);
                if (extraBuffer != null) {
                    System.arraycopy(extraBuffer, 0, buffer, bufferLength, extraBuffer.length);
                }
                eofId += (long)EXTRA_BUFFER_SIZE;
                int id = buffer.length;
                while (id > 0) {
                    if (this.checkEndNoEOL(buffer, id)) {
                        pdfFileBuffer.seek(0L);
                        return eofId;
                    }
                    if (this.checkEndUnx(buffer, id)) {
                        pdfFileBuffer.seek(0L);
                        return eofId;
                    }
                    if (this.checkEndWin(buffer, id)) {
                        pdfFileBuffer.seek(0L);
                        return eofId;
                    }
                    --id;
                    --eofId;
                }
                extraBuffer = Arrays.copyOfRange(buffer, 0, EXTRA_BUFFER_SIZE);
                pdfFileBuffer.rewind(bufferLength);
                ++loop;
            }
            return -1L;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return -1L;
        }
    }

    private boolean checkEndNoEOL(byte[] bf, int lastId) {
        if (lastId < EOF_MARKER_NO_EOL.length) {
            return false;
        }
        byte[] subBuffer = Arrays.copyOfRange(bf, lastId - EOF_MARKER_NO_EOL.length, lastId);
        return Arrays.equals(subBuffer, EOF_MARKER_NO_EOL);
    }

    private boolean checkEndUnx(byte[] bf, int lastId) {
        if (lastId < EOF_MARKER_UNX.length) {
            return false;
        }
        byte[] subBuffer = Arrays.copyOfRange(bf, lastId - EOF_MARKER_UNX.length, lastId);
        return Arrays.equals(subBuffer, EOF_MARKER_UNX);
    }

    private boolean checkEndWin(byte[] bf, int lastId) {
        if (lastId < EOF_MARKER_WIN.length) {
            return false;
        }
        byte[] subBuffer = Arrays.copyOfRange(bf, lastId - EOF_MARKER_WIN.length, lastId);
        return Arrays.equals(subBuffer, EOF_MARKER_WIN);
    }

    protected void parameterValidation(PadesSignatureOptions option) throws CapiException {
        super.parameterValidation((SignatureOptions)option);
        if (option.getDigestAlgorithm() == DigestAlgorithm.SHA3_224 || option.getDigestAlgorithm() == DigestAlgorithm.SHA3_256 || option.getDigestAlgorithm() == DigestAlgorithm.SHA3_384 || option.getDigestAlgorithm() == DigestAlgorithm.SHA3_512) {
            throw new CapiException("Unsupported Digest Algorithm", 3011);
        }
    }

    private class SignatureInterfaceImpl
    implements SignatureInterface {
        CadesSignatureOptions option = new CadesSignatureOptions();

        public SignatureInterfaceImpl(PadesSignatureOptions pdf_option) {
            this.option.setKeyStore(pdf_option.getKeyStore());
            this.option.setKeyStorePassword(pdf_option.getKeyStorePassword());
            this.option.setAlias(pdf_option.getAlias());
            this.option.setDigestAlgorithm(pdf_option.getDigestAlgorithm());
            this.option.setDerEncoded(true);
            this.option.setSignatureMode(SignatureMode.DETACHED);
            if (pdf_option.getSignatureLevel() != SignatureLevel.BES) {
                this.option.setSignatureLevel(SignatureLevel.T);
                this.option.setTimeStampOptions(pdf_option.getTimeStampOptions());
            } else {
                this.option.setSignatureLevel(SignatureLevel.BES);
            }
            if (pdf_option.getProfile() == PdfProfile.BASIC) {
                this.option.setIncludeSigningTime(true);
            } else {
                this.option.setIncludeSigningTime(false);
            }
            this.option.setIncludeCertificateChain(pdf_option.isIncludeCertificateChain());
            this.option.setResolveCertificateChainResources(false);
            if (pdf_option.getCertdb() != null) {
                this.option.setCertdb(pdf_option.getCertdb());
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] sign(InputStream content) throws IOException {
            ByteArrayOutputStream os;
            OutputHandler doc = null;
            try {
                os = new ByteArrayOutputStream();
                doc = DataHandlerBuilder.get().setOutputStream((OutputStream)os).buildOutput();
                this.option.setInput(DataHandlerBuilder.get().setInputStream(content).buildInput());
                this.option.setOutput(doc);
                CadesSignatureGenerator gen = new CadesSignatureGenerator();
                gen.sign((SignatureOptions)this.option);
            }
            catch (CapiException ex) {
                try {
                    logger.debug("Unable save envelope! Got an exception " + ex.getMessage());
                    throw new IOException("Unable save envelope! Got an exception " + ex.getMessage(), ex);
                    catch (FileNotFoundException ex2) {
                        logger.debug("Unable save envelope! Got an exception " + ex2.getMessage());
                        throw new IOException("Unable save envelope! Got an exception " + ex2.getMessage());
                    }
                    catch (MalformedURLException ex3) {
                        logger.debug("Unable save envelope! Got an exception " + ex3.getMessage());
                        throw new IOException("Unable save envelope! Got an exception " + ex3.getMessage());
                    }
                    catch (KeyStoreException ex4) {
                        logger.debug("Unable save envelope! Got an exception " + ex4.getMessage());
                        throw new IOException("Unable save envelope! Got an exception " + ex4.getMessage());
                    }
                    catch (NoSuchAlgorithmException ex5) {
                        logger.debug("Unable save envelope! Got an exception " + ex5.getMessage());
                        throw new IOException("Unable save envelope! Got an exception " + ex5.getMessage());
                    }
                    catch (UnrecoverableKeyException ex6) {
                        logger.debug("Unable save envelope! Got an exception " + ex6.getMessage());
                        throw new IOException("Unable save envelope! Got an exception " + ex6.getMessage());
                    }
                    catch (KeyManagementException ex7) {
                        logger.debug("Unable save envelope! Got an exception " + ex7.getMessage());
                        throw new IOException("Unable save envelope! Got an exception " + ex7.getMessage());
                    }
                    catch (URISyntaxException ex8) {
                        logger.debug("Unable save envelope! Got an exception " + ex8.getMessage());
                        throw new IOException("Unable save envelope! Got an exception " + ex8.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(doc);
                    throw throwable;
                }
            }
            Util.closeQuietly((Closeable)doc);
            return os.toByteArray();
        }
    }
}

