<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

$open_logs = array();

function wi_log_open( $name )
{
    global $config, $open_logs;

    if ( isset( $open_logs[ $name ] ) )
        return $open_logs[ $name ];

    if ( isset( $config[ "log_$name" ] ) && $config[ "log_$name" ] != '' ) {
        $filename = wi_make_absolute_path( $config[ "log_$name" ] );
        $log = @fopen( $filename, 'a' );
        if ( $log ) {
            wi_log_write_header( $log );
            $open_logs[ $name ] = $log;
            return $log;
        }
    }

    return false;
}

function wi_log_check( $name )
{
    global $config, $open_logs;

    if ( isset( $open_logs[ $name ] ) )
        return true;

    if ( isset( $config[ "log_$name" ] ) && $config[ "log_$name" ] != '' ) {
        $filename = wi_make_absolute_path( $config[ "log_$name" ] );
        $log = @fopen( $filename, 'a' );
        if ( $log ) {
            fclose( $log );
            return true;
        }
    }

    return false;
}

function wi_log_write_header( $log )
{
    $date = date( 'Y-m-d H:i:s' );

    if ( isset( $_SERVER[ 'REMOTE_HOST' ] ) )
        $host = $_SERVER[ 'REMOTE_HOST' ];
    else if ( isset( $_SERVER[ 'REMOTE_ADDR' ] ) )
        $host = $_SERVER[ 'REMOTE_ADDR' ];
    else
        $host = 'unknown';

    fwrite( $log, "\n[$date, $host]\n" );
}

function wi_error_handler( $errno, $msg, $file, $line )
{
    if ( $errno & error_reporting() ) {
        $log = wi_log_open( 'errors' );
        if ( $log ) {
            $level = ( $errno == E_NOTICE ) ? 'NOTICE' : 'WARNING';
            fwrite( $log, "$level in $file($line):\n$msg\n" );
        }
    }
}

function wi_make_absolute_path( $path )
{
    if ( $path != null ) {
        $path = str_replace( '\\', '/', $path );
        if ( !wi_is_absolute_path( $path ) )
            $path = wi_get_root_dir() . '/' . $path;
    }
    return $path;
}

function wi_is_absolute_path( $path )
{
    if ( $path[ 0 ] == '/' )
        return true;
    if ( strtoupper( substr( PHP_OS, 0, 3 ) ) == 'WIN' ) {
        if ( strlen( $path ) >= 3 && $path[ 1 ] == ':' )
            return true;
    }
    return false;
}

function wi_get_root_dir()
{
    $dir = realpath( dirname( dirname( __FILE__ ) ) );
    $dir = str_replace( '\\', '/', $dir );
    $dir = rtrim( $dir, '/' );

    return $dir;
}

ini_set( 'html_errors', 0 );

set_error_handler( 'wi_error_handler' );

error_reporting( E_ALL ^ E_NOTICE );
