#include <stdio.h>
#include <stdlib.h>
#include <sched.h>
#include <math.h>
#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include "model.h"
#include "voicesynth.h"
#include "synth.h"

Synth::Synth(Model *p_model, QThread *parent) : QThread(parent) {

  int i1;

  model = p_model;
  for (i1 = 0; i1 < model->getPoly(); i1++) {
    voiceSynth[i1] = new VoiceSynth(model);
    voiceSynth[i1]->loadVoiceData(i1);
  }           
  initSynth();
}

Synth::~Synth() {

}

void Synth::initSynth() {

  int i1;
  
  model->voiceReadyCounter = 0;
  for (i1 = 0; i1 < model->getPoly(); i1++) {
    voiceSynth[i1]->start();
  }
}

void Synth::run() {

  int i1, i2;
     
  while(model->doSynthesis()) {
    memset(model->buf[0], 0, model->getBufSize() * sizeof(double));
    memset(model->buf[1], 0, model->getBufSize() * sizeof(double));
    for (i1 = 0; i1 < model->getPoly(); i1++) {
      for (i2 = 0; i2 < model->getBufSize(); i2++) {
        model->buf[0][i2] += voiceSynth[i1]->vbuf[2 * i2];
        model->buf[1][i2] += voiceSynth[i1]->vbuf[2 * i2 + 1];
      }  
    }
    model->synthMutex.lock();
    model->jackWait.wait(&model->synthMutex);
    model->synthMutex.unlock();
    model->voiceMutex.lock();
    model->voiceWait.wakeAll();
    model->synthWait.wait(&model->voiceMutex);
    model->voiceMutex.unlock();
  }
  model->quitMutex.lock();    
  model->quitWait.wait(&model->quitMutex);
  model->quitMutex.unlock();
  exit();

}
