<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_file_cache - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_file_cache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_file_cache.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_file_cache.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/mod/mod_file_cache.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Mise en cache mmoire d'une liste statique de
fichiers</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>file_cache_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_file_cache.c</td></tr></table>
<h3>Sommaire</h3>


    <div class="warning">
      Ce module doit tre utilis avec prcautions. Il est recommand de
      lire attentivement ce document, car l'utilisation de
      <code class="module"><a href="../mod/mod_file_cache.html">mod_file_cache</a></code> peut facilement conduire  la
      cration d'un site inoprant.
    </div>

    <p>La mise en cache de fichiers souvent demands mais rarement
    modifis est une technique permettant de rduire la charge du
    serveur. <code class="module"><a href="../mod/mod_file_cache.html">mod_file_cache</a></code> met en oeuvre deux
    techniques de mise en cache de fichiers <em>statiques</em>
    frquemment demands. Des directives de configuration vous
    permettent d'indiquer  <code class="module"><a href="../mod/mod_file_cache.html">mod_file_cache</a></code> soit
    d'ouvrir et de charger une image en mmoire d'un fichier avec
    <code>mmap()</code>, soit de prouvrir un fichier et de maintenir en
    service le <em>gestionnaire</em> du fichier. Les deux techniques
    permettent de rduire la charge du serveur lors du traitement des
    requtes concernant ces fichiers, en accomplissant une partie du
    travail ncessaire  la mise  disposition de ces fichiers (en
    particulier les oprations d'entres/sorties sur les fichiers) au
    dmarrage du serveur, plutt qu'au cours de chaque requte.</p>

    <p>Note : ces techniques sont inutilisables pour acclrer des
    programmes CGI ou d'autres fichiers servis par des gestionnaires de
    contenu spciaux. Elles ne peuvent tre utilises que pour des
    fichiers standards, normalement servis par le gestionnaire de contenu
    de base d'Apache.</p>

    <p>Ce module est une extension du module
    d'Apache 1.3 <code>mod_mmap_static</code>et s'en inspire
    fortement .</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#cachefile">CacheFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#mmapfile">MMapFile</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#using">Utilisation de mod_file_cache</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="using" id="using">Utilisation de mod_file_cache</a></h2>

    <p><code class="module"><a href="../mod/mod_file_cache.html">mod_file_cache</a></code> gre la mise en cache d'une liste
    de fichiers dfinie de manire statique via une des directives
    <code class="directive"><a href="#mmapfile">MMapFile</a></code> ou
    <code class="directive"><a href="#cachefile">CacheFile</a></code> au niveau
    de la configuration du serveur principal.</p>

    <p>Les deux directives ne sont pas supportes par toutes les
    plates-formes. Par exemple, Apache pour Windows ne supporte pas
    actuellement la directive <code class="directive"><a href="#mmapfile">MMapFile</a></code>, alors que d'autres
    plates-formes, comme AIX, supportent les deux. Vous recevrez un
    message d'erreur dans le journal des erreurs du serveur si vous
    essayez d'utiliser une directive non supporte. Si vous utilisez une
    directive non supporte, le serveur dmarrera, mais les fichiers ne
    seront pas mis en cache. Sur les plates-formes qui supportent les
    deux directives, vous devez faire des essais afin de dterminer
    quelle directive vous convient le mieux.</p>

    <h3>Directive MMapFile</h3>

      <p>La directive <code class="directive"><a href="#mmapfile">MMapFile</a></code> du module
      <code class="module"><a href="../mod/mod_file_cache.html">mod_file_cache</a></code> permet de transfrer en mmoire
      une liste statique de fichiers  l'aide de l'appel systme
      <code>mmap()</code>. Cet appel systme est disponible sur la
      plupart des plates-formes de style Unix, mais pas sur toutes. Il
      existe parfois des limites spcifiques au systme quant  la
      taille et au nombre de fichiers qui peuvent tre
      <code>mmap()</code>s, et l'exprimentation est probablement la
      mthode la plus simple pour dterminer ces limites.</p>

      <p>Ce <code>mmap()</code>age n'est effectu qu'une seul fois au
      dmarrage ou redmarrage du serveur. Ainsi, chaque fois qu'un des
      fichiers chargs en mmoire est modifi au niveau du systme de
      fichiers, vous <em>devez</em> redmarrer le serveur (voir la
      documentation sur l'<a href="../stopping.html">Arrt et redmarrage</a>). Pour bien
      insister sur ce point, si des fichiers sont modifis <em>sur
      disque</em>, et si vous ne redmarrez pas le serveur, vous allez
      finir par servir des contenus compltement obsoltes. Vous devez
      mettre  jour les fichiers en renommant l'ancienne version et en
      enregistrant la nouvelle sur disque. Pour y parvenir, on peut
      utiliser des outils comme <code>rdist</code> et <code>mv</code>.
      La raison pour laquelle ce module ne prend pas en compte les
      modifications de fichiers rside dans le fait que cette
      vrification ncessiterait un appel  <code>stat()</code>  chaque
      accs, et en fin de compte, l'augmentation de la consommation de
      ressources finirait par aller contre le but initial de
      rduire les entres/sorties.</p>
    

    <h3>Directive CacheFile</h3>

      <p>La directive <code class="directive"><a href="#cachefile">CacheFile</a></code> du module
      <code class="module"><a href="../mod/mod_file_cache.html">mod_file_cache</a></code> permet d'associer un
      <em>gestionnaire</em> ou <em>descripteur de fichier</em>  chaque
      fichier numr dans la directive de configuration et place ces
      gestionnaires de fichiers ouverts dans le cache. Lorsqu'un des
      fichier est demand, le serveur slectionne son gestionnaire dans
      le cache et le transmet  l'API <code>sendfile()</code> (ou
      <code>TransmitFile()</code> sous Windows).</p>

      

      <p>Cette mise en cache des gestionnaire n'est effectue qu'une
      seule fois au dmarrage ou redmarrage du systme. Ainsi, chaque
      fois qu'un des fichiers chargs en mmoire est modifi au niveau
      du systme de fichiers, vous <em>devez</em> redmarrer le serveur
      (voir la documentation sur l'<a href="../stopping.html">Arrt et redmarrage</a>).
      Pour bien
      insister sur ce point, si des fichiers sont modifis <em>sur
      disque</em>, et si vous ne redmarrez pas le serveur, vous allez
      finir par servir des contenus compltement obsoltes. Vous devez
      mettre  jour les fichiers en renommant l'ancienne version et en
      enregistrant la nouvelle sur disque. Pour y parvenir, on peut
      utiliser des outils comme <code>rdist</code> et
      <code>mv</code>.</p>
    

    <div class="note"><h3>Note</h3>
      <p>Ne cherchez pas  trouver de directive qui met tous les
      fichiers d'un rpertoire en cache, de manire rcursive. Pour y
      parvenir, vous pouvez vous reporter  la directive <code class="directive"><a href="../mod/core.html#include">Include</a></code> directive, et considrer cette
      commande :</p>

      <div class="example"><p><code>
        find /www/htdocs -type f -print \<br />
        | sed -e 's/.*/mmapfile &amp;/' &gt; /www/conf/mmap.conf
      </code></p></div>
    </div>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheFile" id="CacheFile">CacheFile</a> <a name="cachefile" id="cachefile">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Met en cache une liste de gestionnaires de fichiers au
dmarrage</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheFile <var>chemin fichier</var> [<var>chemin fichier</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_file_cache</td></tr>
</table>
    <p>La directive <code class="directive">CacheFile</code> permet d'associer
    des gestionnaires  un ou plusieurs fichiers (spars par des
    espaces), et de placer ceux-ci dans le cache au dmarrage du
    serveur. Les gestionnaires des fichiers mis en cache sont
    automatiquement ferms  l'arrt du serveur. Lorsqu'un ou plusieurs
    fichiers ont t modifis sur disque, le serveur doit tre redmarr
    afin que les modifications soient prises en compte par le cache.</p>

    <p>Soyez prudent avec les arguments <var>chemin fichier</var> : ils
    doivent correspondre exactement au chemin du systme de fichier que
    crent les gestionnaires de traduction URL-vers-nom-fichier
    d'Apache. On ne peut pas comparer des inodes ou autres identifiants
    pour mettre en correspondance des chemins  l'aide de liens
    symboliques <em>(etc...)</em>, car l encore, ceci ncessiterait un
    appel  <code>stat()</code> supplmentaire, ce qui n'est pas acceptable.
    Il n'est pas garanti que ce module fonctionne avec des noms de
    fichiers rcrits par <code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code> ou
    <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">CacheFile /usr/local/apache/htdocs/index.html</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="MMapFile" id="MMapFile">MMapFile</a> <a name="mmapfile" id="mmapfile">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Charge au dmarrage une liste de fichiers en mmoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MMapFile <var>chemin fichier</var> [<var>chemin fichier</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_file_cache</td></tr>
</table>
    <p>La directive <code class="directive">MMapFile</code> permet de charger un
    ou plusieurs fichiers (spars par des espaces) en mmoire au
    dmarrage du serveur. Ceux-ci sont automatiquement dchargs de la
    mmoire  l'arrt du serveur. Lorsqu'un ou plusieurs fichiers ont
    t modifis sur disque, on doit au minimum envoyer un signal
    <code>HUP</code> ou <code>USR1</code> au serveur afin de les
    re<code>mmap()</code>er.</p>

    <p>Soyez prudent avec les arguments <var>chemin fichier</var> : ils
    doivent correspondre exactement au chemin du systme de fichier que
    crent les gestionnaires de traduction URL-vers-nom-fichier
    d'Apache. On ne peut pas comparer des inodes ou autres identifiants
    pour mettre en correspondance des chemins  l'aide de liens
    symboliques <em>(etc...)</em>, car l encore, ceci ncessiterait un
    appel  <code>stat()</code> supplmentaire, ce qui n'est pas
    acceptable.
    Il n'est pas garanti que ce module fonctionne avec des noms de
    fichiers rcrits par <code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code> ou
    <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">MMapFile /usr/local/apache/htdocs/index.html</pre>
</div>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_file_cache.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_file_cache.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/mod/mod_file_cache.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_file_cache.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>