/*
 *   khexedit - Versatile hex editor
 *   Copyright (C) 1999  Espen Sand, espensa@online.no
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _LISTVIEW_H_
#define _LISTVIEW_H_

#include <klistview.h>

class CListView : public KListView
{
  Q_OBJECT

  public:
    CListView( QWidget *parent=0, const char *name=0, int visibleItem=10 );
    
    void setVisibleItem( int visibleItem, bool updateSize=true );
    virtual QSize sizeHint( void ) const; 

  private:
    int mVisibleItem;
};




#endif






