/***************************************************************************
                          arc.h  -  description
                             -------------------
    begin                : Tue Jul 31 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARC_H
#define ARC_H

#include <geoobjects.h>

/**This class features arcs.
  *@author Marc Bartsch
  */

class Arc : public GeoObjects
{
	public:

		Arc();
		~Arc();

		virtual void		getObjectOverlay( QList <QRect> & list );

	  virtual void 		paint( QPainter *p );
	  virtual bool 		contains( QPoint *pt );

	  virtual void 		move();
		virtual void 		move( QPoint *pt );

		virtual double 	getAngle();

		virtual void 		writeToFile( KSimpleConfig *config );
		virtual void 		readFromFile( KSimpleConfig *config );

	protected:

		QRect  textRect;
		QPoint anchorPoint;
	  double startAngle;
  	double angle;
  	double radius;
	  QPointArray arrow;
};

#endif
