/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __kxpage_h__
#define __kxpage_h__

#include <qobject.h>
#include <qptrlist.h>

class KXData;

/**
 * Abstract base class for all Wizard Pages.
 */
class KXPage
{
public:
    KXPage();

    void setData( KXData *data );

    void savePage();
    void loadPage();

    void setSavingDirty( bool dirty ) { m_savingDirty = dirty; }
    bool isSavingDirty() const { return m_savingDirty; }

    void setLoadingDirty( bool dirty ) { m_loadingDirty = dirty; }
    bool isLoadingDirty() const { return m_loadingDirty; }

    void setForwardEnabled( bool enabled ) { m_forwardEnabled = enabled; }
    bool isForwardEnabled() const { return m_forwardEnabled; }

protected:
    virtual void load() = 0;
    virtual void save() = 0;

    KXData *m_data;
    bool m_savingDirty;
    bool m_loadingDirty;
    bool m_forwardEnabled;
};

class KXPageHandler : public QObject
{
    Q_OBJECT
public:
    KXPageHandler( QObject *parent = 0, const char *name = 0 );
    virtual ~KXPageHandler();

    void addPage( QWidget *page );

    virtual bool eventFilter( QObject *obj, QEvent *ev );

signals:
    void enableForward( bool );

private slots:
    void slotChanged();

private:
    QPtrList<KXPage> m_pages;
};

#endif
