/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailImplConfigBase;
import org.openrdf.sail.memory.config.MemoryStoreSchema;

public class MemoryStoreConfig
extends SailImplConfigBase {
    private boolean persist = false;
    private long syncDelay = 0L;

    public MemoryStoreConfig() {
        super("openrdf:MemoryStore");
    }

    public MemoryStoreConfig(boolean persist) {
        this();
        this.setPersist(persist);
    }

    public MemoryStoreConfig(boolean persist, long syncDelay) {
        this(persist);
        this.setSyncDelay(syncDelay);
    }

    public boolean getPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public long getSyncDelay() {
        return this.syncDelay;
    }

    public void setSyncDelay(long syncDelay) {
        this.syncDelay = syncDelay;
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (this.persist) {
            graph.add(implNode, MemoryStoreSchema.PERSIST, graph.getValueFactory().createLiteral(this.persist), new Resource[0]);
        }
        if (this.syncDelay != 0L) {
            graph.add(implNode, MemoryStoreSchema.SYNC_DELAY, graph.getValueFactory().createLiteral(this.syncDelay), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        block7: {
            super.parse(graph, implNode);
            try {
                Literal syncDelayValue;
                Literal persistValue = GraphUtil.getOptionalObjectLiteral(graph, implNode, MemoryStoreSchema.PERSIST);
                if (persistValue != null) {
                    try {
                        this.setPersist(persistValue.booleanValue());
                    }
                    catch (IllegalArgumentException e) {
                        throw new SailConfigException("Boolean value required for " + MemoryStoreSchema.PERSIST + " property, found " + persistValue);
                    }
                }
                if ((syncDelayValue = GraphUtil.getOptionalObjectLiteral(graph, implNode, MemoryStoreSchema.SYNC_DELAY)) == null) break block7;
                try {
                    this.setSyncDelay(syncDelayValue.longValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Long integer value required for " + MemoryStoreSchema.SYNC_DELAY + " property, found " + syncDelayValue);
                }
            }
            catch (GraphUtilException e) {
                throw new SailConfigException(e.getMessage(), e);
            }
        }
    }
}

