/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tracer
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(Tracer.class);
    private static int count;
    private Object delegate;
    private String var;
    private PrintWriter out;

    public static boolean isTraceEnabled() {
        try {
            return System.getProperty("org.openrdf.repository.trace") != null;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static DataSource traceDataSource(DataSource ds) {
        try {
            String var = Tracer.getVariableName(DataSource.class);
            File traceFile = File.createTempFile("sqltrace-" + Long.toHexString(System.currentTimeMillis()), ".java");
            PrintWriter out = new PrintWriter(traceFile);
            logger.info("Using trace file: {}", (Object)traceFile);
            return (DataSource)Tracer.trace(var, ds, DataSource.class, out);
        }
        catch (IOException e) {
            return ds;
        }
    }

    private static Object trace(String var, Object delegate, Class<?> type, PrintWriter out) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] types = new Class[]{type};
        return Proxy.newProxyInstance(cl, types, (InvocationHandler)new Tracer(delegate, var, out));
    }

    private static String getVariableName(Class<?> type) {
        return type.getSimpleName().replaceAll("[a-z]", "").toLowerCase() + ++count;
    }

    public Tracer(Object delegate, String var, PrintWriter out) {
        this.delegate = delegate;
        this.var = var;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String returnVar = null;
            if (method.getReturnType().isInterface()) {
                returnVar = Tracer.getVariableName(method.getReturnType());
            }
            if (this.out != null) {
                this.out.println(this.buildMethodCall(returnVar, method, args));
                this.out.flush();
            }
            Object result = method.invoke(this.delegate, args);
            Class<?> type = method.getReturnType();
            if (result != null && type.isInterface()) {
                return Tracer.trace(returnVar, result, type, this.out);
            }
            return result;
        }
        catch (InvocationTargetException exc) {
            String name = method.getName();
            String msg = exc.getCause().getMessage();
            String line = "/* ERROR in " + this.var + "." + name + ": " + msg;
            PrintWriter printWriter = this.out;
            synchronized (printWriter) {
                SQLException se;
                SQLException next;
                this.out.println(line);
                exc.getCause().printStackTrace(this.out);
                if (exc.getCause() instanceof SQLException && (next = (se = (SQLException)exc.getCause()).getNextException()) != null) {
                    next.printStackTrace(this.out);
                }
                this.out.println("*/");
            }
            this.out.flush();
            throw exc.getCause();
        }
    }

    private String buildMethodCall(String returnVar, Method method, Object[] args) {
        StringBuilder sb = new StringBuilder();
        if (method.getReturnType().isInterface()) {
            sb.append(method.getReturnType().getSimpleName()).append(" ");
            sb.append(returnVar);
            sb.append(" = ");
        }
        sb.append(this.var).append('.');
        sb.append(method.getName());
        sb.append("(");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Object arg = args[i];
                this.appendArg(arg, sb);
            }
        }
        sb.append(");");
        return sb.toString();
    }

    private void appendArg(Object arg, StringBuilder sb) {
        if (arg == null) {
            sb.append("null");
        } else if (arg instanceof String) {
            String str = (String)arg;
            sb.append("\"");
            str = str.replace("\\", "\\\\");
            str = str.replace("\n", "\\n");
            str = str.replace("\"", "\\\"");
            sb.append(str);
            sb.append("\"");
        } else if (arg instanceof Long) {
            sb.append(arg).append('l');
        } else if (arg.getClass().isArray()) {
            sb.append("new ");
            sb.append(arg.getClass().getComponentType().getSimpleName());
            sb.append("[]{");
            Object[] ar = (Object[])arg;
            for (int i = 0; i < ar.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.appendArg(ar[i], sb);
            }
            sb.append("}");
        } else {
            sb.append(arg);
        }
    }
}

