/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENSITIVE_SYM = 686,
     SEPARATOR_SYM = 687,
     SERIALIZABLE_SYM = 688,
     SERIAL_SYM = 689,
     SESSION_SYM = 690,
     SET = 691,
     SET_VAR = 692,
     SHARE_SYM = 693,
     SHIFT_LEFT = 694,
     SHIFT_RIGHT = 695,
     SHOW = 696,
     SHUTDOWN = 697,
     SIGNED_SYM = 698,
     SIMPLE_SYM = 699,
     SLAVE = 700,
     SMALLINT = 701,
     SNAPSHOT_SYM = 702,
     SOUNDS_SYM = 703,
     SOURCE_SYM = 704,
     SPATIAL_SYM = 705,
     SPECIFIC_SYM = 706,
     SQLEXCEPTION_SYM = 707,
     SQLSTATE_SYM = 708,
     SQLWARNING_SYM = 709,
     SQL_BIG_RESULT = 710,
     SQL_BUFFER_RESULT = 711,
     SQL_CACHE_SYM = 712,
     SQL_CALC_FOUND_ROWS = 713,
     SQL_NO_CACHE_SYM = 714,
     SQL_SMALL_RESULT = 715,
     SQL_SYM = 716,
     SQL_THREAD = 717,
     SSL_SYM = 718,
     STARTING = 719,
     START_SYM = 720,
     STATUS_SYM = 721,
     STD_SYM = 722,
     STDDEV_SAMP_SYM = 723,
     STOP_SYM = 724,
     STORAGE_SYM = 725,
     STRAIGHT_JOIN = 726,
     STRING_SYM = 727,
     SUBDATE_SYM = 728,
     SUBJECT_SYM = 729,
     SUBSTRING = 730,
     SUBSTRING_INDEX = 731,
     SUM_SYM = 732,
     SUPER_SYM = 733,
     SUSPEND_SYM = 734,
     SWAPS_SYM = 735,
     SWITCHES_SYM = 736,
     SYSDATE = 737,
     TABLES = 738,
     TABLESPACE = 739,
     TABLE_SYM = 740,
     TEMPORARY = 741,
     TEMPTABLE_SYM = 742,
     TERMINATED = 743,
     TEXT_STRING = 744,
     TEXT_SYM = 745,
     TIMESTAMP = 746,
     TIMESTAMP_ADD = 747,
     TIMESTAMP_DIFF = 748,
     TIME_SYM = 749,
     TINYBLOB = 750,
     TINYINT = 751,
     TINYTEXT = 752,
     TO_SYM = 753,
     TRAILING = 754,
     TRANSACTION_SYM = 755,
     TRIGGER_SYM = 756,
     TRIGGERS_SYM = 757,
     TRIM = 758,
     TRUE_SYM = 759,
     TRUNCATE_SYM = 760,
     TYPES_SYM = 761,
     TYPE_SYM = 762,
     UDF_RETURNS_SYM = 763,
     UDF_SONAME_SYM = 764,
     ULONGLONG_NUM = 765,
     UNCOMMITTED_SYM = 766,
     UNDEFINED_SYM = 767,
     UNDERSCORE_CHARSET = 768,
     UNDO_SYM = 769,
     UNICODE_SYM = 770,
     UNION_SYM = 771,
     UNIQUE_SYM = 772,
     UNIQUE_USERS = 773,
     UNIX_TIMESTAMP = 774,
     UNKNOWN_SYM = 775,
     UNLOCK_SYM = 776,
     UNSIGNED = 777,
     UNTIL_SYM = 778,
     UPDATE_SYM = 779,
     UPGRADE_SYM = 780,
     USAGE = 781,
     USER = 782,
     USE_FRM = 783,
     USE_SYM = 784,
     USING = 785,
     UTC_DATE_SYM = 786,
     UTC_TIMESTAMP_SYM = 787,
     UTC_TIME_SYM = 788,
     VAR_SAMP_SYM = 789,
     VALUES = 790,
     VALUE_SYM = 791,
     VARBINARY = 792,
     VARCHAR = 793,
     VARIABLES = 794,
     VARIANCE_SYM = 795,
     VARYING = 796,
     VIEW_SYM = 797,
     WARNINGS = 798,
     WEEK_SYM = 799,
     WHEN_SYM = 800,
     WHERE = 801,
     WHILE_SYM = 802,
     WITH = 803,
     WORK_SYM = 804,
     WRITE_SYM = 805,
     X509_SYM = 806,
     XA_SYM = 807,
     XOR = 808,
     YEARWEEK = 809,
     YEAR_MONTH_SYM = 810,
     YEAR_SYM = 811,
     ZEROFILL = 812,
     TABLE_REF_PRIORITY = 813,
     ELSE = 814,
     THEN_SYM = 815,
     CASE_SYM = 816,
     BETWEEN_SYM = 817,
     NEG = 818
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENSITIVE_SYM 686
#define SEPARATOR_SYM 687
#define SERIALIZABLE_SYM 688
#define SERIAL_SYM 689
#define SESSION_SYM 690
#define SET 691
#define SET_VAR 692
#define SHARE_SYM 693
#define SHIFT_LEFT 694
#define SHIFT_RIGHT 695
#define SHOW 696
#define SHUTDOWN 697
#define SIGNED_SYM 698
#define SIMPLE_SYM 699
#define SLAVE 700
#define SMALLINT 701
#define SNAPSHOT_SYM 702
#define SOUNDS_SYM 703
#define SOURCE_SYM 704
#define SPATIAL_SYM 705
#define SPECIFIC_SYM 706
#define SQLEXCEPTION_SYM 707
#define SQLSTATE_SYM 708
#define SQLWARNING_SYM 709
#define SQL_BIG_RESULT 710
#define SQL_BUFFER_RESULT 711
#define SQL_CACHE_SYM 712
#define SQL_CALC_FOUND_ROWS 713
#define SQL_NO_CACHE_SYM 714
#define SQL_SMALL_RESULT 715
#define SQL_SYM 716
#define SQL_THREAD 717
#define SSL_SYM 718
#define STARTING 719
#define START_SYM 720
#define STATUS_SYM 721
#define STD_SYM 722
#define STDDEV_SAMP_SYM 723
#define STOP_SYM 724
#define STORAGE_SYM 725
#define STRAIGHT_JOIN 726
#define STRING_SYM 727
#define SUBDATE_SYM 728
#define SUBJECT_SYM 729
#define SUBSTRING 730
#define SUBSTRING_INDEX 731
#define SUM_SYM 732
#define SUPER_SYM 733
#define SUSPEND_SYM 734
#define SWAPS_SYM 735
#define SWITCHES_SYM 736
#define SYSDATE 737
#define TABLES 738
#define TABLESPACE 739
#define TABLE_SYM 740
#define TEMPORARY 741
#define TEMPTABLE_SYM 742
#define TERMINATED 743
#define TEXT_STRING 744
#define TEXT_SYM 745
#define TIMESTAMP 746
#define TIMESTAMP_ADD 747
#define TIMESTAMP_DIFF 748
#define TIME_SYM 749
#define TINYBLOB 750
#define TINYINT 751
#define TINYTEXT 752
#define TO_SYM 753
#define TRAILING 754
#define TRANSACTION_SYM 755
#define TRIGGER_SYM 756
#define TRIGGERS_SYM 757
#define TRIM 758
#define TRUE_SYM 759
#define TRUNCATE_SYM 760
#define TYPES_SYM 761
#define TYPE_SYM 762
#define UDF_RETURNS_SYM 763
#define UDF_SONAME_SYM 764
#define ULONGLONG_NUM 765
#define UNCOMMITTED_SYM 766
#define UNDEFINED_SYM 767
#define UNDERSCORE_CHARSET 768
#define UNDO_SYM 769
#define UNICODE_SYM 770
#define UNION_SYM 771
#define UNIQUE_SYM 772
#define UNIQUE_USERS 773
#define UNIX_TIMESTAMP 774
#define UNKNOWN_SYM 775
#define UNLOCK_SYM 776
#define UNSIGNED 777
#define UNTIL_SYM 778
#define UPDATE_SYM 779
#define UPGRADE_SYM 780
#define USAGE 781
#define USER 782
#define USE_FRM 783
#define USE_SYM 784
#define USING 785
#define UTC_DATE_SYM 786
#define UTC_TIMESTAMP_SYM 787
#define UTC_TIME_SYM 788
#define VAR_SAMP_SYM 789
#define VALUES 790
#define VALUE_SYM 791
#define VARBINARY 792
#define VARCHAR 793
#define VARIABLES 794
#define VARIANCE_SYM 795
#define VARYING 796
#define VIEW_SYM 797
#define WARNINGS 798
#define WEEK_SYM 799
#define WHEN_SYM 800
#define WHERE 801
#define WHILE_SYM 802
#define WITH 803
#define WORK_SYM 804
#define WRITE_SYM 805
#define X509_SYM 806
#define XA_SYM 807
#define XOR 808
#define YEARWEEK 809
#define YEAR_MONTH_SYM 810
#define YEAR_SYM 811
#define ZEROFILL 812
#define TABLE_REF_PRIORITY 813
#define ELSE 814
#define THEN_SYM 815
#define CASE_SYM 816
#define BETWEEN_SYM 817
#define NEG 818




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define YYERROR_UNLESS(A)                  \
  if (!(A))                             \
  {					\
    yyerror(ER(ER_SYNTAX_ERROR));	\
    YYABORT;				\
  }

/* Helper for parsing "IS [NOT] truth_value" */
inline Item *is_truth_value(Item *A, bool v1, bool v2)
{
  return new Item_func_if(create_func_ifnull(A,
	new Item_int((char *) (v2 ? "TRUE" : "FALSE"), v2, 1)),
	new Item_int((char *) (v1 ? "TRUE" : "FALSE"), v1, 1),
	new Item_int((char *) (v1 ? "FALSE" : "TRUE"),!v1, 1));
}

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 280 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1513 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 320 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1528 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  471
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43641

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  583
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  674
/* YYNRULES -- Number of rules. */
#define YYNRULES  2049
/* YYNRULES -- Number of states. */
#define YYNSTATES  3700

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   818

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   576,     2,     2,     2,   569,   564,     2,
     573,   574,   567,   566,   575,   565,   580,   568,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   582,   581,
       2,     2,     2,     2,   579,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   570,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   577,   563,   578,   571,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   572
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   458,   459,   461,   463,
     465,   467,   470,   472,   474,   478,   479,   482,   483,   486,
     487,   491,   492,   498,   500,   502,   503,   506,   509,   512,
     515,   516,   523,   526,   527,   530,   532,   534,   538,   539,
     540,   541,   549,   550,   553,   556,   558,   560,   561,   562,
     571,   572,   579,   581,   584,   586,   589,   590,   591,   598,
     599,   600,   607,   608,   611,   612,   618,   619,   621,   622,
     628,   633,   634,   635,   644,   645,   653,   655,   657,   659,
     661,   663,   666,   669,   672,   677,   682,   683,   688,   689,
     690,   696,   697,   705,   706,   707,   714,   715,   717,   718,
     720,   722,   725,   727,   729,   730,   732,   734,   737,   739,
     740,   744,   745,   747,   749,   752,   754,   757,   761,   765,
     769,   773,   777,   781,   785,   789,   793,   797,   801,   805,
     809,   813,   817,   821,   825,   831,   833,   835,   839,   844,
     849,   853,   858,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   894,   895,
     897,   899,   901,   903,   905,   907,   911,   913,   915,   918,
     921,   928,   936,   945,   948,   951,   952,   954,   957,   958,
     960,   963,   964,   969,   973,   977,   981,   983,   988,   990,
     992,   998,  1001,  1007,  1010,  1015,  1017,  1023,  1029,  1034,
    1038,  1040,  1042,  1045,  1047,  1049,  1052,  1054,  1056,  1058,
    1061,  1065,  1068,  1072,  1075,  1078,  1082,  1086,  1090,  1091,
    1098,  1099,  1106,  1109,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1134,  1137,  1139,  1142,  1144,
    1147,  1151,  1154,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1171,  1172,  1176,  1178,  1184,  1185,  1187,  1190,  1192,  1194,
    1196,  1198,  1199,  1203,  1204,  1206,  1207,  1209,  1212,  1214,
    1216,  1219,  1222,  1227,  1229,  1233,  1236,  1238,  1241,  1244,
    1247,  1250,  1252,  1255,  1257,  1259,  1261,  1263,  1265,  1267,
    1269,  1271,  1273,  1275,  1276,  1279,  1281,  1283,  1284,  1286,
    1287,  1290,  1292,  1295,  1299,  1302,  1303,  1305,  1306,  1308,
    1310,  1313,  1314,  1316,  1317,  1322,  1324,  1329,  1333,  1335,
    1336,  1338,  1341,  1343,  1347,  1351,  1354,  1357,  1360,  1362,
    1364,  1367,  1370,  1373,  1375,  1378,  1381,  1384,  1387,  1389,
    1391,  1392,  1394,  1396,  1398,  1400,  1401,  1403,  1405,  1407,
    1408,  1411,  1414,  1416,  1418,  1420,  1425,  1428,  1430,  1435,
    1436,  1438,  1439,  1442,  1444,  1448,  1449,  1456,  1457,  1463,
    1464,  1470,  1471,  1477,  1478,  1490,  1491,  1493,  1494,  1497,
    1500,  1502,  1506,  1509,  1513,  1516,  1521,  1522,  1529,  1530,
    1531,  1540,  1545,  1550,  1554,  1558,  1561,  1564,  1571,  1577,
    1581,  1587,  1589,  1591,  1593,  1594,  1596,  1597,  1599,  1600,
    1602,  1604,  1605,  1608,  1610,  1611,  1613,  1615,  1617,  1618,
    1624,  1628,  1629,  1635,  1639,  1643,  1644,  1648,  1649,  1652,
    1654,  1658,  1659,  1661,  1663,  1664,  1667,  1669,  1673,  1674,
    1681,  1682,  1689,  1690,  1696,  1697,  1699,  1701,  1702,  1709,
    1710,  1712,  1714,  1717,  1719,  1721,  1723,  1724,  1731,  1732,
    1738,  1739,  1741,  1743,  1746,  1748,  1750,  1752,  1754,  1756,
    1759,  1760,  1767,  1768,  1770,  1772,  1773,  1778,  1783,  1787,
    1793,  1795,  1799,  1803,  1809,  1811,  1815,  1818,  1820,  1822,
    1823,  1830,  1832,  1836,  1840,  1841,  1844,  1845,  1850,  1851,
    1854,  1856,  1859,  1864,  1867,  1871,  1872,  1876,  1877,  1878,
    1885,  1888,  1890,  1892,  1895,  1898,  1907,  1912,  1913,  1915,
    1918,  1920,  1922,  1924,  1926,  1928,  1930,  1932,  1934,  1936,
    1938,  1940,  1941,  1944,  1949,  1953,  1955,  1957,  1962,  1963,
    1964,  1966,  1968,  1969,  1972,  1975,  1977,  1979,  1980,  1983,
    1984,  1988,  1989,  1993,  1997,  1998,  2002,  2003,  2007,  2010,
    2012,  2016,  2021,  2025,  2030,  2034,  2039,  2041,  2045,  2050,
    2054,  2058,  2065,  2067,  2073,  2080,  2086,  2094,  2101,  2110,
    2116,  2123,  2128,  2133,  2139,  2143,  2148,  2150,  2154,  2156,
    2160,  2162,  2166,  2170,  2172,  2176,  2180,  2185,  2190,  2192,
    2196,  2200,  2204,  2208,  2212,  2214,  2218,  2220,  2222,  2224,
    2226,  2228,  2230,  2232,  2234,  2236,  2238,  2240,  2242,  2244,
    2246,  2248,  2250,  2252,  2255,  2257,  2261,  2263,  2265,  2267,
    2269,  2273,  2276,  2279,  2282,  2285,  2289,  2293,  2299,  2306,
    2311,  2316,  2324,  2329,  2332,  2339,  2345,  2352,  2359,  2364,
    2369,  2373,  2378,  2385,  2394,  2401,  2410,  2417,  2422,  2429,
    2434,  2441,  2446,  2451,  2456,  2461,  2468,  2477,  2480,  2483,
    2488,  2491,  2499,  2507,  2511,  2516,  2521,  2528,  2535,  2540,
    2547,  2554,  2561,  2566,  2573,  2578,  2585,  2594,  2605,  2618,
    2625,  2630,  2637,  2644,  2646,  2653,  2658,  2667,  2678,  2683,
    2685,  2689,  2694,  2701,  2708,  2717,  2724,  2731,  2736,  2743,
    2750,  2759,  2764,  2769,  2776,  2781,  2784,  2789,  2794,  2799,
    2806,  2811,  2816,  2820,  2829,  2836,  2841,  2848,  2852,  2859,
    2868,  2873,  2882,  2889,  2898,  2905,  2914,  2917,  2922,  2927,
    2932,  2939,  2948,  2957,  2962,  2970,  2978,  2986,  2993,  3000,
    3007,  3014,  3021,  3028,  3029,  3035,  3046,  3050,  3055,  3059,
    3062,  3065,  3068,  3073,  3080,  3085,  3090,  3097,  3104,  3111,
    3118,  3123,  3130,  3135,  3142,  3147,  3152,  3157,  3162,  3169,
    3174,  3181,  3186,  3193,  3198,  3203,  3210,  3215,  3222,  3227,
    3234,  3239,  3244,  3251,  3256,  3263,  3264,  3268,  3272,  3273,
    3275,  3276,  3279,  3281,  3285,  3290,  3295,  3301,  3306,  3311,
    3316,  3322,  3327,  3328,  3329,  3337,  3348,  3353,  3359,  3364,
    3370,  3375,  3380,  3385,  3390,  3395,  3401,  3402,  3411,  3412,
    3416,  3420,  3422,  3427,  3428,  3430,  3431,  3434,  3435,  3437,
    3438,  3442,  3445,  3449,  3452,  3454,  3457,  3459,  3462,  3464,
    3466,  3468,  3471,  3472,  3474,  3475,  3478,  3480,  3484,  3486,
    3490,  3491,  3494,  3496,  3500,  3501,  3503,  3504,  3507,  3512,
    3518,  3520,  3522,  3524,  3526,  3530,  3534,  3538,  3539,  3546,
    3547,  3554,  3555,  3564,  3569,  3570,  3579,  3580,  3591,  3598,
    3599,  3608,  3609,  3620,  3627,  3629,  3632,  3635,  3636,  3641,
    3642,  3654,  3658,  3665,  3666,  3670,  3671,  3672,  3678,  3679,
    3681,  3682,  3684,  3685,  3688,  3691,  3694,  3695,  3701,  3702,
    3704,  3708,  3710,  3712,  3714,  3718,  3720,  3722,  3724,  3726,
    3728,  3730,  3732,  3734,  3736,  3738,  3740,  3742,  3744,  3746,
    3748,  3750,  3752,  3754,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3771,  3773,  3775,  3776,  3779,  3780,  3782,  3783,
    3784,  3788,  3789,  3790,  3794,  3797,  3798,  3799,  3804,  3809,
    3812,  3813,  3816,  3819,  3823,  3827,  3829,  3832,  3833,  3835,
    3836,  3841,  3846,  3849,  3850,  3852,  3854,  3855,  3857,  3858,
    3860,  3863,  3865,  3869,  3873,  3875,  3877,  3879,  3881,  3882,
    3885,  3887,  3889,  3891,  3893,  3895,  3897,  3899,  3901,  3903,
    3905,  3907,  3908,  3909,  3916,  3917,  3919,  3923,  3925,  3928,
    3929,  3932,  3936,  3938,  3941,  3943,  3944,  3948,  3949,  3955,
    3958,  3960,  3961,  3965,  3972,  3973,  3980,  3985,  3990,  3995,
    4000,  4006,  4011,  4013,  4017,  4019,  4020,  4023,  4024,  4026,
    4027,  4028,  4037,  4038,  4039,  4046,  4047,  4049,  4051,  4053,
    4055,  4057,  4060,  4062,  4064,  4066,  4070,  4075,  4076,  4080,
    4084,  4086,  4089,  4092,  4093,  4097,  4098,  4104,  4108,  4110,
    4114,  4116,  4120,  4122,  4124,  4125,  4127,  4128,  4133,  4134,
    4136,  4140,  4142,  4144,  4146,  4147,  4148,  4155,  4156,  4157,
    4169,  4173,  4175,  4179,  4183,  4185,  4189,  4190,  4192,  4193,
    4198,  4199,  4206,  4207,  4213,  4214,  4221,  4223,  4227,  4231,
    4237,  4238,  4241,  4242,  4245,  4247,  4249,  4251,  4255,  4256,
    4258,  4259,  4261,  4263,  4267,  4269,  4271,  4274,  4277,  4280,
    4282,  4284,  4286,  4288,  4289,  4293,  4294,  4298,  4301,  4306,
    4311,  4316,  4321,  4322,  4327,  4334,  4351,  4354,  4357,  4358,
    4365,  4371,  4374,  4377,  4380,  4382,  4388,  4394,  4397,  4400,
    4402,  4407,  4411,  4414,  4417,  4420,  4424,  4427,  4430,  4433,
    4435,  4437,  4441,  4446,  4450,  4454,  4457,  4460,  4464,  4468,
    4472,  4476,  4480,  4484,  4486,  4488,  4490,  4492,  4493,  4495,
    4496,  4499,  4500,  4502,  4504,  4506,  4507,  4510,  4511,  4514,
    4515,  4518,  4521,  4522,  4527,  4528,  4533,  4535,  4537,  4538,
    4540,  4541,  4543,  4545,  4546,  4551,  4555,  4557,  4558,  4562,
    4567,  4570,  4572,  4574,  4576,  4578,  4580,  4582,  4584,  4586,
    4587,  4589,  4590,  4594,  4598,  4600,  4602,  4604,  4607,  4608,
    4612,  4616,  4619,  4622,  4623,  4628,  4629,  4631,  4633,  4636,
    4637,  4642,  4648,  4649,  4650,  4651,  4668,  4671,  4672,  4674,
    4675,  4677,  4679,  4680,  4682,  4684,  4685,  4688,  4691,  4693,
    4697,  4702,  4706,  4710,  4711,  4714,  4717,  4719,  4723,  4727,
    4728,  4732,  4733,  4737,  4740,  4744,  4746,  4748,  4751,  4752,
    4755,  4757,  4759,  4762,  4765,  4767,  4769,  4771,  4773,  4775,
    4778,  4781,  4783,  4785,  4787,  4789,  4791,  4793,  4795,  4798,
    4801,  4804,  4807,  4810,  4812,  4814,  4816,  4818,  4820,  4822,
    4824,  4828,  4834,  4836,  4838,  4840,  4842,  4844,  4848,  4853,
    4859,  4861,  4867,  4871,  4874,  4876,  4880,  4883,  4885,  4887,
    4889,  4891,  4893,  4895,  4897,  4899,  4901,  4903,  4905,  4907,
    4909,  4911,  4915,  4918,  4920,  4922,  4924,  4926,  4928,  4930,
    4932,  4934,  4936,  4938,  4940,  4942,  4944,  4946,  4948,  4950,
    4952,  4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,  4970,
    4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,  4990,
    4992,  4994,  4996,  4998,  5000,  5002,  5004,  5006,  5008,  5010,
    5012,  5014,  5016,  5018,  5020,  5022,  5024,  5026,  5028,  5030,
    5032,  5034,  5036,  5038,  5040,  5042,  5044,  5046,  5048,  5050,
    5052,  5054,  5056,  5058,  5060,  5062,  5064,  5066,  5068,  5070,
    5072,  5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,  5090,
    5092,  5094,  5096,  5098,  5100,  5102,  5104,  5106,  5108,  5110,
    5112,  5114,  5116,  5118,  5120,  5122,  5124,  5126,  5128,  5130,
    5132,  5134,  5136,  5138,  5140,  5142,  5144,  5146,  5148,  5150,
    5152,  5154,  5156,  5158,  5160,  5162,  5164,  5166,  5168,  5170,
    5172,  5174,  5176,  5178,  5180,  5182,  5184,  5186,  5188,  5190,
    5192,  5194,  5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,
    5212,  5214,  5216,  5218,  5220,  5222,  5224,  5226,  5228,  5230,
    5232,  5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,
    5252,  5254,  5256,  5258,  5260,  5262,  5264,  5266,  5268,  5270,
    5272,  5274,  5276,  5278,  5280,  5282,  5284,  5286,  5288,  5290,
    5292,  5294,  5296,  5298,  5300,  5302,  5304,  5306,  5308,  5310,
    5312,  5314,  5316,  5318,  5320,  5322,  5324,  5326,  5328,  5330,
    5332,  5334,  5336,  5338,  5340,  5342,  5344,  5346,  5348,  5350,
    5352,  5354,  5356,  5358,  5360,  5362,  5364,  5366,  5368,  5370,
    5372,  5374,  5376,  5378,  5380,  5382,  5384,  5386,  5388,  5390,
    5392,  5394,  5396,  5398,  5400,  5402,  5404,  5406,  5408,  5410,
    5412,  5414,  5416,  5418,  5420,  5422,  5424,  5426,  5428,  5430,
    5432,  5434,  5436,  5438,  5440,  5442,  5443,  5448,  5449,  5451,
    5453,  5457,  5458,  5461,  5463,  5465,  5467,  5469,  5470,  5472,
    5473,  5475,  5477,  5479,  5480,  5483,  5486,  5489,  5491,  5494,
    5499,  5505,  5510,  5517,  5520,  5524,  5528,  5532,  5538,  5540,
    5544,  5548,  5551,  5554,  5557,  5559,  5561,  5566,  5571,  5573,
    5575,  5577,  5579,  5581,  5582,  5587,  5589,  5591,  5593,  5597,
    5601,  5603,  5605,  5608,  5611,  5612,  5616,  5621,  5625,  5626,
    5634,  5636,  5639,  5641,  5643,  5645,  5647,  5649,  5651,  5652,
    5658,  5660,  5662,  5664,  5666,  5668,  5672,  5679,  5686,  5693,
    5701,  5705,  5714,  5723,  5732,  5733,  5735,  5737,  5740,  5741,
    5743,  5745,  5749,  5750,  5754,  5755,  5759,  5760,  5764,  5765,
    5769,  5771,  5773,  5775,  5777,  5779,  5781,  5783,  5785,  5787,
    5789,  5791,  5794,  5797,  5799,  5803,  5806,  5809,  5812,  5815,
    5818,  5821,  5824,  5827,  5828,  5830,  5834,  5836,  5839,  5842,
    5845,  5847,  5851,  5855,  5857,  5859,  5863,  5865,  5869,  5874,
    5880,  5882,  5883,  5887,  5891,  5893,  5895,  5896,  5899,  5902,
    5905,  5908,  5909,  5912,  5915,  5917,  5920,  5923,  5926,  5929,
    5932,  5933,  5937,  5938,  5940,  5941,  5945,  5948,  5949,  5951,
    5954,  5955,  5957,  5962,  5967,  5973,  5976,  5980,  5981,  5983,
    5984,  5989,  5990,  5992,  5994,  5995,  5998,  6001,  6003,  6004,
    6006,  6008,  6013,  6014,  6022,  6024,  6025,  6026,  6029,  6033,
    6035,  6037,  6039,  6040,  6044,  6046,  6049,  6051,  6054,  6058,
    6062,  6066,  6067,  6069,  6070,  6074,  6078,  6079,  6088,  6089,
    6093,  6095,  6099,  6100,  6103,  6107,  6113,  6114,  6118,  6123,
    6128,  6129,  6144,  6145,  6152,  6153,  6154,  6155,  6156,  6169,
    6174,  6179,  6183,  6188,  6192,  6195,  6197,  6201,  6207,  6209,
    6211,  6212,  6214,  6216,  6217,  6220,  6221,  6222,  6226,  6227
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     584,     0,    -1,     3,    -1,   585,     3,    -1,   586,    -1,
    1202,    -1,   782,    -1,   823,    -1,   813,    -1,   621,    -1,
     598,    -1,   825,    -1,   815,    -1,  1208,    -1,   603,    -1,
     587,    -1,  1043,    -1,  1074,    -1,   999,    -1,  1001,    -1,
     591,    -1,  1080,    -1,  1177,    -1,  1168,    -1,   596,    -1,
    1007,    -1,  1094,    -1,  1098,    -1,  1160,    -1,   830,    -1,
     838,    -1,   842,    -1,   589,    -1,  1090,    -1,  1211,    -1,
     833,    -1,   818,    -1,  1010,    -1,  1086,    -1,   811,    -1,
    1175,    -1,  1209,    -1,  1210,    -1,   850,    -1,  1143,    -1,
    1060,    -1,   800,    -1,   803,    -1,  1054,    -1,  1166,    -1,
    1035,    -1,  1097,    -1,  1249,    -1,   588,   370,  1137,    -1,
     106,    -1,   129,    -1,   370,  1137,   175,   590,    -1,  1134,
      -1,   579,  1139,    -1,    -1,   151,  1137,   592,   593,    -1,
      -1,   530,   594,    -1,   594,   575,   595,    -1,   595,    -1,
     579,  1139,    -1,    -1,   202,   597,  1139,    -1,    -1,    53,
     287,   498,   599,   600,    -1,   601,    -1,   600,   575,   601,
      -1,   274,   145,  1134,    -1,   288,   145,  1134,    -1,   277,
     145,  1134,    -1,   278,   145,   984,    -1,   273,   145,   984,
      -1,   286,   145,   984,    -1,   282,   145,  1134,    -1,   281,
     145,  1134,    -1,   283,   145,  1134,    -1,   284,   145,  1134,
      -1,   285,   145,  1134,    -1,   602,    -1,   275,   145,  1134,
      -1,   276,   145,   985,    -1,   396,   145,  1134,    -1,   397,
     145,   984,    -1,    -1,    87,   700,   485,   703,  1131,   604,
     687,    -1,    -1,    87,   774,   217,  1137,   775,   344,  1131,
     605,   573,   777,   574,    -1,    -1,    87,    94,   703,  1137,
     606,   697,    -1,    -1,    87,   607,  1225,    -1,    87,   527,
     608,  1193,    -1,    -1,  1137,   580,  1137,    -1,  1137,    -1,
     413,   716,   509,  1134,    -1,    -1,    -1,    -1,    -1,    -1,
     573,   611,   626,   574,   612,   413,   613,   727,   614,   617,
     615,   649,    -1,    -1,   616,   618,    -1,    -1,   617,   619,
      -1,    68,  1134,    -1,   241,   461,    -1,   335,   461,    -1,
      80,   461,    -1,   389,   461,    96,    -1,   311,   461,    96,
      -1,   620,    -1,   618,    -1,   121,    -1,   889,   121,    -1,
     461,   429,   112,    -1,   461,   429,   228,    -1,    -1,    48,
     609,   622,   623,    -1,    -1,   573,   624,   574,    -1,    -1,
     625,    -1,   625,   575,   871,    -1,   871,    -1,    -1,   627,
      -1,   627,   575,   629,    -1,   629,    -1,    -1,  1137,   628,
     727,    -1,    -1,   631,    -1,   631,   575,   632,    -1,   632,
      -1,   633,   628,  1137,   727,    -1,    -1,   229,    -1,   357,
      -1,   221,    -1,    -1,   634,   649,   581,    -1,   649,   581,
      -1,   635,   649,   581,    -1,    -1,   636,   637,   581,    -1,
      -1,   109,   647,   638,   727,   648,    -1,   109,  1137,    76,
     172,   644,    -1,    -1,   109,   642,   199,   172,   639,   643,
     649,    -1,   109,  1137,    92,   172,   640,    -1,    -1,   641,
     586,    -1,   153,    -1,    82,    -1,   646,    -1,   643,   575,
     646,    -1,   984,    -1,   453,   645,  1135,    -1,    -1,   536,
      -1,   644,    -1,  1137,    -1,   454,    -1,   889,   173,    -1,
     452,    -1,  1137,    -1,   647,   575,  1137,    -1,    -1,   111,
     871,    -1,    -1,   650,   586,    -1,    -1,   414,   651,   871,
      -1,    -1,   213,   652,   657,   141,   213,    -1,   662,    -1,
     677,    -1,    -1,   653,   680,    -1,   248,  1138,    -1,   235,
    1138,    -1,   347,  1137,    -1,    -1,   161,   655,  1137,   226,
     654,   656,    -1,    61,  1137,    -1,    -1,   330,   175,    -1,
     175,    -1,  1137,    -1,   656,   575,  1137,    -1,    -1,    -1,
      -1,   658,   871,   560,   659,   635,   660,   661,    -1,    -1,
     135,   657,    -1,   559,   635,    -1,   663,    -1,   666,    -1,
      -1,    -1,   561,   664,   871,   665,   668,   676,   141,   561,
      -1,    -1,   561,   667,   669,   676,   141,   561,    -1,   670,
      -1,   668,   670,    -1,   673,    -1,   669,   673,    -1,    -1,
      -1,   545,   671,   871,   672,   560,   635,    -1,    -1,    -1,
     545,   674,   871,   675,   560,   635,    -1,    -1,   559,   635,
      -1,    -1,  1138,   582,   678,   680,   679,    -1,    -1,  1138,
      -1,    -1,    28,   681,   636,   634,   141,    -1,   269,   635,
     141,   269,    -1,    -1,    -1,   547,   682,   871,   128,   683,
     635,   141,   547,    -1,    -1,   404,   635,   523,   684,   871,
     141,   404,    -1,    27,    -1,     8,    -1,   223,    -1,   524,
      -1,   115,    -1,   573,   688,    -1,   704,   690,    -1,   252,
    1131,    -1,   573,   252,  1131,   574,    -1,   717,   574,   704,
     690,    -1,    -1,   693,   574,   689,  1215,    -1,    -1,    -1,
    1106,   696,   693,   691,  1212,    -1,    -1,  1106,   696,   573,
     693,   574,   692,  1215,    -1,    -1,    -1,   430,   694,   860,
     864,   695,   714,    -1,    -1,    18,    -1,    -1,   698,    -1,
     699,    -1,   698,   699,    -1,   709,    -1,   708,    -1,    -1,
     701,    -1,   702,    -1,   702,   701,    -1,   486,    -1,    -1,
     213,   889,   152,    -1,    -1,   706,    -1,   707,    -1,   707,
     705,    -1,   707,    -1,   707,   706,    -1,   707,   575,   706,
      -1,   143,  1027,   710,    -1,   507,  1027,   710,    -1,   292,
    1027,   985,    -1,   307,  1027,   985,    -1,    24,  1027,   984,
      -1,   361,  1027,  1134,    -1,    68,  1027,  1134,    -1,    23,
    1027,   985,    -1,   358,  1027,   984,    -1,   358,  1027,   111,
      -1,    57,  1027,   984,    -1,   114,  1027,   984,    -1,   423,
    1027,   711,    -1,   387,  1027,   712,    -1,   384,  1027,   984,
      -1,   385,  1027,   984,    -1,   516,  1027,   573,  1003,   574,
      -1,   708,    -1,   709,    -1,   224,  1027,   713,    -1,    96,
     122,  1027,  1134,    -1,   217,   122,  1027,  1134,    -1,    77,
    1027,  1134,    -1,   756,   748,  1027,   750,    -1,   756,    64,
    1027,   755,    -1,  1139,    -1,   111,    -1,   165,    -1,   133,
      -1,    72,    -1,   393,    -1,    71,    -1,   386,    -1,   383,
      -1,   984,    -1,   335,    -1,   164,    -1,   243,    -1,   979,
      -1,   859,   863,    -1,    -1,    10,    -1,   472,    -1,   391,
      -1,   108,    -1,   227,    -1,   718,    -1,   717,   575,   718,
      -1,   719,    -1,   720,    -1,   725,   721,    -1,   725,   761,
      -1,   769,   779,   775,   573,   777,   574,    -1,   723,   770,
     779,   775,   573,   777,   574,    -1,   723,   170,   238,   779,
     573,   777,   574,   761,    -1,   724,   721,    -1,   723,   722,
      -1,    -1,   722,    -1,    58,   871,    -1,    -1,   724,    -1,
      79,   779,    -1,    -1,  1130,   726,   727,   744,    -1,   735,
     742,   739,    -1,   736,   743,   739,    -1,   167,   737,   739,
      -1,    37,    -1,    37,   573,   338,   574,    -1,    42,    -1,
      41,    -1,   731,   573,   338,   574,   757,    -1,   731,   757,
      -1,   732,   573,   338,   574,   758,    -1,   732,   758,    -1,
      32,   573,   338,   574,    -1,    32,    -1,   733,   573,   338,
     574,   757,    -1,   734,   573,   338,   574,   758,    -1,   537,
     573,   338,   574,    -1,   556,   742,   739,    -1,   100,    -1,
     494,    -1,   491,   742,    -1,    97,    -1,   495,    -1,    39,
     742,    -1,   730,    -1,   296,    -1,   265,    -1,   268,   537,
      -1,   268,   733,   757,    -1,   497,   757,    -1,   490,   742,
     757,    -1,   298,   757,    -1,   266,   757,    -1,   108,   737,
     739,    -1,   339,   737,   739,    -1,   165,   737,   739,    -1,
      -1,   144,   728,   573,   781,   574,   757,    -1,    -1,   436,
     729,   573,   781,   574,   757,    -1,   268,   757,    -1,   434,
      -1,   187,    -1,   186,    -1,   365,    -1,   318,    -1,   256,
      -1,   317,    -1,   367,    -1,   319,    -1,    56,    -1,   326,
      -1,   323,    56,    -1,   731,   541,    -1,   538,    -1,   323,
     538,    -1,   340,    -1,   326,   538,    -1,   323,    56,   541,
      -1,   326,   541,    -1,   227,    -1,   496,    -1,   446,    -1,
     297,    -1,    31,    -1,   391,    -1,   127,    -1,   127,   369,
      -1,    -1,   573,   338,   574,    -1,   738,    -1,   573,   338,
     575,   338,   574,    -1,    -1,   740,    -1,   740,   741,    -1,
     741,    -1,   443,    -1,   522,    -1,   557,    -1,    -1,   573,
     338,   574,    -1,    -1,   738,    -1,    -1,   745,    -1,   745,
     746,    -1,   746,    -1,   337,    -1,   889,   337,    -1,   111,
     747,    -1,   344,   524,   334,   870,    -1,    23,    -1,   434,
     111,   536,    -1,   760,   238,    -1,   517,    -1,   517,   238,
      -1,    68,  1134,    -1,    64,   753,    -1,   334,   870,    -1,
    1121,    -1,    56,   436,    -1,    55,    -1,  1139,    -1,    32,
      -1,   749,    -1,   111,    -1,  1139,    -1,    32,    -1,   751,
      -1,   111,    -1,  1139,    -1,    -1,    64,   755,    -1,   753,
      -1,   111,    -1,    -1,   111,    -1,    -1,    20,   758,    -1,
      46,    -1,   515,   758,    -1,   748,   749,   758,    -1,    32,
     759,    -1,    -1,    32,    -1,    -1,    20,    -1,   515,    -1,
     748,   749,    -1,    -1,   372,    -1,    -1,   394,  1131,   762,
     763,    -1,   765,    -1,   573,   764,   574,   765,    -1,   764,
     575,  1137,    -1,  1137,    -1,    -1,   766,    -1,   766,   767,
      -1,   767,    -1,   344,   115,   768,    -1,   344,   524,   768,
      -1,   289,   177,    -1,   289,   360,    -1,   289,   444,    -1,
     411,    -1,    49,    -1,   436,   337,    -1,   335,     5,    -1,
     436,   111,    -1,   771,    -1,   178,   772,    -1,   450,   772,
      -1,   372,   238,    -1,   517,   772,    -1,   238,    -1,   217,
      -1,    -1,   771,    -1,   237,    -1,   217,    -1,   216,    -1,
      -1,   517,    -1,   178,    -1,   450,    -1,    -1,   530,   776,
      -1,   507,   776,    -1,    44,    -1,   425,    -1,   200,    -1,
     777,   575,   778,   977,    -1,   778,   977,    -1,  1137,    -1,
    1137,   573,   338,   574,    -1,    -1,  1130,    -1,    -1,   580,
    1137,    -1,  1119,    -1,   781,   575,  1119,    -1,    -1,    13,
     796,   485,  1131,   783,   789,    -1,    -1,    13,    94,   788,
     784,   697,    -1,    -1,    13,   374,   609,   785,   616,    -1,
      -1,    13,   179,   609,   786,   616,    -1,    -1,    13,  1231,
    1227,  1232,   542,  1131,   787,  1235,    18,  1237,  1240,    -1,
      -1,  1137,    -1,    -1,   124,   484,    -1,   215,   484,    -1,
     791,    -1,   789,   575,   791,    -1,     6,   795,    -1,   790,
     719,   798,    -1,     6,   720,    -1,   790,   573,   717,   574,
      -1,    -1,    53,   795,  1130,   792,   725,   798,    -1,    -1,
      -1,   312,   795,  1130,   793,   727,   744,   794,   798,    -1,
     129,   795,  1130,   797,    -1,   129,   170,   238,   779,    -1,
     129,   372,   238,    -1,   129,   771,  1130,    -1,   123,   237,
      -1,   137,   237,    -1,    13,   795,  1130,   436,   111,  1121,
      -1,    13,   795,  1130,   129,   111,    -1,   401,   799,  1131,
      -1,    83,   498,   748,   750,   754,    -1,   705,    -1,   169,
      -1,   970,    -1,    -1,    67,    -1,    -1,   214,    -1,    -1,
     411,    -1,    49,    -1,    -1,     8,  1137,    -1,   164,    -1,
      -1,   498,    -1,   145,    -1,    18,    -1,    -1,   465,   445,
     805,   801,   809,    -1,   469,   445,   805,    -1,    -1,   445,
     465,   805,   802,   809,    -1,   445,   469,   805,    -1,   465,
     500,   804,    -1,    -1,   548,    78,   447,    -1,    -1,   806,
     807,    -1,   808,    -1,   807,   575,   808,    -1,    -1,   462,
      -1,   398,    -1,    -1,   523,   810,    -1,   602,    -1,   810,
     575,   602,    -1,    -1,   410,  1162,   812,  1003,   175,  1134,
      -1,    -1,    26,  1162,   814,  1003,   498,  1134,    -1,    -1,
      57,  1162,   816,  1003,   817,    -1,    -1,   382,    -1,   156,
      -1,    -1,   402,   832,  1162,   819,  1003,   820,    -1,    -1,
     821,    -1,   822,    -1,   822,   821,    -1,   382,    -1,   156,
      -1,   528,    -1,    -1,    14,   832,  1162,   824,  1003,   827,
      -1,    -1,    58,  1162,   826,  1003,   827,    -1,    -1,   828,
      -1,   829,    -1,   829,   828,    -1,   382,    -1,   159,    -1,
     299,    -1,   156,    -1,    54,    -1,   172,   525,    -1,    -1,
     348,   832,  1162,   831,  1003,   827,    -1,    -1,   336,    -1,
     258,    -1,    -1,   401,  1162,   834,   836,    -1,   401,   527,
     608,   835,    -1,  1140,   498,  1140,    -1,   835,   575,  1140,
     498,  1140,    -1,   837,    -1,   836,   575,   837,    -1,  1131,
     498,  1131,    -1,    47,   217,   839,   229,   841,    -1,   840,
      -1,   839,   575,   840,    -1,  1131,   846,    -1,  1137,    -1,
     111,    -1,    -1,   257,   217,   226,    47,   843,   844,    -1,
     845,    -1,   844,   575,   845,    -1,  1131,   846,   849,    -1,
      -1,   847,   848,    -1,    -1,   772,   573,   954,   574,    -1,
      -1,   214,   247,    -1,   851,    -1,   430,   853,    -1,   573,
     852,   574,  1215,    -1,   430,   855,    -1,   573,   852,   574,
      -1,    -1,   855,   854,  1212,    -1,    -1,    -1,   856,   860,
     864,   857,   858,   863,    -1,   973,   979,    -1,   995,    -1,
     859,    -1,   995,   859,    -1,   859,   995,    -1,   175,   928,
     962,   967,   964,   973,   979,   986,    -1,   175,   130,   962,
     979,    -1,    -1,   861,    -1,   861,   862,    -1,   862,    -1,
     471,    -1,   204,    -1,   125,    -1,   460,    -1,   455,    -1,
     456,    -1,   458,    -1,   459,    -1,   457,    -1,    12,    -1,
      -1,   172,   524,    -1,   262,   229,   438,   310,    -1,   864,
     575,   865,    -1,   865,    -1,   567,    -1,   866,   868,   867,
     869,    -1,    -1,    -1,  1125,    -1,   871,    -1,    -1,    18,
    1137,    -1,    18,  1134,    -1,  1137,    -1,  1134,    -1,    -1,
     573,   574,    -1,    -1,   874,   872,   873,    -1,    -1,   873,
     887,   874,    -1,   874,   553,   874,    -1,    -1,   877,   875,
     876,    -1,    -1,   876,   888,   877,    -1,   333,   877,    -1,
     878,    -1,   879,   232,   504,    -1,   879,   232,   889,   504,
      -1,   879,   232,   158,    -1,   879,   232,   889,   158,    -1,
     879,   232,   520,    -1,   879,   232,   889,   520,    -1,   879,
      -1,   879,   232,   337,    -1,   879,   232,   889,   337,    -1,
     879,   146,   880,    -1,   879,   891,   880,    -1,   879,   891,
     892,   573,  1220,   574,    -1,   880,    -1,   881,   229,   573,
    1220,   574,    -1,   881,   889,   229,   573,  1220,   574,    -1,
     881,   229,   573,   871,   574,    -1,   881,   229,   573,   871,
     575,   917,   574,    -1,   881,   889,   229,   573,   871,   574,
      -1,   881,   889,   229,   573,   871,   575,   917,   574,    -1,
     881,   562,   881,    16,   880,    -1,   881,   889,   562,   881,
      16,   880,    -1,   881,   448,   252,   881,    -1,   881,   252,
     894,   966,    -1,   881,   889,   252,   894,   966,    -1,   881,
     395,   881,    -1,   881,   889,   395,   881,    -1,   881,    -1,
     881,   563,   882,    -1,   882,    -1,   882,   564,   883,    -1,
     883,    -1,   883,   439,   884,    -1,   883,   440,   884,    -1,
     884,    -1,   884,   566,   885,    -1,   884,   565,   885,    -1,
     884,   566,   893,   956,    -1,   884,   565,   893,   956,    -1,
     885,    -1,   885,   567,   886,    -1,   885,   568,   886,    -1,
     885,   569,   886,    -1,   885,   126,   886,    -1,   885,   313,
     886,    -1,   886,    -1,   886,   570,   894,    -1,   894,    -1,
     354,    -1,   351,    -1,    16,    -1,    15,    -1,   333,    -1,
     332,    -1,   576,    -1,   332,    -1,   145,    -1,   184,    -1,
     198,    -1,   244,    -1,   271,    -1,   328,    -1,    12,    -1,
      17,    -1,   225,   871,    -1,  1127,    -1,   894,    64,  1139,
      -1,  1122,    -1,  1120,    -1,   907,    -1,   903,    -1,   894,
     353,   894,    -1,   566,   894,    -1,   565,   894,    -1,   571,
     894,    -1,   890,   894,    -1,   573,  1220,   574,    -1,   573,
     871,   574,    -1,   573,   871,   575,   917,   574,    -1,   424,
     573,   871,   575,   917,   574,    -1,   152,   573,  1220,   574,
      -1,   577,  1137,   871,   578,    -1,   289,   920,     9,   573,
     881,   897,   574,    -1,    20,   573,   871,   574,    -1,    32,
     894,    -1,    51,   573,   871,    18,   915,   574,    -1,   561,
     924,   926,   925,   141,    -1,    83,   573,   871,   575,   915,
     574,    -1,    83,   573,   871,   530,   749,   574,    -1,   111,
     573,  1127,   574,    -1,   535,   573,  1128,   574,    -1,   180,
     573,   574,    -1,   181,   573,   871,   574,    -1,   182,   573,
     871,   575,   871,   574,    -1,   183,   573,   871,   575,   871,
     575,   871,   574,    -1,     7,   573,   871,   575,   871,   574,
      -1,     7,   573,   871,   575,   225,   871,   956,   574,    -1,
     404,   573,   871,   575,   871,   574,    -1,    22,   573,   871,
     574,    -1,    22,   573,   871,   575,   871,   574,    -1,    56,
     573,   917,   574,    -1,    56,   573,   917,   530,   749,   574,
      -1,    55,   573,   871,   574,    -1,    62,   573,   917,   574,
      -1,    65,   573,   871,   574,    -1,    73,   573,   917,   574,
      -1,    74,   573,   871,   575,   917,   574,    -1,    84,   573,
     871,   575,   871,   575,   871,   574,    -1,    90,   870,    -1,
      93,   870,    -1,    93,   573,   871,   574,    -1,    91,   870,
      -1,    98,   573,   871,   575,   893,   956,   574,    -1,    99,
     573,   871,   575,   893,   956,   574,    -1,    94,   573,   574,
      -1,   100,   573,   871,   574,    -1,   105,   573,   871,   574,
      -1,   136,   573,   871,   575,   917,   574,    -1,   272,   573,
     871,   575,   917,   574,    -1,   140,   573,   871,   574,    -1,
     140,   573,   871,   575,   871,   574,    -1,   110,   573,   871,
     575,  1135,   574,    -1,   139,   573,   871,   575,  1135,   574,
      -1,   118,   573,   871,   574,    -1,   118,   573,   871,   575,
     871,   574,    -1,   119,   573,   871,   574,    -1,   119,   573,
     871,   575,   871,   574,    -1,   155,   573,   871,   575,   871,
     575,   871,   574,    -1,   155,   573,   871,   575,   871,   575,
     871,   575,   871,   574,    -1,   155,   573,   871,   575,   871,
     575,   871,   575,   871,   575,   871,   574,    -1,   171,   573,
     871,   575,   338,   574,    -1,   176,   573,   871,   574,    -1,
     176,   573,   871,   575,   871,   574,    -1,   162,   573,   871,
     575,   917,   574,    -1,   896,    -1,   190,   573,   958,   575,
     871,   574,    -1,   209,   573,   871,   574,    -1,   213,   573,
     871,   575,   871,   575,   871,   574,    -1,   223,   573,   871,
     575,   871,   575,   871,   575,   871,   574,    -1,   893,   956,
     566,   871,    -1,   893,    -1,   242,   573,   574,    -1,   242,
     573,   871,   574,    -1,   249,   573,   871,   575,   871,   574,
      -1,   259,   573,   871,   575,   871,   574,    -1,   259,   573,
     871,   575,   871,   575,   871,   574,    -1,   194,   573,   871,
     575,   917,   574,    -1,   246,   573,   871,   575,   917,   574,
      -1,   264,   573,   871,   574,    -1,   264,   573,   871,   575,
     871,   574,    -1,   279,   573,   871,   575,   871,   574,    -1,
     279,   573,   871,   575,   871,   575,   871,   574,    -1,   302,
     573,   871,   574,    -1,   306,   573,   871,   574,    -1,   313,
     573,   871,   575,   871,   574,    -1,   314,   573,   871,   574,
      -1,   334,   870,    -1,   334,   573,   871,   574,    -1,   361,
     573,   871,   574,    -1,   343,   573,   871,   574,    -1,   368,
     573,   881,   229,   871,   574,    -1,   380,   573,   871,   574,
      -1,   388,   573,   871,   574,    -1,   388,   573,   574,    -1,
     405,   573,   871,   575,   871,   575,   871,   574,    -1,   416,
     573,   871,   575,   871,   574,    -1,   419,   573,   871,   574,
      -1,   419,   573,   871,   575,   871,   574,    -1,   422,   573,
     574,    -1,   473,   573,   871,   575,   871,   574,    -1,   473,
     573,   871,   575,   225,   871,   956,   574,    -1,   428,   573,
     871,   574,    -1,   475,   573,   871,   575,   871,   575,   871,
     574,    -1,   475,   573,   871,   575,   871,   574,    -1,   475,
     573,   871,   175,   871,   172,   871,   574,    -1,   475,   573,
     871,   175,   871,   574,    -1,   476,   573,   871,   575,   871,
     575,   871,   574,    -1,   482,   870,    -1,   482,   573,   871,
     574,    -1,   494,   573,   871,   574,    -1,   491,   573,   871,
     574,    -1,   491,   573,   871,   575,   871,   574,    -1,   492,
     573,   957,   575,   871,   575,   871,   574,    -1,   493,   573,
     957,   575,   871,   575,   871,   574,    -1,   503,   573,   871,
     574,    -1,   503,   573,   245,   871,   175,   871,   574,    -1,
     503,   573,   499,   871,   175,   871,   574,    -1,   503,   573,
      43,   871,   175,   871,   574,    -1,   503,   573,   245,   175,
     871,   574,    -1,   503,   573,   499,   175,   871,   574,    -1,
     503,   573,    43,   175,   871,   574,    -1,   503,   573,   871,
     175,   871,   574,    -1,   505,   573,   871,   575,   871,   574,
      -1,  1137,   580,  1137,   573,   916,   574,    -1,    -1,  1133,
     573,   895,   898,   574,    -1,   518,   573,  1118,   575,   338,
     575,   338,   575,   917,   574,    -1,   519,   573,   574,    -1,
     519,   573,   871,   574,    -1,   527,   573,   574,    -1,   531,
     870,    -1,   533,   870,    -1,   532,   870,    -1,   544,   573,
     871,   574,    -1,   544,   573,   871,   575,   871,   574,    -1,
     556,   573,   871,   574,    -1,   554,   573,   871,   574,    -1,
     554,   573,   871,   575,   871,   574,    -1,    29,   573,   984,
     575,   871,   574,    -1,   157,   573,   956,   175,   871,   574,
      -1,    80,   573,   871,   575,   871,   574,    -1,   188,   573,
     871,   574,    -1,   188,   573,   871,   575,   871,   574,    -1,
     189,   573,   871,   574,    -1,   189,   573,   871,   575,   871,
     574,    -1,   186,   573,   917,   574,    -1,   256,   573,   917,
     574,    -1,   317,   573,   917,   574,    -1,   309,   573,   871,
     574,    -1,   309,   573,   871,   575,   871,   574,    -1,   315,
     573,   871,   574,    -1,   315,   573,   871,   575,   871,   574,
      -1,   316,   573,   871,   574,    -1,   316,   573,   871,   575,
     871,   574,    -1,   318,   573,   917,   574,    -1,   319,   573,
     917,   574,    -1,   365,   573,   871,   575,   871,   574,    -1,
     364,   573,   871,   574,    -1,   364,   573,   871,   575,   871,
     574,    -1,   366,   573,   871,   574,    -1,   366,   573,   871,
     575,   871,   574,    -1,   367,   573,   917,   574,    -1,   185,
     573,   871,   574,    -1,   185,   573,   871,   575,   871,   574,
      -1,   254,   573,   871,   574,    -1,   254,   573,   871,   575,
     871,   574,    -1,    -1,   548,   381,   154,    -1,   229,    41,
     310,    -1,    -1,   899,    -1,    -1,   900,   901,    -1,   902,
      -1,   901,   575,   902,    -1,   866,   871,   867,   869,    -1,
      25,   573,   913,   574,    -1,    25,   573,   125,   913,   574,
      -1,    35,   573,   913,   574,    -1,    36,   573,   913,   574,
      -1,    38,   573,   913,   574,    -1,    85,   573,   961,   567,
     574,    -1,    85,   573,   913,   574,    -1,    -1,    -1,    85,
     573,   125,   904,   917,   905,   574,    -1,   197,   573,  1118,
     575,   338,   575,   338,   575,   913,   574,    -1,   308,   573,
     913,   574,    -1,   308,   573,   125,   913,   574,    -1,   293,
     573,   913,   574,    -1,   293,   573,   125,   913,   574,    -1,
     467,   573,   913,   574,    -1,   540,   573,   913,   574,    -1,
     468,   573,   913,   574,    -1,   534,   573,   913,   574,    -1,
     477,   573,   913,   574,    -1,   477,   573,   125,   913,   574,
      -1,    -1,   196,   573,   910,   906,   917,   912,   911,   574,
      -1,    -1,   579,   908,   909,    -1,  1139,   437,   871,    -1,
    1139,    -1,   579,  1152,  1139,   780,    -1,    -1,   125,    -1,
      -1,   432,  1119,    -1,    -1,   974,    -1,    -1,   961,   914,
     871,    -1,    32,   742,    -1,    56,   742,   757,    -1,   326,
     742,    -1,   443,    -1,   443,   227,    -1,   522,    -1,   522,
     227,    -1,   100,    -1,   494,    -1,    97,    -1,   108,   737,
      -1,    -1,   917,    -1,    -1,   918,   919,    -1,   871,    -1,
     919,   575,   871,    -1,   921,    -1,   573,   921,   574,    -1,
      -1,   922,   923,    -1,  1127,    -1,   923,   575,  1127,    -1,
      -1,   871,    -1,    -1,   559,   871,    -1,   545,   871,   560,
     871,    -1,   926,   545,   871,   560,   871,    -1,   939,    -1,
     930,    -1,   929,    -1,   927,    -1,   929,   575,   927,    -1,
     927,   938,   927,    -1,   927,   471,   939,    -1,    -1,   927,
     938,   927,   344,   931,   871,    -1,    -1,   927,   471,   939,
     344,   932,   871,    -1,    -1,   927,   938,   927,   530,   933,
     573,   955,   574,    -1,   927,   324,   236,   939,    -1,    -1,
     927,   249,   949,   236,   927,   344,   934,   871,    -1,    -1,
     927,   249,   949,   236,   939,   935,   530,   573,   955,   574,
      -1,   927,   324,   249,   949,   236,   939,    -1,    -1,   927,
     416,   949,   236,   927,   344,   936,   871,    -1,    -1,   927,
     416,   949,   236,   939,   937,   530,   573,   955,   574,    -1,
     927,   324,   416,   949,   236,   939,    -1,   236,    -1,   219,
     236,    -1,    88,   236,    -1,    -1,   940,  1131,   960,   950,
      -1,    -1,   577,  1137,   927,   249,   355,   236,   927,   344,
     941,   871,   578,    -1,   948,   947,   944,    -1,   573,   947,
     942,  1215,   574,   960,    -1,    -1,   947,   943,   929,    -1,
      -1,    -1,   945,   860,   864,   946,   714,    -1,    -1,   430,
      -1,    -1,   355,    -1,    -1,   529,   951,    -1,   169,   951,
      -1,   214,   951,    -1,    -1,   771,   952,   573,   953,   574,
      -1,    -1,   954,    -1,   954,   575,  1137,    -1,  1137,    -1,
     372,    -1,  1137,    -1,   955,   575,  1137,    -1,   957,    -1,
     101,    -1,   102,    -1,   103,    -1,   104,    -1,   206,    -1,
     207,    -1,   208,    -1,   302,    -1,   304,    -1,   305,    -1,
     427,    -1,   555,    -1,   105,    -1,   544,    -1,   209,    -1,
     174,    -1,   306,    -1,   314,    -1,   380,    -1,   428,    -1,
     556,    -1,   100,    -1,   494,    -1,    97,    -1,   491,    -1,
      -1,    18,    -1,   145,    -1,    -1,   959,  1137,    -1,    -1,
      12,    -1,    -1,    -1,   546,   963,   871,    -1,    -1,    -1,
     201,   965,   871,    -1,   149,   894,    -1,    -1,    -1,   195,
      45,   968,   969,    -1,   968,   575,  1126,   977,    -1,  1126,
     977,    -1,    -1,   548,    89,    -1,   548,   418,    -1,   352,
      45,   971,    -1,   971,   575,   972,    -1,   972,    -1,  1128,
     977,    -1,    -1,   974,    -1,    -1,   352,    45,   975,   976,
      -1,   976,   575,  1126,   977,    -1,  1126,   977,    -1,    -1,
      19,    -1,   116,    -1,    -1,   980,    -1,    -1,   980,    -1,
     253,   981,    -1,   982,    -1,   982,   575,   982,    -1,   982,
     341,   982,    -1,  1120,    -1,   510,    -1,   267,    -1,   338,
      -1,    -1,   253,   982,    -1,   338,    -1,   203,    -1,   267,
      -1,   510,    -1,   107,    -1,   166,    -1,   338,    -1,   510,
      -1,   267,    -1,   107,    -1,   166,    -1,    -1,    -1,   374,
    1137,   987,   573,   988,   574,    -1,    -1,   989,    -1,   989,
     575,   990,    -1,   990,    -1,   866,   871,    -1,    -1,   992,
     993,    -1,   993,   575,   994,    -1,   994,    -1,   579,  1139,
      -1,  1139,    -1,    -1,   226,   996,   997,    -1,    -1,   356,
    1136,   998,  1107,  1110,    -1,   131,  1136,    -1,   991,    -1,
      -1,   128,  1000,   917,    -1,   129,  1006,  1162,  1005,  1003,
     797,    -1,    -1,   129,   217,  1137,   344,  1131,  1002,    -1,
     129,    94,  1005,  1137,    -1,   129,   179,  1005,   609,    -1,
     129,   374,  1005,   609,    -1,   129,   527,   608,  1192,    -1,
     129,   542,  1005,  1003,   797,    -1,   129,   501,  1005,   609,
      -1,  1004,    -1,  1003,   575,  1004,    -1,  1131,    -1,    -1,
     213,   152,    -1,    -1,   486,    -1,    -1,    -1,   223,  1008,
    1013,   796,  1015,  1009,  1017,  1033,    -1,    -1,    -1,   405,
    1011,  1014,  1015,  1012,  1017,    -1,    -1,   270,    -1,   113,
      -1,   204,    -1,  1042,    -1,   113,    -1,   226,  1016,    -1,
    1016,    -1,  1004,    -1,  1020,    -1,   573,   574,  1020,    -1,
     573,  1019,   574,  1020,    -1,    -1,   436,  1018,  1024,    -1,
    1019,   575,  1124,    -1,  1124,    -1,   535,  1023,    -1,   536,
    1023,    -1,    -1,   693,  1021,  1212,    -1,    -1,   573,   693,
     574,  1022,  1215,    -1,  1023,   575,  1028,    -1,  1028,    -1,
    1024,   575,  1025,    -1,  1025,    -1,  1128,  1026,  1032,    -1,
     145,    -1,   437,    -1,    -1,  1026,    -1,    -1,   573,  1029,
    1030,   574,    -1,    -1,  1031,    -1,  1031,   575,  1032,    -1,
    1032,    -1,   871,    -1,   111,    -1,    -1,    -1,   344,   132,
    1034,   238,   524,  1040,    -1,    -1,    -1,   524,  1036,  1042,
     796,   928,   436,  1038,  1037,   962,   973,   983,    -1,  1038,
     575,  1039,    -1,  1039,    -1,  1128,  1026,  1032,    -1,  1040,
     575,  1041,    -1,  1041,    -1,  1128,  1026,  1032,    -1,    -1,
     270,    -1,    -1,   115,  1044,  1052,  1045,    -1,    -1,   175,
    1131,  1046,   962,   973,   983,    -1,    -1,  1049,  1047,   175,
     928,   962,    -1,    -1,   175,  1049,  1048,   530,   928,   962,
      -1,  1050,    -1,  1049,   575,  1050,    -1,  1137,  1051,   960,
      -1,  1137,   580,  1137,  1051,   960,    -1,    -1,   580,   567,
      -1,    -1,  1053,  1052,    -1,   382,    -1,   270,    -1,   214,
      -1,   505,  1055,  1004,    -1,    -1,   485,    -1,    -1,  1057,
      -1,  1058,    -1,  1057,   575,  1058,    -1,    86,    -1,   300,
      -1,    40,   230,    -1,    81,   481,    -1,   359,   160,    -1,
     231,    -1,   480,    -1,   449,    -1,    12,    -1,    -1,   172,
     381,   338,    -1,    -1,   441,  1061,  1062,    -1,    95,  1073,
      -1,  1069,   483,  1068,  1073,    -1,  1069,   502,  1068,  1073,
      -1,   485,   466,  1068,  1073,    -1,   347,   483,  1068,  1073,
      -1,    -1,   143,   710,  1063,  1065,    -1,  1069,    66,  1070,
    1131,  1068,  1073,    -1,   329,   287,   172,   445,   548,   275,
     145,  1134,    16,   276,   145,   985,    16,   280,   145,   984,
      -1,  1066,   263,    -1,   445,   205,    -1,    -1,    33,   150,
    1071,  1072,  1064,   978,    -1,   773,  1070,  1131,  1068,   962,
      -1,    67,   506,    -1,   485,   506,    -1,  1067,   142,    -1,
     373,    -1,    85,   573,   567,   574,   543,    -1,    85,   573,
     567,   574,   147,    -1,   543,   978,    -1,   147,   978,    -1,
     378,    -1,   377,  1056,  1059,   978,    -1,  1151,   466,  1073,
      -1,   220,   466,    -1,   320,   466,    -1,  1069,   376,    -1,
    1151,   539,  1073,    -1,   748,  1073,    -1,    65,  1073,    -1,
      30,   263,    -1,   263,    -1,   193,    -1,   193,   172,  1140,
      -1,    87,    94,   703,  1137,    -1,    87,   485,  1131,    -1,
      87,   542,  1131,    -1,   287,   466,    -1,   445,   466,    -1,
      87,   374,   609,    -1,    87,   179,   609,    -1,   374,   466,
    1073,    -1,   179,   466,  1073,    -1,   374,    63,   609,    -1,
     179,    63,   609,    -1,   466,    -1,   263,    -1,   287,    -1,
      32,    -1,    -1,   470,    -1,    -1,  1070,  1137,    -1,    -1,
     177,    -1,   175,    -1,   229,    -1,    -1,   229,  1134,    -1,
      -1,   175,   985,    -1,    -1,   252,  1134,    -1,   546,   871,
      -1,    -1,  1077,  1131,  1075,  1079,    -1,    -1,  1077,  1078,
    1076,   850,    -1,   116,    -1,   117,    -1,    -1,   156,    -1,
      -1,  1119,    -1,  1137,    -1,    -1,   168,   832,  1081,  1082,
      -1,  1082,   575,  1083,    -1,  1083,    -1,    -1,  1162,  1084,
    1085,    -1,   483,   548,   390,   262,    -1,   381,    47,    -1,
     205,    -1,   373,    -1,   263,    -1,   466,    -1,   445,    -1,
     287,    -1,   120,    -1,   409,    -1,    -1,  1003,    -1,    -1,
     408,  1087,  1088,    -1,  1088,   575,  1089,    -1,  1089,    -1,
     445,    -1,   287,    -1,   381,    47,    -1,    -1,   379,  1091,
    1092,    -1,  1066,   263,  1093,    -1,   498,  1134,    -1,    27,
     871,    -1,    -1,   239,  1095,  1096,   871,    -1,    -1,    77,
      -1,   381,    -1,   529,  1137,    -1,    -1,   257,    96,  1099,
    1100,    -1,   257,   485,  1131,   175,   287,    -1,    -1,    -1,
      -1,  1105,  1104,   218,  1136,  1101,  1106,   226,  1102,   485,
    1131,  1103,  1107,  1110,  1113,  1114,  1117,    -1,   175,   287,
      -1,    -1,   258,    -1,    -1,    75,    -1,   270,    -1,    -1,
     405,    -1,   214,    -1,    -1,    66,  1108,    -1,  1108,  1109,
      -1,  1109,    -1,   488,    45,  1119,    -1,   350,   138,    45,
    1119,    -1,   138,    45,  1119,    -1,   148,    45,  1119,    -1,
      -1,   255,  1111,    -1,  1111,  1112,    -1,  1112,    -1,   488,
      45,  1119,    -1,   464,    45,  1119,    -1,    -1,   214,   338,
     255,    -1,    -1,   573,  1115,   574,    -1,   573,   574,    -1,
    1115,   575,  1116,    -1,  1116,    -1,  1128,    -1,   579,  1139,
      -1,    -1,   436,  1040,    -1,  1135,    -1,   325,    -1,   513,
     489,    -1,  1118,  1135,    -1,  1135,    -1,   203,    -1,    34,
      -1,   362,    -1,  1122,    -1,   566,  1123,    -1,   565,  1123,
      -1,  1118,    -1,  1123,    -1,   337,    -1,   158,    -1,   504,
      -1,   203,    -1,    34,    -1,   513,   203,    -1,   513,    34,
      -1,   100,  1118,    -1,   494,  1118,    -1,   491,  1118,    -1,
     338,    -1,   267,    -1,   510,    -1,   107,    -1,   166,    -1,
    1128,    -1,  1125,    -1,  1137,   580,   567,    -1,  1137,   580,
    1137,   580,   567,    -1,   871,    -1,  1137,    -1,  1129,    -1,
    1137,    -1,  1129,    -1,  1137,   580,  1137,    -1,   580,  1137,
     580,  1137,    -1,  1137,   580,  1137,   580,  1137,    -1,  1137,
      -1,  1137,   580,  1137,   580,  1137,    -1,  1137,   580,  1137,
      -1,   580,  1137,    -1,  1137,    -1,  1137,   580,  1137,    -1,
     580,  1137,    -1,  1137,    -1,   210,    -1,   212,    -1,   489,
      -1,   489,    -1,   489,    -1,  1133,    -1,  1141,    -1,  1133,
      -1,  1142,    -1,  1137,    -1,  1134,    -1,   251,    -1,  1139,
      -1,  1139,   579,  1139,    -1,    91,   870,    -1,  1142,    -1,
      20,    -1,    26,    -1,    28,    -1,    46,    -1,    47,    -1,
      55,    -1,    57,    -1,    61,    -1,    68,    -1,    70,    -1,
      80,    -1,   106,    -1,   128,    -1,   141,    -1,   151,    -1,
     168,    -1,   199,    -1,   202,    -1,   241,    -1,   335,    -1,
     347,    -1,   370,    -1,   402,    -1,   408,    -1,   410,    -1,
     417,    -1,   426,    -1,   429,    -1,   443,    -1,   445,    -1,
     465,    -1,   469,    -1,   505,    -1,   515,    -1,   552,    -1,
     525,    -1,     5,    -1,     7,    -1,     8,    -1,     9,    -1,
      10,    -1,    11,    -1,    17,    -1,    23,    -1,    24,    -1,
      25,    -1,    30,    -1,    33,    -1,    37,    -1,    40,    -1,
      42,    -1,    41,    -1,    44,    -1,    50,    -1,    52,    -1,
      54,    -1,    59,    -1,    60,    -1,    63,    -1,    65,    -1,
      66,    -1,    69,    -1,    71,    -1,    72,    -1,    75,    -1,
      78,    -1,    81,    -1,    86,    -1,    89,    -1,    96,    -1,
      97,    -1,   100,    -1,   105,    -1,   112,    -1,   114,    -1,
     120,    -1,   122,    -1,   124,    -1,   131,    -1,   132,    -1,
     133,    -1,   144,    -1,   143,    -1,   142,    -1,   147,    -1,
     149,    -1,   150,    -1,   154,    -1,   156,    -1,   159,    -1,
     160,    -1,   173,    -1,   123,    -1,   137,    -1,   177,    -1,
     163,    -1,   164,    -1,   165,    -1,   174,    -1,   187,    -1,
     186,    -1,   190,    -1,   193,    -1,   191,    -1,   200,    -1,
     205,    -1,   209,    -1,   211,    -1,   228,    -1,   215,    -1,
     216,    -1,   233,    -1,   234,    -1,   220,    -1,   224,    -1,
     230,    -1,   231,    -1,   398,    -1,   243,    -1,   247,    -1,
     250,    -1,   256,    -1,   258,    -1,   261,    -1,   263,    -1,
     292,    -1,   287,    -1,   274,    -1,   278,    -1,   275,    -1,
     276,    -1,   288,    -1,   277,    -1,   280,    -1,   273,    -1,
     286,    -1,   282,    -1,   281,    -1,   283,    -1,   284,    -1,
     285,    -1,   290,    -1,   291,    -1,   294,    -1,   295,    -1,
     299,    -1,   300,    -1,   301,    -1,   302,    -1,   303,    -1,
     306,    -1,   307,    -1,   312,    -1,   310,    -1,   314,    -1,
     317,    -1,   318,    -1,   319,    -1,   320,    -1,   322,    -1,
     321,    -1,   323,    -1,   326,    -1,   327,    -1,   330,    -1,
     329,    -1,   331,    -1,   340,    -1,   341,    -1,   343,    -1,
     345,    -1,   346,    -1,   358,    -1,   359,    -1,   360,    -1,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,   371,    -1,
     373,    -1,   375,    -1,   376,    -1,   377,    -1,   378,    -1,
     380,    -1,   381,    -1,   382,    -1,   383,    -1,   384,    -1,
     385,    -1,   386,    -1,   387,    -1,   392,    -1,   393,    -1,
     396,    -1,   397,    -1,   400,    -1,   403,    -1,   406,    -1,
     409,    -1,   412,    -1,   413,    -1,   418,    -1,   420,    -1,
     421,    -1,   423,    -1,   424,    -1,   425,    -1,   428,    -1,
     434,    -1,   433,    -1,   435,    -1,   444,    -1,   438,    -1,
     442,    -1,   447,    -1,   448,    -1,   449,    -1,   457,    -1,
     456,    -1,   459,    -1,   462,    -1,   466,    -1,   470,    -1,
     472,    -1,   473,    -1,   474,    -1,   478,    -1,   479,    -1,
     480,    -1,   481,    -1,   483,    -1,   484,    -1,   486,    -1,
     487,    -1,   490,    -1,   500,    -1,   502,    -1,   491,    -1,
     492,    -1,   493,    -1,   494,    -1,   506,    -1,   507,    -1,
     508,    -1,   179,    -1,   511,    -1,   512,    -1,   520,    -1,
     523,    -1,   527,    -1,   528,    -1,   539,    -1,   542,    -1,
     536,    -1,   543,    -1,   544,    -1,   549,    -1,   551,    -1,
     556,    -1,    -1,   436,  1145,  1144,  1146,    -1,    -1,   349,
      -1,  1147,    -1,  1146,   575,  1147,    -1,    -1,  1148,  1153,
      -1,  1150,    -1,   191,    -1,   258,    -1,   435,    -1,    -1,
     345,    -1,    -1,   191,    -1,   258,    -1,   435,    -1,    -1,
     191,   580,    -1,   258,   580,    -1,   435,   580,    -1,  1154,
      -1,  1150,  1155,    -1,  1149,  1156,  1026,  1159,    -1,  1149,
     500,   233,   250,  1157,    -1,   579,  1139,  1026,   871,    -1,
     579,   579,  1152,  1156,  1026,  1159,    -1,   748,   752,    -1,
     321,  1026,   871,    -1,   321,   750,   754,    -1,   361,  1026,
    1158,    -1,   361,   172,  1140,  1026,  1158,    -1,  1137,    -1,
    1137,   580,  1137,    -1,   111,   580,  1137,    -1,   390,   511,
      -1,   390,    69,    -1,   403,   390,    -1,   433,    -1,   489,
      -1,   361,   573,   489,   574,    -1,   343,   573,   489,   574,
      -1,   871,    -1,   111,    -1,   344,    -1,    12,    -1,    32,
      -1,    -1,   262,  1162,  1161,  1163,    -1,   485,    -1,   483,
      -1,  1164,    -1,  1163,   575,  1164,    -1,  1131,   960,  1165,
      -1,   390,    -1,   550,    -1,   270,   550,    -1,   390,   258,
      -1,    -1,   521,  1167,  1162,    -1,   199,  1131,   347,   960,
      -1,   199,  1132,    61,    -1,    -1,   199,  1132,   390,  1169,
    1170,   962,   979,    -1,  1171,    -1,  1137,  1172,    -1,   164,
      -1,   330,    -1,   164,    -1,   330,    -1,   371,    -1,   243,
      -1,    -1,  1174,  1173,   573,  1031,   574,    -1,   145,    -1,
     184,    -1,   244,    -1,   198,    -1,   271,    -1,   415,   608,
    1176,    -1,  1180,   344,  1179,  1191,   175,  1193,    -1,  1180,
     344,   179,  1191,   175,  1193,    -1,  1180,   344,   374,  1191,
     175,  1193,    -1,    12,  1181,   575,   192,   349,   175,  1193,
      -1,   192,   608,  1178,    -1,  1180,   344,  1179,  1191,   498,
    1193,  1198,  1199,    -1,  1180,   344,   179,  1191,   498,  1193,
    1198,  1199,    -1,  1180,   344,   374,  1191,   498,  1193,  1198,
    1199,    -1,    -1,   485,    -1,  1182,    -1,    12,  1181,    -1,
      -1,   373,    -1,  1183,    -1,  1182,   575,  1183,    -1,    -1,
     430,  1184,  1195,    -1,    -1,   223,  1185,  1195,    -1,    -1,
     524,  1186,  1195,    -1,    -1,   394,  1187,  1195,    -1,   115,
      -1,   526,    -1,   217,    -1,    13,    -1,    87,    -1,   129,
      -1,   151,    -1,   400,    -1,   442,    -1,   375,    -1,   163,
      -1,   192,   349,    -1,   441,    95,    -1,   478,    -1,    87,
     486,   483,    -1,   262,   483,    -1,   406,   445,    -1,   406,
      60,    -1,    87,   542,    -1,   441,   542,    -1,    87,   420,
      -1,    13,   420,    -1,    87,   527,    -1,    -1,    16,    -1,
    1190,  1188,  1189,    -1,  1190,    -1,   474,   489,    -1,   234,
     489,    -1,    59,   489,    -1,   567,    -1,  1137,   580,   567,
      -1,   567,   580,   567,    -1,  1131,    -1,  1140,    -1,  1192,
     575,  1140,    -1,  1194,    -1,  1193,   575,  1194,    -1,  1140,
     211,    45,   489,    -1,  1140,   211,    45,   361,   489,    -1,
    1140,    -1,    -1,   573,  1196,   574,    -1,  1196,   575,  1197,
      -1,  1197,    -1,  1137,    -1,    -1,   407,  1189,    -1,   407,
     463,    -1,   407,   551,    -1,   407,   331,    -1,    -1,   548,
    1200,    -1,  1200,  1201,    -1,  1201,    -1,   192,   349,    -1,
     291,   984,    -1,   294,   984,    -1,   290,   984,    -1,   295,
     984,    -1,    -1,    28,  1203,  1204,    -1,    -1,   549,    -1,
      -1,    16,   335,    52,    -1,    16,    52,    -1,    -1,   399,
      -1,   335,   399,    -1,    -1,   426,    -1,    70,  1204,  1205,
    1206,    -1,   417,  1204,  1205,  1206,    -1,   417,  1204,   498,
    1207,  1137,    -1,   426,  1137,    -1,   399,   426,  1137,    -1,
      -1,  1213,    -1,    -1,   516,  1219,  1214,   851,    -1,    -1,
    1213,    -1,  1216,    -1,    -1,  1217,  1218,    -1,   974,   978,
      -1,   980,    -1,    -1,   125,    -1,    12,    -1,   430,  1223,
    1222,  1224,    -1,    -1,   573,  1223,  1220,   574,  1221,  1212,
    1224,    -1,   853,    -1,    -1,    -1,  1227,  1226,    -1,  1228,
    1227,  1233,    -1,  1233,    -1,  1241,    -1,  1243,    -1,    -1,
     112,   145,  1140,    -1,  1229,    -1,  1229,  1230,    -1,  1230,
      -1,   354,   405,    -1,    11,   145,   512,    -1,    11,   145,
     301,    -1,    11,   145,   487,    -1,    -1,  1230,    -1,    -1,
     461,   429,   112,    -1,   461,   429,   228,    -1,    -1,  1232,
     542,  1131,  1234,  1235,    18,  1237,  1240,    -1,    -1,   573,
    1236,   574,    -1,  1137,    -1,  1236,   575,  1137,    -1,    -1,
    1238,  1239,    -1,   430,   866,   853,    -1,   573,   866,   852,
     574,  1215,    -1,    -1,   548,    58,   349,    -1,   548,    50,
      58,   349,    -1,   548,   258,    58,   349,    -1,    -1,   501,
     866,   609,   685,   686,   344,   866,  1131,   172,   866,   134,
     424,  1242,   649,    -1,    -1,   715,   866,   179,   609,  1244,
     610,    -1,    -1,    -1,    -1,    -1,   374,   866,   609,  1245,
     573,  1246,   630,   574,  1247,   617,  1248,   649,    -1,   552,
    1251,  1250,  1252,    -1,   552,   141,  1250,  1254,    -1,   552,
     370,  1250,    -1,   552,    70,  1250,  1253,    -1,   552,   417,
    1250,    -1,   552,   392,    -1,  1119,    -1,  1119,   575,  1119,
      -1,  1119,   575,  1119,   575,   984,    -1,    28,    -1,   465,
      -1,    -1,   236,    -1,   412,    -1,    -1,   346,   363,    -1,
      -1,    -1,   479,  1255,  1256,    -1,    -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1074,  1074,  1088,  1091,  1092,  1097,  1098,  1099,  1100,
    1101,  1102,  1103,  1104,  1105,  1106,  1107,  1108,  1109,  1110,
    1111,  1112,  1113,  1114,  1115,  1116,  1117,  1118,  1119,  1120,
    1121,  1122,  1123,  1124,  1125,  1126,  1127,  1128,  1129,  1130,
    1131,  1132,  1133,  1134,  1135,  1136,  1137,  1138,  1139,  1140,
    1141,  1142,  1143,  1147,  1161,  1162,  1167,  1181,  1188,  1198,
    1197,  1213,  1215,  1219,  1220,  1223,  1236,  1235,  1254,  1253,
    1264,  1265,  1268,  1273,  1278,  1283,  1288,  1292,  1297,  1301,
    1305,  1309,  1313,  1318,  1322,  1326,  1342,  1346,  1358,  1357,
    1380,  1379,  1400,  1399,  1412,  1411,  1419,  1427,  1441,  1456,
    1474,  1494,  1531,  1537,  1545,  1557,  1493,  1586,  1587,  1591,
    1592,  1597,  1599,  1601,  1603,  1605,  1607,  1609,  1615,  1616,
    1617,  1621,  1625,  1633,  1632,  1645,  1647,  1650,  1652,  1656,
    1660,  1667,  1669,  1673,  1674,  1679,  1698,  1724,  1726,  1730,
    1731,  1735,  1761,  1762,  1763,  1764,  1768,  1769,  1773,  1774,
    1779,  1782,  1809,  1808,  1864,  1879,  1878,  1918,  1942,  1942,
    1973,  1974,  1979,  2000,  2024,  2030,  2045,  2046,  2050,  2054,
    2063,  2068,  2073,  2081,  2096,  2114,  2115,  2119,  2119,  2165,
    2164,  2188,  2187,  2191,  2192,  2194,  2194,  2205,  2234,  2262,
    2278,  2277,  2294,  2311,  2313,  2314,  2318,  2339,  2362,  2364,
    2378,  2362,  2396,  2398,  2399,  2403,  2404,  2409,  2415,  2408,
    2434,  2433,  2449,  2450,  2454,  2455,  2460,  2464,  2459,  2481,
    2485,  2480,  2500,  2508,  2513,  2512,  2550,  2551,  2556,  2555,
    2582,  2593,  2595,  2592,  2619,  2618,  2636,  2638,  2643,  2645,
    2647,  2652,  2653,  2654,  2666,  2681,  2682,  2682,  2686,  2688,
    2687,  2690,  2689,  2695,  2711,  2694,  2725,  2726,  2729,  2730,
    2733,  2734,  2737,  2738,  2741,  2742,  2745,  2746,  2749,  2752,
    2753,  2755,  2757,  2760,  2761,  2764,  2765,  2766,  2769,  2770,
    2771,  2772,  2773,  2774,  2775,  2776,  2777,  2792,  2798,  2799,
    2800,  2801,  2806,  2811,  2816,  2831,  2832,  2833,  2834,  2835,
    2836,  2840,  2857,  2873,  2883,  2884,  2885,  2886,  2887,  2888,
    2891,  2892,  2893,  2896,  2897,  2898,  2901,  2902,  2905,  2906,
    2909,  2910,  2911,  2912,  2915,  2916,  2920,  2921,  2925,  2926,
    2933,  2941,  2949,  2966,  2970,  2976,  2978,  2982,  2986,  2987,
    2991,  2996,  2995,  3017,  3018,  3019,  3020,  3022,  3024,  3026,
    3028,  3030,  3032,  3035,  3038,  3041,  3044,  3046,  3049,  3052,
    3053,  3054,  3055,  3068,  3069,  3071,  3073,  3085,  3087,  3089,
    3091,  3092,  3093,  3094,  3095,  3096,  3098,  3100,  3102,  3102,
    3104,  3104,  3106,  3107,  3116,  3117,  3118,  3121,  3122,  3123,
    3124,  3125,  3129,  3133,  3134,  3138,  3139,  3143,  3144,  3145,
    3146,  3147,  3151,  3152,  3153,  3154,  3155,  3158,  3160,  3161,
    3165,  3166,  3167,  3170,  3177,  3178,  3181,  3182,  3185,  3186,
    3187,  3190,  3191,  3194,  3195,  3198,  3199,  3202,  3203,  3206,
    3207,  3208,  3209,  3211,  3212,  3218,  3224,  3230,  3236,  3237,
    3253,  3254,  3258,  3259,  3263,  3271,  3275,  3276,  3280,  3289,
    3293,  3294,  3297,  3307,  3308,  3312,  3313,  3316,  3317,  3320,
    3321,  3322,  3323,  3332,  3333,  3336,  3337,  3340,  3341,  3342,
    3351,  3353,  3355,  3360,  3359,  3371,  3372,  3375,  3376,  3380,
    3381,  3384,  3385,  3388,  3389,  3390,  3391,  3392,  3395,  3396,
    3397,  3398,  3399,  3402,  3403,  3404,  3416,  3417,  3420,  3421,
    3424,  3425,  3429,  3430,  3431,  3434,  3435,  3436,  3437,  3450,
    3451,  3452,  3455,  3456,  3460,  3463,  3464,  3467,  3468,  3479,
    3480,  3483,  3484,  3487,  3488,  3496,  3495,  3519,  3518,  3533,
    3532,  3551,  3550,  3570,  3568,  3583,  3584,  3586,  3587,  3588,
    3589,  3590,  3593,  3601,  3602,  3606,  3611,  3610,  3618,  3627,
    3617,  3639,  3646,  3650,  3657,  3664,  3670,  3676,  3682,  3689,
    3708,  3729,  3734,  3738,  3745,  3746,  3749,  3750,  3754,  3755,
    3756,  3760,  3761,  3762,  3765,  3766,  3767,  3768,  3776,  3775,
    3786,  3794,  3793,  3803,  3813,  3822,  3823,  3830,  3830,  3836,
    3837,  3841,  3842,  3843,  3847,  3848,  3865,  3866,  3871,  3870,
    3881,  3880,  3891,  3890,  3900,  3901,  3902,  3907,  3906,  3918,
    3919,  3922,  3923,  3926,  3927,  3928,  3932,  3931,  3944,  3943,
    3960,  3961,  3964,  3965,  3968,  3969,  3970,  3971,  3972,  3973,
    3977,  3976,  3988,  3989,  3990,  3995,  3994,  4000,  4007,  4012,
    4020,  4021,  4024,  4036,  4045,  4046,  4049,  4062,  4063,  4068,
    4067,  4077,  4078,  4081,  4094,  4094,  4104,  4105,  4114,  4115,
    4124,  4133,  4135,  4138,  4160,  4164,  4163,  4183,  4191,  4183,
    4197,  4198,  4199,  4200,  4201,  4204,  4206,  4213,  4215,  4226,
    4227,  4230,  4231,  4237,  4238,  4239,  4240,  4246,  4252,  4258,
    4268,  4271,  4273,  4279,  4289,  4290,  4291,  4304,  4322,  4325,
    4328,  4329,  4332,  4333,  4334,  4335,  4336,  4340,  4341,  4345,
    4345,  4362,  4364,  4369,  4370,  4370,  4387,  4389,  4394,  4395,
    4398,  4399,  4400,  4401,  4402,  4403,  4404,  4407,  4408,  4409,
    4410,  4412,  4414,  4417,  4419,  4421,  4425,  4431,  4435,  4443,
    4445,  4451,  4454,  4456,  4458,  4459,  4461,  4464,  4465,  4468,
    4469,  4472,  4474,  4476,  4479,  4480,  4481,  4483,  4485,  4488,
    4489,  4490,  4491,  4492,  4493,  4496,  4497,  4499,  4499,  4500,
    4500,  4501,  4501,  4502,  4502,  4504,  4505,  4506,  4507,  4508,
    4509,  4512,  4513,  4517,  4521,  4522,  4529,  4530,  4531,  4532,
    4533,  4535,  4536,  4537,  4538,  4539,  4543,  4544,  4549,  4554,
    4558,  4559,  4563,  4564,  4568,  4578,  4580,  4589,  4591,  4602,
    4604,  4615,  4626,  4637,  4648,  4650,  4652,  4654,  4656,  4658,
    4660,  4662,  4664,  4666,  4668,  4670,  4672,  4678,  4680,  4682,
    4687,  4692,  4694,  4696,  4701,  4703,  4705,  4707,  4709,  4714,
    4715,  4717,  4719,  4721,  4723,  4725,  4727,  4729,  4731,  4733,
    4735,  4737,  4741,  4743,  4753,  4755,  4757,  4759,  4761,  4764,
    4773,  4778,  4783,  4785,  4787,  4789,  4791,  4793,  4795,  4797,
    4802,  4807,  4809,  4811,  4813,  4815,  4817,  4819,  4825,  4827,
    4829,  4831,  4833,  4835,  4837,  4839,  4841,  4842,  4847,  4849,
    4851,  4853,  4855,  4857,  4859,  4861,  4863,  4870,  4877,  4879,
    4881,  4883,  4885,  4887,  4889,  4891,  4893,  4895,  4897,  4899,
    4901,  4903,  4905,  4919,  4918,  5036,  5040,  5045,  5047,  5049,
    5051,  5053,  5055,  5060,  5062,  5064,  5066,  5068,  5073,  5077,
    5079,  5081,  5083,  5085,  5087,  5091,  5094,  5097,  5099,  5101,
    5103,  5105,  5107,  5109,  5112,  5115,  5117,  5119,  5121,  5123,
    5125,  5128,  5130,  5132,  5134,  5139,  5140,  5141,  5145,  5146,
    5150,  5150,  5156,  5160,  5167,  5198,  5200,  5202,  5204,  5206,
    5208,  5210,  5213,  5215,  5212,  5218,  5220,  5227,  5229,  5231,
    5233,  5235,  5237,  5239,  5241,  5243,  5246,  5245,  5260,  5259,
    5274,  5280,  5286,  5299,  5300,  5303,  5304,  5309,  5312,  5324,
    5323,  5339,  5340,  5341,  5342,  5343,  5344,  5345,  5346,  5347,
    5348,  5349,  5353,  5354,  5358,  5358,  5363,  5364,  5367,  5368,
    5371,  5371,  5376,  5377,  5380,  5381,  5384,  5385,  5388,  5394,
    5404,  5405,  5414,  5419,  5420,  5440,  5442,  5446,  5444,  5461,
    5459,  5477,  5475,  5483,  5492,  5490,  5508,  5507,  5518,  5529,
    5527,  5546,  5545,  5557,  5567,  5568,  5569,  5574,  5574,  5593,
    5591,  5610,  5632,  5680,  5679,  5702,  5719,  5702,  5726,  5730,
    5756,  5757,  5760,  5761,  5767,  5774,  5782,  5782,  5788,  5789,
    5793,  5797,  5801,  5807,  5815,  5824,  5825,  5826,  5827,  5828,
    5829,  5830,  5831,  5832,  5833,  5834,  5835,  5836,  5839,  5840,
    5841,  5842,  5843,  5844,  5845,  5846,  5847,  5851,  5852,  5853,
    5854,  5857,  5859,  5860,  5863,  5864,  5867,  5869,  5873,  5875,
    5874,  5888,  5891,  5890,  5905,  5911,  5924,  5926,  5929,  5931,
    5935,  5936,  5949,  5967,  5971,  5972,  5976,  5989,  5991,  5995,
    5994,  6026,  6028,  6032,  6033,  6034,  6039,  6045,  6049,  6050,
    6054,  6058,  6065,  6072,  6081,  6082,  6083,  6084,  6089,  6093,
    6101,  6102,  6103,  6104,  6105,  6106,  6110,  6111,  6112,  6113,
    6114,  6117,  6120,  6119,  6148,  6149,  6152,  6153,  6156,  6169,
    6169,  6179,  6180,  6184,  6196,  6229,  6228,  6241,  6240,  6249,
    6261,  6272,  6271,  6288,  6295,  6295,  6307,  6314,  6326,  6338,
    6342,  6348,  6358,  6359,  6362,  6370,  6371,  6375,  6376,  6384,
    6393,  6383,  6403,  6410,  6402,  6420,  6432,  6433,  6434,  6438,
    6439,  6442,  6443,  6446,  6455,  6456,  6457,  6459,  6458,  6468,
    6469,  6472,  6473,  6474,  6474,  6475,  6475,  6479,  6480,  6483,
    6485,  6488,  6496,  6497,  6501,  6502,  6507,  6506,  6519,  6520,
    6523,  6528,  6536,  6537,  6540,  6542,  6542,  6550,  6559,  6549,
    6581,  6582,  6585,  6592,  6593,  6596,  6605,  6606,  6612,  6611,
    6625,  6624,  6633,  6632,  6640,  6639,  6649,  6650,  6653,  6660,
    6673,  6674,  6678,  6679,  6682,  6683,  6684,  6687,  6697,  6699,
    6701,  6703,  6706,  6707,  6710,  6714,  6718,  6722,  6726,  6730,
    6734,  6738,  6742,  6750,  6753,  6762,  6761,  6775,  6783,  6792,
    6801,  6810,  6820,  6819,  6822,  6832,  6842,  6846,  6851,  6850,
    6855,  6865,  6870,  6876,  6881,  6886,  6888,  6890,  6892,  6894,
    6896,  6898,  6907,  6909,  6911,  6913,  6922,  6930,  6938,  6940,
    6942,  6952,  6959,  6965,  6973,  6981,  6985,  6989,  6996,  7003,
    7013,  7023,  7033,  7046,  7060,  7073,  7074,  7076,  7078,  7081,
    7082,  7085,  7086,  7089,  7090,  7093,  7094,  7097,  7098,  7100,
    7102,  7105,  7117,  7116,  7131,  7130,  7140,  7141,  7144,  7145,
    7149,  7150,  7151,  7159,  7158,  7170,  7171,  7174,  7174,  7175,
    7176,  7177,  7178,  7179,  7180,  7181,  7182,  7183,  7184,  7187,
    7188,  7192,  7191,  7200,  7201,  7204,  7205,  7206,  7210,  7209,
    7218,  7222,  7227,  7239,  7239,  7247,  7248,  7249,  7254,  7264,
    7263,  7276,  7294,  7305,  7310,  7293,  7323,  7332,  7333,  7336,
    7337,  7349,  7353,  7354,  7355,  7357,  7359,  7362,  7363,  7366,
    7371,  7378,  7383,  7389,  7391,  7394,  7395,  7398,  7403,  7409,
    7411,  7418,  7419,  7420,  7423,  7425,  7430,  7431,  7436,  7437,
    7443,  7448,  7450,  7452,  7457,  7459,  7470,  7483,  7503,  7504,
    7505,  7514,  7515,  7516,  7518,  7519,  7520,  7521,  7522,  7536,
    7550,  7551,  7552,  7555,  7556,  7557,  7558,  7566,  7581,  7582,
    7585,  7591,  7602,  7605,  7639,  7643,  7651,  7655,  7723,  7738,
    7762,  7763,  7779,  7789,  7792,  7793,  7794,  7798,  7802,  7803,
    7828,  7840,  7853,  7865,  7866,  7875,  7876,  7885,  7886,  7887,
    7890,  7903,  7916,  7930,  7931,  7932,  7933,  7934,  7935,  7936,
    7937,  7938,  7939,  7940,  7941,  7942,  7943,  7944,  7945,  7946,
    7947,  7948,  7949,  7950,  7951,  7952,  7953,  7954,  7955,  7956,
    7957,  7958,  7959,  7960,  7961,  7962,  7963,  7964,  7965,  7966,
    7976,  7977,  7978,  7979,  7980,  7981,  7982,  7983,  7984,  7985,
    7986,  7987,  7988,  7989,  7990,  7991,  7992,  7993,  7994,  7995,
    7996,  7997,  7998,  7999,  8000,  8001,  8002,  8003,  8004,  8005,
    8006,  8007,  8008,  8009,  8010,  8011,  8012,  8013,  8014,  8015,
    8016,  8017,  8018,  8019,  8020,  8021,  8022,  8023,  8024,  8025,
    8026,  8027,  8028,  8029,  8030,  8031,  8032,  8033,  8034,  8035,
    8036,  8037,  8038,  8039,  8040,  8041,  8042,  8043,  8044,  8045,
    8046,  8047,  8048,  8049,  8050,  8051,  8052,  8053,  8054,  8055,
    8056,  8057,  8058,  8059,  8060,  8061,  8062,  8063,  8064,  8065,
    8066,  8067,  8068,  8069,  8070,  8071,  8072,  8073,  8074,  8075,
    8076,  8077,  8078,  8079,  8080,  8081,  8082,  8083,  8084,  8085,
    8086,  8087,  8088,  8089,  8090,  8091,  8092,  8093,  8094,  8095,
    8096,  8097,  8098,  8099,  8100,  8101,  8102,  8103,  8104,  8105,
    8106,  8107,  8108,  8109,  8110,  8111,  8112,  8113,  8114,  8115,
    8116,  8117,  8118,  8119,  8120,  8121,  8122,  8123,  8124,  8125,
    8126,  8127,  8128,  8129,  8130,  8131,  8132,  8133,  8134,  8135,
    8136,  8137,  8138,  8139,  8140,  8141,  8142,  8143,  8144,  8145,
    8146,  8147,  8148,  8149,  8150,  8151,  8152,  8153,  8154,  8155,
    8156,  8157,  8158,  8159,  8160,  8161,  8162,  8163,  8164,  8165,
    8166,  8167,  8168,  8169,  8170,  8171,  8172,  8173,  8174,  8175,
    8176,  8177,  8178,  8179,  8180,  8181,  8182,  8183,  8184,  8185,
    8186,  8187,  8188,  8189,  8190,  8191,  8192,  8193,  8194,  8195,
    8196,  8197,  8198,  8199,  8200,  8207,  8206,  8220,  8221,  8224,
    8225,  8228,  8228,  8300,  8301,  8302,  8303,  8307,  8308,  8312,
    8313,  8314,  8315,  8319,  8320,  8321,  8322,  8326,  8327,  8330,
    8410,  8423,  8427,  8432,  8439,  8454,  8467,  8488,  8495,  8533,
    8576,  8590,  8591,  8592,  8593,  8597,  8598,  8605,  8614,  8615,
    8616,  8617,  8618,  8626,  8625,  8641,  8642,  8645,  8646,  8649,
    8657,  8658,  8659,  8660,  8665,  8664,  8685,  8697,  8710,  8709,
    8728,  8729,  8733,  8734,  8738,  8739,  8740,  8741,  8743,  8742,
    8753,  8754,  8755,  8756,  8757,  8763,  8768,  8775,  8788,  8800,
    8807,  8812,  8820,  8833,  8847,  8849,  8852,  8853,  8860,  8862,
    8866,  8867,  8870,  8870,  8871,  8871,  8872,  8872,  8873,  8873,
    8874,  8875,  8876,  8877,  8878,  8879,  8880,  8881,  8882,  8883,
    8884,  8885,  8886,  8887,  8888,  8889,  8890,  8891,  8892,  8893,
    8894,  8895,  8896,  8901,  8902,  8906,  8907,  8911,  8921,  8931,
    8944,  8959,  8972,  8985,  8997,  8998,  9007,  9008,  9017,  9042,
    9044,  9051,  9055,  9058,  9059,  9062,  9083,  9084,  9088,  9092,
    9096,  9103,  9104,  9107,  9108,  9112,  9113,  9119,  9125,  9131,
    9141,  9140,  9150,  9151,  9155,  9156,  9157,  9161,  9162,  9163,
    9167,  9168,  9172,  9182,  9189,  9199,  9208,  9222,  9223,  9228,
    9227,  9262,  9263,  9264,  9268,  9268,  9292,  9293,  9297,  9298,
    9299,  9303,  9308,  9307,  9328,  9334,  9354,  9370,  9372,  9377,
    9379,  9381,  9393,  9403,  9416,  9418,  9420,  9425,  9430,  9432,
    9434,  9440,  9441,  9447,  9448,  9450,  9456,  9455,  9470,  9471,
    9475,  9480,  9488,  9488,  9506,  9515,  9528,  9529,  9531,  9533,
    9546,  9544,  9619,  9618,  9628,  9657,  9664,  9671,  9627,  9693,
    9697,  9701,  9705,  9709,  9713,  9719,  9726,  9733,  9742,  9743,
    9747,  9748,  9749,  9753,  9754,  9758,  9759,  9759,  9764,  9765
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STD_SYM", "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'",
  "$accept", "query", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "@1",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "@2",
  "change", "@3", "master_defs", "master_def", "master_file_def", "create",
  "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_cond", "opt_value",
  "sp_hcond", "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "@17",
  "@18", "@19", "@20", "@21", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "@22", "@23", "@24", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "@25", "@26", "searched_case_stmt", "@27",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "@28", "@29", "searched_when_clause", "@30", "@31",
  "else_clause_opt", "sp_labeled_control", "@32", "sp_opt_label",
  "sp_unlabeled_control", "@33", "@34", "@35", "@36", "trg_action_time",
  "trg_event", "create2", "create2a", "@37", "create3", "@38", "@39",
  "create_select", "@40", "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "old_or_new_charset_name",
  "old_or_new_charset_name_or_default", "collation_name", "opt_collate",
  "collation_name_or_default", "opt_default", "opt_binary", "opt_bin_mod",
  "opt_bin_charset", "opt_primary", "references", "@45", "opt_ref_list",
  "ref_list", "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@46", "@47", "@48", "@49",
  "@50", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@51", "@52", "@53", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_ignore_lines", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user", "keyword", "keyword_sp", "set", "@132",
  "opt_option", "option_value_list", "option_type_value", "@133",
  "option_type", "option_type2", "opt_var_type", "opt_var_ident_type",
  "ext_option_value", "sys_option_value", "option_value",
  "internal_variable_name", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "@134", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "@135",
  "handler", "@136", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "@137", "handler_rkey_mode", "revoke",
  "revoke_command", "grant", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "@138", "@139", "@140", "@141", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "grant_option_list",
  "grant_option", "begin", "@142", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "@143", "union_opt",
  "union_order_or_limit", "@144", "order_or_limit", "union_option",
  "subselect", "@145", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@146", "view_list_opt",
  "view_list", "view_select", "@147", "view_select_aux",
  "view_check_option", "trigger_tail", "@148", "sp_tail", "@149", "@150",
  "@151", "@152", "@153", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@154",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   124,    38,    45,    43,    42,    47,    37,
      94,   126,   818,    40,    41,    44,    33,   123,   125,    64,
      46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   583,   584,   584,   585,   585,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   587,   588,   588,   589,   590,   590,   592,
     591,   593,   593,   594,   594,   595,   597,   596,   599,   598,
     600,   600,   601,   601,   601,   601,   601,   601,   601,   601,
     601,   601,   601,   601,   602,   602,   602,   602,   604,   603,
     605,   603,   606,   603,   607,   603,   603,   608,   609,   609,
     610,   611,   612,   613,   614,   615,   610,   616,   616,   617,
     617,   618,   618,   618,   618,   618,   618,   618,   619,   619,
     619,   620,   620,   622,   621,   623,   623,   624,   624,   625,
     625,   626,   626,   627,   627,   628,   629,   630,   630,   631,
     631,   632,   633,   633,   633,   633,   634,   634,   635,   635,
     636,   636,   638,   637,   637,   639,   637,   637,   641,   640,
     642,   642,   643,   643,   644,   644,   645,   645,   646,   646,
     646,   646,   646,   647,   647,   648,   648,   650,   649,   651,
     649,   652,   649,   649,   649,   653,   649,   649,   649,   649,
     654,   649,   649,   655,   655,   655,   656,   656,   658,   659,
     660,   657,   661,   661,   661,   662,   662,   664,   665,   663,
     667,   666,   668,   668,   669,   669,   671,   672,   670,   674,
     675,   673,   676,   676,   678,   677,   679,   679,   681,   680,
     680,   682,   683,   680,   684,   680,   685,   685,   686,   686,
     686,   687,   687,   687,   687,   688,   689,   688,   690,   691,
     690,   692,   690,   694,   695,   693,   696,   696,   697,   697,
     698,   698,   699,   699,   700,   700,   701,   701,   702,   703,
     703,   704,   704,   705,   705,   706,   706,   706,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     707,   708,   709,   710,   711,   711,   711,   711,   711,   711,
     712,   712,   712,   713,   713,   713,   714,   714,   715,   715,
     716,   716,   716,   716,   717,   717,   718,   718,   719,   719,
     720,   720,   720,   720,   720,   721,   721,   722,   723,   723,
     724,   726,   725,   727,   727,   727,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   727,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   727,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   727,   727,   727,   728,   727,
     729,   727,   727,   727,   730,   730,   730,   730,   730,   730,
     730,   730,   731,   732,   732,   733,   733,   734,   734,   734,
     734,   734,   735,   735,   735,   735,   735,   736,   736,   736,
     737,   737,   737,   738,   739,   739,   740,   740,   741,   741,
     741,   742,   742,   743,   743,   744,   744,   745,   745,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     747,   747,   748,   748,   749,   749,   750,   750,   751,   751,
     752,   752,   753,   754,   754,   755,   755,   756,   756,   757,
     757,   757,   757,   757,   757,   758,   758,   759,   759,   759,
     759,   760,   760,   762,   761,   763,   763,   764,   764,   765,
     765,   766,   766,   767,   767,   767,   767,   767,   768,   768,
     768,   768,   768,   769,   769,   769,   770,   770,   771,   771,
     772,   772,   773,   773,   773,   774,   774,   774,   774,   775,
     775,   775,   776,   776,   776,   777,   777,   778,   778,   779,
     779,   780,   780,   781,   781,   783,   782,   784,   782,   785,
     782,   786,   782,   787,   782,   788,   788,   789,   789,   789,
     789,   789,   790,   791,   791,   791,   792,   791,   793,   794,
     791,   791,   791,   791,   791,   791,   791,   791,   791,   791,
     791,   791,   791,   791,   795,   795,   796,   796,   797,   797,
     797,   798,   798,   798,   799,   799,   799,   799,   801,   800,
     800,   802,   800,   800,   803,   804,   804,   806,   805,   807,
     807,   808,   808,   808,   809,   809,   810,   810,   812,   811,
     814,   813,   816,   815,   817,   817,   817,   819,   818,   820,
     820,   821,   821,   822,   822,   822,   824,   823,   826,   825,
     827,   827,   828,   828,   829,   829,   829,   829,   829,   829,
     831,   830,   832,   832,   832,   834,   833,   833,   835,   835,
     836,   836,   837,   838,   839,   839,   840,   841,   841,   843,
     842,   844,   844,   845,   847,   846,   848,   848,   849,   849,
     850,   851,   851,   852,   852,   854,   853,   856,   857,   855,
     858,   858,   858,   858,   858,   859,   859,   860,   860,   861,
     861,   862,   862,   862,   862,   862,   862,   862,   862,   862,
     862,   863,   863,   863,   864,   864,   864,   865,   866,   867,
     868,   868,   869,   869,   869,   869,   869,   870,   870,   872,
     871,   873,   873,   874,   875,   874,   876,   876,   877,   877,
     878,   878,   878,   878,   878,   878,   878,   879,   879,   879,
     879,   879,   879,   880,   880,   880,   880,   880,   880,   880,
     880,   880,   880,   880,   880,   880,   880,   881,   881,   882,
     882,   883,   883,   883,   884,   884,   884,   884,   884,   885,
     885,   885,   885,   885,   885,   886,   886,   887,   887,   888,
     888,   889,   889,   890,   890,   891,   891,   891,   891,   891,
     891,   892,   892,   893,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   895,   894,   894,   894,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   897,   897,   897,   898,   898,
     900,   899,   901,   901,   902,   903,   903,   903,   903,   903,
     903,   903,   904,   905,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   906,   903,   908,   907,
     909,   909,   909,   910,   910,   911,   911,   912,   912,   914,
     913,   915,   915,   915,   915,   915,   915,   915,   915,   915,
     915,   915,   916,   916,   918,   917,   919,   919,   920,   920,
     922,   921,   923,   923,   924,   924,   925,   925,   926,   926,
     927,   927,   928,   929,   929,   930,   930,   931,   930,   932,
     930,   933,   930,   930,   934,   930,   935,   930,   930,   936,
     930,   937,   930,   930,   938,   938,   938,   940,   939,   941,
     939,   939,   939,   943,   942,   945,   946,   944,   947,   948,
     949,   949,   950,   950,   950,   950,   952,   951,   953,   953,
     954,   954,   954,   955,   955,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   958,   958,   958,
     958,   959,   959,   959,   960,   960,   961,   961,   962,   963,
     962,   964,   965,   964,   966,   966,   967,   967,   968,   968,
     969,   969,   969,   970,   971,   971,   972,   973,   973,   975,
     974,   976,   976,   977,   977,   977,   978,   978,   979,   979,
     980,   981,   981,   981,   982,   982,   982,   982,   983,   983,
     984,   984,   984,   984,   984,   984,   985,   985,   985,   985,
     985,   986,   987,   986,   988,   988,   989,   989,   990,   992,
     991,   993,   993,   994,   994,   996,   995,   998,   997,   997,
     997,  1000,   999,  1001,  1002,  1001,  1001,  1001,  1001,  1001,
    1001,  1001,  1003,  1003,  1004,  1005,  1005,  1006,  1006,  1008,
    1009,  1007,  1011,  1012,  1010,  1013,  1013,  1013,  1013,  1014,
    1014,  1015,  1015,  1016,  1017,  1017,  1017,  1018,  1017,  1019,
    1019,  1020,  1020,  1021,  1020,  1022,  1020,  1023,  1023,  1024,
    1024,  1025,  1026,  1026,  1027,  1027,  1029,  1028,  1030,  1030,
    1031,  1031,  1032,  1032,  1033,  1034,  1033,  1036,  1037,  1035,
    1038,  1038,  1039,  1040,  1040,  1041,  1042,  1042,  1044,  1043,
    1046,  1045,  1047,  1045,  1048,  1045,  1049,  1049,  1050,  1050,
    1051,  1051,  1052,  1052,  1053,  1053,  1053,  1054,  1055,  1055,
    1056,  1056,  1057,  1057,  1058,  1058,  1058,  1058,  1058,  1058,
    1058,  1058,  1058,  1059,  1059,  1061,  1060,  1062,  1062,  1062,
    1062,  1062,  1063,  1062,  1062,  1062,  1062,  1062,  1064,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1065,  1065,  1066,  1066,  1067,  1067,  1068,
    1068,  1069,  1069,  1070,  1070,  1071,  1071,  1072,  1072,  1073,
    1073,  1073,  1075,  1074,  1076,  1074,  1077,  1077,  1078,  1078,
    1079,  1079,  1079,  1081,  1080,  1082,  1082,  1084,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1085,
    1085,  1087,  1086,  1088,  1088,  1089,  1089,  1089,  1091,  1090,
    1092,  1093,  1093,  1095,  1094,  1096,  1096,  1096,  1097,  1099,
    1098,  1098,  1101,  1102,  1103,  1100,  1100,  1104,  1104,  1105,
    1105,  1105,  1106,  1106,  1106,  1107,  1107,  1108,  1108,  1109,
    1109,  1109,  1109,  1110,  1110,  1111,  1111,  1112,  1112,  1113,
    1113,  1114,  1114,  1114,  1115,  1115,  1116,  1116,  1117,  1117,
    1118,  1118,  1118,  1118,  1119,  1119,  1119,  1120,  1121,  1121,
    1121,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1123,  1123,  1123,  1123,  1123,  1124,  1124,
    1125,  1125,  1126,  1127,  1127,  1128,  1128,  1129,  1129,  1129,
    1130,  1130,  1130,  1130,  1131,  1131,  1131,  1132,  1133,  1133,
    1134,  1135,  1136,  1137,  1137,  1138,  1138,  1139,  1139,  1139,
    1140,  1140,  1140,  1141,  1141,  1141,  1141,  1141,  1141,  1141,
    1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,
    1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,
    1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1144,  1143,  1145,  1145,  1146,
    1146,  1148,  1147,  1149,  1149,  1149,  1149,  1150,  1150,  1151,
    1151,  1151,  1151,  1152,  1152,  1152,  1152,  1153,  1153,  1154,
    1154,  1155,  1155,  1155,  1155,  1155,  1155,  1155,  1156,  1156,
    1156,  1157,  1157,  1157,  1157,  1158,  1158,  1158,  1159,  1159,
    1159,  1159,  1159,  1161,  1160,  1162,  1162,  1163,  1163,  1164,
    1165,  1165,  1165,  1165,  1167,  1166,  1168,  1168,  1169,  1168,
    1170,  1170,  1171,  1171,  1172,  1172,  1172,  1172,  1173,  1172,
    1174,  1174,  1174,  1174,  1174,  1175,  1176,  1176,  1176,  1176,
    1177,  1178,  1178,  1178,  1179,  1179,  1180,  1180,  1181,  1181,
    1182,  1182,  1184,  1183,  1185,  1183,  1186,  1183,  1187,  1183,
    1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,
    1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,
    1183,  1183,  1183,  1188,  1188,  1189,  1189,  1190,  1190,  1190,
    1191,  1191,  1191,  1191,  1192,  1192,  1193,  1193,  1194,  1194,
    1194,  1195,  1195,  1196,  1196,  1197,  1198,  1198,  1198,  1198,
    1198,  1199,  1199,  1200,  1200,  1201,  1201,  1201,  1201,  1201,
    1203,  1202,  1204,  1204,  1205,  1205,  1205,  1206,  1206,  1206,
    1207,  1207,  1208,  1209,  1209,  1210,  1211,  1212,  1212,  1214,
    1213,  1215,  1215,  1215,  1217,  1216,  1218,  1218,  1219,  1219,
    1219,  1220,  1221,  1220,  1222,  1223,  1224,  1225,  1225,  1226,
    1226,  1226,  1227,  1227,  1228,  1228,  1228,  1229,  1230,  1230,
    1230,  1231,  1231,  1232,  1232,  1232,  1234,  1233,  1235,  1235,
    1236,  1236,  1238,  1237,  1239,  1239,  1240,  1240,  1240,  1240,
    1242,  1241,  1244,  1243,  1245,  1246,  1247,  1248,  1243,  1249,
    1249,  1249,  1249,  1249,  1249,  1250,  1250,  1250,  1251,  1251,
    1252,  1252,  1252,  1253,  1253,  1254,  1255,  1254,  1256,  1256
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     3,     0,     1,     1,     1,
       1,     2,     1,     1,     3,     0,     2,     0,     2,     0,
       3,     0,     5,     1,     1,     0,     2,     2,     2,     2,
       0,     6,     2,     0,     2,     1,     1,     3,     0,     0,
       0,     7,     0,     2,     2,     1,     1,     0,     0,     8,
       0,     6,     1,     2,     1,     2,     0,     0,     6,     0,
       0,     6,     0,     2,     0,     5,     0,     1,     0,     5,
       4,     0,     0,     8,     0,     7,     1,     1,     1,     1,
       1,     2,     2,     2,     4,     4,     0,     4,     0,     0,
       5,     0,     7,     0,     0,     6,     0,     1,     0,     1,
       1,     2,     1,     1,     0,     1,     1,     2,     1,     0,
       3,     0,     1,     1,     2,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     1,     1,     3,     4,     4,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     2,     2,
       6,     7,     8,     2,     2,     0,     1,     2,     0,     1,
       2,     0,     4,     3,     3,     3,     1,     4,     1,     1,
       5,     2,     5,     2,     4,     1,     5,     5,     4,     3,
       1,     1,     2,     1,     1,     2,     1,     1,     1,     2,
       3,     2,     3,     2,     2,     3,     3,     3,     0,     6,
       0,     6,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     2,     1,     2,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     3,     1,     5,     0,     1,     2,     1,     1,     1,
       1,     0,     3,     0,     1,     0,     1,     2,     1,     1,
       2,     2,     4,     1,     3,     2,     1,     2,     2,     2,
       2,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     0,     1,     0,
       2,     1,     2,     3,     2,     0,     1,     0,     1,     1,
       2,     0,     1,     0,     4,     1,     4,     3,     1,     0,
       1,     2,     1,     3,     3,     2,     2,     2,     1,     1,
       2,     2,     2,     1,     2,     2,     2,     2,     1,     1,
       0,     1,     1,     1,     1,     0,     1,     1,     1,     0,
       2,     2,     1,     1,     1,     4,     2,     1,     4,     0,
       1,     0,     2,     1,     3,     0,     6,     0,     5,     0,
       5,     0,     5,     0,    11,     0,     1,     0,     2,     2,
       1,     3,     2,     3,     2,     4,     0,     6,     0,     0,
       8,     4,     4,     3,     3,     2,     2,     6,     5,     3,
       5,     1,     1,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     2,     1,     0,     1,     1,     1,     0,     5,
       3,     0,     5,     3,     3,     0,     3,     0,     2,     1,
       3,     0,     1,     1,     0,     2,     1,     3,     0,     6,
       0,     6,     0,     5,     0,     1,     1,     0,     6,     0,
       1,     1,     2,     1,     1,     1,     0,     6,     0,     5,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       0,     6,     0,     1,     1,     0,     4,     4,     3,     5,
       1,     3,     3,     5,     1,     3,     2,     1,     1,     0,
       6,     1,     3,     3,     0,     2,     0,     4,     0,     2,
       1,     2,     4,     2,     3,     0,     3,     0,     0,     6,
       2,     1,     1,     2,     2,     8,     4,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     4,     3,     1,     1,     4,     0,     0,
       1,     1,     0,     2,     2,     1,     1,     0,     2,     0,
       3,     0,     3,     3,     0,     3,     0,     3,     2,     1,
       3,     4,     3,     4,     3,     4,     1,     3,     4,     3,
       3,     6,     1,     5,     6,     5,     7,     6,     8,     5,
       6,     4,     4,     5,     3,     4,     1,     3,     1,     3,
       1,     3,     3,     1,     3,     3,     4,     4,     1,     3,
       3,     3,     3,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     3,     1,     1,     1,     1,
       3,     2,     2,     2,     2,     3,     3,     5,     6,     4,
       4,     7,     4,     2,     6,     5,     6,     6,     4,     4,
       3,     4,     6,     8,     6,     8,     6,     4,     6,     4,
       6,     4,     4,     4,     4,     6,     8,     2,     2,     4,
       2,     7,     7,     3,     4,     4,     6,     6,     4,     6,
       6,     6,     4,     6,     4,     6,     8,    10,    12,     6,
       4,     6,     6,     1,     6,     4,     8,    10,     4,     1,
       3,     4,     6,     6,     8,     6,     6,     4,     6,     6,
       8,     4,     4,     6,     4,     2,     4,     4,     4,     6,
       4,     4,     3,     8,     6,     4,     6,     3,     6,     8,
       4,     8,     6,     8,     6,     8,     2,     4,     4,     4,
       6,     8,     8,     4,     7,     7,     7,     6,     6,     6,
       6,     6,     6,     0,     5,    10,     3,     4,     3,     2,
       2,     2,     4,     6,     4,     4,     6,     6,     6,     6,
       4,     6,     4,     6,     4,     4,     4,     4,     6,     4,
       6,     4,     6,     4,     4,     6,     4,     6,     4,     6,
       4,     4,     6,     4,     6,     0,     3,     3,     0,     1,
       0,     2,     1,     3,     4,     4,     5,     4,     4,     4,
       5,     4,     0,     0,     7,    10,     4,     5,     4,     5,
       4,     4,     4,     4,     4,     5,     0,     8,     0,     3,
       3,     1,     4,     0,     1,     0,     2,     0,     1,     0,
       3,     2,     3,     2,     1,     2,     1,     2,     1,     1,
       1,     2,     0,     1,     0,     2,     1,     3,     1,     3,
       0,     2,     1,     3,     0,     1,     0,     2,     4,     5,
       1,     1,     1,     1,     3,     3,     3,     0,     6,     0,
       6,     0,     8,     4,     0,     8,     0,    10,     6,     0,
       8,     0,    10,     6,     1,     2,     2,     0,     4,     0,
      11,     3,     6,     0,     3,     0,     0,     5,     0,     1,
       0,     1,     0,     2,     2,     2,     0,     5,     0,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     2,     0,     1,     0,     0,
       3,     0,     0,     3,     2,     0,     0,     4,     4,     2,
       0,     2,     2,     3,     3,     1,     2,     0,     1,     0,
       4,     4,     2,     0,     1,     1,     0,     1,     0,     1,
       2,     1,     3,     3,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     0,     6,     0,     1,     3,     1,     2,     0,
       2,     3,     1,     2,     1,     0,     3,     0,     5,     2,
       1,     0,     3,     6,     0,     6,     4,     4,     4,     4,
       5,     4,     1,     3,     1,     0,     2,     0,     1,     0,
       0,     8,     0,     0,     6,     0,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     3,     4,     0,     3,     3,
       1,     2,     2,     0,     3,     0,     5,     3,     1,     3,
       1,     3,     1,     1,     0,     1,     0,     4,     0,     1,
       3,     1,     1,     1,     0,     0,     6,     0,     0,    11,
       3,     1,     3,     3,     1,     3,     0,     1,     0,     4,
       0,     6,     0,     5,     0,     6,     1,     3,     3,     5,
       0,     2,     0,     2,     1,     1,     1,     3,     0,     1,
       0,     1,     1,     3,     1,     1,     2,     2,     2,     1,
       1,     1,     1,     0,     3,     0,     3,     2,     4,     4,
       4,     4,     0,     4,     6,    16,     2,     2,     0,     6,
       5,     2,     2,     2,     1,     5,     5,     2,     2,     1,
       4,     3,     2,     2,     2,     3,     2,     2,     2,     1,
       1,     3,     4,     3,     3,     2,     2,     3,     3,     3,
       3,     3,     3,     1,     1,     1,     1,     0,     1,     0,
       2,     0,     1,     1,     1,     0,     2,     0,     2,     0,
       2,     2,     0,     4,     0,     4,     1,     1,     0,     1,
       0,     1,     1,     0,     4,     3,     1,     0,     3,     4,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     0,     3,     3,     1,     1,     1,     2,     0,     3,
       3,     2,     2,     0,     4,     0,     1,     1,     2,     0,
       4,     5,     0,     0,     0,    16,     2,     0,     1,     0,
       1,     1,     0,     1,     1,     0,     2,     2,     1,     3,
       4,     3,     3,     0,     2,     2,     1,     3,     3,     0,
       3,     0,     3,     2,     3,     1,     1,     2,     0,     2,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       3,     5,     1,     1,     1,     1,     1,     3,     4,     5,
       1,     5,     3,     2,     1,     3,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     4,     0,     1,     1,
       3,     0,     2,     1,     1,     1,     1,     0,     1,     0,
       1,     1,     1,     0,     2,     2,     2,     1,     2,     4,
       5,     4,     6,     2,     3,     3,     3,     5,     1,     3,
       3,     2,     2,     2,     1,     1,     4,     4,     1,     1,
       1,     1,     1,     0,     4,     1,     1,     1,     3,     3,
       1,     1,     2,     2,     0,     3,     4,     3,     0,     7,
       1,     2,     1,     1,     1,     1,     1,     1,     0,     5,
       1,     1,     1,     1,     1,     3,     6,     6,     6,     7,
       3,     8,     8,     8,     0,     1,     1,     2,     0,     1,
       1,     3,     0,     3,     0,     3,     0,     3,     0,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     3,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     1,     3,     1,     2,     2,     2,
       1,     3,     3,     1,     1,     3,     1,     3,     4,     5,
       1,     0,     3,     3,     1,     1,     0,     2,     2,     2,
       2,     0,     2,     2,     1,     2,     2,     2,     2,     2,
       0,     3,     0,     1,     0,     3,     2,     0,     1,     2,
       0,     1,     4,     4,     5,     2,     3,     0,     1,     0,
       4,     0,     1,     1,     0,     2,     2,     1,     0,     1,
       1,     4,     0,     7,     1,     0,     0,     2,     3,     1,
       1,     1,     0,     3,     1,     2,     1,     2,     3,     3,
       3,     0,     1,     0,     3,     3,     0,     8,     0,     3,
       1,     3,     0,     2,     3,     5,     0,     3,     4,     4,
       0,    14,     0,     6,     0,     0,     0,     0,    12,     4,
       4,     3,     4,     3,     2,     1,     3,     5,     1,     1,
       0,     1,     1,     0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  2001,   632,     0,  1950,     0,     0,     0,     0,
       0,  1952,    94,    54,  1268,  1376,  1377,  1191,  1207,     0,
     632,    97,     0,    66,  1209,  1413,     0,     0,   632,     0,
    1408,     0,     0,   632,  1212,  1401,     0,    97,  1952,     0,
     667,  1787,  1305,     0,     0,     0,  1288,  1844,  1257,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   660,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1378,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   535,     0,   567,
       0,     0,  2002,  1992,   634,   633,     0,  1836,  1835,   600,
    1952,     0,  1560,  1561,  1562,  1563,  1564,  1565,  1566,  1524,
    1567,  1568,  1569,  1525,  1526,  1570,  1571,  1572,  1573,  1575,
    1574,  1576,  1527,  1528,  1577,  1578,  1579,  1529,  1530,  1580,
    1581,  1531,  1582,  1583,  1584,  1532,  1585,  1533,  1586,  1587,
    1588,  1589,  1534,  1590,  1591,  1592,  1593,  1594,  1595,  1596,
    1535,  1597,  1598,  1599,  1600,  1616,  1601,  1536,  1602,  1603,
    1604,  1617,  1537,  1607,  1606,  1605,  1608,  1609,  1610,  1538,
    1611,  1612,  1613,  1614,  1619,  1620,  1621,  1539,  1615,  1622,
    1618,  1770,  1624,  1623,  1625,  1627,  1626,  1540,  1628,  1541,
    1629,  1630,  1508,  1631,  1509,  1633,  1634,  1637,  1638,  1632,
    1639,  1640,  1635,  1636,  1542,  1642,  1643,  1644,  1645,  1646,
    1647,  1648,  1658,  1651,  1653,  1654,  1656,  1652,  1657,  1661,
    1660,  1662,  1663,  1664,  1659,  1650,  1655,  1665,  1666,  1649,
    1667,  1668,  1669,  1670,  1671,  1672,  1673,  1674,  1675,  1677,
    1676,  1678,  1679,  1680,  1681,  1682,  1684,  1683,  1685,  1686,
    1687,  1689,  1688,  1690,  1543,  1691,  1692,  1693,  1694,  1695,
    1544,  1696,  1697,  1698,  1699,  1700,  1701,  1702,  1545,  1703,
    1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,  1712,  1713,
    1714,  1715,  1716,  1717,  1718,  1719,  1720,  1641,  1721,  1546,
    1722,  1723,  1547,  1724,  1548,  1725,  1726,  1549,  1727,  1728,
    1729,  1730,  1731,  1732,  1550,  1733,  1551,  1735,  1734,  1736,
    1738,  1739,  1552,  1737,  1553,  1740,  1741,  1742,  1744,  1743,
    1745,  1746,  1554,  1747,  1555,  1748,  1749,  1750,  1751,  1752,
    1753,  1754,  1755,  1756,  1757,  1758,  1759,  1760,  1763,  1764,
    1765,  1766,  1761,  1762,  1556,  1767,  1768,  1769,  1771,  1772,
    1557,  1773,  1774,  1559,  1775,  1776,  1779,  1777,  1778,  1780,
    1781,  1782,  1783,  1558,  1784,   123,  1513,    99,  1514,  1523,
       0,   602,   618,  1953,  1954,   269,   507,   508,   268,   506,
      97,  1992,     0,   265,   266,     0,  1282,  1014,  1205,  1205,
       0,  1205,  1208,  1205,    97,  1205,     0,    59,  1383,     0,
       0,     0,     0,  1507,     0,  1215,  1415,  1419,     0,     0,
    1833,     0,     0,     0,     0,    97,   635,     0,  1266,     0,
     598,     0,  1954,  1965,   661,   665,   677,  1788,  1785,  1361,
     587,   587,   587,   585,   587,  1289,     0,     0,  1266,  1418,
    2038,     0,     0,     0,  2034,     0,  2039,     0,   667,     0,
       0,     1,     3,     0,  1612,  1374,  1372,  1504,     0,   527,
     536,   531,   529,     0,     0,  2003,   616,     0,  1951,     0,
     644,   654,   125,     0,    68,     0,     0,     0,  1957,     0,
       0,     0,     0,    95,   318,  1992,  1994,  1996,   269,   267,
       0,  1286,  1285,  1284,     0,  1282,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1205,    61,     0,  1878,
    1893,  1894,  1890,  1895,  1896,  1900,     0,  1892,  1884,     0,
    1899,  1888,  1897,     0,  1882,     0,  1898,  1903,  1886,  1891,
    1870,     0,  1876,  1880,  1506,  1111,  1847,  1848,     0,  1519,
    1510,  1518,  1517,    67,  1217,  1218,  1216,   566,  1416,  1417,
       0,  1429,     0,     0,     0,   630,     0,  1356,  1355,     0,
    1409,  1966,     0,     0,   607,  1220,  1267,     0,  1219,  1406,
       0,  1405,  1402,  1404,     0,  1878,  1865,     0,  1960,  1957,
    1967,   690,   683,   682,   685,   686,   689,   687,   688,   684,
     681,   698,   678,   680,  1791,     0,     0,   443,     0,  1369,
       0,     0,     0,  1369,     0,  1146,  1362,     0,  1800,  1340,
     504,   503,     0,   502,  1801,  1339,  1355,     0,     0,     0,
    1324,     0,  1290,  1329,  1802,     0,  1358,     0,  1146,  1369,
       0,  1306,     0,     0,     0,     0,   581,   591,   583,   578,
       0,   584,   580,  1287,  1204,  1845,   566,  1466,  1465,  1511,
    2035,  1464,  2043,  2045,  2031,  2033,  2040,   663,     0,  1971,
      53,     0,  1380,  1999,  2000,  1998,   457,   107,   107,   525,
       0,     0,     0,     0,     0,  1202,     0,     0,   646,   656,
     127,   124,    98,     0,   604,   620,  1956,     0,     0,  1958,
    1962,   772,   771,     0,    92,   707,  1520,  1930,    96,  1926,
    1997,   319,   698,   698,   698,  1987,     0,  1989,  1990,  1991,
    2003,  1995,     0,   509,     0,  1269,  1272,  1276,  1280,  1283,
    1561,  1524,     0,  1569,     0,     0,  1477,     0,     0,     0,
       0,  1529,     0,     0,  1583,     0,     0,  1534,     0,     0,
       0,   707,   707,   707,     0,     0,     0,  1595,  1596,  1486,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1474,     0,  1487,     0,     0,     0,     0,     0,     0,     0,
    1624,     0,     0,  1625,     0,     0,     0,  1476,  1630,     0,
       0,     0,     0,     0,     0,     0,  1645,     0,     0,  1484,
       0,     0,  1020,     0,  1672,  1674,     0,     0,     0,  1678,
       0,     0,  1679,  1680,  1681,  1461,   774,     0,   707,  1473,
    1483,  1693,  1699,  1467,     0,  1701,     0,  1702,     0,  1709,
       0,     0,     0,     0,     0,     0,  1731,  1733,     0,     0,
    1750,     0,     0,     0,   707,  1763,  1764,  1765,  1766,     0,
    1475,  1556,  1485,     0,     0,     0,  1775,   707,   707,   707,
       0,     0,     0,  1781,     0,  1784,  1024,     0,     0,     0,
       0,   773,     0,   988,     0,  1016,   709,   714,   719,   726,
     732,   746,   748,   750,   753,   758,   764,     0,   859,   766,
     853,   789,   788,  1015,  1471,   787,   786,  1472,   784,  1494,
    1513,  1460,  1493,  1206,  1196,  1197,     0,  1198,  1201,  1924,
    1199,   568,     0,     0,    60,  1397,  1391,  1393,  1396,  1392,
       0,  1398,  1395,  1394,  1836,  1384,  1386,  1387,  1879,  1877,
    1911,  1910,     0,  1912,  1908,  1901,  1931,  1905,  1931,  1907,
    1906,  1931,  1902,  1909,  1931,  1874,     0,  1112,  1113,     0,
    1846,     0,  1505,     0,  1414,  1430,     0,  1431,  1420,  1427,
     649,     0,  1111,  1834,  1837,     0,     0,    56,    57,     0,
     637,     0,   636,   640,     0,     0,     0,  1223,  1213,  1222,
    1407,     0,     0,  1877,  1874,  1961,     0,  1963,  1978,   666,
    1968,   696,   668,   695,     0,   679,  1786,  1789,  1797,  1338,
    1365,   442,     0,     0,  1337,  1321,     0,   269,     0,     0,
       0,     0,  1307,  1312,   303,     0,  1328,  1147,     0,  1369,
       0,  1332,  1345,  1333,     0,  1359,     0,  1369,  1302,     0,
       0,  1294,  1299,  1295,     0,  1301,  1300,  1303,  1291,  1292,
    1317,  1346,  1359,  1322,  1327,  1336,  1363,  1364,     0,  1316,
    1323,     0,  1334,  1359,  1359,  1369,  1369,   594,   593,   592,
     588,   589,   594,     0,  1057,     0,     0,  2032,  2046,  2030,
    2041,  2042,  2029,   664,  1972,   662,  1973,     0,  1375,  1373,
    1381,  1382,   458,   528,   457,   260,   263,   262,     0,   532,
     530,   457,  1993,     0,     0,   620,     0,     0,   648,   643,
     647,   645,   499,   498,   501,     0,   655,     0,   128,   130,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    69,    70,    83,   606,   605,
     603,   628,   627,   625,     0,   626,   624,   619,   621,   622,
    1955,  1959,   270,   457,     0,  1522,     0,     0,     0,     0,
       0,     0,     0,  1988,    88,     0,     0,     0,  1274,  1270,
    1280,     0,     0,     0,  1111,     0,     0,     0,  1116,     0,
     803,  1116,  1116,  1116,     0,     0,  1014,  1014,     0,  1014,
       0,     0,     0,     0,  1116,   827,   830,     0,   828,     0,
       0,     0,     0,     0,  1480,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1014,     0,     0,     0,     0,   993,
       0,     0,     0,     0,   783,     0,     0,     0,     0,  1014,
       0,     0,     0,     0,  1020,     0,  1018,     0,  1116,     0,
       0,  1116,     0,     0,     0,     0,     0,  1014,  1014,  1014,
     718,     0,   875,     0,     0,     0,     0,     0,  1014,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1116,
    1116,     0,     0,     0,  1116,     0,   896,     0,  1482,     0,
       0,     0,  1481,     0,     0,  1479,  1478,  1462,     0,     0,
       0,   919,   921,   920,  1116,     0,  1116,     0,     0,     0,
    1025,     0,   792,   791,   793,  1985,     0,     0,     0,     0,
       0,     0,     0,   711,   716,   775,     0,   776,   777,     0,
     778,   779,   780,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   794,  1086,  1087,  1088,  1089,  1098,  1101,  1090,
    1091,  1092,  1100,  1093,  1094,  1095,  1102,  1103,  1104,  1096,
    1105,  1099,  1097,  1106,     0,  1085,     0,     0,     0,  1463,
     913,     0,  1194,     0,   570,   569,  1200,   568,     0,    62,
      64,  1390,     0,     0,  1399,  1904,     0,  1885,  1889,  1883,
    1887,     0,     0,  1875,     0,  1881,  1115,  1620,  1688,     0,
    1118,  1850,  1210,  1426,  1428,     0,     0,  1421,     0,     0,
     620,    58,     0,     0,  1410,     0,     0,     0,     0,   609,
    1221,     0,  1403,     0,     0,     0,     0,     0,  1964,  1980,
    1979,  1969,   698,  1137,   699,   701,   700,  1493,  1791,  1794,
    1795,  1798,  1796,     0,  1793,  1792,  1807,     0,  1367,  1370,
    1371,     0,     0,  1348,  1347,  1343,  1344,     0,  1156,  1157,
    1155,  1150,  1151,  1154,  1352,  1350,  1341,     0,  1369,     0,
    1351,  1349,  1296,  1297,  1298,     0,  1146,     0,  1369,  1359,
       0,  1369,  1369,  1331,  1335,     0,   582,   591,   579,   586,
    1069,  1068,     0,  1033,     0,  1032,  1031,  1030,     0,  1068,
    2036,  2044,  2048,     0,  1146,  1977,  1975,   261,  1244,  1244,
       0,     0,     0,     0,     0,     0,     0,   108,   117,   564,
     564,  1244,  1244,   564,  1244,  1244,  1244,     0,     0,  1244,
       0,     0,   564,     0,  1244,   562,     0,     0,  1244,  1244,
    1244,   564,     0,  1244,  1244,  1244,  1244,  1244,   574,  1244,
    1244,  1244,   561,   273,   295,   296,   526,     0,   540,   563,
    2004,  2005,   533,   617,   601,  1203,     0,   126,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   629,   623,    93,   708,  1521,
       0,  1927,  2024,     0,     0,  2006,   271,   512,   514,   513,
     511,   510,     0,     0,  1118,     0,  1277,  1057,  1281,  1280,
    1278,     0,     0,     0,  1117,  1116,     0,   999,  1164,  1165,
    1161,  1162,  1160,  1163,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   972,     0,
     999,     0,   833,     0,     0,     0,     0,     0,     0,  1493,
       0,     0,     0,     0,     0,  1985,     0,     0,     0,     0,
       0,     0,   810,     0,     0,     0,     0,     0,     0,     0,
    1109,  1107,  1110,  1108,     0,     0,   994,   986,     0,     0,
       0,     0,   860,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1021,  1022,  1116,     0,     0,     0,
    1116,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   882,
       0,     0,     0,     0,     0,   887,     0,     0,     0,     0,
       0,     0,     0,  1116,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   916,     0,   918,     0,
       0,  1496,  1495,     0,     0,     0,     0,     0,  1026,   667,
       0,   796,  1014,   795,     0,  1803,   989,   991,     0,   713,
     710,   715,   729,   722,   727,   720,   724,     0,   781,  1566,
     730,     0,     0,  1125,   744,     0,     0,   747,     0,     0,
       0,     0,   749,   751,   752,   755,   859,   754,   859,   762,
     763,   759,   760,   761,   765,     0,   785,   790,  1017,   960,
    1497,  1195,  1925,  1193,    65,     0,     0,  1385,  1400,  1388,
    1935,     0,  1934,  1920,  1923,  1504,     0,     0,     0,  1860,
    1854,  1861,  1863,  1857,  1862,  1864,  1855,  1856,  1851,  1858,
    1119,  1148,     0,     0,   650,   651,   654,     0,  1840,  1841,
    1839,  1838,   631,  1412,  1411,     0,   638,   641,   642,   614,
     613,   615,   608,   610,   611,   253,  1227,     0,     0,     0,
    1233,  1214,  1224,   599,     0,     0,     0,     0,     0,   694,
    1057,  1185,   691,   672,  1148,  1138,   671,   702,     0,  1790,
       0,  1761,  1818,     0,     0,     0,     0,     0,  1808,  1366,
       0,  1318,     0,  1342,  1354,  1353,  1313,     0,     0,     0,
    1311,  1360,     0,  1330,  1293,  1310,  1118,  1359,  1308,  1309,
     596,   595,   590,  1068,  1057,     0,     0,  1054,  1070,     0,
    1070,  1057,  1057,     0,  1057,  1111,  1065,     0,     0,  2047,
    1139,  1976,  1242,  1243,  1245,     0,     0,   111,   114,   112,
       0,   113,     0,     0,   565,   519,   500,   500,   544,     0,
     335,   519,   493,   542,     0,     0,     0,     0,     0,     0,
       0,     0,  1244,     0,   555,   538,     0,     0,     0,     0,
     556,     0,   539,  1244,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   577,   576,   575,     0,     0,     0,
       0,   274,   457,   338,     0,   571,   335,   341,  1500,  2008,
    1082,     0,  1081,   129,    76,    72,    84,  1169,  1170,  1168,
    1166,  1167,    85,    74,    75,    79,    78,    80,    81,    82,
      77,    73,    86,    87,    71,     0,  1928,     0,   237,   236,
       0,  2022,  2008,     0,   338,    89,  1432,   272,   275,    90,
    1057,  1137,  1280,  1118,     0,  1111,     0,   802,   817,     0,
       0,   965,     0,     0,   967,   968,   969,     0,   821,     0,
     819,   822,   823,   824,  1014,     0,     0,     0,     0,  1014,
     971,     0,   829,     0,     0,   834,   835,     0,   808,     0,
     842,     0,   844,     0,  1014,     0,   838,     0,   799,     0,
       0,  1014,     0,   850,     0,   811,     0,     0,   951,     0,
     934,   930,     0,   932,     0,     0,  1014,  1014,     0,   855,
       0,     0,   861,  1014,     0,   953,     0,   935,     0,   867,
       0,  1014,     0,  1019,     0,     0,     0,   978,   871,   872,
       0,   976,   937,     0,     0,   874,   939,     0,   941,     0,
     936,   943,   944,   876,   878,   877,   946,     0,     0,   948,
       0,   950,     0,   880,   881,     0,     0,     0,   885,     0,
    1014,   890,   980,   982,     0,     0,     0,     0,     0,   984,
     897,   899,     0,     0,     0,   898,     0,     0,     0,     0,
       0,     0,     0,   903,     0,     0,   917,   983,   809,   981,
     922,     0,   925,     0,   924,     0,     0,     0,     0,  1984,
    1986,     0,     0,   800,     0,     0,     0,     0,     0,  1498,
     768,   767,     0,   770,   769,     0,   723,   728,   721,   725,
       0,     0,     0,     0,   742,   741,     0,     0,  1125,   745,
       0,   757,   756,   858,     0,   959,   698,  1014,     0,    63,
    1389,  1932,     0,     0,     0,     0,     0,     0,     0,     0,
    1849,  1149,  1254,  1512,  1422,     0,   658,  1842,  1843,     0,
     612,   677,     0,  1246,  1231,  1238,  1232,     0,     0,     0,
    1230,  1489,  1488,  1495,  1967,     0,     0,     0,     0,  1970,
    1118,  1118,  1179,     0,     0,   669,   674,   670,   673,     0,
     697,   706,   705,  1490,  1497,     0,     0,     0,     0,   445,
     447,   446,   453,     0,   444,     0,     0,  1803,     0,   449,
     451,   450,  1813,   448,  1368,  1146,  1326,  1325,  1153,  1152,
       0,  1304,  1320,  1369,     0,  1974,  1063,     0,  1056,  1055,
    1071,     0,  1057,  1070,  1070,     0,  1036,  1035,  1258,  1261,
       0,  1034,  1072,  1061,   677,  2037,  2049,     0,   456,   455,
     302,   452,   301,   116,   115,   121,   122,   340,   520,   494,
     495,     0,     0,     0,   500,   334,   519,   333,   336,   509,
       0,   285,   282,   546,   288,   284,   300,     0,     0,   289,
     519,   553,   554,   568,   278,     0,   314,   315,   313,   297,
     280,   281,   548,  1133,  1135,  1143,   287,   286,   283,   292,
     293,   311,   310,   291,   312,   559,   309,   307,   304,   306,
     305,   308,   290,   279,     0,   541,     0,   324,   326,   327,
    1503,     0,   573,   543,     0,   328,   329,     0,     0,     0,
       0,   657,     0,  1929,  2025,   240,   238,   239,     0,     0,
       0,   243,     0,   241,     0,     0,  1434,  1433,   242,   256,
     457,   276,     0,  1118,  1158,  1273,  1279,     0,     0,     0,
     966,  1000,     0,   421,   421,  1010,  1008,   410,   421,  1004,
    1009,  1006,     0,     0,     0,     0,     0,     0,     0,   973,
     970,     0,     0,     0,  1497,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   997,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   955,  1023,   979,   977,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   985,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1027,   805,  1981,  1982,   797,  1804,  1805,  1806,
     521,   990,   712,   717,     0,   735,  1014,   733,  1124,   739,
       0,     0,   743,     0,   914,     0,   961,   962,     0,  1013,
    1499,  1933,  1922,  1921,  1936,  1936,  1936,     0,  1120,     0,
    1211,  1432,   652,     0,   653,   639,   698,  1228,  1240,     0,
    1248,     0,     0,  1225,  1235,     0,     0,     0,  1234,     0,
    1867,  1868,  1866,  1148,  1126,     0,     0,  1190,     0,  1186,
     692,     0,   704,   703,     0,  1820,     0,  1819,  1831,  1832,
    1829,  1830,  1828,  1809,     0,  1815,  1814,     0,     0,     0,
    1825,  1816,     0,     0,  1319,     0,  1314,   597,     0,  1057,
    1070,  1057,  1043,     0,     0,  1057,  1039,  1037,  1041,     0,
    1118,     0,     0,     0,     0,  1058,   698,  1492,  1140,  1143,
     337,   519,   496,   497,   509,     0,     0,     0,     0,   453,
     298,   552,   551,   299,     0,     0,  1144,  1145,  1136,     0,
     545,   338,   572,   473,   406,   355,   346,   421,   349,   348,
     392,   363,   360,   410,   408,   378,   410,   410,   385,   384,
     402,   388,   368,   459,   459,   367,   405,   459,   389,   387,
     391,     0,   393,   410,   398,   386,   390,   407,   383,   380,
     404,   421,   421,   361,   364,   403,   459,     0,   396,   421,
     425,   366,   459,   465,     0,     0,   421,   423,  1502,  2010,
       0,  2012,  1080,   142,   698,     0,   101,  2023,  2012,     0,
     246,   271,   257,     0,   277,     0,  1275,     0,  1271,   783,
     814,   818,   927,     0,  1001,   459,     0,  1011,   412,  1003,
    1005,  1007,   804,   820,   825,   929,   807,   806,     0,     0,
       0,     0,   840,   843,   845,   836,   841,   839,     0,   928,
     852,   849,   851,   812,     0,   952,   931,   933,   854,   865,
     995,   998,     0,     0,     0,   866,   862,   954,   863,     0,
     868,   837,   869,     0,     0,     0,     0,   938,   873,   940,
     942,   947,   945,   949,   879,   816,     0,   884,   886,   798,
     783,   888,     0,   894,   892,     0,     0,   900,     0,     0,
     909,     0,   907,     0,   908,     0,   910,   911,     0,   923,
     926,  1028,     0,  1967,     0,   992,   731,     0,   737,  1014,
     734,   740,   699,   698,   912,     0,  1941,  1941,  1941,  1253,
    1252,     0,  1251,  1255,     0,   659,   254,     0,     0,     0,
    1249,  1237,  1971,  1226,  1229,  1497,  1869,   676,     0,  1121,
    1189,  1187,     0,  1180,  1182,  1184,     0,  1491,     0,     0,
    1824,  1810,   454,     0,     0,     0,     0,  1811,     0,  1111,
    1064,     0,     0,  1030,  1057,  1057,     0,  1030,     0,     0,
       0,  1260,  1137,  1262,  1076,  1074,  1075,  1073,  1066,     0,
    1142,     0,     0,     0,   558,     0,   571,   560,   425,  1134,
     294,   325,   479,     0,     0,   365,   414,   409,     0,   414,
     414,   465,   467,   461,   465,     0,   374,   392,   369,     0,
     459,   382,   373,   394,   397,   399,   401,   414,     0,   459,
     362,   371,     0,   414,   433,     0,     0,     0,   429,     0,
     472,     0,   436,   342,   426,   428,     0,     0,   395,     0,
     351,   466,     0,   353,     0,     0,   414,     0,   424,   414,
       0,  2009,     0,  2016,     0,   145,   143,   144,     0,   138,
     140,   135,     0,   322,   323,   321,   320,     0,   131,  2016,
     244,  1971,  1432,     0,   249,     0,  1143,   517,  1159,     0,
       0,  1002,     0,     0,   974,   831,   832,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   801,     0,
       0,     0,     0,     0,     0,     0,   906,   904,   905,     0,
    1029,  1986,   522,   736,     0,   702,   963,     0,     0,  1940,
    1938,     0,  1939,  1937,  1913,     0,  1872,  1873,  1871,  1859,
       0,     0,  1423,  1148,  1239,  1241,  1247,  1236,     0,  1122,
    1137,  1435,  1183,     0,   693,  1822,  1821,  1823,  1817,     0,
       0,     0,     0,  1062,  1057,  1044,     0,  1048,  1053,  1049,
       0,  1040,  1038,     0,  1158,     0,  1148,  1143,     0,     0,
       0,     0,     0,     0,     0,     0,   557,  1468,   547,   549,
       0,     0,     0,   474,   475,   480,   482,     0,     0,   418,
     419,   420,   375,   415,   417,     0,   377,   345,   460,   468,
     469,     0,   464,   462,   465,   370,   400,   376,     0,   372,
       0,   359,   439,   438,   707,   431,   441,     0,     0,   437,
     427,   435,   430,     0,     0,     0,     0,   343,     0,   344,
    1501,  2011,     0,   534,   698,   698,  2013,  2026,   142,     0,
       0,     0,     0,   132,   134,   135,  2007,   247,   245,     0,
    1967,    91,     0,   516,     0,   815,   422,   411,     0,   826,
     846,     0,   813,   996,   987,  1116,   856,     0,   864,   870,
     957,   956,   883,   889,   893,   891,   895,   901,   902,  1014,
    1983,   738,   964,  1919,  1918,  1917,  1914,     0,     0,     0,
       0,     0,     0,  1942,  1944,  1250,     0,     0,   255,   691,
     316,  1130,  1143,     0,  1148,     0,  1443,  1181,  1827,  1826,
    1812,     0,     0,     0,     0,     0,     0,     0,  1083,  1259,
    1078,  1067,  1141,     0,     0,   330,  1470,  1469,   571,   485,
     486,   487,     0,     0,     0,   478,   481,   354,   347,   416,
       0,   523,   470,   463,     0,   358,   440,   707,   434,   459,
     465,   459,   465,     0,     0,     0,   667,     0,   109,   139,
       0,   698,   100,   102,     0,     0,   251,   250,  1143,     0,
       0,     0,     0,     0,     0,  1915,  1945,  1948,  1946,  1947,
    1949,  1943,     0,     0,   317,     0,     0,  1127,  1129,  1123,
    1171,     0,     0,     0,     0,  1436,  1438,     0,  1188,     0,
    1059,  1045,     0,  1050,     0,  1042,     0,     0,  1079,     0,
     331,   550,   489,     0,   488,     0,   483,   484,   479,     0,
     459,     0,   459,   432,   350,   352,   356,   357,     0,  2017,
       0,  2014,     0,  2027,   141,     0,     0,   133,   136,  1971,
     515,   518,   413,   847,     0,   975,   857,   915,  1256,  1264,
       0,  1424,  1131,  1132,  1143,     0,   675,     0,     0,     0,
       0,  1437,     0,     0,  1444,  1446,     0,     0,     0,     0,
    1084,  1077,   332,   491,   492,   490,   476,   477,   379,   524,
     381,  2018,  2019,  1971,   119,   118,   110,     0,   177,     0,
     103,   252,     0,     0,     0,  1435,  1128,  1172,  1441,  1442,
       0,  1439,     0,     0,  1445,     0,     0,  1047,  1052,  2015,
     120,     0,   193,   181,     0,     0,     0,   179,   207,  2028,
       0,     0,   183,   205,   206,   184,  1515,     0,  1516,  2020,
       0,   848,  1263,  1265,  1443,     0,  1440,  1448,  1447,     0,
    1060,   192,   195,     0,     0,   198,   188,   187,   189,     0,
       0,     0,   178,   228,   177,   177,   231,   186,   224,   177,
     104,  1449,   698,     0,   194,     0,     0,     0,   180,   208,
     219,   222,   214,   150,   177,     0,   177,     0,     0,  2021,
     109,     0,  1451,     0,     0,  1175,  1177,     0,   190,     0,
       0,     0,     0,   177,   215,     0,   146,     0,     0,   148,
     234,     0,   226,   105,     0,     0,  1458,  1178,  1173,   698,
    1315,     0,   182,   199,   216,   222,   212,   220,   177,     0,
       0,   177,     0,   230,   149,     0,   232,   225,   227,   177,
    1450,  1453,     0,     0,  1455,  1456,     0,  1425,  1176,   191,
     196,   177,     0,   213,     0,     0,   211,   161,   160,     0,
     152,   173,   229,     0,   151,     0,   177,   106,  1457,  1452,
       0,  1459,     0,   177,   217,     0,   177,     0,     0,     0,
       0,     0,   147,     0,   177,  1454,   197,   202,     0,   209,
     177,   155,   174,   175,     0,   158,   235,     0,   198,   177,
     201,   177,     0,     0,   153,   166,   154,   164,   157,     0,
     233,   203,   177,   177,   172,   170,   177,   168,   162,     0,
     169,   176,   167,     0,   159,     0,   156,   171,   165,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   977,    58,   527,
     924,  1389,  1390,    59,   424,    60,   703,  1135,  1136,  1137,
      61,  1606,  2472,  1153,   401,   419,   385,  2777,  3048,  3416,
    3510,  3560,  3609,  1099,  3413,  1527,  3466,  1528,    62,   492,
     701,  1117,  1118,  3222,  3223,  3219,  3224,  3038,  3039,  3040,
    3041,  3601,  3554,  3576,  3602,  3649,  3672,  3678,  3679,  3629,
    3686,  3687,  3693,  3688,  3630,  3674,  3555,  3500,  3529,  3525,
    3501,  3591,  3524,  3619,  3546,  3547,  3621,  3657,  3670,  3502,
    3503,  3530,  3571,  3504,  3531,  3595,  3551,  3596,  3622,  3658,
    3552,  3572,  3625,  3575,  3505,  3558,  3607,  3537,  3553,  3557,
    3636,  3605,  2050,  2458,  2055,  2463,  3051,  2468,  3230,  3419,
    1880,  2281,  3113,  2783,  1093,  1094,  1095,   402,   403,   404,
     500,  2056,  1562,  2057,  2058,  1564,  1565,  1023,  2432,  2423,
    2409,  3278,   724,  3047,  2436,  2437,  2438,  2439,  2387,  2388,
    1969,  1970,  2016,  2447,  2760,  2978,  2998,  2761,  2762,  2763,
    2764,  2765,  2766,  2767,  2797,  2798,  3172,  3173,  3174,  2794,
    3029,  3013,  3014,  3015,  3195,  2985,  2321,  2322,  2331,  2332,
    2369,  2655,  2370,  1098,  2986,  3023,  3182,  3016,  2446,  2972,
    3163,  3314,  3164,  3165,  3166,  3396,  1971,  2386,  1114,  1115,
     650,   405,  1167,  1610,  3055,  3056,  2377,  2885,  3320,    63,
    1101,   686,   688,   687,  2019,   479,  1566,  1567,  1568,  2698,
    2704,  3308,  1973,   111,  1386,  2443,  2007,    64,  1072,  1067,
      65,   661,   656,   657,  1070,  1071,  1496,  1931,    66,   594,
      67,   487,    68,   495,  1140,    69,   985,  1872,  1873,  1874,
      70,   693,    71,   496,  1147,  1148,  1149,    72,   975,   116,
      73,   583,   980,   982,   983,    74,   489,   490,  1109,    75,
    1416,  1854,  1855,   698,   699,  1116,  2614,    76,    77,   470,
     444,   600,   445,   446,  1443,  1892,  3279,   611,   612,   613,
    2305,  1002,  1003,  1004,  1897,  1444,  2310,  1155,  2900,  1323,
    1780,   886,  1324,  1781,   887,   888,   889,   890,   891,   892,
     893,   894,   895,   896,  2232,  2235,  3017,   897,  1333,  1791,
     898,   899,  1819,   900,  2846,  2254,  2255,  2256,  2596,  2597,
     901,  2089,  2809,  2127,   902,  1320,  1776,  1687,  3070,  2830,
    1626,  2072,  2492,  2598,   516,   517,   903,  1245,  1246,  1247,
    1704,  1311,  2218,  1768,  1503,  1504,  1505,  1506,  2949,  2948,
    2950,  3293,  3136,  3295,  3140,  1942,  1507,  1508,  3447,  2345,
    2669,  2363,  2364,  3146,  1933,  1509,  2351,  2685,  2955,  3145,
    3387,  2021,  3297,  1374,  1375,  1684,   959,   960,  1627,  1851,
    2269,  3120,  3283,  2244,  2919,  3281,  3367,  1569,  2413,  2414,
    1894,  1895,  2367,  2688,  2708,  1026,  3280,  2271,  1471,  1472,
    2788,  3677,  2032,  3436,  3515,  3564,  3565,  3566,  2637,  2638,
    2923,  2924,  1896,  2302,  2639,  3121,    78,   407,    79,  1821,
     694,   695,   519,   416,    80,   425,  1852,    81,   438,  1431,
     567,   587,   988,   989,  1881,  2282,  2289,  1882,  2294,  2912,
    2284,  2617,  2618,  1954,  1955,  2285,  2620,  2909,  2901,  2902,
    2610,  3111,    82,   458,  2680,  2358,  2359,  3428,  3429,   588,
      83,   406,   735,  1614,  1172,  1613,   736,   737,  1174,   514,
     515,    84,   456,  1047,  1048,  1049,  1486,    85,   449,   651,
    1467,  2335,  1916,   579,   653,  1478,   654,  1479,  1458,  1911,
    1014,    86,   682,   681,    87,   475,  1089,    88,   528,   935,
     936,  1394,  1829,    89,   439,   592,   593,    90,   433,   580,
    1424,    91,   426,   570,    92,    93,   571,   968,  2611,  3277,
    3475,  1415,   969,  2469,  3286,  3375,  3376,  3378,  3444,  3445,
    3562,  3586,  3613,  3614,  3617,   904,   670,   905,  3156,   906,
     907,  2290,  2291,  2689,   908,  3430,   909,  2017,   664,   422,
     910,   561,   911,  2274,   912,  3507,   716,   717,   388,   389,
      94,   614,   448,  1006,  1007,  1008,  1453,  1454,   655,  2227,
    1455,  1456,  1908,  1903,  2931,  2661,  2653,    95,   574,   937,
     973,   974,  1860,    96,   457,    97,   961,  1410,  1411,  1848,
    2268,  1849,    98,   596,    99,   550,  1404,   551,   939,   552,
     553,   951,   946,   954,   948,  3267,  3103,  3104,  1836,   920,
     718,   719,  1397,  1831,  1832,  2896,  3106,  3273,  3274,   100,
     120,   394,   498,   710,   996,   101,   102,   103,   104,   999,
    1084,  1888,  1085,  1086,  1087,  1516,  1441,  1318,  2883,  2220,
    1770,  2574,   503,   725,   485,   505,   506,   112,   113,   726,
     727,  2052,  2450,  2770,  3033,  3034,  3216,  3213,   728,  3539,
     729,  2459,  2047,  2773,  3338,  3468,   105,   672,   467,  1082,
    1077,  1079,  1512,  1949
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3233
static const int yypact[] =
{
    4041, -3233,   172,   562,   575, -3233,   159, 41513,   489,   575,
     575,  -164,   671, -3233, -3233, -3233, -3233, -3233,   623, 41513,
     562, -3233, 19986, -3233, -3233, -3233,   191,   575,   562, 41513,
   -3233,   372,   692,   562, -3233, -3233,   575, -3233,  -164, 41513,
   -3233,    47, -3233,   720,   -90,   405,   370, -3233, -3233, 41513,
     746,  -115,   893,   936, -3233, -3233,   652, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, 20539, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233,   924, 41513, 41513, -3233,
   41513,   691, -3233,   991, -3233, -3233,   575, -3233, -3233, -3233,
    -164, 19986, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233,   557, -3233, -3233,
     714, -3233, -3233, -3233,  1202,  1018, -3233, -3233, -3233, -3233,
   -3233,   194,   752, -3233,   759,  1050,   731, -3233,  1046,  1046,
   41513,  1046, -3233,  1046, -3233,  1046,   575, -3233, -3233,  1527,
   41513,   922,   301,  -116, 36563,   687,   325, -3233,  1045, 19986,
   -3233,   575,  1102,   214, 41513, -3233, -3233,   575,   666,   521,
   -3233,  2120,   122, -3233, -3233, -3233,   408, -3233, -3233, 43098,
   -3233, -3233, -3233,   735, -3233, -3233, 19986,   575,  1009, -3233,
   -3233,   114,   114,   114, -3233,   114, -3233,   114, -3233,  -115,
     721, -3233, -3233, 41513,   421, -3233, -3233,   708,   -31, -3233,
   -3233, -3233, -3233, 19986,  1155,   844, -3233, 19986, -3233,   -35,
   -3233, -3233,   739, 41513, -3233, 19986, 19986,   196,     0,   909,
   41513, 34363,   916, -3233,   135,   991,  1316, -3233,  1018, -3233,
   41513, -3233, -3233, -3233, 38213,   731, -3233, 12091,  1180, 41513,
   41513,   999, 41513, 41513, 34363, 19986,  1046,   805,  1374,   977,
     953,   587, -3233, -3233, -3233, -3233,  1004, -3233, -3233,   892,
   -3233, -3233, -3233,   141, -3233,    68, -3233, -3233, -3233, -3233,
   -3233,  1036,   808, -3233, -3233,   126, -3233, -3233, 41513, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233,  1171, -3233, -3233,
   12091,   192,  1341,  1217, 19986, -3233,  -160, -3233, -3233,  1133,
   -3233, -3233, 34363, 19986, -3233, -3233, -3233, 17764, -3233, -3233,
    1351, -3233,   826, -3233, 19986,   977, -3233,  1069,  1040,     0,
     908, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233,   872,   408, -3233, -3233,  1172,  1300, -3233,  1032,    11,
     971,   889,   216,    11, 36563,  1201, -3233,   176, -3233,  1310,
   -3233, -3233,  1020, -3233, -3233, -3233,  1033,  1039,  1197,  1019,
   -3233,   195,   292, -3233, -3233,    60, -3233,   -91,  1201,    11,
     917, -3233,  1255,  1394,   198,  -125, -3233,   657, -3233, -3233,
    1460, -3233, -3233, -3233, -3233, -3233,  1171, -3233, -3233, -3233,
     968, -3233,  1204,  1085, -3233, -3233,   507, -3233,   974,    31,
   -3233,   422, 34913, -3233, -3233, -3233,    84, -3233, -3233, -3233,
   34363,  1127,  1025, 19986,   569, -3233, 38763, 19986, -3233,    -4,
   12091, -3233, -3233,  2193,    71,    81, -3233,  1524,  1179, -3233,
   -3233, -3233, -3233,  1431, -3233,  1016,  1012,  1382,  1021, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233,  1062, -3233, -3233, -3233,
     844, -3233, 19986,   362, 19986, -3233,  1041, -3233,  1047, -3233,
    1052,  1059,  1067,  1072,  1075, 14971, -3233,  1086,  1089,  1091,
    1093,  1096,  1098,  1100,  1111,  1115,  1122,  1128,  1134,  1139,
    1143,  1016,  1016,  1145,  1147,  1153,  1159,   622,  1166, -3233,
    1168,  1170,  1190,  1195,  1199,  1205,  1211,  1213,  1215,  1233,
   -3233,  1234, -3233,  1235,  1236,  1237,  1239,  1243,  1244,  1245,
    1247,  1248,  1249,  1253,  1254,  1256,  1257, -3233,  1259,  1261,
    1262, 12091,  1263,  1264,  1265,  1266,  1268,  1270,  1271, -3233,
    1273,  1275,  1277,  1278,  1281,  1282,  1285,  1287,  1288,  1289,
    1290,  1291,  1294,  1301,  1302, -3233, -3233, 12091,  1303, -3233,
   -3233,  1306,  1307, -3233,  1308,  1309,  1311,  1313,  1314,  1319,
    1320,  1321,  1322,  1323,  1325,  1330,  1331,  1333,  1334,  1335,
    1336,  1337,  1338,  1339,  1340,   695,  1342,  1343,   738,  1344,
   -3233,  1345, -3233,   154,  1346,  1349,  1350,  1016,  1016,  1016,
    1352,  1353,  1355,  1356,  1358,  1359, 12091, 14971, 14971, 14971,
    7483, -3233, 41513, -3233, 41513, -3233,  1060, -3233, -3233,  1483,
   -3233,  1252,  1055,   854,   742,   183,  1064, 14971,  2574,   329,
   -3233, -3233, -3233,  1082,  1210, -3233, -3233, -3233, -3233, -3233,
    1361, -3233,  1165, -3233, -3233, -3233, 19986, -3233, -3233, -3233,
    1250,   127, 19986,  1304, -3233, -3233, -3233, -3233, -3233, -3233,
    1723, -3233, -3233, -3233,  1280,  1267, -3233, -3233, -3233, -3233,
   -3233, -3233,  1383, -3233, -3233, -3233,  1362, -3233,  1362, -3233,
   -3233,  1362, -3233, -3233,  1362,    70,  2115, -3233, -3233, 41513,
   -3233, 42063, -3233, 17764, -3233, -3233,  1586, -3233, -3233,  1631,
   -3233,  1637,   137,  1363, -3233, 19986, 36563, -3233, -3233,   113,
    1364,  1439,  1365, -3233,  1443, 19986, 19986, -3233, -3233, -3233,
   -3233,   521,   146,  1367,    96, -3233, 41513, -3233,   296, -3233,
   -3233, -3233,  1368, -3233, 12091, -3233,  1369, -3233,   596, -3233,
    1717, -3233,  1458, 12091, -3233, -3233,  1384,  1018, 41513, 41513,
   19986, 19986, -3233, -3233, -3233,   445, -3233, -3233, 41513,    11,
   34363, -3233, -3233, -3233,  1778,   917, 41513,    11, -3233,  1722,
    1472, -3233, -3233, -3233,  1794, -3233, -3233,  1783,  1381, -3233,
   -3233, -3233,   917, -3233, -3233, -3233, -3233, -3233, 19986, -3233,
   -3233,   917, -3233,   917,   917,    11,    11,  1436, -3233, -3233,
    1386, -3233,  1436,  1516,  -141,   114,  1599, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233,   508, -3233, -3233,
   -3233, -3233, -3233, -3233,    93, -3233, -3233, -3233,  1293,   858,
     858,  1167, -3233,   212, 19986,    81,  1458, 19986, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233,  1393, -3233,  1398,  1399, -3233,
    1830,  1832,  1840,  1841,  1842,  1843,  1844,  1847,  1848,  1849,
    1853,  1854,  1856,  1858,  1863,  1434, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233,  1485, -3233, -3233, -3233, -3233,   986,
   -3233, -3233, -3233,    84,  1438, -3233, 36563,  1968, 34363, 41513,
   41513,  1836, 19986, -3233, -3233,   305,   305,  1672,  1041, -3233,
      89, 41513,  1846, 24405,    75, 12091, 12091, 12091,   308,   638,
    1953,  2006,  2006,  2006, 12091, 12091, -3233, -3233, 12091, -3233,
   12091, 12091, 12091, 12091,   321, -3233, -3233,  8059, -3233,  1445,
   12091, 12091,  1538, 12091,  1210, 12091, 12091, 21092, 12091, 12091,
   12091, 12091, 12091,   570, 12091,  2574, 12091, 12091, 12091,  1455,
   12091, 12091, 12091, 12091, -3233, 12091, 12091,   269, 12091,  1906,
     583, 12091, 12091, 12091, -3233,  8635, 12091, 12091, 12091, -3233,
   12091, 12091, 12091, 12091, -3233,  2023, -3233, 21092,   803, 12091,
   12091,   860, 12091, 12091, 12091, 12091, 12091, -3233, -3233, -3233,
   -3233,  8059, -3233, 12091, 12091, 12091, 12091, 12091, -3233, 14971,
   12091,  9211, 12091, 12091, 12091, 12091,  1459, 12091, 12091,  2006,
    2006, 12091, 12091, 12091,   871,  8059, -3233, 12091,  1210,   390,
     390, 12091,  1210,  6331, 12091, -3233, -3233, -3233,   583,  9787,
    1465, -3233, -3233, -3233,  2006, 21092,  2006, 12091, 12091, 12091,
   -3233,  1489,  1953,  1953,  1953, -3233,  7483,   740,  1469, 12091,
   22198,  1456, 12091, -3233, -3233, -3233, 14971, -3233, -3233,   611,
   -3233, -3233, -3233, 12667,  1475, 14971, 14971,  1793, 14971, 14971,
     565, 14971, 14971, 14971, 14971, 14971, 14971, 14971, 14971, 14971,
   14971, 14971,  1953, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233,  1484, -3233, 36563, 14971, 12091, -3233,
   -3233, 41513, -3233, 34363, -3233, -3233, -3233,   127, 36563,  1474,
   -3233, -3233,  1662,  1374, 19986, -3233, 41513, -3233, -3233, -3233,
   -3233, 18317, 18317, -3233, 18317, -3233, -3233,    72,    83,  1462,
    1508, -3233, -3233, -3233, -3233,  1837, 19986, -3233,   -16, 19986,
      81, -3233, 12091,  1458, -3233, 34363, 34363, 19986, 19986,    69,
   -3233,   703, -3233,  1458,  1864, 18317, 18317, 18317, -3233, -3233,
   -3233, -3233, -3233,   636, -3233, -3233, -3233,  1478, -3233, -3233,
   -3233, -3233, -3233, 39313,   131, -3233, -3233,  1458,  1885, -3233,
   -3233,  1487, 41513, -3233, -3233, -3233, -3233,    44, -3233, -3233,
   -3233, -3233,  -103, -3233, -3233, -3233, -3233,  1617,    11, 41513,
   -3233, -3233, -3233, -3233, -3233,  1682,  1201,   292,    11,   917,
   19986,    11,    11, -3233, -3233,   809, -3233,   657, -3233, -3233,
   -3233, -3233, 41513,  1084,  1628,  1490, -3233, -3233, 19986, -3233,
    1491, -3233,  1895,  2024,  1201, -3233, -3233, -3233,   310,   310,
    1458,  1609,  1612,  1614,  1616,  1619,  1649, -3233, -3233,   261,
    2014,   310,   310,  2014,   310,   310,   310,  1584,  1961,   310,
    1852,  1600,   760,  1857,   310, -3233,  1601,  1971,   310,   310,
     310,  2014,  2050,   310,   310,   310,   310,   310,   143,   310,
     310,   310, -3233,  2798, -3233, -3233,  1523, 18870, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, 39863, -3233, 12091,   638,
    1458,  1458,   578,  1458,   638,  1458,  1458,  1458,  1458,  1458,
     638,  1458,  1458,   638,  2193, -3233, -3233, -3233, -3233, -3233,
     385, -3233, -3233,  1038, 41513, -3233,  2063, -3233, -3233, -3233,
   -3233, -3233, 19986,  1569,  1508, 24405, -3233,  -141, -3233,  1520,
   -3233,  1528,  1532,   771, -3233,  2006,  1533, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233,  1530,  1534,  1535,  1536,  2084,  1537,
    -176,  1539,  1547,  1548,  1549,  1550,  -174,  1551, -3233,  1555,
    1563,  1560, -3233,  1561,  1562,  1565,  1567,  1568,  1570,  1571,
     804,   831,  1572,  1573,   836, -3233,  1575,  1577,  1960,  1578,
    1579,   842, -3233,  1576,  1580,  1581,   857,  1587,   868,   870,
   -3233, -3233, -3233, -3233,  1583,  1589, -3233, -3233,  -166,  1588,
    1590,  1591, -3233,  1593,  1595,  1596,   901,  1598,  1603,   914,
    1604,  1605,  1602,  1608,  1613, -3233,  2006,  1610,  1618,  1620,
    2006,  1621,   923,  1622,  1625,   933,   935,  1629,  1630,  1634,
    1635,  1636,  1638,   946,  1639,   948,  1641,   -26,  1642, -3233,
    1643,  1646,  1647,  1648,   952, -3233,  1650,  1644,  1655,  1657,
    1659,   147,  1661,  2006,  1658,  1663,   956,  1664,  1666,  1668,
   10363, 10939, 11515,    10,  1670,   431, -3233,  1669, -3233,  1673,
    1674, -3233,  1571,  1676,   958,   970,  1678, 12091,   500, -3233,
     570, -3233, -3233, -3233,  1564,   615, -3233,  1708, 41513, -3233,
     895,  1543, -3233, -3233, -3233, -3233, -3233,   391, -3233,  1623,
   -3233,  1632,  7483,   673,  1624, 14971,    82,  1055,  1640, 14971,
   14971, 14971,   854,   742,   742,   183,  2574,   183,  2574,  1064,
    1064,  1064,  1064,  1064,  1953, 12091, -3233,  1953, -3233,  1679,
    -201, -3233, -3233, -3233, -3233,  1304,  1911, -3233,  1671, -3233,
   -3233,   988, -3233,  1611, -3233,  1681,  1677,  1685,  1695, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233,  1201,   703,  1749,  1687, -3233, -3233,  1704,  1998, -3233,
   -3233, -3233, -3233, -3233, -3233,  1713, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233,   160, -3233, -3233,  1690,  1690, 16653,
   -3233, -3233, -3233, -3233,  1915,  2090,  2092,  2094,   422, -3233,
     142, -3233,   763,  2044,  1201, -3233,  2098, 37113, 24957, -3233,
    1694,  2043,  1697,   310, 32713,   330, 22748, 33263, -3233, -3233,
     578, -3233,    45, -3233, -3233, -3233, -3233,   445,   445,  1731,
   -3233, -3233,  1943, -3233, -3233, -3233,  1508,   917, -3233, -3233,
   -3233,  1707, -3233, -3233,  -141,  2048,  2052, -3233,  1931,   665,
    1931,  -141,  -141, 21092,  -141,  1449, -3233,   638,  1989, -3233,
   -3233, -3233, -3233, -3233, -3233, 35463, 33813, -3233, -3233, -3233,
    2197, -3233,  2198,   259, -3233, 21645,   969,   969, -3233,    85,
     156, 21645, -3233, -3233, 21645,   578,   638, 21645,   638,  1458,
    1458,  1515,   310,   638, -3233, -3233,  2057,  2059, 21645, 21645,
   -3233, 36563, -3233,   310,   618,   578,   578, 21645, 21092,   239,
    1458,   638,   638,   724, -3233, -3233, -3233, 19986,  1110, 36563,
    1725, -3233,  4304, 16100, 41513,   795,   149, -3233,  1719,  1727,
   -3233,   998, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233,  1812, -3233,  1730, -3233, -3233,
     107, -3233,  1727, 19986, 15547, -3233,    86, -3233,  1653, -3233,
    -141,  1952,   117,  1508,  1738,    75, 13243, -3233, -3233, 12091,
    1732, -3233, 12091, 12091, -3233, -3233, -3233,   237, -3233, 36013,
   -3233, -3233, -3233, -3233, -3233, 12091, 36013,   237, 12091, -3233,
   -3233,  1735, -3233,  2086,  2086, -3233, -3233,  1210, -3233, 41513,
   -3233, 12091, -3233, 12091, -3233,  1210, -3233, 12091, -3233, 12091,
   12091, -3233,  1976, -3233, 12091, -3233, 12091, 12091, -3233, 12091,
   -3233, -3233, 12091, -3233, 12091, 12091, -3233, -3233,  1978, -3233,
   12091, 12091, -3233, -3233, 12091, -3233, 12091, -3233, 12091, -3233,
   12091, -3233, 12091, -3233, 14971, 21092,  1743, -3233, -3233, -3233,
    1745, -3233, -3233, 12091, 12091, -3233, -3233, 12091, -3233, 12091,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, 12091, 12091, -3233,
   12091, -3233, 12091, -3233, -3233, 12091, 12091, 12091, -3233, 12091,
   -3233, -3233, -3233, -3233, 13819, 12091, 12091, 12091,  1746, -3233,
   -3233, -3233, 12091, 12091, 12091, -3233, 12091,  2147, 12091,  2148,
   12091,  2149, 12091, -3233, 12091,  1987, -3233, -3233, -3233, -3233,
   -3233, 12091, -3233, 12091, -3233,  1766, 12091, 12091,  2186, -3233,
   -3233,  1754,  1755, -3233,  1751,  1753,  1756, 36563, 12091, -3233,
   -3233, -3233, 12091, -3233, -3233, 12091, -3233, -3233, -3233, -3233,
     570,  1000,  1760, 14971, -3233,  1624, 14971,  7483,   673,  1624,
     121, -3233, -3233, -3233,  1761, -3233, -3233,  1765, 41513, -3233,
   -3233, -3233, 41513,  1773, 25509, 34363, 34363, 34363,  1768, 12091,
   -3233, -3233,  2002, -3233, -3233, 19986,  2133, -3233, -3233, 34363,
   -3233,   408, 21092, -3233,  1774, -3233,  1774,   626,  1776,  1006,
   -3233, -3233, -3233,  1771,   908,  2173, 34363, 34363, 34363, -3233,
    1508,  1508,   129,  1829,  2125, -3233, -3233, -3233, -3233, 40413,
   -3233, -3233, -3233, -3233,   574, 41513,  2106, 41513,  6907, -3233,
   -3233, -3233,  2293, 12091, -3233, 34363,   453,   615,   310, -3233,
   -3233, -3233, -3233, -3233, -3233,  1201, -3233, -3233, -3233, -3233,
    2083, -3233, -3233,    11,   809,  -158, -3233,  1298, -3233, -3233,
   -3233,  2123,  -141,  1931,  1931,  2124,  2017,   -30,  1788, -3233,
     310,  1084,    29, -3233,   408, -3233, -3233, 12091, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, 12091,  2126,  2127,   969, -3233, 21645, -3233, -3233,   362,
      94, -3233, -3233, -3233, -3233, -3233, -3233, 33813,  1458, -3233,
   21645, -3233, -3233,   157, -3233,  1458, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233,  1791, -3233,   931, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, 19986, -3233,  1013, -3233, -3233, -3233,
   -3233, 41513, -3233, -3233, 19986, -3233, -3233,  5594, 41513, 41513,
    2349, -3233, 41513, -3233, -3233, -3233, -3233, -3233,  2025,  -130,
    2353, -3233, 19986, -3233,  1799,  1024, -3233, -3233, -3233,  2356,
     980, -3233,  1802,  1508,  2128, -3233, -3233, 12091,  1804,  1806,
   -3233, -3233,  1809,  1811,  1811, -3233, -3233,  1813,  1811,  2160,
   -3233,  2161,  1815,  1818,  1820,  1821,  1822,  1823,  1826, -3233,
   -3233,  2574,  2574,  1828,  1824,  1831,  1833,  1834,  1835,  1839,
    1845,  1851,  1855,  1861,  1862,  1865,  1868,  1866,  1872,  1877,
    1878,  1880,  1952,  1881,  1882,  1883,  1886,  1887,  1888,  1026,
    1889,  1890,  1028,   225, -3233, -3233, -3233,  1898,  1899,  1908,
    1910,  1913,  1914,  1917,  1918,  1919,  1884,  1920,  1922,  1924,
   12091,  1925,   140,  1035,  1905, -3233,  1926,  1927,  1928,  1930,
   12091,  1932, 12091,  1933, 12091,  1939,  1942,  1944,  1948,  1949,
   12091,  1859, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
    1838, -3233,  1060, -3233,  1950, -3233, -3233, -3233,   329, -3233,
    1049,  1951, -3233, 14971, -3233, 12091,  1954, -3233,  1956, -3233,
   -3233, -3233, -3233, -3233,   417,   417,   417, 14395, -3233,  2271,
   -3233,   519, -3233,  2159, -3233, -3233,   872,  1957, -3233,   310,
   14395,  1690,  1981, -3233, -3233,   626, 21092, 24957, -3233, 34363,
    1021,  1021,  1021,  1201,  2219,  1749,  1749, -3233, 23298, -3233,
   -3233,  1977, -3233, -3233, 26061, -3233,   -22, -3233, -3233, 14971,
    1170, -3233, -3233, -3233, 35463, -3233, -3233,   310,  1850,  1912,
   -3233, -3233, 40963, 12091, -3233,  2272, -3233, -3233,  1959,  -141,
    2061,  -141, -3233,  2190,  2192,  -141, -3233, -3233, -3233, 21092,
    1508, 14395,   969,   969,   969, -3233,   872, -3233,  1962,   931,
   -3233, 21645, -3233, -3233,   362,  1916,  2311,  2321, 21645,  2293,
   -3233, -3233, -3233, -3233,  5594, 21092, -3233, -3233, -3233,  1077,
   -3233, 16100, -3233, -3233, -3233,  1945,  1955,  1811, -3233, -3233,
   -3233, -3233, -3233,  1813,  2069, -3233,  1813,  1813, -3233, -3233,
   -3233, -3233, -3233,   134,   201, -3233, -3233,   134, -3233, -3233,
   -3233,   101,   684,  1813, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233,  1811,  1811, -3233, -3233, -3233,   134,  1958, -3233,  1811,
     745, -3233,   119,    67,  1965,  1966,  1811,  1967,  1921, -3233,
    1079, -3233, -3233,   -13, -3233,   451, -3233, -3233, -3233,  1969,
   -3233,  2798, -3233,   586, -3233, 41513, -3233,   445, -3233,  2574,
   -3233, -3233, -3233,  2167, -3233,   134,  2179, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, 12091,  1970,
    1972,  1973, -3233, -3233, -3233, -3233, -3233, -3233, 12091, -3233,
   -3233, -3233, -3233, -3233, 12091, -3233, -3233, -3233, -3233, -3233,
    2095, -3233,  2196, 12091, 12091, -3233, -3233, -3233, -3233, 12091,
   -3233, -3233, -3233, 12091,  2494,  2168,  1974, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, 12091, -3233, -3233, -3233,
    2574, -3233, 12091, -3233, -3233, 12091, 12091, -3233, 12091, 12091,
   -3233,  1979, -3233,  1980, -3233,  1984, -3233, -3233,  2203, -3233,
   -3233, -3233, 12091,   908, 41513, -3233, -3233,  1985, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233,    97,  2003,  2003,  2003,  1170,
   -3233,  1105, -3233, -3233,  2326, -3233,  1368, 21092, 14395,  1986,
    1988, -3233,    31, -3233, -3233,  1975,  1021, -3233,  2519,  2364,
   -3233, -3233, 36563,  1991, -3233, -3233,  2257, -3233,    98,  2178,
   -3233, -3233, -3233,   453,  2080,  2085,   310, -3233,  1458,  1652,
    1490,  2336,  1090,  2045,  -141,  -141,  1141,  2046, 12091, 12091,
    2000, -3233,  1952, -3233, -3233, -3233, -3233, -3233,  1368, 12091,
   -3233,  2004,  2005, 41513, -3233,  1531,   795, -3233,   745, -3233,
   -3233, -3233,   -65,  2242,  2243, -3233,   744, -3233,  2011,   744,
     744,  2553,   180, -3233,  2553, 36013, -3233,  1032, -3233,  2047,
     134, -3233, -3233,  2051, -3233, -3233, -3233,   744,  2013,   134,
   -3233, -3233,  2249,   744, -3233, 36563,  1458,  1126, -3233,  2070,
   -3233,  2484,  2358, -3233,   745, -3233,  2359,  2262, -3233,  2263,
   -3233, -3233,  2264, -3233,  2265,  2266,   744,  2267, -3233,   744,
   41513, -3233, 41513,  2058,   594, -3233, -3233, -3233,  2026,  2032,
   -3233, -3233, 19986, -3233, -3233, -3233, -3233,  2099, 41513,  2058,
   -3233,    31,    86,  1981, -3233,  1112,   931,  2038, -3233,  2040,
    2041, -3233,  1119,  2042, -3233, -3233, -3233,  1129,  2049,   114,
    2053,  2037,  2054,  2055,  2060,  2066,  2307,  2464, -3233,  2068,
    2071,  2074,  2077,  2078,  2079,  2082, -3233, -3233, -3233,  2087,
   -3233, -3233, -3233, -3233,  2089, 37113, -3233,  2132,  2135, -3233,
   -3233,  2136, -3233, -3233,   118,  1061, -3233, -3233, -3233, -3233,
   14395,  2388, -3233,   830, -3233, -3233, -3233, -3233, 12091, -3233,
    1952,  2563, -3233, 23298, -3233, -3233, -3233, -3233, -3233,  2091,
    2093,  6907,  2617, -3233,  -141, -3233,  2105, -3233, -3233, -3233,
    2113, -3233, -3233, 41513,  2128,  2088,   830,   931, 41513, 41513,
    1148,   583,   583,   583,   705,   705, -3233, -3233, -3233, -3233,
     543,   144, 41513, -3233, -3233,   495, -3233,  2096,  2100, -3233,
   -3233, -3233, -3233,   744, -3233,   114, -3233, -3233, -3233, -3233,
   -3233, 36013, -3233, -3233,  2553, -3233, -3233, -3233,   114, -3233,
    2107, -3233, -3233, -3233,  1016, -3233, -3233,  2324,  2121, -3233,
   -3233, -3233, -3233,  2108,  2109,  2111,  2112, -3233,  2114, -3233,
   -3233, -3233,   741, -3233, -3233, -3233, -3233, -3233,   891, 41513,
    2487,  1458,  2116,  2117, -3233, -3233, -3233, -3233, -3233,  2119,
     908, -3233, 41513, -3233,  2322, -3233, -3233, -3233,  2328, -3233,
   -3233, 12091, -3233, -3233, -3233,  2006, -3233, 12091, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233,   109,  2315,   638,
     638,   638,   638,  1061, -3233, -3233,  2156,  2188, -3233,   763,
   -3233,   593,   931, 12091,  1201,   215,  2432, -3233, -3233, -3233,
   -3233,  2418,  1242, 12091,  2122, 12091,  2129,  1150, -3233, -3233,
   39863, -3233, -3233,  1154,  1161, -3233, -3233, -3233,   795, -3233,
   -3233, -3233,   374,   374,  1163, -3233, -3233, -3233, -3233, -3233,
    1178, -3233, -3233, -3233,  1183, -3233, -3233,  1016, -3233,   134,
    2553,   134,  2553,  2638,  2350,  2642, -3233,  -115, -3233, -3233,
    5594, -3233, -3233, -3233, 41513,  5594, -3233, -3233,   931,  2131,
    2134,  1185,  2137,  2138,  2140, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, 21092, 19986, -3233,   173, 12091, -3233, -3233, -3233,
    2327,  2658,  2661,  2569,  2665,   215, -3233,   -99, -3233,  2570,
   -3233, -3233, 41513, -3233, 41513, -3233, 41513,  2143,  2145,  2331,
   -3233, -3233, -3233,  2713, -3233,   174, -3233, -3233,   495, 41513,
     134,   114,   134, -3233, -3233, -3233, -3233, -3233,  2372, -3233,
    2373, -3233,  2152,   881, -3233,  2593,  2316, -3233, -3233,    31,
   -3233, -3233, -3233, -3233, 12091, -3233, -3233, -3233,  2153, -3233,
     310, -3233, -3233, -3233,   931, 41513, -3233,   114,   114,  2685,
     114, -3233,  2686,  2689,   -99, -3233,   578, 12091,  1187,  1191,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233,    31, -3233, -3233, -3233,  2614, 31053,  2313,
   -3233, -3233,  2164, 21092, 14395,  2563, -3233, -3233, -3233, -3233,
     114, -3233,   114,   114, -3233,  2723,  2162, -3233, -3233, -3233,
   -3233, 41513,   130, -3233, 42613, 42613, 41513, -3233,  2199, -3233,
    5009,   125, -3233, -3233, -3233, -3233, -3233,  2163, -3233, -3233,
    5594, -3233, -3233, -3233,  2432,  2169, -3233, -3233, -3233,  2461,
   -3233, -3233, -3233,  2571, 41513, -3233, -3233, -3233, -3233, 12091,
   12091,  2204, -3233, -3233, 31053, 31053, -3233, -3233, -3233, 31053,
   -3233,  2536,  2180,  2608, -3233,  2529,  2615, 12091, -3233, -3233,
   -3233,   651, -3233, -3233, 28278,  2182, 31608, 12091,   125, -3233,
   -3233,  2426,  2195, 12091,  2191,  2201, -3233,   638, -3233,  2557,
    2206,  2226, 12091, 31053, -3233,  2631,  2664,  2505,  2207, -3233,
    2205,  2649, 42613,   881,  2530, 17206,  2354, -3233, -3233, -3233,
   -3233, 41513, -3233, -3233, -3233,   664, -3233, -3233, 28833,  2228,
   37663, 29388,  2210, -3233, -3233, 12091, -3233, -3233, -3233, 31053,
   -3233, -3233, 36563,  1200, -3233, -3233, 21092, -3233, -3233,  2217,
   -3233, 31053, 12091, -3233,  2652,  2234, -3233, -3233, -3233,  2596,
    2224,  1042, -3233,  2222, -3233,  2659, 31053, -3233, -3233, -3233,
   19428,  2153, 41513, 26613, -3233,  2246, 31053,  2636, 41513,  5594,
    2637,  2639, -3233,  2408, 29943, -3233, -3233,    42,  2253, -3233,
   27168, -3233, -3233,  2703,   145, -3233, -3233,  2268, -3233, 31053,
   -3233, 31053, 32163, 12091, -3233,  2281, -3233, -3233, -3233,  5009,
   -3233, -3233, 30498, 27723, -3233, -3233, 23848, -3233, -3233,  2647,
   -3233, -3233, -3233,  1210, -3233, 32163, -3233, -3233, -3233, -3233
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3233, -3233, -3233, -3232, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233,  1001, -3233, -3233, -3233, -3233, -3233,  1231, -1432,
   -3233, -3233, -3233, -3233, -3233,   340,   -55, -3233, -3233, -3233,
   -3233, -3233, -3233,  2139,  -732, -3086, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233,  -396,  -514, -3233, -3233,  -387,
   -3233, -3233, -2299, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233,  -832, -3233,  -861, -3233, -3233, -1497, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233,  -833, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233,  -759, -3233, -3233,
    -713, -3233, -3233,  -755, -3233, -3233, -3233,  -717, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233,  -208, -3233, -3233,
   -1825, -3233, -3233, -3233,  1696, -3233,  1757, -3233,  2446, -3233,
    -393,    76,  1295, -1877, -1022,  -516,  -515,  -939, -3233, -3233,
   -3233,  -294, -3233, -3233,   802,   148,  1296,  1332,   848,   896,
   -3233, -3233,   162, -3233, -2632, -3233, -3233, -3233,   133, -3233,
     136, -3233, -3233, -3233, -2339,   104, -1663, -3233,  -305, -1698,
   -3233,   -96, -3233,  -140, -3233,  -446, -2010, -1783, -3233, -3233,
    -132,   184,   230, -3233, -2565, -2204, -3233, -3233,  -507, -3233,
   -3233, -3233,  -513, -3233,  -278,  -424, -3233, -3233, -1481, -1725,
   -3233, -3233, -2144,  1724, -2227,  -341, -1865, -3233,  -296, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,   883, -3233,
   -3233, -3233,  -269,   228, -1337, -2754, -3233, -3233, -3233, -3233,
   -3233, -3233,   907, -3233, -3233,  1396,  1827, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,  1022, -3233,
   -3233, -3233, -3233, -3233,  -854,  1752, -3233, -3233, -3233,  1269,
   -3233, -3233, -3233, -3233,  1471, -3233, -3233,  2211, -3233, -3233,
   -3233, -3233,   627,  1048, -3233, -3233, -3233,  2230,  1015,  -468,
   -1730, -3233,  2439, -3233, -3233, -3233, -1302, -1934, -3233,  2301,
    -365, -1773,  1476,  -703,    24, -3233,  -175,  -745,  2740, -3233,
   -3233, -1248, -3233, -3233,  -782, -3233, -3233, -1275, -1174,  1582,
    1585,   434,   435,   166, -3233, -3233,  -491, -3233, -3233, -3233,
   -1260,  -719, -3233, -3233, -3233, -3233, -3233, -3233, -3233,    26,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -1154, -3233,   837, -3233, -1040, -3233, -3233, -3233,  1683, -3233,
   -3233, -3233, -3233, -3233, -1882, -1406,   254, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -1870, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -1327, -3233, -1660, -3233,  -902, -3233,
   -3233,  -375, -2127, -1178,   501, -3233, -3233,  -959,  1734, -1544,
   -3233, -3233, -3233,   681, -3233, -3233, -3233, -3233, -3233,   226,
   -2012, -1049, -3233, -3233, -2577,  -604, -1804,  -589, -3233, -1836,
    -214, -1155, -1864, -3233, -3233, -3233, -3233,  -657, -3233, -3233,
   -3233,  -190,  1043, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
    -461,  -378,   845, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233,  1983,  1963,  1083, -3233, -3233, -2043, -3233, -3233,
    1056, -3233,    30, -1838, -1258,   317, -3233, -3233,   319, -2590,
   -3233, -3233, -3233, -3233, -3233, -3233,   263,  -676,  -530,  2486,
   -3233, -3233, -3233, -3233, -3233, -3233,  2214,  1779, -1440,  2436,
   -3233, -3233, -3233, -3233, -3233,  1466, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233,  2503, -3233,  -945, -3233,  -448, -3233, -3233,
    -592, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
    1566, -3233, -3233, -3233, -3233, -3233,  1964, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233,   346,  -517, -3233,  -415,  -552, -3233,  -483,
   -3233, -3233, -3233,  -677, -3233,  -753,  -678, -1000,   -43, -2601,
   -1360,   339,  1982, -2766, -1130, -1264, -1272, -1861,    21, -3233,
      -7,  -553,  -456,  -836,  2323, -3156,  -414,  -494, -3233,  -885,
   -3233, -3233, -3233, -3233,  1518, -3233, -3233, -3233, -3233,   640,
   -3233, -3233, -3233,   306, -3233,    36,  -161, -3233, -3233,   849,
   -3233,  1552, -3233, -3233, -3233, -3233, -3233, -3233, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233,  1993,  2531,  2378, -3233,
    2018, -3233, -3233, -3233, -3233, -3233,  -292, -3233,    34, -3233,
   -1906,  1819,   377, -3233,   717,  -803, -1093, -3233,  -297, -3233,
   -3233,   787,  2538,  2384, -3233, -3233, -3233, -3233, -3233, -2221,
    -598, -3233, -2289, -3233, -3233, -3233, -3233, -1145, -3233, -3233,
    1675,  -106, -3233, -3233,   689, -3233, -3233,   -88, -3233,  2504,
    2258, -3233,   939, -3233,   217, -3233, -3233,   -57, -3233, -3233,
   -3233, -3233, -3233, -3233, -3233, -3233, -3233,   937, -3233, -3233,
   -3233, -3233, -3233, -3233
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2004
static const short int yytable[] =
{
     386,   678,  1000,   649,  1090,   671,   671,   671,   713,   671,
     563,   671,   386,  1418,  1204,   386,  1195,  1196,  1198,  1159,
    1160,  1161,   386,   978,  1634,  1473,  1180,  1635,  1636,  1637,
     919,  1022,   386,  1761,   704,   705,  1027,  1668,  1514,  2219,
    1649,  1760,   386,   421,  1054,  1260,  2334,  2270,  1972,  2474,
    1823,  1782,  2347,   481,  2288,   482,  2668,  1055,  1790,  1027,
    2357,  1988,  2361,  1930,   921,  2318,  2323,  2326,  1666,  2493,
    2061,  2356,  2968,  2628,  1779, -1852,  2496,  1658,   663,  1563,
     386,  2338,  2339,  1262,  1806,  1808, -1853,  -258,   981,  -248,
    2307,  2953, -1504,   957,  1707,  1727,  -259,  1711,  2246,  3021,
     386,   386,  1288,   386,  2378,  1292,  2389,  1488,   476,  1286,
    2378,  2391,  2960,  2390,   386,   732,  2393,  1705,  1491,  1492,
   -1505, -1916,  1301,  1302,  1303,  1738,  1739,  2402,  2403, -1114,
    1744,  2410,  2411,   992,  3266,  1141,  2412,  2593,   497,  2981,
    1422,  1893,   491,  2381,   957,   721,  1640,  1641,   667,  1643,
    1759,  2982,  1763,  3533,  2981,   957,  3097,  2993,  1312,  1313,
    1314,  2004,  1794,   952,  1796,  2983,  2982,  3125,  3097,  2991,
    1096,  1097,  2992,  2372,   617,   618,  1384,  3668,  1352,  2065,
    2983,  2471,  1946,   106,  1677,  2202,   617,   618,  1295,   617,
     618,  3001,  2336,  3147,   696,  1092,  1102,  3020,  2682,  1697,
    3179,   949,  1058,  2172,  1092,   106,  1384,  2381,  3035,   987,
    1024,  2063,  3158,  1112,  2381,  1620,  3036,  1717,  1718,  1719,
     958,  2981,  2455,  2696,  3160,  1869,   671,  1138,  1726,  2464,
    3061, -1504,  1105,  2982,  1113,   617,   618,  1142,  1917,  1028,
    1143,  2379,  2380,  2683,  2623,  2695,   577,  2983,   706,  1401,
   -1114,  1573,  1628,  1144,  1857,  2382,   617,  2987,  1036,  3312,
    2635,  1956,  3432,  1012,  1061,  1050,   107,   965,  3532,  2483,
     683,   958,  2300,  1975,  1976,  1435,  1978,  1979,  1980,  3161,
    2355,  1983,   958,  2775, -1974,  3454,  1991,   427,  2005,  1500,
    1994,  1995,  1996,  2484,  1939,  1999,  2000,  2001,  2002,  2003,
    2466,  2008,  2009,  2010,  1038,  3522,   484,  1914,  1439,  1346,
    1017,  1629,  2862,   507,  2677,   468,  1869,   668,  3115,  -338,
    1624,  1433,  2185,   669,  1570, -1852,  -339,  3465,  1964,   560,
    2456,  3098,  1039,  1624,  2485,   708, -1853,  2486,  3526,  3527,
    1965,  1065, -1504,  3098,  3037,  2487,  1628,  2616,  1630,  1607,
    2416,   108,  3282,  3371,  2079,   452,  2086,  1296,   998,  2604,
    2605,  2606,   556,  3372,  3157,  3442,  1680,   966,  2928,  1681,
   -1505,  2375,  2257,  1040,  1858,  1052,   121,   441,  1041,  2258,
    1145,  2929,  2342, -1974,  2976,   393,   109,  2979,  2980,  3443,
    2630,  2631,  2632,  1376,  3534,  1018,   447,  1510,  2080,   709,
    1340,  2087,   568,   386,  2997,  1629,  3157, -1114,   428,  2128,
     453,  2930,  1631,   386,  1066,  1053, -1971,   386,   731,   976,
     601,  1440,   386,  3392,  2024,  3185,  3608,   386,  3099,  2034,
    2686,  -338,  1501,  1625,  3189,  2040,  1502,  1475,  2043,  1966,
    1571, -1504,  1630,  2776,  1402,  1481,  1648,  3694,  1379,   386,
     573,  1870,  1904,  1139,  2844,  1952,   684,  2383,   469,  1459,
    3523,  1387,   967,  1146,   558,   915,   386,   917,   918, -1505,
    1436,  2070,  1918,  1493,  1494,  1952,   386,  1688,  1112,  3233,
     386,   685,  2672,  1632,  2301,  2636,   386,  2376,   386,   386,
    2663,  2467,  1905,   386,   386,  1357,  1347,  3465,  1515,  1113,
    2678,   578,  2325,   386,   689,  1608,  1631,   386,  3162,   722,
    1915,  3455,   386,   386,  1420,   386,   386,   386,   386,  2475,
    3275,  2694,  2681,  1042,  1429,  2378,  1051, -1114,  -339,  3535,
    2697,   707,  1972,   602,  1859,  2701,  1476,  1339,  1385,  2378,
     697,  1563,  1870,  2444,  1926,  1755,   110,   998,   502,  2236,
    2962,   386,  2146,  1574,  3391,  1403,  2150,  1013,  2684,  3043,
    3100,  -137,  1421,  2488,  1358,  3373,  1862,   386,  1385,  -500,
    3302,  3101,  1500,  1972,  1062,   386,   386,  1632,  1096,  1097,
     386,  1403,  2913,  3101,  2203,   987,   950,   386,  2337,  2188,
    1019,  3433,  1043,  2784,  2308,   972,   691,  1871,  3675,  1362,
    3434,  3669,  2384,   669,   984, -1114,  2346,  1761,   987,  3126,
     953,  1423,   603,  1490,  2699,  2292,  1793,   386, -1852,   671,
     598,  2245,  2065,  3117,  1462,  2221,  2249,  2250,  2251, -1853,
    2252,  2457,  1814,  -338,  2984, -1504,   723,  1096,  1097,  2994,
    3022,  2006,  1029,  1297,  1107,  1339,  1107,  2242,  3102,  2984,
   -1114,  1044,  1519, -1852,  2473,  1633,  1107,  -566,  1817,  2693,
    3018,  1037,  3091, -1505, -1853,  -258, -1916,  -248,  3313,  1615,
   -1504,  1761,  3536,  -339,  -259,   386,   429, -2003,  3044,  2360,
    2489,  1063,  1377,   386,  1339,  2027,   386, -1114,  1871,   386,
     386,   557,  3019,  2673,  2674,  3180,  1366,  2064, -1505, -1916,
    1064,  1020,  1107,  3374,  1367,  3368,   569, -1114,  3414,  3393,
    1906,  1967,  1468,  3418,  2863,  1501,  2984,   408,   491,  1502,
    3309,  1107,  2186,  2916,  2398,   386,  1761,   386,  2237,  1575,
    1609,  2490,  2222,  2466,  2415,  2405,  3150,  1376,  2988,  2758,
     501,  1045,  1599,  1080,  2028,  1628,  2045,  1953,  1379,  1633,
    1348,  1349,  1350,  1164,   524,  1169,  2633,  2634,  1021,  2491,
    1682,  1025,  3227,  1683,  3404,   395,  3406,  1953,  3004,  1783,
    1368,  3420,  1046,  2845,   460,   582,   390,  3178,  -338,   585,
    3183,  2908,  2406,  1469,  3160,  3394,  2795,  1449,  1339,  2942,
    2799,  3333,  2365,  2946,  1798,   963,  2658,  2288,   434,  3334,
     564,  2943,   409,  2441,  1629,  2947,  2224,   833,   589,  3005,
    3395,  1890,   769,  3006,  2659,  1624,   461,  1799,  1370,  2933,
     114,  2392,  2243,  2394,  2895,   442,  2961,  1964,  2399,  2917,
    2378,  1628,  1379,  2501,  2502,  3458,  1379,  3460,  1787,  3161,
     410,  1630,  3045,  2906,  2417,  2029,  2419,  2420,  2424,   396,
     454, -1379,    40,   119,  1450,   455,  3007,  3476,   391,   392,
    1513,  2407,  1891,   604,   605,   606,   607,   608,   609,  1165,
    1864,   782,  1624,  2225,  2046,   386,   430,   386,  3540,   610,
    1883,   436,  1923,  1624,  3513,   440,  1920,   462,  -505,  1822,
    1629,   565,  1166,   471,  1074,  2238,  1925,  1027,   115,  1928,
    1929,  2352,   590,  3310,  1909,  1631,  1777,   488,   825,   386,
    1951,  2239,  2667,  2958,  2353,   386,  2030,  1473,  1473,  1081,
     669,  3303,  3304,  3046,  2467,  1027,  1520,  1630,  1706,  2786,
    1986,  1865,  1866,  1828,  1371,  2303,   586,  1382,  1521,   472,
    3144,  1451,  2660,   711,   712,   511,  1373,   825,  1784,  1520,
    2706,  3058,   386,  2408,   386,  1470,   386,   566,  3054,  2442,
    1800,  1521,  1816,  1463,  1464,   486,   591,  1957,   386,   386,
    2533,  2589,   809,  1474,  1824,  3184,  1632,  1112,   386,   386,
    3323,  1480,  2343,  -471,  2582,  1710,  2362,  3311,  1513,   386,
    1563,  1631,  1158,   -55, -1379,    51,  1743,   411,  1113,  3335,
    1315,   512,  3464,  1531,  1532,  1890,  2205,   941,  1907,  3347,
    1761,   386,   386,   386,   386,  2534,  1875,  3663,  2619,  2975,
     825,   386,   473,   386,  3214,  2304,  1377,  2025,  2026,   386,
    2033,  1452,  2035,  2036,  2037,  2038,  2039,  1534,  2041,  2042,
    1141,  1465,  1466,   830,  2494,  2216,  2048,  2707,  1535,  2499,
    2226,   386,  2404,  2999,  3000,  1068,  1875,  1536,   117,  2217,
     118,  3003,  1632,   825,  2507,  2049,  2702,  1106,  3026,   478,
    2433,  2512,   669,   942,  3137,  3138,  1538,   711,   712,  1489,
    2248,  2354,  3008,  1025,  1122,  1123,  2521,  2522,  2031,  3009,
     504,  1092,  1056,  2526,  1539,  2584,  1202,   386,  3131,  1522,
     386,  2531,  2591,   484,  1602,  1603,  2476,  2421,  3284,   412,
    2422,   669,  3035,   513,   943,  1785,   463,  3010,  3650,  1069,
    3036,   397,  1522,  1544,   413,  1572,  3405,  1801,  3407,   944,
    3471,  1786,  1987,  1875,  3651,  1202,  2952,   493,   464,  1876,
    2549,  3365,  1142,  1665,  1107,  1143,  1057,  2257,  1633,   386,
     414,   386,   386,   386,  2644,   386,  -264,   398,  1144,  3053,
     746,  1877,  1878,   465,   386,   415,   386,  3215,  3366,  1523,
    -537,  3322,  1935,  1529,  3489,   117,   483,   118,  1935,  3011,
    1530,  2426,  2427,  1605,   669,   450,  1112,  3169,   399,   451,
    1531,  1532,  1523,  1524,   730,  1203,  3550,  1547,   400,  2622,
     386,  2954,  2954,  2954,  1548,  1133,  1134,  1113,  1202,  3594,
    3573,   466,   494,   711,   712,   862,  1524,  2599,   497,   435,
    1533,  2428,  2995,  3573,  1534,  2996,  3151,   669,  3229,  1935,
    1972,   499,  1379,   769,  1633,  1535,  3556,   508,  1877,  1878,
     386,   711,   712,  2429,  1536,   398,  2230,  1525,  3037,  2231,
    1537,  1202,  3292,  3268,   520,  3448,   522,  3449,   523,   518,
     525,  1974,  3012,  1538,  1977,   526,  3170,   510,  1287,   555,
    1525,   572,  1549,  1989,  3598,  2430,  1879,   576,  1092,   586,
     575,  1539,  1997,   660,   780,  1145,   584,  1550,   558,   418,
    1540,  1541,   782,  1342,  1343,   679,  1542,   431,   386,  1379,
     690,  3171,   437,  1936,  1543,   691,   665,  1344,  1345,  1936,
    1544,  1291,   700,   386,  1771,  1772,  3176,  3177,  2891,  1526,
    1937,   720,  3643,  2810,  2811,  1398,  1937,   106,  1399,   797,
    1935,  1400,   913,  1938,  3187,   923,  1545,  3654,  1553,  1938,
    3191,  1554,  1526,   916,  2311,  2068,  2069,  3660,   617,   618,
     938,  3269,  3270,   945,  1761,  3271,  3272,  1518,   658,   659,
    1936,   662,  2292,  3207,  1555,  1556,  3209,  1557,  1146,   386,
    3682,   922,  3683,   940,   386,   947,   386,  1937,  2100,  2101,
     955,   386,  1546,   956,  1547,   109,  1935,   386,   970,   386,
    1938,  1548,   971,   809,   386,   386,   979,   386,   990,   673,
     674,   991,   675,  1559,   676,  2102,  2103,  1761,  1939,   386,
    2106,  2107,   386,   994,  1939,  2360,  2113,  2114,   386,   386,
     386,   386,  1834,  1834,   998,  1834,  2395,  2396,   386,   386,
     386,  2118,  2119,  1761,  3135,  1009,  1837,  1856,  1838,  1001,
     972,  2415,  2121,  2122,  2123,  2124,   386,  2418,   984,  1868,
    1010,   825, -1114,  2583,  1025,   386,  1834,  1834,  1834,  1549,
    3194,  1936,  1016,   829,   830,  1939,   995,   957,  1011,  1885,
    1886,  1887,   386,  2831,  1550,  2135,  2136,  1015,  1937,  1551,
    3370,  1334,  1030,   386,  1034,  3139,  1031,  1560,  2139,  2140,
    2324,  1938,  2328,  2333,   925,   386,  1561,  2152,  2153,  1032,
    1940,   386,  1035,  2431,  1335,  1033,  1940,  2156,  2157,  2158,
    2159,  1927,  1809,  1810,  1811,  1812,  1813,  1936,  1059,  1552,
    2166,  2167,  2169,  2170,  2588,  1553,  2178,  2179,  1554,  1945,
    2191,  2192,  2210,  2211,  1937,  2397,  1060, -1114,  1073,   529,
     530,  2371,  2324,  1075,  2212,  2213,  2887,  2670,  1083,  2051,
    1076,  1555,  1556,  2595,  1557,  1941,  1103,  1940,  2233,  2234,
     386,  1941,  2261,  2262,  1078,   746,  1939,  1104,  1558,   386,
     617,   618,  2451,  2452,  2585,  2586,  1150,  1024,  1151,   926,
    2625,  2626,  3485,  1152,   711,   712,  3380,  2710,  2711,  1154,
    1559,  1156,  3474,  1157,   958,  1024,  1158,   386,  2781,  2711,
    2838,  2839,  2842,  2843,  1162,   386,  3411,  1839,   386,  2864,
    2865,  3059,  1941,  1322,   531,   669,  1171,  3152, -1114,  1341,
    3153, -1114,  1939,  2888,  2889,  1175,  1840,  1173,  1325,  1326,
     860,  3151,  1176,  2059,  1351,  1761,   862,   927,   769,   863,
    1177,  2503,   532,  2619, -1114,  1178,  1841,  1336,  1179,  2508,
   -1114,  2970,  1107,  3031,  3032, -1114,   533,  1378,  1940,  1181,
    1842,   928,  1182, -1114,  1183,  2324,  1184,  1327, -1114,  1185,
     957,  1186,  2324,  1187,  1560, -1114,  1531,  1532,   534,  3109,
    3110,  1328,  3080,  1561,  1188, -1114,  3231,  3232,  1189,   780,
     535,  3154,  3155,  3237,  3238,  1190,  1000,   782, -1114,   669,
    1337,  1191, -1114,  3240,  3241,  1843,  1844,  1192,  -457,  -457,
    1534, -1114,  1193,  1941,  1940,  1329,  1194,  -457,  1197,   536,
    1199,  1535,  3305,  3232,  3385,  3386,  1200,  1330,  3389,  3232,
    1536,  2664,  1201,  1845,   797,  3390,  3232,  3398,  3399,  1205,
   -1114,  1206,  -537,  1207,   537,  1381,  1027,   929,  -537,  1538,
     538,  2666,  3400,  3401,  1331,   930,  2642,  3402,  3401,  3423,
    3424,  3487,  3386,  1208,  1092,  3488,  3386,  1539,  1209,  1941,
    1391,   386,  1210, -1114,  3639,  3640,  1803,  1804,  1211,  1805,
    1807,  2956,  2957,   931,  1212,  2615,  1213,  1473,  1214,   539,
    1747,  1748,  1846, -1114,  3306,  3307,  1544,   958,   809,  2920,
    2921, -1114,  2897,  2898,  3107,  3108,  1215,  1216,  1217,  1218,
    1219,  1332,  1220,  2580,  1338,  1339,  1221,  1222,  1223,   932,
    1224,  1225,  1226, -1114, -1114,  1383,  1227,  1228,  1392,  1229,
    1230,  2657,  1231,  1847,  1232,  1233,  1235,  1236,  1237,  1238,
     933,  1239,  1393,  1240,  1241,  2700,  1242, -1114,  1243,  3094,
    1244,  1248,  2703, -1114,  1249,  1250,   825,   934,  1251,   118,
    1252,  1253,  1254,  1255,  1256, -1114,  1395,  1257,   829,   830,
    1547, -1114,   386,  1413,  1258,  1259,  1261,  1548, -1114,  1263,
    1264,  1265,  1266,  1388,  1267, -1114,  1268,  1269, -1114,  1414,
     386,   386,  1270,  1271,  1272,  1273,  1274,   386,  1275,   386,
     386, -1114,   540,  1276,  1277, -1114,  1278,  1279,  1280,  1281,
    1282,  1283,  1284,  1285, -1114,  1289,  1290,  1293,  1294,  1298,
   -1114,   541,  1299,  1300,  1417,  1304,  1305,   542,  1306,  1307,
    1180,  1308,  1309,   543,  1380,  1396,   386,  1426,  1419,  1425,
    1427,  1428,  1434,  1442,  1448,  1549,  1457,   560,   386,   386,
    1477,  1461,  1482,  1483,  1484,  1485,  1487,   544,   386,  1495,
    1550,  1497,  1511,  1499,   386, -1114,  1576,   386,   545,   546,
     386,  3499,  1577,  2709,  1578,  1579, -1114,  1580, -1114, -1114,
    3133,   386,   386,  2324,   386,  1581,  1582,  1583,  1584,  1585,
     386,   386,  1586,  1587,  1588, -1114, -1114, -1114,  1589,  1590,
     386,  1591,   386,  1592, -1114,   547,   386,   386,  1593,  1594,
    1595,  1553,  1598,  1600,  1554,  1604,  1612,  1376,  1624,  1652,
     669,  1617,  3152, -1114, -1114,  3153, -1114,  1297,  2425,  1672,
   -1114,  1686,  1703,  1735,  1767,   860,  1778,  1555,  1556,  1758,
    1557,   862,  3559,  1773,   863,  1795,   386,   386,  1792,  1825,
    1815,   548,  1826,   549,  1850,  1853,  1884,  3578,  1898,  3578,
    1910,  1912,  1919,  1922,  1943,  1944,  1947,  1948, -1114,  1950,
    1958,  3042,   386,  1959,  2461,  1960,  1559,  1961,  1963,   386,
    1962,  1964,  1981,  1982,  1985,  1992,  1531,  1532, -1114,  1984,
    1761,  3352,   386,  1993,  1990,  1998,  3154,  3155,  2012,  2060,
    2064,  3578,  2077,  2066,  3633,  2073,  2067,  2071,  2074,  2075,
    2076,  2078,  3637,  2081,  3357,  3358,  3359,  3360,  -457,  -457,
    1534,  2082,  2083, -1114,  2084,  2085,  2088,  -457,   530,  2090,
    2091,  1535,   595,   530,  2092,  2110,  2093,  2094,   386,  2095,
    1536,  2096,  2223,  2097,  2098,  2228,  3578,  2104,  2105,  2108,
    2115,  2099,  2109,  2111,  2112,  2116,  2117,  3578,  2125,  1538,
    1560,  2120,  2129,  3578,  2126,  2130,  2131,  2132, -1114,  1561,
    2133,  2134,  2137,  2260,  1092,  2265,  2143,  1539,  2138,  2141,
    2142,  2144, -1114,  2266,  2147,  3578,  3578,  1339,  2145,  3696,
    2595,  2263,  2148,  2267,  2149,  2151,  -782,  2154, -1114,  2155,
   -1114,  1761,   531,  2160,  2161,  2240,  1544,   531,  2162,  2163,
    2164,  2279,  2165,  2247,  2168,  2171,  2173,  2174,  2181,  3354,
     386,  2175,  2176,  2177,  2925,  2180, -1114, -1114,  2470,  2182,
     532,  2183,  2189, -1114,  2184,   532,  2187,  2190,  2273,  2193,
    2371,  2194,  2195,  2206,   533,  2204,  1107,  2207,  2208,   533,
    2209,   386,  2214,  -958,  2277,   386,  2278,   386,   386,   386,
     386,  2264,  2275,  2283,  2295,  2296,   534,  2297,   386,  2298,
    1891,   534,   386,  1890,  2315,   386,  2316,  2317,   535,  2340,
    1547,  2341,  2344,   535,  2348,  1000,  2350,  1548,  2349,   386,
     386,   386,  2366,  2373,  2374,  2400,  1856,  2401,  2434,  2448,
    2449,  2453,   386,  2454,  1513,  1618,  2480,   536,   386,  2500,
     386,   801,   536,  1761,  2513,  2053,  2523,  2535,   386,  2536,
    2555,  3615,  2560,  2562,  2564,  2567,  2570,  2573,  2575,  2576,
     387,  2577,   537,  2578,  2587,  2594,  2579,   537,   538, -1012,
    2602,  2607,   417,   538,  1761,   423,  2609,  2613,  2629,  2621,
    2624,  2627,   432,  2640,  2641,  1549,  2646,  2654,  2665,  2671,
    2675,  2676,   443,  2679,  2691,  2692,  2705,  2771,  1761,  2774,
    1550,  2778,   459,  2780,  2782,  2785,  3615,   539,  2790,   386,
    2791,  2787,   539,  2792,  2793,  3132,  2796,  2800,  2801,  2802,
     386,  3243,  2803,   386,  2804,  2805,  2806,  2807,  1204,  1288,
    1292,  2808,  2812,  2903,  2258,  2813,  2905,  2814,  2815,  2816,
     477,  1875,  3590,  2817,  2918,  2926,  2941,  2938,  2884,  2882,
    2818,  1553,  2964,  2934,  1554,  2819,  2944,   386,  2945,  2820,
     480,   387,  2965,   387,   386,  2821,  2822,   386,  2977,  2823,
    2825,   386,   386,  2824,   477,   386,  2826,  1555,  1556,  3326,
    1557,  2827,  2828,  3193,  2829,   386,  2832,  2833,  2834,  2856,
    2835,  2836,  2837,  2840,  2841,  2713,  1120,  1121,  1122,  1123,
    1124,  1125,  2847,  2848,  1126,  1127,  1128,  1129,  1130,  1131,
    2866,  1132,  2849,  2779,  2850,  2935,  1559,  2851,  2852,  2963,
     540,  2853,  2854,  2855,  2857,   540,  2858,  3321,  2859,  2861,
    2867,  3030,  2868,  2869,  2870,  3060,  2872,  2874,  3122,   541,
    3321,  3336,  3337,  2876,   541,   542,  2877,  3062,  2973,  2878,
     542,   543,  2879,  2880,  2886,  2890,   543,  3069,  2974,  2893,
    2894,  3002,  2907,  2939,  3071,  3076,  3181,  2959,  3024,  3025,
    3027,  3089,  2311,  3050,  3064,   544,  3065,  3066,  3078,  3077,
     544,  3105,  3112,  3086,  3087,  2644,   545,   546,  3088,  3093,
    3116,   545,   546,  3110,  3118,  3119,  3123,  3124,  3127,  3129,
    1560,  2324,  3134,  3143,  3130, -1046, -1051,  3148,  3149,  1561,
    3167,  3168,  3403,  3508,  3175,  3021,  3188,  3190,  3018,  1133,
    1134,  2371,  3186,   547,  3197,  3198,  3199,  3201,   547,  3202,
    3217,  3203,  3204,  3205,  3206,  3208,  3212,  3218,  3221,  3508,
    3508,  3234,  3245,   671,  3235,  3236,  3239,  3250,  3251,   386,
     386,  3263,   386,  3242,  3264,  3265,  3276,  3244,  3246,  3285,
    3247,   386,  1000,  3291,  3248,  3294,  2054,   386,  3415,   548,
    3249,   549,  3252,  3296,   548,  3253,   549,   386,  3254,  3508,
    3508,  3255,  3256,  3257,  3508,   386,  3258,  3328,  3327,  3341,
    3349,  3300,  3259,  3261,  3356,  3288,  3350,  3289,  3342,  3508,
    3317,  3508,   386,  3363,  3318,  1353,  1354,  1355,  1356,  1357,
    3362,  3325,  3329,  3330,   386,  3331,  3332,  3377,  3508,  3238,
    3343,   386,  3344,  3346,  3379,  3382,  3408,  3508,   386,  3409,
    3410,  3435,  3384,  3437,   386,  3421,  3438,  3439,  3422,  2925,
    3440,  3425,  3426,  3508,  3427,  3446,  3508,  3451,  3453,   671,
    2452,  3461,  3462,  3459,  3508,  2444,  3463,  3469,  3473,  3470,
    3480,  3482,   671,   521,  3483,  3490,  3508,  3509,  3511,  3519,
    3520,  3543,  3542,   554,  -210,  3538,  3544,   562,  1358,  3550,
    3561,  3508,   477,  3567, -1174,  3568,  3569,   581,  3508,  3478,
    3479,  3508,  3481,  3579,  3584,  3588,  3593,  2324,  3585,  3508,
    3592,  3594,  3599,  3600,  3603,  3508,  3589,  3606,   386,   477,
    1359,  1360,  1361,  1362,  3508,  3610,  3508, -1774,  3604,  3626,
    3616,  3634,  3642,  3645,  3646,  3647,   680,  3508,  3508,  3648,
    3653,  3508,  3516,  3652,  3517,  3518,   477,  3659,  3661,  3664,
     477,  3665,  3666,  3671,  3673,  3680,   702,  3692,   477,   477,
    3697,  1531,  1532,   714,   562,  2044,  2259,  1100,  3583,  3345,
    3417,  3339,  3676,   733,  3699,  3681,  3623,   738,  3574,  3563,
    3624,  3582,   914,   387,  3228,   387,   387,   562,   477,  1597,
     509,  1517,  3301,  -457,  -457,  1534,  2465,  3052,  2011,  2971,
    2966,  1968,  -457,  2015,  2445,  2385,  1535,  2989,  3319,  3412,
    2990,  3028,  3159,  3192,  3200,  1536,  1363,   386,  1364,  1365,
    1366,   962,  3452,  2967,  2932,  3456,  3563,  3316,  1367,  3397,
    1611,  3348,  3324,  1932,  1538,  2435,  2280,   477,  1867,  1498,
     386,  1596,  2612,  2299,  2276,   562,   477,   677,  1111,  1092,
     477,  1088,  1539,  1005,  3364,   386,  3095,   477,  1889,  3096,
    3262,  1797,  3467,  2940,  2497,  3388,  1802,  1702,  1650,  2592,
    3299,  2969,  3618,  3287,  2286,  2272,  2306,  3114,  2911,  2910,
    3641,  1544,  2951,  3512,   666,   671,  1412,   562,  1168,  1430,
    1616,   739,   652,  1924,  1368,  1432,   386,  2904,  3514,  1827,
    3441,  3484,  3541,  3655,  3196,  2914,  1899,  2662,  2936,  3128,
    3290,  1861,   597,   993,  1405,  3355,  3361,  1601,   386,  2601,
     599,   671,   671,   997,   671,  3260,  1446,  1437,  1163,   692,
    1769,  2460,  3226,     0,     0,  3049,     0,     0,   386,     0,
       0,  1369,  1370,     0,     0,  1091,     0,     0,     0,     0,
       0,     0,     0,   562,     0,  1547,   477,     0,     0,  1110,
     477,     0,  1548,   386,   671,   386,   671,   671,     0,     0,
       0,     0,     0,     0,     0,   386,     0,     0,     0,     0,
       0,   386,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   477,     0,  1170,     0,     0,
       0,     0,     0,  3220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   386,     0,
    1549,     0,  3467,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1550,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   386,     0,  1371,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1372,
    1373,     0,     0,     0,     0,     0,   386,     0,     0,     0,
       0,   386,   386,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   386,  1553,     0,     0,  1554,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   386,     0,     0,     0,     0,     0,
       0,  3689,  1555,  1556,     0,  1557,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3638,     0,
       0,     0,     0,     0,  3689,  1319,     0,  1321,     0,     0,
       0,     0,   386,     0,     0,     0,     0,     0,     0,     0,
       0,  1559,     0,     0,     0,   386,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3698,     0,   477,
       0,     0,     0,     0,     0,   477,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   885,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1406,     0,  1409,     0,   477,     0,     0,     0,
       0,     0,     0,   386,     0,     0,     0,     0,   477,   562,
       0,     0,     0,     0,     0,  1560,     0,     0,   477,   477,
     964,     0,     0,     0,  1561,     0,     0,     0,     0,  1438,
       0,     0,     0,     0,     0,     0,     0,  1447,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   386,     0,     0,
       0,   387,   387,   477,   477,     0,     0,     0,     0,     0,
       0,   387,     0,   562,     0,   386,   386,     0,     0,   387,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   386,     0,   386,     0,   386,
       0,   477,     0,     0,  3431,     0,     0,     0,     0,     0,
       0,     0,   386,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   477,   386,     0,
     477,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3506,     0,     0,     0,     0,   386,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   562,
       0,   562,   387,   387,   386,   477,     0,  3506,  3506,   386,
       0,     0,     0,     0,   738,     0,  1619,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   386,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3506,  3506,     0,
    1659,     0,  3506,     0,     0,     0,     0,     0,     0,     0,
       0,  1234,     0,     0,     0,     0,     0,  3506,     0,  3506,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3506,     0,     0,     0,
    1659,     0,     0,     0,     0,  3506,     0,     0,   386,     0,
       0,     0,     0,     0,   386,     0,     0,     0,     0,     0,
       0,  3506,     0,   386,  3506,     0,     0,     0,     0,     0,
       0,     0,  3506,     0,     0,   386,     0,     0,     0,   386,
       0,     0,     0,     0,  3506,     0,  1310,     0,     0,     0,
    1317,     0,     0,     0,     0,     0,     0,     0,  1762,  3506,
       0,     0,     0,   386,     0,   386,  3506,     0,     0,  3506,
       0,   386,     0,   562,     0,     0,     0,  3506,     0,     0,
       0,     0,     0,  3506,     0,     0,     0,     0,     0,     0,
       0,     0,  3506,     0,  3506,   386,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3506,  3506,     0,     0,  3506,
       0,     0,     0,     0,     0,     0,     0,     0,   386,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   562,
       0,     0,     0,     0,  1820,     0,   562,     0,     0,     0,
       0,   562,     0,     0,     0,     0,     0,   477,     0,  1830,
       0,     0,     0,     0,  1835,  1835,     0,  1835,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   477,     0,  1445,     0,     0,     0,   562,   562,
     477,   477,     0,  1460,     0,     0,     0,     0,  1835,  1835,
    1835,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1902,     0,     0,     0,
       0,     0,     0,     0,     0,  1913,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1921,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   477,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
       0,   477,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2018,     0,     0,     0,     0,     0,     0,     0,     0,  2022,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1621,  1622,  1623,     0,     0,
       0,     0,     0,     0,  1638,  1639,     0,   387,  1642,     0,
    1644,  1645,  1646,  1647,     0,   477,     0,  1651,  2062,     0,
    1653,  1654,     0,  1655,     0,  1656,  1657,     0,  1660,  1661,
    1662,  1663,  1664,     0,  1667,     0,  1669,  1670,  1671,     0,
    1673,  1674,  1675,  1676,     0,  1678,  1679,     0,  1685,     0,
       0,  1689,  1690,  1691,     0,  1693,  1694,  1695,  1696,     0,
    1698,  1699,  1700,  1701,     0,     0,     0,     0,     0,  1708,
    1709,     0,  1712,  1713,  1714,  1715,  1716,     0,     0,     0,
       0,  1720,     0,  1721,  1722,  1723,  1724,  1725,     0,     0,
    1728,  1730,  1731,  1732,  1733,  1734,     0,  1736,  1737,     0,
       0,  1740,  1741,  1742,     0,  1745,     0,  1746,     0,     0,
       0,  1749,     0,  1753,  1754,     0,     0,     0,     0,  1757,
       0,     0,     0,     0,     1,     0,     0,  1764,  1765,  1766,
       0,     0,     0,     0,     2,     3,  1317,     0,     0,  1774,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     8,     0,     0,     0,     9,    10,
       0,  2229,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    11,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    12,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    13,     0,     0,
       0,     0,     0,     0,     0,     0,    14,    15,    16,     0,
       0,     0,  1863,     0,     0,     0,     0,     0,     0,    17,
      18,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    19,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2293,     0,     0,     0,     0,     0,     0,    20,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2312,  2314,     0,     0,     0,     0,     0,   562,     0,   562,
     562,     0,     0,    21,     0,     0,     0,     0,     0,     0,
      22,     0,     0,    23,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    24,     0,  1762,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   562,   562,
      25,     0,     0,     0,     0,     0,     0,     0,  2018,     0,
       0,     0,     0,     0,  2018,     0,     0,  2018,    26,     0,
    2018,     0,     0,    27,     0,     0,     0,     0,     0,     0,
    1529,  2018,  2018,     0,   562,     0,     0,  1530,  2023,     0,
    2018,  1762,     0,     0,     0,     0,     0,  1531,  1532,     0,
     477,     0,   562,     0,     0,     0,  2018,  2440,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1533,     0,     0,
       0,  1534,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1535,     0,     0,     0,   477,  2018,     0,     0,
       0,  1536,     0,     0,     0,     0,     0,  1537,     0,    28,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1538,     0,   562,     0,     0,     0,     0,     0,     0,   562,
       0,    29,     0,     0,     0,  1092,     0,     0,  1539,     0,
      30,     0,  2504,     0,     0,     0,     0,  1540,     0,     0,
       0,     0,     0,  1542,     0,     0,     0,     0,     0,     0,
      31,  1543,    32,    33,     0,     0,    34,  1544,     0,    35,
       0,    36,     0,     0,     0,     0,    37,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,    39,  1659,     0,
       0,    40,     0,  1545,     0,     0,     0,    41,     0,     0,
       0,     0,    42,     0,     0,     0,    43,     0,     0,     0,
    2197,  2199,  2201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    44,  2215,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1547,     0,     0,     0,     0,     0,     0,  1548,     0,
       0,     0,  2241,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
     562,     0,     0,     0,     0,  2253,     0,     0,     0,     0,
       0,     0,    47,     0,     0,    48,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2600,     0,     0,     0,  1830,     0,   962,   562,   562,
     562,     0,     0,    50,     0,     0,  1549,     0,   477,     0,
       0,     0,   562,     0,     0,  1762,     0,     0,     0,     0,
       0,  1550,     0,     0,    51,     0,  1551,     0,     0,   562,
     562,   562,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2643,     0,     0,     0,     0,     0,  2645,     0,
    2647,     0,     0,     0,     0,     0,     0,     0,   562,     0,
       0,     0,     0,     0,     0,     0,  1552,     0,     0,     0,
       0,     0,  1553,     0,     0,  1554,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1555,  1556,
       0,  1557,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1558,     0,     0,     0,  2018,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     562,     0,     0,  2018,     0,     0,     0,  1559,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   477,     0,     0,
       0,     0,     0,     0,  2712,     0,     0,   477,     0,     0,
       0,  2768,  2769,     0,     0,  2772,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   477,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2478,     0,     0,  2479,
       0,  1560,  2481,  2482,     0,     0,     0,     0,     0,     0,
    1561,     0,     0,     0,     0,  2495,     0,     0,  2498,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2505,     0,  2506,     0,     0,     0,  2509,     0,  2510,
    2511,     0,     0,     0,  2514,     0,  2515,  2516,     0,  2517,
       0,     0,  2518,     0,  2519,  2520,     0,     0,     0,     0,
    2524,  2525,     0,     0,  2527,     0,  2528,     0,  2529,     0,
    2530,     0,  2532,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2537,  2538,     0,     0,  2539,     0,  2540,
       0,     0,     0,     0,     0,     0,     0,  2541,  2542,     0,
    2543,     0,  2544,     0,     0,  2545,  2546,  2547,     0,  2548,
       0,     0,     0,     0,  2551,  2552,  2553,  2554,     0,     0,
       0,     0,  2556,  2557,  2558,     0,  2559,     0,  2561,     0,
    2563,     0,  2565,     0,  2566,     0,     0,     0,     0,  2293,
    2915,  2568,   562,  2569,     0,     0,  2571,  2572,     0,     0,
       0,   562,     0,     0,     0,     0,     0,  2600,  2581,     0,
       0,     0,     0,     0,     0,     0,     0,   562,     0,     0,
       0,     0,     0,     0,     0,  1902,     0,  2590,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1762,     0,     0,     0,     0,     0,     0,  2608,
       0,     0,     0,     0,  2018,     0,     0,     0,     0,     0,
       0,  2018,     2,     3,     0,     0,     0,     0,  1762,     0,
       0,     0,     0,     0,  2018,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,  2652,     0,
       0,     0,     8,  2656,     0,     0,     9,    10,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    11,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    12,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2687,  3057,     0,
       0,     0,     0,     0,     0,    13,     0,     0,     0,     0,
       0,  2690,     0,     0,    14,    15,    16,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    17,    18,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      19,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    20,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,  3092,    22,     0,
       0,    23,     0,     0,     0,     0,     0,  2789,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1762,     0,    24,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   562,     0,     0,    25,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    26,     0,     0,     0,
       0,    27,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3057,     0,     0,     0,
    2860,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2871,     0,  2873,     0,  2875,     0,     0,     0,   562,     0,
    2881,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   562,     0,
       0,     0,     0,     0,     0,  2892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3210,     0,  3211,     0,    28,     0,     0,
       0,     0,     0,     0,     0,   477,     0,     0,     0,     0,
       0,  3225,     0,     0,     0,     0,     0,     0,     0,    29,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2937,     0,     0,     0,     0,    31,     0,
      32,    33,     0,     0,    34,     0,     0,    35,  2312,    36,
       0,     0,     0,     0,    37,     0,    38,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,    40,
       0,     0,     0,     0,     0,    41,   562,     0,     0,     0,
      42,     0,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3298,     0,     0,     0,
       0,  3057,  3057,     0,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,  3315,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,     0,     0,     0,     0,    49,     0,
       0,     0,  3340,     0,     0,     0,     0,     0,  3063,     0,
       0,     0,     0,     0,     0,  3057,     0,     0,  3067,     0,
       0,    50,     0,     0,  3068,     0,     0,     0,     0,     0,
       0,     0,     0,  3072,  3073,     0,     0,     0,     0,  3074,
       0,     0,    51,  3075,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3079,     0,     0,     0,
       0,     0,  3081,     0,     0,  3082,  3083,     0,  3084,  3085,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3090,  2022,     0,  2714,  2715,     0,     0,     0,
       0,  2716,     0,  2717,     0,  2718,  2719,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2720,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3225,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1762,   477,     0,  3141,  3142,
       0,  2721,     0,     0,  2722,     0,     0,     0,     0,  2687,
       0,     0,  2723,     0,     0,  3298,     0,  3298,     0,  3450,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2724,  3457,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2725,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3477,  2726,
       0,  2727,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2728,  2729,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1762,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3521,     0,     0,     0,     0,  3528,
       0,  2730,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3545,     0,     0,
    2731,     0,     0,     0,     0,     0,     0,     0,  2687,  2732,
    2733,     0,  2734,     0,     0,     0,     0,     0,     0,     0,
       0,  2652,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2735,  2736,  2737,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1762,     0,
       0,  2738,  2739,  2740,  3620,     0,     0,  2741,     0,     0,
    2742,     0,     0,  3631,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2743,  2744,   562,     0,     0,     0,  1762,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2745,
       0,  2746,     0,  1762,     0,  3656,     0,     0,     0,     0,
       0,  3662,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3351,     0,     0,     0,  2747,     0,  3353,     0,     0,
       0,     0,     0,     0,     0,  3690,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3690,     0,
       0,     0,     0,  3369,     0,     0,     0,     0,  2748,     0,
    2749,     0,     0,  3381,     0,  3383,     0,     0,     0,     0,
    2750,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2751,  2752,     0,     0,  2753,  2754,
    2755,  2756,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2687,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2757,  2758,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2759,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3472,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3486,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3548,
    3549,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3570,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3581,     0,     0,
       0,     0,     0,  3587,     0,     0,     0,     0,     0,     0,
       0,     0,  3597,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   122,     0,   740,   124,
     125,   126,   127,     0,     0,  3635,     0,     0,   128,     0,
       0,   741,     0,   742,   130,   131,   743,   133,     0,   134,
     744,   135,  3644,   745,   136,   746,   747,   748,   137,   749,
       0,   138,   139,   140,  1750,   141,     0,   142,   143,     0,
       0,   144,   750,   145,     0,   146,   751,   752,   148,     0,
     149,   150,   151,   753,   152,     0,   754,   154,     0,   155,
     156,   157,   158,   159,   755,   756,   160,     0,     0,   161,
       0,   757,   163,  3691,   758,   759,   760,   164,     0,     0,
     165,   761,   762,     0,   763,   764,     0,   166,   167,   765,
     766,   767,     0,     0,     0,     0,   768,   170,   769,     0,
       0,   770,   771,   171,     0,   172,     0,     0,     0,   772,
     773,   173,     0,   174,   175,   176,     0,     0,     0,   177,
       0,     0,   178,   179,   180,     0,     0,   774,   181,     0,
     775,   776,   182,   183,   184,   185,     0,     0,   186,     0,
     187,   188,   189,   777,     0,   190,   778,   191,   779,   780,
     192,   193,     0,   781,   194,   195,   196,   782,     0,   197,
       0,     0,   783,     0,   198,   199,     0,   784,   200,     0,
     201,   785,   786,   787,   788,     0,   789,   790,   203,   791,
     792,   793,   205,     0,   206,   794,     0,   795,   796,     0,
     207,   208,     0,   209,   797,     0,   210,     0,     0,     0,
     798,   212,   213,   214,   799,     0,   215,   216,     0,     0,
       0,   217,     0,     0,   800,   218,   801,     0,     0,   219,
       0,   220,   221,     0,   222,   223,     0,     0,     0,     0,
       0,     0,   224,   802,   225,     0,  1751,   803,   226,     0,
     804,   227,     0,     0,     0,   805,     0,   806,     0,   229,
     807,     0,   230,     0,   231,   808,     0,     0,   809,     0,
       0,     0,     0,   810,   232,   233,   234,   235,   236,   237,
     811,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     812,   247,   248,   249,   813,   250,   251,     0,     0,     0,
     252,   253,   254,   814,   256,     0,     0,   815,   258,   816,
     817,   259,     0,   260,   818,   819,   820,   821,   822,   823,
     824,   265,   266,   267,   268,     0,   825,   269,   270,     0,
     271,   272,   273,   826,   827,   828,   274,     0,   829,   830,
       0,   275,   276,     0,   831,     0,   278,   279,   280,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   281,
     282,   283,   832,   833,   285,   834,   835,   836,   837,   838,
       0,   288,   289,     0,   290,     0,   291,   292,   293,   294,
       0,   839,   296,   297,   298,   299,   300,   301,   302,   840,
       0,     0,     0,   303,   304,     0,     0,   305,   306,   307,
       0,   308,     0,   309,   310,   841,   842,   311,     0,   312,
     313,   314,     0,   315,   316,     0,     0,   843,   317,   318,
     844,   319,   320,   845,   321,   846,   323,   324,     0,   847,
     326,     0,     0,     0,   327,   328,   329,     0,     0,   330,
       0,     0,     0,   331,   332,   333,   334,     0,   335,   336,
     337,     0,     0,     0,     0,     0,     0,   338,   339,     0,
     340,     0,     0,   341,     0,     0,   342,   343,   848,   849,
     344,   345,     0,   346,   850,   348,   851,   852,   853,   349,
     350,   351,   352,   854,   353,   354,     0,   355,   356,     0,
     669,   357,   855,   856,   857,   858,     0,     0,     0,     0,
    1752,   362,     0,   363,   859,   860,   861,   365,   366,   367,
       0,   862,   368,   369,   863,     0,   370,     0,     0,   864,
     865,   371,     0,     0,   372,     0,   373,     0,   866,   375,
       0,     0,   867,   868,   869,   870,   871,   376,     0,     0,
     377,   872,     0,   378,   379,   873,     0,     0,     0,     0,
     381,     0,   382,   383,     0,   874,     0,   875,     0,     0,
       0,     0,   876,     0,     0,     0,   877,   878,     0,     0,
       0,     0,   879,     0,   880,     0,     0,   881,   882,     0,
     883,   884,   122,     0,   740,   124,   125,   126,   127,  2648,
       0,     0,     0,     0,   128,     0,     0,   741,     0,   742,
     130,   131,   743,   133,     0,   134,   744,   135,     0,  2649,
     136,   746,   747,   748,   137,   749,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   750,   145,
       0,   146,   751,   752,   148,     0,   149,   150,   151,   753,
     152,     0,   754,   154,     0,   155,   156,   157,   158,   159,
     755,   756,   160,     0,     0,   161,     0,   757,   163,     0,
     758,   759,   760,   164,     0,     0,   165,   761,   762,     0,
     763,   764,     0,   166,   167,   765,   766,   767,     0,     0,
       0,     0,   768,   170,   769,     0,     0,   770,  2650,   171,
       0,   172,     0,     0,     0,   772,   773,   173,     0,   174,
     175,   176,     0,     0,     0,   177,     0,     0,   178,   179,
     180,     0,     0,   774,   181,     0,   775,   776,   182,   183,
     184,   185,     0,     0,   186,     0,   187,   188,   189,   777,
       0,   190,   778,   191,   779,   780,   192,   193,     0,   781,
     194,   195,   196,   782,     0,   197,     0,     0,   783,     0,
     198,   199,     0,   784,   200,     0,   201,   785,   786,   787,
     788,     0,   789,   790,   203,   791,   792,   793,   205,     0,
     206,   794,     0,   795,   796,     0,   207,   208,     0,   209,
     797,     0,   210,     0,     0,     0,   798,   212,   213,   214,
     799,     0,   215,   216,     0,     0,     0,   217,     0,     0,
     800,   218,   801,     0,     0,   219,     0,   220,   221,     0,
     222,   223,     0,     0,     0,     0,     0,     0,   224,   802,
     225,     0,     0,   803,   226,     0,   804,   227,     0,     0,
       0,   805,     0,   806,     0,   229,   807,     0,   230,     0,
     231,   808,     0,     0,   809,     0,     0,     0,     0,   810,
     232,   233,   234,   235,   236,   237,   811,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   812,   247,   248,   249,
     813,   250,   251,     0,     0,     0,   252,   253,   254,   814,
     256,     0,     0,   815,   258,   816,   817,   259,     0,   260,
     818,   819,   820,   821,   822,   823,   824,   265,   266,   267,
     268,     0,   825,   269,   270,     0,   271,   272,   273,   826,
     827,   828,   274,     0,   829,   830,     0,   275,   276,     0,
     831,  2651,   278,   279,   280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   281,   282,   283,   832,   833,
     285,   834,   835,   836,   837,   838,     0,   288,   289,     0,
     290,     0,   291,   292,   293,   294,     0,   839,   296,   297,
     298,   299,   300,   301,   302,   840,     0,     0,     0,   303,
     304,     0,     0,   305,   306,   307,     0,   308,     0,   309,
     310,   841,   842,   311,     0,   312,   313,   314,     0,   315,
     316,     0,     0,   843,   317,   318,   844,   319,   320,   845,
     321,   846,   323,   324,     0,   847,   326,     0,     0,     0,
     327,   328,   329,     0,     0,   330,     0,     0,     0,   331,
     332,   333,   334,     0,   335,   336,   337,     0,     0,     0,
       0,     0,     0,   338,   339,     0,   340,     0,     0,   341,
       0,     0,   342,   343,   848,   849,   344,   345,     0,   346,
     850,   348,   851,   852,   853,   349,   350,   351,   352,   854,
     353,   354,     0,   355,   356,     0,   669,   357,   855,   856,
     857,   858,     0,     0,     0,     0,     0,   362,     0,   363,
     859,   860,   861,   365,   366,   367,     0,   862,   368,   369,
     863,     0,   370,     0,     0,   864,   865,   371,     0,     0,
     372,     0,   373,     0,   866,   375,     0,     0,   867,   868,
     869,   870,   871,   376,     0,     0,   377,   872,     0,   378,
     379,   873,     0,     0,     0,     0,   381,     0,   382,   383,
       0,   874,     0,   875,     0,     0,     0,     0,   876,     0,
       0,     0,   877,   878,     0,     0,     0,     0,   879,     0,
     880,     0,     0,   881,   882,     0,   883,   884,   122,     0,
     740,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   741,     0,   742,   130,   131,   743,   133,
       0,   134,   744,   135,     0,   745,   136,   746,   747,   748,
     137,   749,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   750,   145,     0,   146,   751,   752,
     148,     0,   149,   150,   151,   753,   152,     0,   754,   154,
       0,   155,   156,   157,   158,   159,   755,   756,   160,     0,
       0,   161,     0,   757,   163,     0,   758,   759,   760,   164,
       0,     0,   165,   761,   762,     0,   763,   764,     0,   166,
     167,   765,   766,   767,     0,     0,     0,     0,   768,   170,
     769,     0,     0,   770,   771,   171,     0,   172,     0,     0,
       0,   772,   773,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,   774,
     181,     0,   775,   776,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,   777,     0,   190,   778,   191,
     779,   780,   192,   193,     0,   781,   194,   195,   196,   782,
       0,   197,     0,     0,   783,     0,   198,   199,     0,   784,
     200,     0,   201,   785,   786,   787,   788,     0,   789,   790,
     203,   791,   792,   793,   205,     0,   206,   794,     0,   795,
     796,     0,   207,   208,     0,   209,   797,     0,   210,     0,
       0,     0,   798,   212,   213,   214,   799,     0,   215,   216,
       0,     0,     0,   217,     0,     0,   800,   218,   801,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,   802,   225,     0,     0,   803,
     226,     0,   804,   227,     0,     0,     0,   805,     0,   806,
       0,   229,   807,     0,   230,     0,   231,   808,     0,     0,
     809,     0,     0,     0,     0,   810,   232,   233,   234,   235,
     236,   237,   811,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   812,   247,   248,   249,   813,   250,   251,     0,
       0,     0,   252,   253,   254,   814,   256,     0,     0,   815,
     258,   816,   817,   259,     0,   260,   818,   819,   820,   821,
     822,   823,   824,   265,   266,   267,   268,     0,   825,   269,
     270,     0,   271,   272,   273,   826,   827,   828,   274,     0,
     829,   830,     0,   275,   276,     0,   831,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   832,   833,   285,   834,   835,   836,
     837,   838,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   839,   296,   297,   298,   299,   300,   301,
     302,   840,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,   841,   842,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,   843,
     317,   318,   844,   319,   320,   845,   321,   846,   323,   324,
       0,   847,   326,  1315,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
     848,   849,   344,   345,     0,   346,   850,   348,   851,   852,
     853,   349,   350,   351,   352,   854,   353,   354,     0,   355,
     356,     0,   669,   357,   855,   856,   857,   858,     0,     0,
       0,     0,     0,   362,     0,   363,   859,   860,   861,   365,
     366,   367,     0,   862,   368,   369,   863,     0,   370,     0,
       0,   864,   865,   371,     0,     0,   372,     0,   373,     0,
     866,   375,     0,     0,   867,   868,   869,   870,   871,   376,
       0,     0,   377,   872,     0,   378,   379,   873,     0,     0,
       0,     0,   381,     0,   382,   383,     0,   874,     0,   875,
       0,     0,     0,     0,   876,     0,     0,     0,   877,   878,
       0,     0,     0,     0,   879,     0,  1316,     0,     0,   881,
     882,     0,   883,   884,   122,     0,   740,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   741,
       0,   742,   130,   131,   743,   133,     0,   134,   744,   135,
       0,   745,   136,   746,   747,   748,   137,   749,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     750,   145,     0,   146,   751,   752,   148,     0,   149,   150,
     151,   753,   152,     0,   754,   154,     0,   155,   156,   157,
     158,   159,   755,   756,   160,     0,     0,   161,     0,   757,
     163,     0,   758,   759,   760,   164,     0,     0,   165,   761,
     762,     0,   763,   764,     0,   166,   167,   765,   766,   767,
       0,     0,     0,     0,   768,   170,   769,     0,     0,   770,
     771,   171,     0,   172,     0,     0,     0,   772,   773,   173,
       0,   174,   175,   176,     0,     0,     0,   177,     0,     0,
     178,   179,   180,     0,     0,   774,   181,     0,   775,   776,
     182,   183,   184,   185,     0,     0,   186,     0,   187,   188,
     189,   777,     0,   190,   778,   191,   779,   780,   192,   193,
       0,   781,   194,   195,   196,   782,     0,   197,     0,     0,
     783,     0,   198,   199,     0,   784,   200,     0,   201,   785,
     786,   787,   788,     0,   789,   790,   203,   791,   792,   793,
     205,     0,   206,   794,     0,   795,   796,     0,   207,   208,
       0,   209,   797,     0,   210,     0,     0,     0,   798,   212,
     213,   214,   799,     0,   215,   216,     0,     0,     0,   217,
       0,     0,   800,   218,   801,     0,     0,   219,     0,   220,
     221,     0,   222,   223,     0,     0,     0,     0,     0,     0,
     224,   802,   225,     0,     0,   803,   226,     0,   804,   227,
       0,     0,     0,   805,     0,   806,     0,   229,   807,     0,
     230,     0,   231,   808,     0,     0,   809,     0,     0,     0,
       0,   810,   232,   233,   234,   235,   236,   237,   811,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   812,   247,
     248,   249,   813,   250,   251,     0,     0,     0,   252,   253,
     254,   814,   256,     0,     0,   815,   258,   816,   817,   259,
       0,   260,   818,   819,   820,   821,   822,   823,   824,   265,
     266,   267,   268,     0,   825,   269,   270,     0,   271,   272,
     273,   826,   827,   828,   274,     0,   829,   830,     0,   275,
     276,     0,   831,     0,   278,   279,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   281,   282,   283,
     832,   833,   285,   834,   835,   836,   837,   838,     0,   288,
     289,     0,   290,     0,   291,   292,   293,   294,     0,   839,
     296,   297,   298,   299,   300,   301,   302,   840,     0,     0,
       0,   303,   304,     0,     0,   305,   306,   307,     0,   308,
       0,   309,   310,   841,   842,   311,     0,   312,   313,   314,
       0,   315,   316,     0,     0,   843,   317,   318,   844,   319,
     320,   845,   321,   846,   323,   324,     0,   847,   326,     0,
       0,     0,   327,   328,   329,     0,     0,   330,     0,     0,
       0,   331,   332,   333,   334,     0,   335,   336,   337,     0,
       0,     0,     0,     0,     0,   338,   339,     0,   340,     0,
       0,   341,     0,     0,   342,   343,   848,   849,   344,   345,
       0,   346,   850,   348,   851,   852,   853,   349,   350,   351,
     352,   854,   353,   354,     0,   355,   356,     0,   669,   357,
     855,   856,   857,   858,     0,     0,     0,     0,     0,   362,
       0,   363,   859,   860,   861,   365,   366,   367,     0,   862,
     368,   369,   863,     0,   370,     0,     0,   864,   865,   371,
       0,     0,   372,     0,   373,     0,   866,   375,     0,     0,
     867,   868,   869,   870,   871,   376,     0,     0,   377,   872,
       0,   378,   379,   873,     0,     0,     0,     0,   381,     0,
     382,   383,     0,   874,     0,   875,     0,     0,     0,     0,
     876,     0,     0,     0,   877,   878,     0,     0,     0,     0,
     879,     0,   880,  1598,     0,   881,   882,     0,   883,   884,
     122,     0,   740,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   741,     0,   742,   130,   131,
     743,   133,     0,   134,   744,   135,     0,   745,   136,   746,
     747,   748,   137,   749,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   750,   145,     0,   146,
     751,   752,   148,     0,   149,   150,   151,   753,   152,     0,
     754,   154,     0,   155,   156,   157,   158,   159,   755,   756,
     160,     0,     0,   161,     0,   757,   163,     0,   758,   759,
     760,   164,     0,     0,   165,   761,   762,     0,   763,   764,
       0,   166,   167,   765,   766,   767,     0,     0,     0,     0,
     768,   170,   769,     0,     0,   770,   771,   171,     0,   172,
       0,     0,     0,   772,   773,   173,     0,   174,   175,   176,
       0,     0,     0,   177,     0,     0,   178,   179,   180,     0,
       0,   774,   181,     0,   775,   776,   182,   183,   184,   185,
       0,     0,   186,     0,   187,   188,   189,   777,     0,   190,
     778,   191,   779,   780,   192,   193,     0,   781,   194,   195,
     196,   782,     0,   197,     0,     0,   783,     0,   198,   199,
       0,   784,   200,     0,   201,   785,   786,   787,   788,     0,
     789,   790,   203,   791,   792,   793,   205,     0,   206,   794,
       0,   795,   796,     0,   207,   208,     0,   209,   797,     0,
     210,     0,     0,     0,   798,   212,   213,   214,   799,     0,
     215,   216,     0,     0,     0,   217,     0,     0,   800,   218,
     801,     0,     0,   219,     0,   220,   221,     0,   222,   223,
       0,     0,     0,     0,     0,     0,   224,   802,   225,     0,
       0,   803,   226,     0,   804,   227,     0,     0,     0,   805,
       0,   806,     0,   229,   807,     0,   230,     0,   231,   808,
       0,     0,   809,     0,     0,     0,     0,   810,   232,   233,
     234,   235,   236,   237,   811,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   812,   247,   248,   249,   813,   250,
     251,     0,     0,     0,   252,   253,   254,   814,   256,     0,
       0,   815,   258,   816,   817,   259,     0,   260,   818,   819,
     820,   821,   822,   823,   824,   265,   266,   267,   268,     0,
     825,   269,   270,     0,   271,   272,   273,   826,   827,   828,
     274,     0,   829,   830,     0,   275,   276,     0,   831,     0,
     278,   279,   280,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   281,   282,   283,   832,   833,   285,   834,
     835,   836,   837,   838,     0,   288,   289,     0,   290,     0,
     291,   292,   293,   294,     0,   839,   296,   297,   298,   299,
     300,   301,   302,   840,     0,     0,     0,   303,   304,     0,
       0,   305,   306,   307,     0,   308,     0,   309,   310,   841,
     842,   311,     0,   312,   313,   314,     0,   315,   316,     0,
       0,   843,   317,   318,   844,   319,   320,   845,   321,   846,
     323,   324,     0,   847,   326,     0,     0,     0,   327,   328,
     329,     0,     0,   330,     0,     0,     0,   331,   332,   333,
     334,     0,   335,   336,   337,     0,     0,     0,     0,     0,
       0,   338,   339,     0,   340,     0,     0,   341,     0,     0,
     342,   343,   848,   849,   344,   345,     0,   346,   850,   348,
     851,   852,   853,   349,   350,   351,   352,   854,   353,   354,
       0,   355,   356,     0,   669,   357,   855,   856,   857,   858,
       0,     0,     0,     0,     0,   362,     0,   363,   859,   860,
     861,   365,   366,   367,     0,   862,   368,   369,   863,     0,
     370,     0,     0,   864,   865,   371,     0,     0,   372,     0,
     373,     0,   866,   375,     0,     0,   867,   868,   869,   870,
     871,   376,     0,     0,   377,   872,     0,   378,   379,   873,
       0,     0,     0,     0,   381,     0,   382,   383,     0,   874,
       0,   875,     0,     0,     0,     0,   876,     0,     0,     0,
     877,   878,     0,     0,     0,     0,   879,     0,   880,  1692,
       0,   881,   882,     0,   883,   884,   122,     0,   740,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   741,     0,   742,   130,   131,   743,   133,     0,   134,
     744,   135,     0,   745,   136,   746,   747,   748,   137,   749,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   750,   145,     0,   146,   751,   752,   148,     0,
     149,   150,   151,   753,   152,     0,   754,   154,     0,   155,
     156,   157,   158,   159,   755,   756,   160,     0,     0,   161,
       0,   757,   163,     0,   758,   759,   760,   164,     0,     0,
     165,   761,   762,     0,   763,   764,     0,   166,   167,   765,
     766,   767,     0,     0,     0,     0,   768,   170,   769,     0,
       0,   770,   771,   171,     0,   172,     0,     0,     0,   772,
     773,   173,     0,   174,   175,   176,     0,     0,     0,   177,
       0,     0,   178,   179,   180,     0,     0,   774,   181,     0,
     775,   776,   182,   183,   184,   185,     0,     0,   186,     0,
     187,   188,   189,   777,     0,   190,   778,   191,   779,   780,
     192,   193,     0,   781,   194,   195,   196,   782,     0,   197,
       0,     0,   783,     0,   198,   199,     0,   784,   200,     0,
     201,   785,   786,   787,   788,     0,   789,   790,   203,   791,
     792,   793,   205,     0,   206,   794,     0,   795,   796,     0,
     207,   208,     0,   209,   797,     0,   210,     0,     0,     0,
     798,   212,   213,   214,   799,     0,   215,   216,     0,     0,
       0,   217,     0,     0,   800,   218,   801,     0,     0,   219,
       0,   220,   221,     0,   222,   223,     0,     0,     0,     0,
       0,     0,   224,   802,   225,     0,     0,   803,   226,     0,
     804,   227,     0,     0,     0,   805,     0,   806,     0,   229,
     807,     0,   230,     0,   231,   808,     0,     0,   809,     0,
       0,     0,     0,   810,   232,   233,   234,   235,   236,   237,
     811,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     812,   247,   248,   249,   813,   250,   251,     0,     0,     0,
     252,   253,   254,   814,   256,     0,     0,   815,   258,   816,
     817,   259,     0,   260,   818,   819,   820,   821,   822,   823,
     824,   265,   266,   267,   268,     0,   825,   269,   270,     0,
     271,   272,   273,   826,   827,   828,   274,     0,   829,   830,
       0,   275,   276,     0,   831,     0,   278,   279,   280,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   281,
     282,   283,   832,   833,   285,   834,   835,   836,   837,   838,
       0,   288,   289,     0,   290,     0,   291,   292,   293,   294,
       0,   839,   296,   297,   298,   299,   300,   301,   302,   840,
       0,     0,     0,   303,   304,     0,     0,   305,   306,   307,
       0,   308,     0,   309,   310,   841,   842,   311,     0,   312,
     313,   314,     0,   315,   316,     0,     0,   843,   317,   318,
     844,   319,   320,   845,   321,   846,   323,   324,     0,   847,
     326,     0,     0,     0,   327,   328,   329,     0,     0,   330,
       0,     0,     0,   331,   332,   333,   334,     0,   335,   336,
     337,     0,     0,     0,     0,     0,     0,   338,   339,     0,
     340,     0,     0,   341,     0,     0,   342,   343,   848,   849,
     344,   345,     0,   346,   850,   348,   851,   852,   853,   349,
     350,   351,   352,   854,   353,   354,     0,   355,   356,     0,
     669,   357,   855,   856,   857,   858,     0,     0,     0,     0,
       0,   362,     0,   363,   859,   860,   861,   365,   366,   367,
       0,   862,   368,   369,   863,     0,   370,     0,     0,   864,
     865,   371,     0,     0,   372,     0,   373,     0,   866,   375,
       0,     0,   867,   868,   869,   870,   871,   376,     0,     0,
     377,   872,     0,   378,   379,   873,     0,     0,     0,     0,
     381,     0,   382,   383,     0,   874,     0,   875,     0,     0,
       0,     0,   876,     0,     0,     0,   877,   878,     0,     0,
       0,     0,   879,     0,   880,  1729,     0,   881,   882,     0,
     883,   884,   122,     0,   740,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   741,     0,   742,
     130,   131,   743,   133,     0,   134,   744,   135,     0,   745,
     136,   746,   747,   748,   137,   749,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   750,   145,
       0,   146,   751,   752,   148,     0,   149,   150,   151,   753,
     152,     0,   754,   154,     0,   155,   156,   157,   158,   159,
     755,   756,   160,     0,     0,   161,     0,   757,   163,     0,
     758,   759,   760,   164,     0,     0,   165,   761,   762,     0,
     763,   764,     0,   166,   167,   765,   766,   767,     0,     0,
       0,     0,   768,   170,   769,     0,     0,   770,   771,   171,
       0,   172,     0,     0,     0,   772,   773,   173,     0,   174,
     175,   176,     0,     0,     0,   177,     0,     0,   178,   179,
     180,     0,     0,   774,   181,     0,   775,   776,   182,   183,
     184,   185,     0,     0,   186,     0,   187,   188,   189,   777,
       0,   190,   778,   191,   779,   780,   192,   193,     0,   781,
     194,   195,   196,   782,     0,   197,     0,     0,   783,     0,
     198,   199,     0,   784,   200,     0,   201,   785,   786,   787,
     788,     0,   789,   790,   203,   791,   792,   793,   205,     0,
     206,   794,     0,   795,   796,     0,   207,   208,     0,   209,
     797,     0,   210,     0,     0,     0,   798,   212,   213,   214,
     799,     0,   215,   216,     0,     0,     0,   217,     0,     0,
     800,   218,   801,     0,     0,   219,     0,   220,   221,     0,
     222,   223,     0,     0,     0,     0,     0,     0,   224,   802,
     225,     0,     0,   803,   226,     0,   804,   227,     0,     0,
       0,   805,     0,   806,     0,   229,   807,     0,   230,     0,
     231,   808,     0,     0,   809,     0,     0,     0,     0,   810,
     232,   233,   234,   235,   236,   237,   811,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   812,   247,   248,   249,
     813,   250,   251,     0,     0,     0,   252,   253,   254,   814,
     256,     0,     0,   815,   258,   816,   817,   259,     0,   260,
     818,   819,   820,   821,   822,   823,   824,   265,   266,   267,
     268,     0,   825,   269,   270,     0,   271,   272,   273,   826,
     827,   828,   274,     0,   829,   830,     0,   275,   276,     0,
     831,     0,   278,   279,   280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   281,   282,   283,   832,   833,
     285,   834,   835,   836,   837,   838,     0,   288,   289,     0,
     290,     0,   291,   292,   293,   294,     0,   839,   296,   297,
     298,   299,   300,   301,   302,   840,     0,     0,     0,   303,
     304,     0,     0,   305,   306,   307,     0,   308,     0,   309,
     310,   841,   842,   311,     0,   312,   313,   314,     0,   315,
     316,     0,     0,   843,   317,   318,   844,   319,   320,   845,
     321,   846,   323,   324,     0,   847,   326,     0,     0,     0,
     327,   328,   329,     0,     0,   330,     0,     0,     0,   331,
     332,   333,   334,     0,   335,   336,   337,     0,     0,     0,
       0,     0,     0,   338,   339,     0,   340,     0,     0,   341,
       0,     0,   342,   343,   848,   849,   344,   345,     0,   346,
     850,   348,   851,   852,   853,   349,   350,   351,   352,   854,
     353,   354,     0,   355,   356,     0,   669,   357,   855,   856,
     857,   858,     0,     0,     0,     0,     0,   362,     0,   363,
     859,   860,   861,   365,   366,   367,     0,   862,   368,   369,
     863,     0,   370,     0,     0,   864,   865,   371,     0,     0,
     372,     0,   373,     0,   866,   375,     0,     0,   867,   868,
     869,   870,   871,   376,     0,     0,   377,   872,     0,   378,
     379,   873,     0,     0,     0,     0,   381,     0,   382,   383,
       0,   874,     0,   875,     0,     0,     0,     0,   876,     0,
       0,     0,   877,   878,     0,     0,     0,     0,   879,     0,
     880,  1756,     0,   881,   882,     0,   883,   884,   122,     0,
     740,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   741,     0,   742,   130,   131,   743,   133,
       0,   134,   744,   135,     0,   745,   136,   746,   747,   748,
     137,   749,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   750,   145,     0,   146,   751,   752,
     148,     0,   149,   150,   151,   753,   152,     0,   754,   154,
       0,   155,   156,   157,   158,   159,   755,   756,   160,     0,
       0,   161,     0,   757,   163,     0,   758,   759,   760,   164,
       0,     0,   165,   761,   762,     0,   763,   764,     0,   166,
     167,   765,   766,   767,     0,     0,     0,     0,   768,   170,
     769,     0,     0,   770,   771,   171,     0,   172,     0,     0,
       0,   772,   773,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,   774,
     181,     0,   775,   776,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,   777,     0,   190,   778,   191,
     779,   780,   192,   193,     0,   781,   194,   195,   196,   782,
       0,   197,     0,     0,   783,     0,   198,   199,  2196,   784,
     200,     0,   201,   785,   786,   787,   788,     0,   789,   790,
     203,   791,   792,   793,   205,     0,   206,   794,     0,   795,
     796,     0,   207,   208,     0,   209,   797,     0,   210,     0,
       0,     0,   798,   212,   213,   214,   799,     0,   215,   216,
       0,     0,     0,   217,     0,     0,   800,   218,   801,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,   802,   225,     0,     0,   803,
     226,     0,   804,   227,     0,     0,     0,   805,     0,   806,
       0,   229,   807,     0,   230,     0,   231,   808,     0,     0,
     809,     0,     0,     0,     0,   810,   232,   233,   234,   235,
     236,   237,   811,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   812,   247,   248,   249,   813,   250,   251,     0,
       0,     0,   252,   253,   254,   814,   256,     0,     0,   815,
     258,   816,   817,   259,     0,   260,   818,   819,   820,   821,
     822,   823,   824,   265,   266,   267,   268,     0,   825,   269,
     270,     0,   271,   272,   273,   826,   827,   828,   274,     0,
     829,   830,     0,   275,   276,     0,   831,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   832,   833,   285,   834,   835,   836,
     837,   838,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   839,   296,   297,   298,   299,   300,   301,
     302,   840,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,   841,   842,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,   843,
     317,   318,   844,   319,   320,   845,   321,   846,   323,   324,
       0,   847,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
     848,   849,   344,   345,     0,   346,   850,   348,   851,   852,
     853,   349,   350,   351,   352,   854,   353,   354,     0,   355,
     356,     0,   669,   357,   855,   856,   857,   858,     0,     0,
       0,     0,     0,   362,     0,   363,   859,   860,   861,   365,
     366,   367,     0,   862,   368,   369,   863,     0,   370,     0,
       0,   864,   865,   371,     0,     0,   372,     0,   373,     0,
     866,   375,     0,     0,   867,   868,   869,   870,   871,   376,
       0,     0,   377,   872,     0,   378,   379,   873,     0,     0,
       0,     0,   381,     0,   382,   383,     0,   874,     0,   875,
       0,     0,     0,     0,   876,     0,     0,     0,   877,   878,
       0,     0,     0,     0,   879,     0,   880,     0,     0,   881,
     882,     0,   883,   884,   122,     0,   740,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   741,
       0,   742,   130,   131,   743,   133,     0,   134,   744,   135,
       0,   745,   136,   746,   747,   748,   137,   749,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     750,   145,     0,   146,   751,   752,   148,     0,   149,   150,
     151,   753,   152,     0,   754,   154,     0,   155,   156,   157,
     158,   159,   755,   756,   160,     0,     0,   161,     0,   757,
     163,     0,   758,   759,   760,   164,     0,     0,   165,   761,
     762,     0,   763,   764,     0,   166,   167,   765,   766,   767,
       0,     0,     0,     0,   768,   170,   769,     0,     0,   770,
     771,   171,     0,   172,     0,     0,     0,   772,   773,   173,
       0,   174,   175,   176,     0,     0,     0,   177,     0,     0,
     178,   179,   180,     0,     0,   774,   181,     0,   775,   776,
     182,   183,   184,   185,     0,     0,   186,     0,   187,   188,
     189,   777,     0,   190,   778,   191,   779,   780,   192,   193,
       0,   781,   194,   195,   196,   782,     0,   197,     0,     0,
     783,     0,   198,   199,  2198,   784,   200,     0,   201,   785,
     786,   787,   788,     0,   789,   790,   203,   791,   792,   793,
     205,     0,   206,   794,     0,   795,   796,     0,   207,   208,
       0,   209,   797,     0,   210,     0,     0,     0,   798,   212,
     213,   214,   799,     0,   215,   216,     0,     0,     0,   217,
       0,     0,   800,   218,   801,     0,     0,   219,     0,   220,
     221,     0,   222,   223,     0,     0,     0,     0,     0,     0,
     224,   802,   225,     0,     0,   803,   226,     0,   804,   227,
       0,     0,     0,   805,     0,   806,     0,   229,   807,     0,
     230,     0,   231,   808,     0,     0,   809,     0,     0,     0,
       0,   810,   232,   233,   234,   235,   236,   237,   811,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   812,   247,
     248,   249,   813,   250,   251,     0,     0,     0,   252,   253,
     254,   814,   256,     0,     0,   815,   258,   816,   817,   259,
       0,   260,   818,   819,   820,   821,   822,   823,   824,   265,
     266,   267,   268,     0,   825,   269,   270,     0,   271,   272,
     273,   826,   827,   828,   274,     0,   829,   830,     0,   275,
     276,     0,   831,     0,   278,   279,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   281,   282,   283,
     832,   833,   285,   834,   835,   836,   837,   838,     0,   288,
     289,     0,   290,     0,   291,   292,   293,   294,     0,   839,
     296,   297,   298,   299,   300,   301,   302,   840,     0,     0,
       0,   303,   304,     0,     0,   305,   306,   307,     0,   308,
       0,   309,   310,   841,   842,   311,     0,   312,   313,   314,
       0,   315,   316,     0,     0,   843,   317,   318,   844,   319,
     320,   845,   321,   846,   323,   324,     0,   847,   326,     0,
       0,     0,   327,   328,   329,     0,     0,   330,     0,     0,
       0,   331,   332,   333,   334,     0,   335,   336,   337,     0,
       0,     0,     0,     0,     0,   338,   339,     0,   340,     0,
       0,   341,     0,     0,   342,   343,   848,   849,   344,   345,
       0,   346,   850,   348,   851,   852,   853,   349,   350,   351,
     352,   854,   353,   354,     0,   355,   356,     0,   669,   357,
     855,   856,   857,   858,     0,     0,     0,     0,     0,   362,
       0,   363,   859,   860,   861,   365,   366,   367,     0,   862,
     368,   369,   863,     0,   370,     0,     0,   864,   865,   371,
       0,     0,   372,     0,   373,     0,   866,   375,     0,     0,
     867,   868,   869,   870,   871,   376,     0,     0,   377,   872,
       0,   378,   379,   873,     0,     0,     0,     0,   381,     0,
     382,   383,     0,   874,     0,   875,     0,     0,     0,     0,
     876,     0,     0,     0,   877,   878,     0,     0,     0,     0,
     879,     0,   880,     0,     0,   881,   882,     0,   883,   884,
     122,     0,   740,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   741,     0,   742,   130,   131,
     743,   133,     0,   134,   744,   135,     0,   745,   136,   746,
     747,   748,   137,   749,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   750,   145,     0,   146,
     751,   752,   148,     0,   149,   150,   151,   753,   152,     0,
     754,   154,     0,   155,   156,   157,   158,   159,   755,   756,
     160,     0,     0,   161,     0,   757,   163,     0,   758,   759,
     760,   164,     0,     0,   165,   761,   762,     0,   763,   764,
       0,   166,   167,   765,   766,   767,     0,     0,     0,     0,
     768,   170,   769,     0,     0,   770,   771,   171,     0,   172,
       0,     0,     0,   772,   773,   173,     0,   174,   175,   176,
       0,     0,     0,   177,     0,     0,   178,   179,   180,     0,
       0,   774,   181,     0,   775,   776,   182,   183,   184,   185,
       0,     0,   186,     0,   187,   188,   189,   777,     0,   190,
     778,   191,   779,   780,   192,   193,     0,   781,   194,   195,
     196,   782,     0,   197,     0,     0,   783,     0,   198,   199,
    2200,   784,   200,     0,   201,   785,   786,   787,   788,     0,
     789,   790,   203,   791,   792,   793,   205,     0,   206,   794,
       0,   795,   796,     0,   207,   208,     0,   209,   797,     0,
     210,     0,     0,     0,   798,   212,   213,   214,   799,     0,
     215,   216,     0,     0,     0,   217,     0,     0,   800,   218,
     801,     0,     0,   219,     0,   220,   221,     0,   222,   223,
       0,     0,     0,     0,     0,     0,   224,   802,   225,     0,
       0,   803,   226,     0,   804,   227,     0,     0,     0,   805,
       0,   806,     0,   229,   807,     0,   230,     0,   231,   808,
       0,     0,   809,     0,     0,     0,     0,   810,   232,   233,
     234,   235,   236,   237,   811,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   812,   247,   248,   249,   813,   250,
     251,     0,     0,     0,   252,   253,   254,   814,   256,     0,
       0,   815,   258,   816,   817,   259,     0,   260,   818,   819,
     820,   821,   822,   823,   824,   265,   266,   267,   268,     0,
     825,   269,   270,     0,   271,   272,   273,   826,   827,   828,
     274,     0,   829,   830,     0,   275,   276,     0,   831,     0,
     278,   279,   280,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   281,   282,   283,   832,   833,   285,   834,
     835,   836,   837,   838,     0,   288,   289,     0,   290,     0,
     291,   292,   293,   294,     0,   839,   296,   297,   298,   299,
     300,   301,   302,   840,     0,     0,     0,   303,   304,     0,
       0,   305,   306,   307,     0,   308,     0,   309,   310,   841,
     842,   311,     0,   312,   313,   314,     0,   315,   316,     0,
       0,   843,   317,   318,   844,   319,   320,   845,   321,   846,
     323,   324,     0,   847,   326,     0,     0,     0,   327,   328,
     329,     0,     0,   330,     0,     0,     0,   331,   332,   333,
     334,     0,   335,   336,   337,     0,     0,     0,     0,     0,
       0,   338,   339,     0,   340,     0,     0,   341,     0,     0,
     342,   343,   848,   849,   344,   345,     0,   346,   850,   348,
     851,   852,   853,   349,   350,   351,   352,   854,   353,   354,
       0,   355,   356,     0,   669,   357,   855,   856,   857,   858,
       0,     0,     0,     0,     0,   362,     0,   363,   859,   860,
     861,   365,   366,   367,     0,   862,   368,   369,   863,     0,
     370,     0,     0,   864,   865,   371,     0,     0,   372,     0,
     373,     0,   866,   375,     0,     0,   867,   868,   869,   870,
     871,   376,     0,     0,   377,   872,     0,   378,   379,   873,
       0,     0,     0,     0,   381,     0,   382,   383,     0,   874,
       0,   875,     0,     0,     0,     0,   876,     0,     0,     0,
     877,   878,     0,     0,     0,     0,   879,     0,   880,     0,
       0,   881,   882,     0,   883,   884,   122,     0,   740,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   741,     0,   742,   130,   131,   743,   133,     0,   134,
     744,   135,     0,   745,   136,   746,   747,   748,   137,   749,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   750,   145,     0,   146,   751,   752,   148,     0,
     149,   150,   151,   753,   152,     0,   754,   154,     0,   155,
     156,   157,   158,   159,   755,   756,   160,     0,     0,   161,
       0,   757,   163,     0,   758,   759,   760,   164,     0,     0,
     165,   761,   762,     0,   763,   764,     0,   166,   167,   765,
     766,   767,     0,     0,     0,     0,   768,   170,   769,     0,
       0,   770,   771,   171,     0,   172,     0,     0,     0,   772,
     773,   173,     0,   174,   175,   176,     0,     0,     0,   177,
       0,     0,   178,   179,   180,     0,     0,   774,   181,     0,
     775,   776,   182,   183,   184,   185,     0,     0,   186,     0,
     187,   188,   189,   777,     0,   190,   778,   191,   779,   780,
     192,   193,     0,   781,   194,   195,   196,   782,     0,   197,
       0,     0,   783,     0,   198,   199,     0,   784,   200,     0,
     201,   785,   786,   787,   788,     0,   789,   790,   203,   791,
     792,   793,   205,     0,   206,   794,     0,   795,   796,     0,
     207,   208,     0,   209,   797,     0,   210,     0,     0,     0,
     798,   212,   213,   214,   799,     0,   215,   216,     0,     0,
       0,   217,     0,     0,   800,   218,   801,     0,     0,   219,
       0,   220,   221,     0,   222,   223,     0,     0,     0,     0,
       0,     0,   224,   802,   225,     0,     0,   803,   226,     0,
     804,   227,     0,     0,     0,   805,     0,   806,     0,   229,
     807,     0,   230,     0,   231,   808,     0,     0,   809,     0,
       0,     0,     0,   810,   232,   233,   234,   235,   236,   237,
     811,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     812,   247,   248,   249,   813,   250,   251,     0,     0,     0,
     252,   253,   254,   814,   256,     0,     0,   815,   258,   816,
     817,   259,     0,   260,   818,   819,   820,   821,   822,   823,
     824,   265,   266,   267,   268,     0,   825,   269,   270,     0,
     271,   272,   273,   826,   827,   828,   274,     0,   829,   830,
       0,   275,   276,     0,   831,     0,   278,   279,   280,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   281,
     282,   283,   832,   833,   285,   834,   835,   836,   837,   838,
       0,   288,   289,     0,   290,     0,   291,   292,   293,   294,
       0,   839,   296,   297,   298,   299,   300,   301,   302,   840,
       0,     0,     0,   303,   304,     0,     0,   305,   306,   307,
       0,   308,     0,   309,   310,   841,   842,   311,     0,   312,
     313,   314,     0,   315,   316,     0,     0,   843,   317,   318,
     844,   319,   320,   845,   321,   846,   323,   324,     0,   847,
     326,     0,     0,     0,   327,   328,   329,     0,     0,   330,
       0,     0,     0,   331,   332,   333,   334,     0,   335,   336,
     337,     0,     0,     0,     0,     0,     0,   338,   339,     0,
     340,     0,     0,   341,     0,     0,   342,   343,   848,   849,
     344,   345,     0,   346,   850,   348,   851,   852,   853,   349,
     350,   351,   352,   854,   353,   354,     0,   355,   356,     0,
     669,   357,   855,   856,   857,   858,     0,     0,     0,     0,
       0,   362,     0,   363,   859,   860,   861,   365,   366,   367,
       0,   862,   368,   369,   863,     0,   370,     0,     0,   864,
     865,   371,     0,     0,   372,     0,   373,     0,   866,   375,
       0,     0,   867,   868,   869,   870,   871,   376,     0,     0,
     377,   872,     0,   378,   379,   873,     0,     0,     0,     0,
     381,     0,   382,   383,     0,   874,     0,   875,     0,     0,
       0,     0,   876,     0,     0,     0,   877,   878,     0,     0,
       0,     0,   879,     0,   880,     0,     0,   881,   882,     0,
     883,   884,   122,     0,   740,   124,   125,   126,   127,  1788,
       0,     0,     0,     0,  1789,     0,     0,   741,     0,   742,
     130,   131,   743,   133,     0,   134,   744,   135,     0,   745,
     136,   746,   747,   748,   137,   749,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   750,   145,
       0,   146,   751,   752,   148,     0,   149,   150,   151,   753,
     152,     0,   754,   154,     0,   155,   156,   157,   158,   159,
     755,   756,   160,     0,     0,   161,     0,   757,   163,     0,
     758,   759,   760,   164,     0,     0,   165,   761,   762,     0,
     763,   764,     0,   166,   167,   765,   766,   767,     0,     0,
       0,     0,   768,   170,   769,     0,     0,   770,   771,   171,
       0,   172,     0,     0,     0,   772,   773,   173,     0,   174,
     175,   176,     0,     0,     0,   177,     0,     0,   178,   179,
     180,     0,     0,   774,   181,     0,   775,   776,   182,   183,
     184,   185,     0,     0,   186,     0,   187,   188,   189,   777,
       0,   190,   778,   191,   779,   780,   192,   193,     0,   781,
     194,   195,   196,   782,     0,   197,     0,     0,   783,     0,
     198,   199,     0,   784,   200,     0,   201,   785,   786,   787,
     788,     0,   789,   790,   203,   791,   792,   793,   205,     0,
     206,   794,     0,   795,   796,     0,   207,   208,     0,   209,
     797,     0,   210,     0,     0,     0,   798,   212,   213,   214,
     799,     0,   215,   216,     0,     0,     0,   217,     0,     0,
     800,   218,   801,     0,     0,   219,     0,   220,   221,     0,
     222,   223,     0,     0,     0,     0,     0,     0,   224,   802,
     225,     0,     0,   803,   226,     0,   804,   227,     0,     0,
       0,   805,     0,   806,     0,   229,   807,     0,   230,     0,
     231,   808,     0,     0,   809,     0,     0,     0,     0,   810,
     232,   233,   234,   235,   236,   237,   811,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   812,   247,   248,   249,
     813,   250,   251,     0,     0,     0,   252,   253,   254,   814,
     256,     0,     0,   815,   258,   816,   817,   259,     0,   260,
     818,   819,   820,   821,   822,   823,   824,   265,   266,   267,
     268,     0,   825,   269,   270,     0,   271,   272,   273,   826,
       0,   828,   274,     0,   829,   830,     0,   275,   276,     0,
     831,     0,   278,   279,   280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   281,   282,   283,   832,   833,
     285,   834,   835,   836,   837,   838,     0,   288,   289,     0,
     290,     0,   291,   292,   293,   294,     0,   839,   296,   297,
     298,   299,   300,   301,   302,   840,     0,     0,     0,   303,
     304,     0,     0,   305,   306,   307,     0,   308,     0,   309,
     310,   841,   842,   311,     0,   312,   313,   314,     0,   315,
     316,     0,     0,   843,   317,   318,   844,   319,   320,   845,
     321,   846,   323,   324,     0,   847,   326,     0,     0,     0,
     327,   328,   329,     0,     0,   330,     0,     0,     0,   331,
     332,   333,   334,     0,   335,   336,   337,     0,     0,     0,
       0,     0,     0,   338,   339,     0,   340,     0,     0,   341,
       0,     0,   342,   343,   848,   849,   344,   345,     0,   346,
     850,   348,   851,   852,   853,   349,   350,   351,   352,   854,
     353,   354,     0,   355,   356,     0,   669,   357,   855,   856,
     857,   858,     0,     0,     0,     0,     0,   362,     0,   363,
     859,   860,   861,   365,   366,   367,     0,   862,   368,   369,
     863,     0,   370,     0,     0,   864,   865,   371,     0,     0,
     372,     0,   373,     0,   866,   375,     0,     0,   867,   868,
     869,   870,   871,   376,     0,     0,   377,   872,     0,   378,
     379,   873,     0,     0,     0,     0,   381,     0,   382,   383,
       0,   874,     0,   875,     0,     0,     0,     0,   876,     0,
       0,     0,   877,   878,     0,     0,     0,     0,   879,     0,
     880,     0,     0,   881,   882,     0,   883,   884,   122,     0,
     740,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   741,     0,   742,   130,   131,   743,   133,
       0,   134,   744,   135,     0,   745,   136,   746,   747,   748,
     137,   749,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   750,   145,     0,   146,   751,   752,
     148,     0,   149,   150,   151,   753,   152,     0,   754,   154,
       0,   155,   156,   157,   158,   159,   755,   756,   160,     0,
       0,   161,     0,   757,   163,     0,   758,   759,   760,   164,
       0,     0,   165,   761,   762,     0,   763,   764,     0,   166,
     167,   765,   766,   767,     0,     0,     0,     0,   768,   170,
     769,     0,     0,   770,   771,   171,     0,   172,     0,     0,
       0,   772,   773,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,   774,
     181,     0,   775,   776,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,   777,     0,   190,   778,   191,
     779,   780,   192,   193,     0,   781,   194,   195,   196,   782,
       0,   197,     0,     0,   783,     0,   198,   199,     0,   784,
     200,     0,   201,   785,   786,   787,   788,     0,   789,   790,
     203,   791,   792,   793,   205,     0,   206,   794,     0,   795,
     796,     0,   207,   208,     0,   209,   797,     0,   210,     0,
       0,     0,   798,   212,   213,   214,   799,     0,   215,   216,
       0,     0,     0,   217,     0,     0,   800,   218,  2477,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,   802,   225,     0,     0,   803,
     226,     0,   804,   227,     0,     0,     0,   805,     0,   806,
       0,   229,   807,     0,   230,     0,   231,   808,     0,     0,
     809,     0,     0,     0,     0,   810,   232,   233,   234,   235,
     236,   237,   811,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   812,   247,   248,   249,   813,   250,   251,     0,
       0,     0,   252,   253,   254,   814,   256,     0,     0,   815,
     258,   816,   817,   259,     0,   260,   818,   819,   820,   821,
     822,   823,   824,   265,   266,   267,   268,     0,   825,   269,
     270,     0,   271,   272,   273,   826,   827,   828,   274,     0,
     829,   830,     0,   275,   276,     0,   831,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   832,   833,   285,   834,   835,   836,
     837,   838,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   839,   296,   297,   298,   299,   300,   301,
     302,   840,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,   841,   842,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,   843,
     317,   318,   844,   319,   320,   845,   321,   846,   323,   324,
       0,   847,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
     848,   849,   344,   345,     0,   346,   850,   348,   851,   852,
     853,   349,   350,   351,   352,   854,   353,   354,     0,   355,
     356,     0,   669,   357,   855,   856,   857,   858,     0,     0,
       0,     0,     0,   362,     0,   363,   859,   860,   861,   365,
     366,   367,     0,   862,   368,   369,   863,     0,   370,     0,
       0,   864,   865,   371,     0,     0,   372,     0,   373,     0,
     866,   375,     0,     0,   867,   868,   869,   870,   871,   376,
       0,     0,   377,   872,     0,   378,   379,   873,     0,     0,
       0,     0,   381,     0,   382,   383,     0,   874,     0,   875,
       0,     0,     0,     0,   876,     0,     0,     0,   877,   878,
       0,     0,     0,     0,   879,     0,   880,     0,     0,   881,
     882,     0,   883,   884,   122,     0,   740,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   741,
       0,   742,   130,   131,   743,   133,     0,   134,   744,   135,
       0,   745,   136,   746,   747,   748,   137,   749,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     750,   145,     0,   146,   751,   752,   148,     0,   149,   150,
     151,   753,   152,     0,   754,   154,     0,   155,   156,   157,
     158,   159,   755,   756,   160,     0,     0,   161,     0,   757,
     163,     0,   758,   759,   760,   164,     0,     0,   165,   761,
     762,     0,   763,   764,     0,   166,   167,   765,   766,   767,
       0,     0,     0,     0,   768,   170,   769,     0,     0,   770,
     771,   171,     0,   172,     0,     0,     0,   772,   773,   173,
       0,   174,   175,   176,     0,     0,     0,   177,     0,     0,
     178,   179,   180,     0,     0,   774,   181,     0,   775,   776,
     182,   183,   184,   185,     0,     0,   186,     0,   187,   188,
     189,   777,     0,   190,   778,   191,   779,   780,   192,   193,
       0,   781,   194,   195,   196,   782,     0,   197,     0,     0,
     783,     0,   198,   199,     0,   784,   200,     0,   201,   785,
     786,   787,   788,     0,   789,   790,   203,   791,   792,   793,
     205,     0,   206,   794,     0,   795,   796,     0,   207,   208,
       0,   209,   797,     0,   210,     0,     0,     0,   798,   212,
     213,   214,   799,     0,   215,   216,     0,     0,     0,   217,
       0,     0,   800,   218,  2550,     0,     0,   219,     0,   220,
     221,     0,   222,   223,     0,     0,     0,     0,     0,     0,
     224,   802,   225,     0,     0,   803,   226,     0,   804,   227,
       0,     0,     0,   805,     0,   806,     0,   229,   807,     0,
     230,     0,   231,   808,     0,     0,   809,     0,     0,     0,
       0,   810,   232,   233,   234,   235,   236,   237,   811,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   812,   247,
     248,   249,   813,   250,   251,     0,     0,     0,   252,   253,
     254,   814,   256,     0,     0,   815,   258,   816,   817,   259,
       0,   260,   818,   819,   820,   821,   822,   823,   824,   265,
     266,   267,   268,     0,   825,   269,   270,     0,   271,   272,
     273,   826,   827,   828,   274,     0,   829,   830,     0,   275,
     276,     0,   831,     0,   278,   279,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   281,   282,   283,
     832,   833,   285,   834,   835,   836,   837,   838,     0,   288,
     289,     0,   290,     0,   291,   292,   293,   294,     0,   839,
     296,   297,   298,   299,   300,   301,   302,   840,     0,     0,
       0,   303,   304,     0,     0,   305,   306,   307,     0,   308,
       0,   309,   310,   841,   842,   311,     0,   312,   313,   314,
       0,   315,   316,     0,     0,   843,   317,   318,   844,   319,
     320,   845,   321,   846,   323,   324,     0,   847,   326,     0,
       0,     0,   327,   328,   329,     0,     0,   330,     0,     0,
       0,   331,   332,   333,   334,     0,   335,   336,   337,     0,
       0,     0,     0,     0,     0,   338,   339,     0,   340,     0,
       0,   341,     0,     0,   342,   343,   848,   849,   344,   345,
       0,   346,   850,   348,   851,   852,   853,   349,   350,   351,
     352,   854,   353,   354,     0,   355,   356,     0,   669,   357,
     855,   856,   857,   858,     0,     0,     0,     0,     0,   362,
       0,   363,   859,   860,   861,   365,   366,   367,     0,   862,
     368,   369,   863,     0,   370,     0,     0,   864,   865,   371,
       0,     0,   372,     0,   373,     0,   866,   375,     0,     0,
     867,   868,   869,   870,   871,   376,     0,     0,   377,   872,
       0,   378,   379,   873,     0,     0,     0,     0,   381,     0,
     382,   383,     0,   874,     0,   875,     0,     0,     0,     0,
     876,     0,     0,     0,   877,   878,     0,     0,     0,     0,
     879,     0,   880,     0,     0,   881,   882,     0,   883,   884,
     122,     0,   740,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   741,     0,   742,   130,   131,
     743,   133,     0,   134,   744,   135,     0,   745,   136,   746,
     747,   748,   137,   749,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   750,   145,     0,   146,
     751,   752,   148,     0,   149,   150,   151,   753,   152,     0,
     754,   154,     0,   155,   156,   157,   158,   159,   755,   756,
     160,     0,     0,   161,     0,   757,   163,     0,   758,   759,
     760,   164,     0,     0,   165,   761,   762,     0,   763,   764,
       0,   166,   167,   765,   766,   767,     0,     0,     0,     0,
     768,   170,   769,     0,     0,   770,  2899,   171,     0,   172,
       0,     0,     0,   772,   773,   173,     0,   174,   175,   176,
       0,     0,     0,   177,     0,     0,   178,   179,   180,     0,
       0,   774,   181,     0,   775,   776,   182,   183,   184,   185,
       0,     0,   186,     0,   187,   188,   189,   777,     0,   190,
     778,   191,   779,   780,   192,   193,     0,   781,   194,   195,
     196,   782,     0,   197,     0,     0,   783,     0,   198,   199,
       0,   784,   200,     0,   201,   785,   786,   787,   788,     0,
     789,   790,   203,   791,   792,   793,   205,     0,   206,   794,
       0,   795,   796,     0,   207,   208,     0,   209,   797,     0,
     210,     0,     0,     0,   798,   212,   213,   214,   799,     0,
     215,   216,     0,     0,     0,   217,     0,     0,   800,   218,
     801,     0,     0,   219,     0,   220,   221,     0,   222,   223,
       0,     0,     0,     0,     0,     0,   224,   802,   225,     0,
       0,   803,   226,     0,   804,   227,     0,     0,     0,   805,
       0,   806,     0,   229,   807,     0,   230,     0,   231,   808,
       0,     0,   809,     0,     0,     0,     0,   810,   232,   233,
     234,   235,   236,   237,   811,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   812,   247,   248,   249,   813,   250,
     251,     0,     0,     0,   252,   253,   254,   814,   256,     0,
       0,   815,   258,   816,   817,   259,     0,   260,   818,   819,
     820,   821,   822,   823,   824,   265,   266,   267,   268,     0,
     825,   269,   270,     0,   271,   272,   273,   826,   827,   828,
     274,     0,   829,   830,     0,   275,   276,     0,   831,     0,
     278,   279,   280,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   281,   282,   283,   832,   833,   285,   834,
     835,   836,   837,   838,     0,   288,   289,     0,   290,     0,
     291,   292,   293,   294,     0,   839,   296,   297,   298,   299,
     300,   301,   302,   840,     0,     0,     0,   303,   304,     0,
       0,   305,   306,   307,     0,   308,     0,   309,   310,   841,
     842,   311,     0,   312,   313,   314,     0,   315,   316,     0,
       0,   843,   317,   318,   844,   319,   320,   845,   321,   846,
     323,   324,     0,   847,   326,     0,     0,     0,   327,   328,
     329,     0,     0,   330,     0,     0,     0,   331,   332,   333,
     334,     0,   335,   336,   337,     0,     0,     0,     0,     0,
       0,   338,   339,     0,   340,     0,     0,   341,     0,     0,
     342,   343,   848,   849,   344,   345,     0,   346,   850,   348,
     851,   852,   853,   349,   350,   351,   352,   854,   353,   354,
       0,   355,   356,     0,   669,   357,   855,   856,   857,   858,
       0,     0,     0,     0,     0,   362,     0,   363,   859,   860,
     861,   365,   366,   367,     0,   862,   368,   369,   863,     0,
     370,     0,     0,   864,   865,   371,     0,     0,   372,     0,
     373,     0,   866,   375,     0,     0,   867,   868,   869,   870,
     871,   376,     0,     0,   377,   872,     0,   378,   379,   873,
       0,     0,     0,     0,   381,     0,   382,   383,     0,   874,
       0,   875,     0,     0,     0,     0,   876,     0,     0,     0,
     877,   878,     0,     0,     0,     0,   879,     0,   880,     0,
       0,   881,   882,     0,   883,   884,   122,     0,   740,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   741,     0,   742,   130,   131,   743,   133,     0,   134,
     744,   135,     0,   745,   136,   746,   747,   748,   137,   749,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   750,   145,     0,   146,   751,   752,   148,     0,
     149,   150,   151,   753,   152,     0,   754,   154,     0,   155,
     156,   157,   158,   159,   755,   756,   160,     0,     0,   161,
       0,   757,   163,     0,   758,   759,   760,   164,     0,     0,
     165,   761,   762,     0,   763,   764,     0,   166,   167,   765,
     766,   767,     0,     0,     0,     0,   768,   170,   769,     0,
       0,   770,   771,   171,     0,   172,     0,     0,     0,   772,
     773,   173,     0,   174,   175,   176,     0,     0,     0,   177,
       0,     0,   178,   179,   180,     0,     0,   774,   181,     0,
     775,   776,   182,   183,   184,   185,     0,     0,   186,     0,
     187,   188,   189,   777,     0,   190,   778,   191,   779,   780,
     192,   193,     0,   781,   194,   195,   196,   782,     0,   197,
       0,     0,   783,     0,   198,   199,     0,   784,   200,     0,
     201,   785,   786,   787,   788,     0,   789,   790,   203,   791,
     792,   793,   205,     0,   206,   794,     0,   795,   796,     0,
     207,   208,     0,   209,   797,     0,   210,     0,     0,     0,
     798,   212,   213,   214,   799,     0,   215,   216,     0,     0,
       0,   217,     0,     0,   800,   218,   801,     0,     0,   219,
       0,   220,   221,     0,   222,   223,     0,     0,     0,     0,
       0,     0,   224,   802,   225,     0,     0,   803,   226,     0,
     804,   227,     0,     0,     0,   805,     0,   806,     0,   229,
     807,     0,   230,     0,   231,   808,     0,     0,   809,     0,
       0,     0,     0,   810,   232,   233,   234,   235,   236,   237,
     811,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     812,   247,   248,   249,   813,   250,   251,     0,     0,     0,
     252,   253,   254,   814,   256,     0,     0,   815,   258,   816,
     817,   259,     0,   260,   818,   819,   820,   821,   822,   823,
     824,   265,   266,   267,   268,     0,   825,   269,   270,     0,
     271,   272,   273,   826,     0,   828,   274,     0,   829,   830,
       0,   275,   276,     0,   831,     0,   278,   279,   280,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   281,
     282,   283,   832,   833,   285,   834,   835,   836,   837,   838,
       0,   288,   289,     0,   290,     0,   291,   292,   293,   294,
       0,   839,   296,   297,   298,   299,   300,   301,   302,   840,
       0,     0,     0,   303,   304,     0,     0,   305,   306,   307,
       0,   308,     0,   309,   310,   841,   842,   311,     0,   312,
     313,   314,     0,   315,   316,     0,     0,   843,   317,   318,
     844,   319,   320,   845,   321,   846,   323,   324,     0,   847,
     326,     0,     0,     0,   327,   328,   329,     0,     0,   330,
       0,     0,     0,   331,   332,   333,   334,     0,   335,   336,
     337,     0,     0,     0,     0,     0,     0,   338,   339,     0,
     340,     0,     0,   341,     0,     0,   342,   343,   848,   849,
     344,   345,     0,   346,   850,   348,   851,   852,   853,   349,
     350,   351,   352,   854,   353,   354,     0,   355,   356,     0,
     669,   357,   855,   856,   857,   858,     0,     0,     0,     0,
       0,   362,     0,   363,   859,   860,   861,   365,   366,   367,
       0,   862,   368,   369,   863,     0,   370,     0,     0,   864,
     865,   371,     0,     0,   372,     0,   373,     0,   866,   375,
       0,     0,   867,   868,   869,   870,   871,   376,     0,     0,
     377,   872,     0,   378,   379,   873,     0,     0,     0,     0,
     381,     0,   382,   383,     0,   874,     0,   875,     0,     0,
       0,     0,   876,     0,     0,     0,   877,   878,     0,     0,
       0,     0,   879,     0,   880,     0,     0,   881,   882,     0,
     883,   884,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,     0,   161,  1965,   162,   163,     0,
       0,     0,     0,   164,     0,     0,   165,     0,     0,     0,
       0,     0,     0,   166,   167,     0,     0,   168,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,   171,
       0,   172,     0,     0,     0,     0,     0,   173,     0,   174,
     175,   176,     0,     0,     0,   177,     0,     0,   178,   179,
     180,     0,     0,     0,   181,     0,     0,     0,   182,   183,
     184,   185,     0,     0,   186,     0,   187,   188,   189,     0,
       0,   190,     0,   191,     0,     0,   192,   193,     0,     0,
     194,   195,   196,     0,     0,   197,     0,     0,     0,     0,
     198,   199,     0,     0,   200,  1966,   201,     0,     0,     0,
       0,     0,     0,   202,   203,     0,     0,   204,   205,     0,
     206,     0,     0,     0,     0,     0,   207,   208,     0,   209,
       0,     0,   210,     0,     0,     0,   211,   212,   213,   214,
       0,     0,   215,   216,  1112,     0,     0,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,   220,   221,     0,
     222,   223,     0,     0,     0,  1113,     0,     0,   224,     0,
     225,     0,     0,     0,   226,     0,     0,   227,     0,  2462,
       0,     0,     0,   228,     0,   229,     0,     0,   230,     0,
     231,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     232,   233,   234,   235,   236,   237,     0,   238,   239,   240,
     241,   242,   243,   244,   245,   246,     0,   247,   248,   249,
       0,   250,   251,     0,     0,     0,   252,   253,   254,   255,
     256,     0,     0,   257,   258,     0,     0,   259,     0,   260,
       0,   261,     0,     0,   262,   263,   264,   265,   266,   267,
     268,     0,     0,   269,   270,     0,   271,   272,   273,     0,
       0,     0,   274,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,   279,   280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   281,   282,   283,   284,     0,
     285,     0,   286,     0,   287,     0,     0,   288,   289,     0,
     290,     0,   291,   292,   293,   294,     0,   295,   296,   297,
     298,   299,   300,   301,   302,     0,     0,     0,     0,   303,
     304,     0,     0,   305,   306,   307,     0,   308,     0,   309,
     310,     0,     0,   311,     0,   312,   313,   314,     0,   315,
     316,     0,     0,     0,   317,   318,     0,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,  1875,     0,     0,
     327,   328,   329,     0,     0,   330,     0,     0,     0,   331,
     332,   333,   334,     0,   335,   336,   337,  1967,     0,     0,
       0,     0,     0,   338,   339,     0,   340,     0,     0,   341,
       0,     0,   342,   343,     0,     0,   344,   345,     0,   346,
     347,   348,     0,     0,     0,   349,   350,   351,   352,     0,
     353,   354,     0,   355,   356,     0,     0,   357,   358,   359,
     360,   361,     0,     0,     0,     0,     0,   362,     0,   363,
       0,     0,   364,   365,   366,   367,     0,     0,   368,   369,
       0,     0,   370,     0,     0,     0,     0,   371,     0,     0,
     372,     0,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,     0,     0,   377,     0,     0,   378,
     379,   380,     0,     0,     0,     0,   381,     0,   382,   383,
       0,     0,     0,   384,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,  2014,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,     0,   161,  1965,
     162,   163,     0,     0,     0,     0,   164,     0,     0,   165,
       0,     0,     0,     0,     0,     0,   166,   167,     0,     0,
     168,     0,     0,     0,     0,   169,   170,     0,     0,     0,
       0,     0,   171,     0,   172,     0,     0,     0,     0,     0,
     173,     0,   174,   175,   176,     0,     0,     0,   177,     0,
       0,   178,   179,   180,     0,     0,     0,   181,     0,     0,
       0,   182,   183,   184,   185,     0,     0,   186,     0,   187,
     188,   189,     0,     0,   190,     0,   191,     0,     0,   192,
     193,     0,     0,   194,   195,   196,     0,     0,   197,     0,
       0,     0,     0,   198,   199,     0,     0,   200,  1966,   201,
       0,     0,     0,     0,     0,     0,   202,   203,     0,     0,
     204,   205,     0,   206,     0,     0,     0,     0,     0,   207,
     208,     0,   209,     0,     0,   210,     0,     0,     0,   211,
     212,   213,   214,     0,     0,   215,   216,  1112,     0,     0,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
     220,   221,     0,   222,   223,     0,     0,     0,  1113,     0,
       0,   224,     0,   225,     0,     0,     0,   226,     0,     0,
     227,     0,     0,     0,     0,     0,   228,     0,   229,     0,
       0,   230,     0,   231,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   232,   233,   234,   235,   236,   237,     0,
     238,   239,   240,   241,   242,   243,   244,   245,   246,     0,
     247,   248,   249,     0,   250,   251,     0,     0,     0,   252,
     253,   254,   255,   256,     0,     0,   257,   258,     0,     0,
     259,     0,   260,     0,   261,     0,     0,   262,   263,   264,
     265,   266,   267,   268,     0,     0,   269,   270,     0,   271,
     272,   273,     0,     0,     0,   274,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,   279,   280,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   281,   282,
     283,   284,     0,   285,     0,   286,     0,   287,     0,     0,
     288,   289,     0,   290,     0,   291,   292,   293,   294,     0,
     295,   296,   297,   298,   299,   300,   301,   302,     0,     0,
       0,     0,   303,   304,     0,     0,   305,   306,   307,     0,
     308,     0,   309,   310,     0,     0,   311,     0,   312,   313,
     314,     0,   315,   316,     0,     0,     0,   317,   318,     0,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,   327,   328,   329,     0,     0,   330,     0,
       0,     0,   331,   332,   333,   334,     0,   335,   336,   337,
    1967,     0,     0,     0,     0,     0,   338,   339,     0,   340,
       0,     0,   341,     0,     0,   342,   343,     0,     0,   344,
     345,     0,   346,   347,   348,     0,     0,     0,   349,   350,
     351,   352,     0,   353,   354,     0,   355,   356,     0,     0,
     357,   358,   359,   360,   361,     0,     0,     0,     0,     0,
     362,     0,   363,     0,     0,   364,   365,   366,   367,     0,
       0,   368,   369,     0,     0,   370,     0,     0,     0,     0,
     371,     0,     0,   372,     0,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,     0,     0,   377,
       0,     0,   378,   379,   380,     0,     0,     0,     0,   381,
       0,   382,   383,     0,     0,     0,   384,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
    2014,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,  1875,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,     0,   384,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,  2287,     0,   130,
     131,   132,   133,   884,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,     0,   161,     0,   162,   163,     0,     0,
       0,     0,   164,     0,     0,   165,     0,     0,     0,     0,
       0,     0,   166,   167,     0,     0,   168,     0,     0,     0,
       0,   169,   170,     0,     0,     0,     0,     0,   171,     0,
     172,     0,     0,     0,     0,     0,   173,     0,   174,   175,
     176,     0,     0,     0,   177,     0,     0,   178,   179,   180,
       0,     0,     0,   181,     0,     0,     0,   182,   183,   184,
     185,     0,     0,   186,     0,   187,   188,   189,     0,     0,
     190,     0,   191,     0,     0,   192,   193,     0,     0,   194,
     195,   196,     0,     0,   197,     0,     0,     0,     0,   198,
     199,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,   202,   203,     0,     0,   204,   205,     0,   206,
       0,     0,     0,     0,     0,   207,   208,     0,   209,     0,
       0,   210,     0,     0,     0,   211,   212,   213,   214,     0,
       0,   215,   216,     0,     0,     0,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,   220,   221,     0,   222,
     223,     0,     0,     0,     0,     0,     0,   224,     0,   225,
       0,     0,     0,   226,     0,     0,   227,     0,     0,     0,
       0,     0,   228,     0,   229,     0,     0,   230,     0,   231,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   232,
     233,   234,   235,   236,   237,     0,   238,   239,   240,   241,
     242,   243,   244,   245,   246,     0,   247,   248,   249,     0,
     250,   251,     0,     0,     0,   252,   253,   254,   255,   256,
       0,     0,   257,   258,     0,     0,   259,     0,   260,     0,
     261,     0,     0,   262,   263,   264,   265,   266,   267,   268,
       0,     0,   269,   270,     0,   271,   272,   273,     0,     0,
       0,   274,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,   279,   280,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   281,   282,   283,   284,     0,   285,
       0,   286,     0,   287,     0,     0,   288,   289,     0,   290,
       0,   291,   292,   293,   294,     0,   295,   296,   297,   298,
     299,   300,   301,   302,     0,     0,     0,     0,   303,   304,
       0,     0,   305,   306,   307,     0,   308,     0,   309,   310,
       0,     0,   311,     0,   312,   313,   314,     0,   315,   316,
       0,     0,     0,   317,   318,     0,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,   327,
     328,   329,     0,     0,   330,     0,     0,     0,   331,   332,
     333,   334,     0,   335,   336,   337,     0,     0,     0,     0,
       0,     0,   338,   339,     0,   340,     0,     0,   341,     0,
       0,   342,   343,     0,     0,   344,   345,     0,   346,   347,
     348,     0,     0,     0,   349,   350,   351,   352,     0,   353,
     354,     0,   355,   356,     0,     0,   357,   358,   359,   360,
     361,     0,     0,     0,     0,     0,   362,     0,   363,     0,
       0,   364,   365,   366,   367,     0,     0,   368,   369,     0,
       0,   370,     0,     0,     0,     0,   371,     0,     0,   372,
       0,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,     0,     0,   377,     0,     0,   378,   379,
     380,     0,     0,     0,     0,   381,     0,   382,   383,     0,
       0,     0,   384,     0,     0,     0,     0,     0,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
    3611,   128,     0,     0,   129,  3612,   884,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,     0,   161,     0,   162,   163,     0,     0,     0,     0,
     164,     0,     0,   165,     0,     0,     0,     0,     0,     0,
     166,   167,     0,     0,   168,     0,     0,     0,     0,   169,
     170,     0,     0,     0,     0,     0,   171,     0,   172,     0,
       0,     0,     0,     0,   173,     0,   174,   175,   176,     0,
       0,     0,   177,     0,     0,   178,   179,   180,     0,     0,
       0,   181,     0,     0,     0,   182,   183,   184,   185,     0,
       0,   186,     0,   187,   188,   189,     0,     0,   190,     0,
     191,     0,     0,   192,   193,     0,     0,   194,   195,   196,
       0,     0,   197,     0,     0,     0,     0,   198,   199,     0,
       0,   200,     0,   201,     0,     0,     0,     0,     0,     0,
     202,   203,     0,     0,   204,   205,     0,   206,     0,     0,
       0,     0,     0,   207,   208,     0,   209,     0,     0,   210,
       0,     0,     0,   211,   212,   213,   214,     0,     0,   215,
     216,     0,     0,     0,   217,     0,     0,     0,   218,     0,
     986,     0,   219,     0,   220,   221,     0,   222,   223,     0,
       0,     0,     0,     0,     0,   224,     0,   225,     0,     0,
       0,   226,     0,     0,   227,     0,     0,     0,     0,     0,
     228,     0,   229,     0,     0,   230,     0,   231,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   232,   233,   234,
     235,   236,   237,     0,   238,   239,   240,   241,   242,   243,
     244,   245,   246,     0,   247,   248,   249,     0,   250,   251,
       0,     0,     0,   252,   253,   254,   255,   256,     0,     0,
     257,   258,     0,     0,   259,     0,   260,     0,   261,     0,
       0,   262,   263,   264,   265,   266,   267,   268,     0,     0,
     269,   270,     0,   271,   272,   273,     0,     0,     0,   274,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
     279,   280,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   281,   282,   283,   284,     0,   285,     0,   286,
       0,   287,     0,     0,   288,   289,     0,   290,     0,   291,
     292,   293,   294,     0,   295,   296,   297,   298,   299,   300,
     301,   302,     0,     0,     0,     0,   303,   304,     0,     0,
     305,   306,   307,     0,   308,     0,   309,   310,     0,     0,
     311,     0,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,     0,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,   327,   328,   329,
       0,     0,   330,     0,     0,     0,   331,   332,   333,   334,
       0,   335,   336,   337,     0,     0,     0,     0,     0,     0,
     338,   339,     0,   340,     0,     0,   341,     0,     0,   342,
     343,     0,     0,   344,   345,     0,   346,   347,   348,     0,
       0,     0,   349,   350,   351,   352,     0,   353,   354,     0,
     355,   356,     0,     0,   357,   358,   359,   360,   361,     0,
       0,     0,     0,     0,   362,     0,   363,     0,     0,   364,
     365,   366,   367,     0,     0,   368,   369,     0,     0,   370,
       0,     0,     0,     0,   371,     0,     0,   372,     0,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,     0,     0,   377,     0,     0,   378,   379,   380,     0,
       0,     0,     0,   381,     0,   382,   383,     0,     0,     0,
     384,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   420,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,     0,   161,     0,   162,   163,     0,
       0,     0,     0,   164,     0,     0,   165,     0,     0,     0,
       0,     0,     0,   166,   167,     0,     0,   168,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,   171,
       0,   172,     0,     0,     0,     0,     0,   173,     0,   174,
     175,   176,     0,     0,     0,   177,     0,     0,   178,   179,
     180,     0,     0,     0,   181,     0,     0,     0,   182,   183,
     184,   185,     0,     0,   186,     0,   187,   188,   189,     0,
       0,   190,     0,   191,     0,     0,   192,   193,     0,     0,
     194,   195,   196,     0,     0,   197,     0,     0,     0,     0,
     198,   199,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,   202,   203,     0,     0,   204,   205,     0,
     206,     0,     0,     0,     0,     0,   207,   208,     0,   209,
       0,     0,   210,     0,     0,     0,   211,   212,   213,   214,
       0,     0,   215,   216,     0,     0,     0,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,   220,   221,     0,
     222,   223,     0,     0,     0,     0,     0,     0,   224,     0,
     225,     0,     0,     0,   226,     0,     0,   227,     0,     0,
       0,     0,     0,   228,     0,   229,     0,     0,   230,     0,
     231,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     232,   233,   234,   235,   236,   237,     0,   238,   239,   240,
     241,   242,   243,   244,   245,   246,     0,   247,   248,   249,
       0,   250,   251,     0,     0,     0,   252,   253,   254,   255,
     256,     0,     0,   257,   258,     0,     0,   259,     0,   260,
       0,   261,     0,     0,   262,   263,   264,   265,   266,   267,
     268,     0,     0,   269,   270,     0,   271,   272,   273,     0,
       0,     0,   274,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,   279,   280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   281,   282,   283,   284,     0,
     285,     0,   286,     0,   287,     0,     0,   288,   289,     0,
     290,     0,   291,   292,   293,   294,     0,   295,   296,   297,
     298,   299,   300,   301,   302,     0,     0,     0,     0,   303,
     304,     0,     0,   305,   306,   307,     0,   308,     0,   309,
     310,     0,     0,   311,     0,   312,   313,   314,     0,   315,
     316,     0,     0,     0,   317,   318,     0,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
     327,   328,   329,     0,     0,   330,     0,     0,     0,   331,
     332,   333,   334,     0,   335,   336,   337,     0,     0,     0,
       0,     0,     0,   338,   339,     0,   340,     0,     0,   341,
       0,     0,   342,   343,     0,     0,   344,   345,     0,   346,
     347,   348,     0,     0,     0,   349,   350,   351,   352,     0,
     353,   354,     0,   355,   356,     0,     0,   357,   358,   359,
     360,   361,     0,     0,     0,     0,     0,   362,     0,   363,
       0,     0,   364,   365,   366,   367,     0,     0,   368,   369,
       0,     0,   370,     0,     0,     0,     0,   371,     0,     0,
     372,     0,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,     0,     0,   377,     0,     0,   378,
     379,   380,     0,     0,     0,     0,   381,     0,   382,   383,
       0,     0,     0,   384,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,  1833,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,   420,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,     0,   161,     0,
     162,   163,     0,     0,     0,     0,   164,     0,     0,   165,
       0,     0,     0,     0,     0,     0,   166,   167,     0,     0,
     168,     0,     0,     0,     0,   169,   170,     0,     0,     0,
       0,     0,   171,     0,   172,     0,     0,     0,     0,     0,
     173,     0,   174,   175,   176,     0,     0,     0,   177,     0,
       0,   178,   179,   180,     0,     0,     0,   181,     0,     0,
       0,   182,   183,   184,   185,     0,     0,   186,     0,   187,
     188,   189,     0,     0,   190,     0,   191,     0,     0,   192,
     193,     0,     0,   194,   195,   196,     0,     0,   197,     0,
       0,     0,     0,   198,   199,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,   202,   203,     0,     0,
     204,   205,     0,   206,     0,     0,     0,     0,     0,   207,
     208,     0,   209,     0,     0,   210,     0,     0,     0,   211,
     212,   213,   214,     0,     0,   215,   216,     0,     0,     0,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
     220,   221,     0,   222,   223,     0,     0,     0,     0,     0,
       0,   224,     0,   225,     0,     0,     0,   226,     0,     0,
     227,     0,     0,     0,     0,     0,   228,     0,   229,     0,
       0,   230,     0,   231,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   232,   233,   234,   235,   236,   237,     0,
     238,   239,   240,   241,   242,   243,   244,   245,   246,     0,
     247,   248,   249,     0,   250,   251,     0,     0,     0,   252,
     253,   254,   255,   256,     0,     0,   257,   258,     0,     0,
     259,     0,   260,     0,   261,     0,     0,   262,   263,   264,
     265,   266,   267,   268,     0,     0,   269,   270,     0,   271,
     272,   273,     0,     0,     0,   274,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,   279,   280,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   281,   282,
     283,   284,     0,   285,     0,   286,     0,   287,     0,     0,
     288,   289,     0,   290,     0,   291,   292,   293,   294,     0,
     295,   296,   297,   298,   299,   300,   301,   302,     0,     0,
       0,     0,   303,   304,     0,     0,   305,   306,   307,     0,
     308,     0,   309,   310,     0,     0,   311,     0,   312,   313,
     314,     0,   315,   316,     0,     0,     0,   317,   318,     0,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,   327,   328,   329,     0,     0,   330,     0,
       0,     0,   331,   332,   333,   334,     0,   335,   336,   337,
       0,     0,     0,     0,     0,     0,   338,   339,     0,   340,
       0,     0,   341,     0,     0,   342,   343,     0,     0,   344,
     345,     0,   346,   347,   348,     0,     0,     0,   349,   350,
     351,   352,     0,   353,   354,     0,   355,   356,     0,     0,
     357,   358,   359,   360,   361,     0,     0,     0,     0,     0,
     362,     0,   363,     0,     0,   364,   365,   366,   367,     0,
       0,   368,   369,     0,     0,   370,     0,     0,     0,     0,
     371,     0,     0,   372,     0,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,     0,     0,   377,
       0,     0,   378,   379,   380,     0,     0,     0,     0,   381,
       0,   382,   383,     0,     0,     0,   384,     0,     0,     0,
       0,     0,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  2013,     0,   128,     0,     0,   129,     0,
    2014,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,     0,   161,     0,   162,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,   170,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,   177,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,   182,
     183,   184,   185,     0,     0,   186,     0,   187,   188,   189,
       0,     0,   190,     0,   191,     0,     0,   192,   193,     0,
       0,   194,   195,   196,     0,     0,   197,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,   207,   208,     0,
     209,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,     0,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,     0,     0,     0,     0,     0,     0,   224,
       0,   225,     0,     0,     0,   226,     0,     0,   227,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,   274,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,   280,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,   288,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
     309,   310,     0,     0,   311,     0,   312,   313,   314,     0,
     315,   316,     0,     0,     0,   317,   318,     0,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,   332,   333,   334,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,   342,   343,     0,     0,   344,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,     0,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,   364,   365,   366,   367,     0,     0,   368,
     369,     0,     0,   370,     0,     0,     0,     0,   371,     0,
       0,   372,     0,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,     0,     0,   381,     0,   382,
     383,     0,     0,     0,   384,     0,     0,     0,     0,     0,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,  3612,   884,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,     0,   161,     0,   162,   163,     0,     0,
       0,     0,   164,     0,     0,   165,     0,     0,     0,     0,
       0,     0,   166,   167,     0,     0,   168,     0,     0,     0,
       0,   169,   170,     0,     0,     0,     0,     0,   171,     0,
     172,     0,     0,     0,     0,     0,   173,     0,   174,   175,
     176,     0,     0,     0,   177,     0,     0,   178,   179,   180,
       0,     0,     0,   181,     0,     0,     0,   182,   183,   184,
     185,     0,     0,   186,     0,   187,   188,   189,     0,     0,
     190,     0,   191,     0,     0,   192,   193,     0,     0,   194,
     195,   196,     0,     0,   197,     0,     0,     0,     0,   198,
     199,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,   202,   203,     0,     0,   204,   205,     0,   206,
       0,     0,     0,     0,     0,   207,   208,     0,   209,     0,
       0,   210,     0,     0,     0,   211,   212,   213,   214,     0,
       0,   215,   216,     0,     0,     0,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,   220,   221,     0,   222,
     223,     0,     0,     0,     0,     0,     0,   224,     0,   225,
       0,     0,     0,   226,     0,     0,   227,     0,     0,     0,
       0,     0,   228,     0,   229,     0,     0,   230,     0,   231,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   232,
     233,   234,   235,   236,   237,     0,   238,   239,   240,   241,
     242,   243,   244,   245,   246,     0,   247,   248,   249,     0,
     250,   251,     0,     0,     0,   252,   253,   254,   255,   256,
       0,     0,   257,   258,     0,     0,   259,     0,   260,     0,
     261,     0,     0,   262,   263,   264,   265,   266,   267,   268,
       0,     0,   269,   270,     0,   271,   272,   273,     0,     0,
       0,   274,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,   279,   280,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   281,   282,   283,   284,     0,   285,
       0,   286,     0,   287,     0,     0,   288,   289,     0,   290,
       0,   291,   292,   293,   294,     0,   295,   296,   297,   298,
     299,   300,   301,   302,     0,     0,     0,     0,   303,   304,
       0,     0,   305,   306,   307,     0,   308,     0,   309,   310,
       0,     0,   311,     0,   312,   313,   314,     0,   315,   316,
       0,     0,     0,   317,   318,     0,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,   327,
     328,   329,     0,     0,   330,     0,     0,     0,   331,   332,
     333,   334,     0,   335,   336,   337,     0,     0,     0,     0,
       0,     0,   338,   339,     0,   340,     0,     0,   341,     0,
       0,   342,   343,     0,     0,   344,   345,     0,   346,   347,
     348,     0,     0,     0,   349,   350,   351,   352,     0,   353,
     354,     0,   355,   356,     0,     0,   357,   358,   359,   360,
     361,     0,     0,     0,     0,     0,   362,     0,   363,     0,
       0,   364,   365,   366,   367,     0,     0,   368,   369,     0,
       0,   370,     0,     0,     0,     0,   371,     0,     0,   372,
       0,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,     0,     0,   377,     0,     0,   378,   379,
     380,     0,     0,     0,     0,   381,     0,   382,   383,     0,
       0,     0,   384,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,   420,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,     0,   161,     0,   162,
     163,     0,     0,     0,     0,   164,     0,     0,   165,     0,
       0,     0,     0,     0,     0,   166,   167,     0,     0,   168,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,   171,     0,   172,     0,     0,     0,     0,     0,   173,
       0,   174,   175,   176,     0,     0,     0,   177,     0,     0,
     178,   179,   180,     0,     0,     0,   181,     0,     0,     0,
     182,   183,   184,   185,     0,     0,   186,     0,   187,   188,
     189,     0,     0,   190,     0,   474,     0,     0,   192,   193,
       0,     0,   194,   195,   196,     0,     0,   197,     0,     0,
       0,     0,   198,   199,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,   202,   203,     0,     0,   204,
     205,     0,   206,     0,     0,     0,     0,     0,   207,   208,
       0,   209,     0,     0,   210,     0,     0,     0,   211,   212,
     213,   214,     0,     0,   215,   216,     0,     0,     0,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,   220,
     221,     0,   222,   223,     0,     0,     0,     0,     0,     0,
     224,     0,   225,     0,     0,     0,   226,     0,     0,   227,
       0,     0,     0,     0,     0,   228,     0,   229,     0,     0,
     230,     0,   231,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   232,   233,   234,   235,   236,   237,     0,   238,
     239,   240,   241,   242,   243,   244,   245,   246,     0,   247,
     248,   249,     0,   250,   251,     0,     0,     0,   252,   253,
     254,   255,   256,     0,     0,   257,   258,     0,     0,   259,
       0,   260,     0,   261,     0,     0,   262,   263,   264,   265,
     266,   267,   268,     0,     0,   269,   270,     0,   271,   272,
     273,     0,     0,     0,   274,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,   279,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   281,   282,   283,
     284,     0,   285,     0,   286,     0,   287,     0,     0,   288,
     289,     0,   290,     0,   291,   292,   293,   294,     0,   295,
     296,   297,   298,   299,   300,   301,   302,     0,     0,     0,
       0,   303,   304,     0,     0,   305,   306,   307,     0,   308,
       0,   309,   310,     0,     0,   311,     0,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,     0,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,   327,   328,   329,     0,     0,   330,     0,     0,
       0,   331,   332,   333,   334,     0,   335,   336,   337,     0,
       0,     0,     0,     0,     0,   338,   339,     0,   340,     0,
       0,   341,     0,     0,   342,   343,     0,     0,   344,   345,
       0,   346,   347,   348,     0,     0,     0,   349,   350,   351,
     352,     0,   353,   354,     0,   355,   356,     0,     0,   357,
     358,   359,   360,   361,     0,     0,     0,     0,     0,   362,
       0,   363,     0,     0,   364,   365,   366,   367,     0,     0,
     368,   369,     0,     0,   370,     0,     0,     0,     0,   371,
       0,     0,   372,     0,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,     0,     0,   377,     0,
       0,   378,   379,   380,     0,     0,     0,     0,   381,     0,
     382,   383,     0,     0,     0,   384,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,   420,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,     0,
     161,     0,   162,   163,     0,     0,     0,     0,   164,     0,
       0,   165,     0,     0,     0,     0,     0,     0,   166,   167,
       0,     0,   168,     0,     0,     0,     0,   169,   170,     0,
       0,     0,     0,     0,   171,     0,   172,     0,     0,     0,
       0,     0,   173,     0,   174,   175,   176,     0,     0,     0,
     177,     0,     0,   178,   179,   180,     0,     0,     0,   181,
       0,     0,     0,   182,   183,   184,   185,     0,     0,   186,
       0,   187,   188,   189,     0,     0,   190,     0,   191,     0,
       0,   192,   193,     0,     0,   194,   195,   196,     0,     0,
     197,     0,     0,     0,     0,   198,   199,     0,     0,   200,
       0,   201,     0,     0,     0,     0,     0,     0,   202,   203,
       0,     0,   204,   205,     0,   206,     0,     0,     0,     0,
       0,   207,   208,     0,   209,     0,     0,   210,     0,     0,
       0,   211,   212,   213,   214,     0,     0,   215,   216,     0,
       0,     0,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,   220,   221,     0,   222,   223,     0,     0,     0,
       0,     0,     0,   224,     0,   225,     0,     0,     0,   226,
       0,     0,   227,     0,     0,     0,     0,     0,   228,     0,
     229,     0,     0,   230,     0,   231,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   232,   233,   234,   235,   236,
     237,     0,   238,   239,   240,   241,   242,   243,   244,   245,
     246,     0,   247,   248,   249,     0,   250,   251,     0,     0,
       0,   252,   253,   254,   255,   256,     0,     0,   257,   258,
       0,     0,   259,     0,   260,     0,   261,     0,     0,   262,
     263,   264,   265,   266,   267,   268,     0,     0,   269,   270,
       0,   271,   272,   273,     0,     0,     0,   274,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,   279,   280,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     281,   282,   283,   284,     0,   285,     0,   286,     0,   287,
       0,     0,   288,   289,     0,   290,     0,   291,   292,   293,
     294,     0,   295,   296,   297,   298,   299,   300,   301,   302,
       0,     0,     0,     0,   303,   304,     0,     0,   305,   306,
     307,     0,   308,     0,   309,   310,     0,     0,   311,     0,
     312,   313,   314,     0,   315,   316,     0,     0,     0,   317,
     318,     0,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,   327,   328,   329,     0,     0,
     330,     0,     0,     0,   331,   332,   333,   334,     0,   335,
     336,   337,     0,     0,     0,     0,     0,     0,   338,   339,
       0,   340,     0,     0,   341,     0,     0,   342,   343,     0,
       0,   344,   345,     0,   346,   347,   348,     0,     0,     0,
     349,   350,   351,   352,     0,   353,   354,     0,   355,   356,
       0,     0,   357,   358,   359,   360,   361,     0,     0,     0,
       0,     0,   362,     0,   363,     0,     0,   364,   365,   366,
     367,     0,     0,   368,   369,     0,     0,   370,     0,     0,
       0,     0,   371,     0,     0,   372,     0,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,     0,
       0,   377,     0,     0,   378,   379,   380,     0,     0,     0,
       0,   381,     0,   382,   383,     0,     0,     0,   384,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,   884,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,     0,   161,     0,   162,   163,     0,     0,     0,
       0,   164,     0,     0,   165,     0,     0,     0,     0,     0,
       0,   166,   167,     0,     0,   168,     0,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,   171,     0,   172,
       0,     0,     0,     0,     0,   173,     0,   174,   175,   176,
       0,     0,     0,   177,     0,     0,   178,   179,   180,     0,
       0,     0,   181,     0,     0,     0,   182,   183,   184,   185,
       0,     0,   186,     0,   187,   188,   189,     0,     0,   190,
       0,   191,     0,     0,   192,   193,     0,     0,   194,   195,
     196,     0,     0,   197,     0,     0,     0,     0,   198,   199,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,   202,   203,     0,     0,   204,   205,     0,   206,     0,
       0,     0,     0,     0,   207,   208,     0,   209,     0,     0,
     210,     0,     0,     0,   211,   212,   213,   214,     0,     0,
     215,   216,     0,     0,     0,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,   220,   221,     0,   222,   223,
       0,     0,     0,     0,     0,     0,   224,     0,   225,     0,
       0,     0,   226,     0,     0,   227,     0,     0,     0,     0,
       0,   228,     0,   229,     0,     0,   230,     0,   231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   232,   233,
     234,   235,   236,   237,     0,   238,   239,   240,   241,   242,
     243,   244,   245,   246,     0,   247,   248,   249,     0,   250,
     251,     0,     0,     0,   252,   253,   254,   255,   256,     0,
       0,   257,   258,     0,     0,   259,     0,   260,     0,   261,
       0,     0,   262,   263,   264,   265,   266,   267,   268,     0,
       0,   269,   270,     0,   271,   272,   273,     0,     0,     0,
     274,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,   279,   280,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   281,   282,   283,   284,     0,   285,     0,
     286,     0,   287,     0,     0,   288,   289,     0,   290,     0,
     291,   292,   293,   294,     0,   295,   296,   297,   298,   299,
     300,   301,   302,     0,     0,     0,     0,   303,   304,     0,
       0,   305,   306,   307,     0,   308,     0,   309,   310,     0,
       0,   311,     0,   312,   313,   314,     0,   315,   316,     0,
       0,     0,   317,   318,     0,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,   327,   328,
     329,     0,     0,   330,     0,     0,     0,   331,   332,   333,
     334,     0,   335,   336,   337,     0,     0,     0,     0,     0,
       0,   338,   339,     0,   340,     0,     0,   341,     0,     0,
     342,   343,     0,     0,   344,   345,     0,   346,   347,   348,
       0,     0,     0,   349,   350,   351,   352,     0,   353,   354,
       0,   355,   356,     0,     0,   357,   358,   359,   360,   361,
       0,     0,     0,     0,     0,   362,     0,   363,     0,     0,
     364,   365,   366,   367,     0,     0,   368,   369,     0,     0,
     370,     0,     0,     0,     0,   371,     0,     0,   372,     0,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,     0,     0,   377,     0,     0,   378,   379,   380,
       0,     0,     0,     0,   381,     0,   382,   383,     0,     0,
       0,   384,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,  2014,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,     0,   161,     0,   162,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,   170,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,   177,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,   182,
     183,   184,   185,     0,     0,   186,     0,   187,   188,   189,
       0,     0,   190,     0,   191,     0,     0,   192,   193,     0,
       0,   194,   195,   196,     0,     0,   197,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,   207,   208,     0,
     209,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,     0,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,     0,     0,     0,     0,     0,     0,   224,
       0,   225,     0,     0,     0,   226,     0,     0,   227,   559,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,   274,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,   280,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,   288,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
     309,   310,     0,     0,   311,     0,   312,   313,   314,     0,
     315,   316,     0,     0,     0,   317,   318,     0,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,   332,   333,   334,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,   342,   343,     0,     0,   344,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,   560,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,   364,   365,   366,   367,     0,     0,   368,
     369,     0,     0,   370,     0,     0,     0,     0,   371,     0,
       0,   372,     0,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,     0,     0,   381,     0,   382,
     383,     0,     0,   122,   384,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,  1775,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,     0,   161,     0,   162,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,   170,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,   177,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,   182,
     183,   184,   185,     0,     0,   186,     0,   187,   188,   189,
       0,     0,   190,     0,   191,     0,     0,   192,   193,     0,
       0,   194,   195,   196,     0,     0,   197,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,   207,   208,     0,
     209,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,     0,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,     0,     0,     0,     0,     0,     0,   224,
       0,   225,     0,     0,     0,   226,     0,     0,   227,   559,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,   274,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,   280,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,   288,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
     309,   310,     0,     0,   311,     0,   312,   313,   314,     0,
     315,   316,     0,     0,     0,   317,   318,     0,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,   332,   333,   334,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,   342,   343,     0,     0,   344,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,   560,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,   364,   365,   366,   367,     0,     0,   368,
     369,     0,     0,   370,     0,     0,     0,     0,   371,     0,
       0,   372,     0,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,     0,     0,   381,     0,   382,
     383,     0,     0,   122,   384,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,  2327,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,     0,   161,     0,   162,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,   170,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,   177,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,   182,
     183,   184,   185,     0,     0,   186,     0,   187,   188,   189,
       0,     0,   190,     0,   191,     0,     0,   192,   193,     0,
       0,   194,   195,   196,     0,     0,   197,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,   207,   208,     0,
     209,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,     0,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,     0,     0,     0,     0,     0,     0,   224,
       0,   225,     0,     0,     0,   226,     0,     0,   227,   559,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,   274,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,   280,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,   288,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
     309,   310,     0,     0,   311,     0,   312,   313,   314,     0,
     315,   316,     0,     0,     0,   317,   318,     0,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,   332,   333,   334,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,   342,   343,     0,     0,   344,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,   560,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,   364,   365,   366,   367,     0,     0,   368,
     369,     0,     0,   370,     0,     0,     0,     0,   371,     0,
       0,   372,     0,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,     0,     0,   381,     0,   382,
     383,     0,     0,   122,   384,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,  2922,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3491,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,     0,   161,     0,     0,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,     0,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,     0,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,     0,
     183,   184,   185,     0,     0,   186,     0,   187,   188,     0,
       0,     0,   190,     0,   191,     0,     0,   192,   193,  3492,
       0,   194,   195,   196,     0,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,  3493,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,  3494,     0,     0,     0,     0,     0,     0,
       0,   225,     0,     0,     0,   226,  3495,     0,   227,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,  3496,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,     0,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
       0,   310,  -185,     0,   311,     0,     0,   313,     0,     0,
     315,   316,  3497,     0,     0,     0,   318,     0,   319,   320,
       0,   321,   322,   323,     0,     0,   325,     0,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,     0,   333,     0,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,     0,   343,     0,     0,     0,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,     0,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,     0,   365,   366,   367,     0,     0,   368,
     369,     0,     0,     0,     0,     0,     0,     0,   371,     0,
       0,   372,     0,     0,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,  -185,     0,   381,     0,   382,
       0,     0,     0,     0,   384,     0,     0,     0,     0,  3498,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,  3695,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,     0,   161,     0,   162,   163,     0,     0,     0,
       0,   164,     0,     0,   165,     0,     0,     0,     0,     0,
       0,   166,   167,     0,     0,   168,     0,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,   171,     0,   172,
       0,     0,     0,     0,     0,   173,     0,   174,   175,   176,
       0,     0,     0,   177,     0,     0,   178,   179,   180,     0,
       0,     0,   181,     0,     0,     0,   182,   183,   184,   185,
       0,     0,   186,     0,   187,   188,   189,     0,     0,   190,
       0,   191,     0,     0,   192,   193,     0,     0,   194,   195,
     196,     0,     0,   197,     0,     0,     0,     0,   198,   199,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,   202,   203,     0,     0,   204,   205,     0,   206,     0,
       0,     0,     0,     0,   207,   208,     0,   209,     0,     0,
     210,     0,     0,     0,   211,   212,   213,   214,     0,     0,
     215,   216,     0,     0,     0,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,   220,   221,     0,   222,   223,
       0,     0,     0,     0,     0,     0,   224,     0,   225,     0,
       0,     0,   226,     0,     0,   227,     0,     0,     0,     0,
       0,   228,     0,   229,     0,     0,   230,     0,   231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   232,   233,
     234,   235,   236,   237,     0,   238,   239,   240,   241,   242,
     243,   244,   245,   246,     0,   247,   248,   249,     0,   250,
     251,     0,     0,     0,   252,   253,   254,   255,   256,     0,
       0,   257,   258,     0,     0,   259,     0,   260,     0,   261,
       0,     0,   262,   263,   264,   265,   266,   267,   268,     0,
       0,   269,   270,     0,   271,   272,   273,     0,     0,     0,
     274,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,   279,   280,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   281,   282,   283,   284,     0,   285,     0,
     286,     0,   287,     0,     0,   288,   289,     0,   290,     0,
     291,   292,   293,   294,     0,   295,   296,   297,   298,   299,
     300,   301,   302,     0,     0,     0,     0,   303,   304,     0,
       0,   305,   306,   307,     0,   308,     0,   309,   310,     0,
       0,   311,     0,   312,   313,   314,     0,   315,   316,     0,
       0,     0,   317,   318,     0,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,   327,   328,
     329,     0,     0,   330,     0,     0,     0,   331,   332,   333,
     334,     0,   335,   336,   337,     0,     0,     0,     0,     0,
       0,   338,   339,     0,   340,     0,     0,   341,     0,     0,
     342,   343,     0,     0,   344,   345,     0,   346,   347,   348,
       0,     0,     0,   349,   350,   351,   352,     0,   353,   354,
       0,   355,   356,     0,     0,   357,   358,   359,   360,   361,
       0,     0,     0,     0,     0,   362,     0,   363,     0,     0,
     364,   365,   366,   367,     0,     0,   368,   369,     0,     0,
     370,     0,     0,     0,     0,   371,     0,     0,   372,     0,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,     0,     0,   377,     0,     0,   378,   379,   380,
       0,     0,     0,     0,   381,     0,   382,   383,     0,     0,
       0,   384,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  1618,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,     0,   161,     0,   162,   163,     0,
       0,     0,     0,   164,     0,     0,   165,     0,     0,     0,
       0,     0,     0,   166,   167,     0,     0,   168,     0,     0,
       0,     0,   169,   170,     0,     0,     0,     0,     0,   171,
       0,   172,     0,     0,     0,     0,     0,   173,     0,   174,
     175,   176,     0,     0,     0,   177,     0,     0,   178,   179,
     180,     0,     0,     0,   181,     0,     0,     0,   182,   183,
     184,   185,     0,     0,   186,     0,   187,   188,   189,     0,
       0,   190,     0,   191,     0,     0,   192,   193,     0,     0,
     194,   195,   196,     0,     0,   197,     0,     0,     0,     0,
     198,   199,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,   202,   203,     0,     0,   204,   205,     0,
     206,     0,     0,     0,     0,     0,   207,   208,     0,   209,
       0,     0,   210,     0,     0,     0,   211,   212,   213,   214,
       0,     0,   215,   216,     0,     0,     0,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,   220,   221,     0,
     222,   223,     0,     0,     0,     0,     0,     0,   224,     0,
     225,     0,     0,     0,   226,     0,     0,   227,     0,     0,
       0,     0,     0,   228,     0,   229,     0,     0,   230,     0,
     231,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     232,   233,   234,   235,   236,   237,     0,   238,   239,   240,
     241,   242,   243,   244,   245,   246,     0,   247,   248,   249,
       0,   250,   251,     0,     0,     0,   252,   253,   254,   255,
     256,     0,     0,   257,   258,     0,     0,   259,     0,   260,
       0,   261,     0,     0,   262,   263,   264,   265,   266,   267,
     268,     0,     0,   269,   270,     0,   271,   272,   273,     0,
       0,     0,   274,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,   279,   280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   281,   282,   283,   284,     0,
     285,     0,   286,     0,   287,     0,     0,   288,   289,     0,
     290,     0,   291,   292,   293,   294,     0,   295,   296,   297,
     298,   299,   300,   301,   302,     0,     0,     0,     0,   303,
     304,     0,     0,   305,   306,   307,     0,   308,     0,   309,
     310,     0,     0,   311,     0,   312,   313,   314,     0,   315,
     316,     0,     0,     0,   317,   318,     0,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
     327,   328,   329,     0,     0,   330,     0,     0,     0,   331,
     332,   333,   334,     0,   335,   336,   337,     0,     0,     0,
       0,     0,     0,   338,   339,     0,   340,     0,     0,   341,
       0,     0,   342,   343,     0,     0,   344,   345,     0,   346,
     347,   348,     0,     0,     0,   349,   350,   351,   352,     0,
     353,   354,     0,   355,   356,     0,     0,   357,   358,   359,
     360,   361,     0,     0,     0,     0,     0,   362,     0,   363,
       0,     0,   364,   365,   366,   367,     0,     0,   368,   369,
       0,     0,   370,     0,     0,     0,     0,   371,     0,     0,
     372,     0,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,     0,     0,   377,     0,     0,   378,
     379,   380,     0,     0,     0,     0,   381,     0,   382,   383,
       0,     0,     0,   384,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2313,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,     0,   161,     0,   162,
     163,     0,     0,     0,     0,   164,     0,     0,   165,     0,
       0,     0,     0,     0,     0,   166,   167,     0,     0,   168,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,   171,     0,   172,     0,     0,     0,     0,     0,   173,
       0,   174,   175,   176,     0,     0,     0,   177,     0,     0,
     178,   179,   180,     0,     0,     0,   181,     0,     0,     0,
     182,   183,   184,   185,     0,     0,   186,     0,   187,   188,
     189,     0,     0,   190,     0,   191,     0,     0,   192,   193,
       0,     0,   194,   195,   196,     0,     0,   197,     0,     0,
       0,     0,   198,   199,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,   202,   203,     0,     0,   204,
     205,     0,   206,     0,     0,     0,     0,     0,   207,   208,
       0,   209,     0,     0,   210,     0,     0,     0,   211,   212,
     213,   214,     0,     0,   215,   216,     0,     0,     0,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,   220,
     221,     0,   222,   223,     0,     0,     0,     0,     0,     0,
     224,     0,   225,     0,     0,     0,   226,     0,     0,   227,
       0,     0,     0,     0,     0,   228,     0,   229,     0,     0,
     230,     0,   231,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   232,   233,   234,   235,   236,   237,     0,   238,
     239,   240,   241,   242,   243,   244,   245,   246,     0,   247,
     248,   249,     0,   250,   251,     0,     0,     0,   252,   253,
     254,   255,   256,     0,     0,   257,   258,     0,     0,   259,
       0,   260,     0,   261,     0,     0,   262,   263,   264,   265,
     266,   267,   268,     0,     0,   269,   270,     0,   271,   272,
     273,     0,     0,     0,   274,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,   279,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   281,   282,   283,
     284,     0,   285,     0,   286,     0,   287,     0,     0,   288,
     289,     0,   290,     0,   291,   292,   293,   294,     0,   295,
     296,   297,   298,   299,   300,   301,   302,     0,     0,     0,
       0,   303,   304,     0,     0,   305,   306,   307,     0,   308,
       0,   309,   310,     0,     0,   311,     0,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,     0,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,   327,   328,   329,     0,     0,   330,     0,     0,
       0,   331,   332,   333,   334,     0,   335,   336,   337,     0,
       0,     0,     0,     0,     0,   338,   339,     0,   340,     0,
       0,   341,     0,     0,   342,   343,     0,     0,   344,   345,
       0,   346,   347,   348,     0,     0,     0,   349,   350,   351,
     352,     0,   353,   354,     0,   355,   356,     0,     0,   357,
     358,   359,   360,   361,     0,     0,     0,     0,     0,   362,
       0,   363,     0,     0,   364,   365,   366,   367,     0,     0,
     368,   369,     0,     0,   370,     0,     0,     0,     0,   371,
       0,     0,   372,     0,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,     0,     0,   377,     0,
       0,   378,   379,   380,     0,     0,     0,     0,   381,     0,
     382,   383,     0,     0,     0,   384,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,  2603,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,     0,   161,
       0,   162,   163,     0,     0,     0,     0,   164,     0,     0,
     165,     0,     0,     0,     0,     0,     0,   166,   167,     0,
       0,   168,     0,     0,     0,     0,   169,   170,     0,     0,
       0,     0,     0,   171,     0,   172,     0,     0,     0,     0,
       0,   173,     0,   174,   175,   176,     0,     0,     0,   177,
       0,     0,   178,   179,   180,     0,     0,     0,   181,     0,
       0,     0,   182,   183,   184,   185,     0,     0,   186,     0,
     187,   188,   189,     0,     0,   190,     0,   191,     0,     0,
     192,   193,     0,     0,   194,   195,   196,     0,     0,   197,
       0,     0,     0,     0,   198,   199,     0,     0,   200,     0,
     201,     0,     0,     0,     0,     0,     0,   202,   203,     0,
       0,   204,   205,     0,   206,     0,     0,     0,     0,     0,
     207,   208,     0,   209,     0,     0,   210,     0,     0,     0,
     211,   212,   213,   214,     0,     0,   215,   216,     0,     0,
       0,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,   220,   221,     0,   222,   223,     0,     0,     0,     0,
       0,     0,   224,     0,   225,     0,     0,     0,   226,     0,
       0,   227,     0,     0,     0,     0,     0,   228,     0,   229,
       0,     0,   230,     0,   231,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   232,   233,   234,   235,   236,   237,
       0,   238,   239,   240,   241,   242,   243,   244,   245,   246,
       0,   247,   248,   249,     0,   250,   251,     0,     0,     0,
     252,   253,   254,   255,   256,     0,     0,   257,   258,     0,
       0,   259,     0,   260,     0,   261,     0,     0,   262,   263,
     264,   265,   266,   267,   268,     0,     0,   269,   270,     0,
     271,   272,   273,     0,     0,     0,   274,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,   279,   280,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   281,
     282,   283,   284,     0,   285,     0,   286,     0,   287,     0,
       0,   288,   289,     0,   290,     0,   291,   292,   293,   294,
       0,   295,   296,   297,   298,   299,   300,   301,   302,     0,
       0,     0,     0,   303,   304,     0,     0,   305,   306,   307,
       0,   308,     0,   309,   310,     0,     0,   311,     0,   312,
     313,   314,     0,   315,   316,     0,     0,     0,   317,   318,
       0,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,   327,   328,   329,     0,     0,   330,
       0,     0,     0,   331,   332,   333,   334,     0,   335,   336,
     337,     0,     0,     0,     0,     0,     0,   338,   339,     0,
     340,     0,     0,   341,     0,     0,   342,   343,     0,     0,
     344,   345,     0,   346,   347,   348,     0,     0,     0,   349,
     350,   351,   352,     0,   353,   354,     0,   355,   356,     0,
       0,   357,   358,   359,   360,   361,     0,     0,     0,     0,
       0,   362,     0,   363,     0,     0,   364,   365,   366,   367,
       0,     0,   368,   369,     0,     0,   370,     0,     0,     0,
       0,   371,     0,     0,   372,     0,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,     0,     0,
     377,     0,     0,   378,   379,   380,     0,     0,     0,     0,
     381,     0,   382,   383,     0,     0,     0,   384,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,  2927,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -185,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3491,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
       0,   161,     0,     0,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,     0,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,  -200,     0,
     181,     0,     0,     0,  -200,   183,   184,   185,     0,     0,
     186,     0,   187,   188,     0,     0,     0,   190,     0,   191,
       0,     0,   192,   193,  3492,     0,   194,   195,   196,     0,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,     0,   208,     0,     0,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,  3493,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,  3494,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,     0,
     226,  3495,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
    3496,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,     0,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,     0,   310,  -185,     0,   311,
       0,     0,   313,     0,     0,   315,   316,  3497,     0,     0,
       0,   318,     0,   319,   320,     0,   321,   322,   323,     0,
       0,   325,     0,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,     0,   333,     0,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,     0,   343,
       0,     0,     0,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,     0,   365,
     366,   367,     0,     0,   368,   369,     0,     0,     0,     0,
       0,     0,     0,   371,     0,     0,   372,     0,     0,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
    -185,     0,   381,     0,   382,     0,     0,     0,     0,   384,
       0,     0,  -200,   122,  3498,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3491,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,     0,   161,     0,     0,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,     0,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,     0,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,  -221,
     183,   184,   185,     0,     0,   186,     0,   187,   188,     0,
       0,     0,   190,     0,   191,     0,     0,   192,   193,  3492,
       0,   194,   195,   196,     0,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,  3493,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,  3494,     0,     0,     0,     0,     0,     0,
       0,   225,     0,     0,     0,   226,  3495,     0,   227,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,  3496,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,     0,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
       0,   310,  -185,     0,   311,     0,     0,   313,     0,     0,
     315,   316,  3497,     0,     0,     0,   318,     0,   319,   320,
       0,   321,   322,   323,     0,     0,   325,     0,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,     0,   333,     0,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,     0,   343,     0,     0,     0,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,     0,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,     0,   365,   366,   367,     0,     0,   368,
     369,     0,     0,     0,     0,     0,     0,     0,   371,     0,
       0,   372,     0,     0,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,  -221,     0,  -185,     0,   381,     0,   382,
       0,     0,     0,     0,   384,     0,     0,  -221,   122,  3498,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -185,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3491,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
       0,   161,     0,     0,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,     0,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,  -218,   183,   184,   185,     0,     0,
     186,     0,   187,   188,     0,     0,     0,   190,     0,   191,
       0,     0,   192,   193,  3492,     0,   194,   195,   196,     0,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,     0,   208,     0,     0,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,  3493,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,  3494,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,     0,
     226,  3495,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
    3496,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,     0,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,     0,   310,  -185,     0,   311,
       0,     0,   313,     0,     0,   315,   316,  3497,     0,     0,
       0,   318,     0,   319,   320,     0,   321,   322,   323,     0,
       0,   325,     0,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,     0,   333,     0,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,     0,   343,
       0,     0,     0,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,     0,   365,
     366,   367,     0,     0,   368,   369,     0,     0,     0,     0,
       0,     0,     0,   371,     0,     0,   372,     0,     0,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,  -218,     0,
    -185,     0,   381,     0,   382,     0,     0,     0,     0,   384,
       0,     0,  -218,   122,  3498,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3491,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,     0,   161,     0,     0,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,     0,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,     0,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,  3577,
     183,   184,   185,     0,     0,   186,     0,   187,   188,     0,
       0,     0,   190,     0,   191,     0,     0,   192,   193,  3492,
       0,   194,   195,   196,     0,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,  3493,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,  3494,     0,     0,     0,     0,     0,     0,
       0,   225,     0,     0,     0,   226,  3495,     0,   227,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,  3496,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,     0,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
       0,   310,  -185,     0,   311,     0,     0,   313,     0,     0,
     315,   316,  3497,     0,     0,     0,   318,     0,   319,   320,
       0,   321,   322,   323,     0,     0,   325,     0,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,     0,   333,     0,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,     0,   343,     0,     0,     0,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,     0,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,     0,   365,   366,   367,     0,     0,   368,
     369,     0,     0,     0,     0,     0,     0,     0,   371,     0,
       0,   372,     0,     0,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,  -185,     0,   381,     0,   382,
       0,     0,     0,     0,   384,     0,     0,     0,   122,  3498,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -185,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3491,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
       0,   161,     0,     0,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,     0,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,  -223,   183,   184,   185,     0,     0,
     186,     0,   187,   188,     0,     0,     0,   190,     0,   191,
       0,     0,   192,   193,  3492,     0,   194,   195,   196,     0,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,     0,   208,     0,     0,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,  3493,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,  3494,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,     0,
     226,  3495,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
    3496,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,     0,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,     0,   310,  -185,     0,   311,
       0,     0,   313,     0,     0,   315,   316,  3497,     0,     0,
       0,   318,     0,   319,   320,     0,   321,   322,   323,     0,
       0,   325,     0,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,     0,   333,     0,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,     0,   343,
       0,     0,     0,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,     0,   365,
     366,   367,     0,     0,   368,   369,     0,     0,     0,     0,
       0,     0,     0,   371,     0,     0,   372,     0,     0,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
    -185,     0,   381,     0,   382,     0,     0,     0,     0,   384,
       0,     0,     0,   122,  3498,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3491,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,     0,   161,     0,     0,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,     0,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,     0,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,  3632,
     183,   184,   185,     0,     0,   186,     0,   187,   188,     0,
       0,     0,   190,     0,   191,     0,     0,   192,   193,  3492,
       0,   194,   195,   196,     0,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,  3493,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,  3494,     0,     0,     0,     0,     0,     0,
       0,   225,     0,     0,     0,   226,  3495,     0,   227,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,  3496,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,     0,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
       0,   310,  -185,     0,   311,     0,     0,   313,     0,     0,
     315,   316,  3497,     0,     0,     0,   318,     0,   319,   320,
       0,   321,   322,   323,     0,     0,   325,     0,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,     0,   333,     0,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,     0,   343,     0,     0,     0,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,     0,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,     0,   365,   366,   367,     0,     0,   368,
     369,     0,     0,     0,     0,     0,     0,     0,   371,     0,
       0,   372,     0,     0,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,  -185,     0,   381,     0,   382,
       0,     0,     0,     0,   384,     0,     0,     0,   122,  3498,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -185,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3491,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
       0,   161,     0,     0,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,     0,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,  3667,   183,   184,   185,     0,     0,
     186,     0,   187,   188,     0,     0,     0,   190,     0,   191,
       0,     0,   192,   193,  3492,     0,   194,   195,   196,     0,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,     0,   208,     0,     0,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,  3493,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,  3494,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,     0,
     226,  3495,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
    3496,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,     0,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,     0,   310,  -185,     0,   311,
       0,     0,   313,     0,     0,   315,   316,  3497,     0,     0,
       0,   318,     0,   319,   320,     0,   321,   322,   323,     0,
       0,   325,     0,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,     0,   333,     0,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,     0,   343,
       0,     0,     0,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,     0,   365,
     366,   367,     0,     0,   368,   369,     0,     0,     0,     0,
       0,     0,     0,   371,     0,     0,   372,     0,     0,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
    -185,     0,   381,     0,   382,     0,     0,     0,     0,   384,
       0,     0,     0,   122,  3498,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3491,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,     0,   161,     0,     0,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,     0,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,     0,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,  -204,
     183,   184,   185,     0,     0,   186,     0,   187,   188,     0,
       0,     0,   190,     0,   191,     0,     0,   192,   193,  3492,
       0,   194,   195,   196,     0,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,  3493,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,  3494,     0,     0,     0,     0,     0,     0,
       0,   225,     0,     0,     0,   226,  3495,     0,   227,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,  3496,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,     0,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
       0,   310,  -185,     0,   311,     0,     0,   313,     0,     0,
     315,   316,  3497,     0,     0,     0,   318,     0,   319,   320,
       0,   321,   322,   323,     0,     0,   325,     0,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,     0,   333,     0,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,     0,   343,     0,     0,     0,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,     0,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,     0,   365,   366,   367,     0,     0,   368,
     369,     0,     0,     0,     0,     0,     0,     0,   371,     0,
       0,   372,     0,     0,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,  -185,     0,   381,     0,   382,
       0,     0,     0,     0,   384,     0,     0,     0,   122,  3498,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -185,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3491,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
       0,   161,     0,     0,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,     0,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,     0,   183,   184,   185,     0,     0,
     186,     0,   187,   188,     0,     0,     0,   190,     0,   191,
       0,     0,   192,   193,  3492,     0,   194,   195,   196,     0,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,     0,   208,     0,     0,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,  3493,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,  3494,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,     0,
     226,  3495,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
    3496,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,     0,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,     0,   310,  -185,     0,   311,
       0,     0,   313,     0,     0,   315,   316,  3497,     0,     0,
       0,   318,     0,   319,   320,     0,   321,   322,   323,     0,
       0,   325,     0,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,     0,   333,     0,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,     0,   343,
       0,     0,     0,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,     0,   365,
     366,   367,     0,     0,   368,   369,     0,     0,     0,     0,
       0,     0,     0,   371,     0,     0,   372,     0,     0,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
    -185,     0,   381,     0,   382,     0,     0,     0,     0,   384,
       0,     0,     0,   122,  3498,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3491,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,     0,   161,     0,     0,   163,
       0,     0,     0,     0,   164,     0,     0,   165,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,   168,     0,
       0,     0,     0,   169,     0,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,   173,     0,
     174,   175,   176,     0,     0,     0,     0,     0,     0,   178,
     179,   180,     0,     0,     0,   181,     0,     0,     0,     0,
     183,   184,   185,     0,     0,   186,     0,   187,   188,     0,
       0,     0,   190,     0,   191,     0,     0,   192,   193,  3492,
       0,   194,   195,   196,     0,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,   202,   203,     0,     0,   204,   205,
       0,   206,     0,     0,     0,     0,     0,     0,   208,     0,
       0,     0,     0,   210,     0,     0,     0,   211,   212,   213,
     214,  3493,     0,   215,   216,     0,     0,     0,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,   220,   221,
       0,   222,   223,  3494,     0,     0,     0,     0,     0,     0,
       0,   225,     0,     0,     0,   226,  3495,     0,   227,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,   230,
       0,   231,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   232,   233,   234,   235,   236,   237,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   247,   248,
     249,     0,   250,   251,     0,     0,     0,   252,   253,   254,
     255,   256,     0,     0,   257,   258,     0,     0,   259,     0,
     260,     0,   261,     0,     0,   262,   263,   264,   265,   266,
     267,   268,     0,     0,   269,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,   279,  3496,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   281,   282,   283,   284,
       0,   285,     0,   286,     0,   287,     0,     0,     0,   289,
       0,   290,     0,   291,   292,   293,   294,     0,   295,   296,
     297,   298,   299,   300,   301,   302,     0,     0,     0,     0,
     303,   304,     0,     0,   305,   306,   307,     0,   308,     0,
       0,   310,  -185,     0,   311,     0,     0,   313,     0,     0,
     315,   316,  3497,     0,     0,     0,   318,     0,   319,   320,
       0,   321,   322,   323,     0,     0,   325,     0,     0,     0,
       0,   327,   328,   329,     0,     0,   330,     0,     0,     0,
     331,     0,   333,     0,     0,   335,   336,   337,     0,     0,
       0,     0,     0,     0,   338,   339,     0,   340,     0,     0,
     341,     0,     0,     0,   343,     0,     0,     0,   345,     0,
     346,   347,   348,     0,     0,     0,   349,   350,   351,   352,
       0,   353,   354,     0,   355,   356,     0,     0,   357,   358,
     359,   360,   361,     0,     0,     0,     0,     0,   362,     0,
     363,     0,     0,     0,   365,   366,   367,     0,     0,   368,
     369,     0,     0,     0,     0,     0,     0,     0,   371,     0,
       0,  3580,     0,     0,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,     0,     0,   377,     0,     0,
     378,   379,   380,     0,     0,  -185,     0,   381,     0,   382,
       0,     0,     0,     0,   384,     0,     0,     0,   122,  3498,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
    1628,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,  1629,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,  1630,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
    1631,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,   711,   712,     0,   274,     0,
       0,  1632,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,  3684,  3675,  3685,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,  1633,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2319,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,  2320,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,  1952,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,   559,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
    1953,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2329,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,  2330,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,   559,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2319,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,  2320,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,   559,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,   715,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,   559,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,   667,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,   668,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   669,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,  2368,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,   559,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2319,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,   559,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,   559,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,  2309,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,  3627,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,  3628,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,   734,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,  1108,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,  1900,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,  1901,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,  2020,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,   560,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,  1900,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
       0,   161,     0,   162,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,   177,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,   182,   183,   184,   185,     0,     0,
     186,     0,   187,   188,   189,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,  1407,   196,     0,
       0,   197,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,   207,   208,     0,   209,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,   224,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,  1408,   273,     0,     0,     0,   274,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,   288,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,   309,   310,     0,     0,   311,
       0,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,     0,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,   332,   333,   334,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,   342,   343,
       0,     0,   344,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,   364,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   370,     0,
       0,     0,     0,   371,     0,     0,   372,     0,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,     0,     0,   378,   379,   380,     0,     0,
       0,     0,   381,     0,   382,   383,     0,     0,   122,   384,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,     0,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,     0,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
       0,   161,     0,     0,   163,     0,     0,     0,     0,   164,
       0,     0,   165,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,     0,     0,   169,     0,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
       0,     0,     0,   173,     0,   174,   175,   176,     0,     0,
       0,     0,     0,     0,   178,   179,   180,     0,     0,     0,
     181,     0,     0,     0,     0,   183,   184,   185,     0,     0,
     186,     0,   187,   188,     0,     0,     0,   190,     0,   191,
       0,     0,   192,   193,     0,     0,   194,   195,   196,     0,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,   202,
     203,     0,     0,   204,   205,     0,   206,     0,     0,     0,
       0,     0,     0,   208,     0,     0,     0,     0,   210,     0,
       0,     0,   211,   212,   213,   214,     0,     0,   215,   216,
       0,     0,     0,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,   220,   221,     0,   222,   223,     0,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,     0,
     226,     0,     0,   227,     0,     0,     0,     0,     0,   228,
       0,   229,     0,     0,   230,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,   233,   234,   235,
     236,   237,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   247,   248,   249,     0,   250,   251,     0,
       0,     0,   252,   253,   254,   255,   256,     0,     0,   257,
     258,     0,     0,   259,     0,   260,     0,   261,     0,     0,
     262,   263,   264,   265,   266,   267,   268,     0,     0,   269,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,   279,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   281,   282,   283,   284,     0,   285,     0,   286,     0,
     287,     0,     0,     0,   289,     0,   290,     0,   291,   292,
     293,   294,     0,   295,   296,   297,   298,   299,   300,   301,
     302,     0,     0,     0,     0,   303,   304,     0,     0,   305,
     306,   307,     0,   308,     0,     0,   310,     0,     0,   311,
       0,     0,   313,     0,     0,   315,   316,     0,     0,     0,
       0,   318,     0,   319,   320,     0,   321,   322,   323,     0,
       0,   325,     0,     0,     0,     0,   327,   328,   329,     0,
       0,   330,     0,     0,     0,   331,     0,   333,     0,     0,
     335,   336,   337,     0,     0,     0,     0,     0,     0,   338,
     339,     0,   340,     0,     0,   341,     0,     0,     0,   343,
       0,     0,     0,   345,     0,   346,   347,   348,     0,     0,
       0,   349,   350,   351,   352,     0,   353,   354,     0,   355,
     356,     0,     0,   357,   358,   359,   360,   361,     0,     0,
       0,     0,     0,   362,     0,   363,     0,     0,     0,   365,
     366,   367,     0,     0,   368,   369,     0,     0,   615,     0,
     577,   616,     0,   371,     0,     0,   372,     0,     0,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
       0,     0,   377,   617,   618,   378,   379,   380,     0,     0,
       0,     0,   381,   619,   382,   620,     0,     0,     0,   384,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   621,     0,   622,     0,     0,     0,     0,
       0,     0,     0,   623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1357,   624,     0,     0,     0,   625,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   626,     0,   627,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   628,
       0,   629,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   630,   631,     0,     0,   632,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   633,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   634,     0,     0,     0,
       0,   635,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   637,     0,
       0,     0,     0,     0,     0,     0,     0,   638,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   639,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   640,   641,     0,     0,   642,   643,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   645,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1799,     0,     0,     0,   646,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   647,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1799,     0,     0,
       0,   648
};

static const short int yycheck[] =
{
       7,   469,   600,   449,   682,   461,   462,   463,   499,   465,
     424,   467,    19,   972,   767,    22,   761,   762,   763,   722,
     723,   724,    29,   576,  1179,  1025,   745,  1181,  1182,  1183,
     524,   623,    39,  1305,   495,   496,   625,  1215,  1087,  1769,
    1194,  1305,    49,    22,   648,   827,  1910,  1851,  1529,  2061,
    1387,  1326,  1934,   108,  1879,   110,  2345,   649,  1333,   648,
    1942,  1542,  1944,  1495,   525,  1903,  1904,  1905,  1213,  2079,
    1614,  1941,  2704,  2294,  1322,     3,  2086,  1207,   456,  1101,
      87,  1917,  1918,   828,  1344,  1345,     3,     3,   582,     3,
    1894,  2681,     3,    18,  1248,  1269,     3,  1251,    16,    32,
     107,   108,   855,   110,  1965,   858,  1971,  1052,    87,   854,
    1971,  1975,  2689,  1974,   121,   508,  1977,  1247,  1063,  1064,
       3,     3,   867,   868,   869,  1279,  1280,  1988,  1989,     3,
    1284,  1995,  1996,   594,    16,    54,  1997,    16,    16,    20,
      27,  1443,   121,    58,    18,    10,  1186,  1187,    34,  1189,
    1304,    32,  1306,    28,    20,    18,    59,    56,   877,   878,
     879,    18,  1336,    95,  1338,    46,    32,    69,    59,  2734,
     686,   686,  2737,  1956,    55,    56,    49,   135,   897,  1619,
      46,  2058,  1509,    11,  1224,   175,    55,    56,    34,    55,
      56,  2756,   147,  2959,   229,   111,   690,  2762,   169,  1239,
      20,    60,   650,   229,   111,    11,    49,    58,   221,   587,
     624,  1617,  2966,   217,    58,  1174,   229,  1257,  1258,  1259,
     145,    20,   115,   129,   289,   156,   682,   156,  1268,  2054,
    2795,   347,   693,    32,   238,    55,    56,   156,   341,    63,
     159,  1966,  1967,   214,  2287,  2389,    32,    46,    52,   179,
     175,  1105,   107,   172,   270,   170,    55,    56,    63,   115,
     131,  1519,    89,   252,    66,   205,    94,    75,  3500,    32,
     301,   145,   130,  1531,  1532,   179,  1534,  1535,  1536,   344,
    1940,  1539,   145,   413,   253,   111,  1544,    96,   145,   430,
    1548,  1549,  1550,    56,   324,  1553,  1554,  1555,  1556,  1557,
     214,  1559,  1560,  1561,    12,   175,   112,   263,    12,   126,
      94,   166,   172,   401,   344,   430,   156,   203,  2908,    58,
      12,   175,   175,   489,   112,   253,   170,  3413,    67,   489,
     223,   234,    40,    12,    97,   335,   253,   100,  3494,  3495,
      79,   466,   253,   234,   357,   108,   107,  2281,   203,    44,
     111,   179,  3118,   138,   530,   445,   530,   203,   516,  2265,
    2266,  2267,    61,   148,  2965,   464,    97,   175,   390,   100,
     253,   112,   573,    81,   390,   466,   217,    37,    86,   580,
     299,   403,  1926,   352,  2723,   549,   214,  2726,  2727,   488,
    2296,  2297,  2298,    64,   269,   179,   349,  1075,   574,   399,
     891,   575,    77,   410,  2743,   166,  3007,   270,   217,   575,
     500,   433,   267,   420,   539,   506,   574,   424,   506,   579,
      12,   125,   429,    49,  1579,  2990,  3582,   434,   331,  1584,
    2364,   170,   573,   125,  2999,  1590,   577,  1029,  1593,   178,
     228,   352,   203,   573,   374,  1037,   125,  3679,   904,   456,
     429,   382,   321,   382,   229,   145,   487,   372,   573,  1012,
     330,   922,   270,   382,   580,   520,   473,   522,   523,   352,
     374,  1625,   575,  1065,  1066,   145,   483,  1230,   217,  3056,
     487,   512,  2352,   338,  1890,   356,   493,   228,   495,   496,
    2328,   405,   361,   500,   501,   105,   313,  3583,  1087,   238,
     530,   287,   172,   510,   483,   200,   267,   514,   573,   374,
     466,   337,   519,   520,   975,   522,   523,   524,   525,  2063,
    3110,  2386,  2360,   231,   985,  2386,   466,   390,   372,   404,
     436,   335,  2013,   125,   550,  2400,  1030,   563,   411,  2400,
     575,  1563,   382,   394,  1489,  1298,   374,   516,   354,   158,
    2694,   558,  1706,  1106,  3308,   485,  1710,   546,   529,   108,
     463,   574,   976,   326,   174,   350,  1420,   574,   411,   573,
    3147,   474,   430,  2054,   376,   582,   583,   338,  1094,  1094,
     587,   485,  2625,   474,   574,   963,   445,   594,   543,  1743,
     374,   418,   300,  2470,  1896,   574,   461,   528,   453,   209,
    3366,   559,   517,   489,   583,   530,  1933,  1879,   986,   511,
     542,   498,   204,  1061,  2397,  1879,  1335,   624,   546,  1075,
     498,  1795,  2062,  2912,  1017,  1770,  1800,  1801,  1806,   546,
    1808,   524,  1351,   372,   515,   546,   501,  1153,  1153,   538,
     573,   498,   466,   489,   575,   563,   575,  1792,   551,   515,
     575,   359,  1098,   581,  2060,   510,   575,   485,  1377,  2384,
     541,   466,  2883,   546,   581,   581,   548,   581,   524,   580,
     581,  1943,   547,   517,   581,   682,   485,   542,   227,  1943,
     443,   483,   353,   690,   563,   107,   693,   550,   528,   696,
     697,   390,   573,  2353,  2354,   515,   306,   580,   581,   581,
     502,   485,   575,   488,   314,  3282,   381,   581,  3340,   335,
     579,   450,   267,  3345,   574,   573,   515,    94,   697,   577,
     177,   575,   575,  2629,  1982,   732,  1998,   734,   337,  1107,
     425,   494,  1772,   214,  1998,  1993,  2963,    64,   537,   538,
     400,   449,  1156,   236,   166,   107,   361,   437,  1204,   510,
     567,   568,   569,   732,   414,   734,  2300,  2301,   542,   522,
     491,   253,  3051,   494,  3329,    94,  3331,   437,    23,   158,
     380,  3348,   480,   548,    28,   435,   287,  2981,   517,   113,
    2984,  2619,   164,   338,   289,   411,  2484,   191,   563,  2671,
    2488,    50,  1947,  2675,   229,   567,   343,  2622,   426,    58,
     113,  2671,   179,     8,   166,  2675,   191,   362,   287,    64,
     436,   175,   107,    68,   361,    12,    70,   252,   428,  2657,
     258,  1976,   149,  1978,   407,    38,  2691,    67,  1983,  2633,
    2691,   107,  1288,  2093,  2094,  3400,  1292,  3402,  1329,   344,
     217,   203,   391,  2616,  1999,   267,  2001,  2002,  2003,   178,
     445,   430,   430,     4,   258,   485,   111,  3434,     9,    10,
     352,   243,   226,   455,   456,   457,   458,   459,   460,   507,
    1423,   166,    12,   258,   489,   882,    27,   884,  3510,   471,
    1433,    32,  1486,    12,  3474,    36,  1478,   141,   217,  1383,
     166,   204,   530,     0,   666,   504,  1488,  1486,   336,  1491,
    1492,   236,   381,   360,  1457,   267,  1320,   120,   325,   916,
    1514,   520,  2344,  2686,   249,   922,   338,  1917,  1918,   412,
     489,  3148,  3149,   472,   405,  1514,    68,   203,   125,  2473,
     170,  1425,  1426,  1394,   544,   172,   270,   916,    80,     3,
    2952,   345,   489,   332,   333,   214,   556,   325,   337,    68,
      19,  2787,   959,   335,   961,   510,   963,   270,  2783,   164,
     395,    80,  1376,  1018,  1019,   116,   445,  1520,   975,   976,
    2144,  2246,   267,  1028,  1388,  2985,   338,   217,   985,   986,
    3184,  1036,  1927,   238,  2232,   125,  1945,   444,   352,   996,
    2012,   267,   575,   370,   573,   573,   125,   374,   238,   258,
     430,   270,   121,    23,    24,   175,   575,   420,  1454,  3230,
    2282,  1018,  1019,  1020,  1021,  2145,   430,  3649,  2282,  2717,
     325,  1028,   370,  1030,   430,   262,   353,  1580,  1581,  1036,
    1583,   435,  1585,  1586,  1587,  1588,  1589,    57,  1591,  1592,
      54,  1020,  1021,   338,  2084,   545,     8,   116,    68,  2089,
     435,  1058,  1991,  2751,  2752,   398,   430,    77,   483,   559,
     485,  2759,   338,   325,  2104,    27,  2403,   498,  2766,   145,
    2009,  2111,   489,   486,  2944,  2945,    96,   332,   333,  1058,
    1799,   416,   337,   253,   275,   276,  2126,  2127,   510,   344,
     401,   111,   175,  2133,   114,  2240,   513,  1104,  2936,   241,
    1107,  2141,  2247,   112,  1159,  1160,  2065,   383,  3120,   486,
     386,   489,   221,   382,   527,   504,   370,   372,    76,   462,
     229,   450,   241,   143,   501,  1104,  3330,   562,  3332,   542,
    3419,   520,   372,   430,    92,   513,  2680,   580,   392,   436,
    2180,   548,   156,   573,   575,   159,   229,   573,   510,  1156,
     527,  1158,  1159,  1160,   580,  1162,   485,   486,   172,   573,
      34,   535,   536,   417,  1171,   542,  1173,   573,   575,   311,
       3,  3181,    88,     6,  3463,   483,   485,   485,    88,   434,
      13,    71,    72,  1162,   489,   465,   217,   443,   517,   469,
      23,    24,   311,   335,   505,   573,   545,   217,   527,   573,
    1207,  2682,  2683,  2684,   224,   396,   397,   238,   513,   545,
     559,   465,   498,   332,   333,   510,   335,  2257,    16,   527,
      53,   111,   538,   559,    57,   541,   100,   489,  3053,    88,
    2711,   213,  1688,   107,   510,    68,  3535,   485,   535,   536,
    1247,   332,   333,   133,    77,   486,   351,   389,   357,   354,
      83,   513,  3134,   192,   409,  3382,   411,  3384,   413,   213,
     415,  1530,   517,    96,  1533,   416,   522,   217,   573,   347,
     389,   226,   292,  1542,  3573,   165,   573,   175,   111,   270,
     431,   114,  1551,   548,   158,   299,   437,   307,   580,    20,
     123,   124,   166,   439,   440,   574,   129,    28,  1305,  1755,
     145,   557,    33,   219,   137,   461,   457,   565,   566,   219,
     143,   573,   573,  1320,   574,   575,  2979,  2980,  2593,   461,
     236,   405,  3621,  2501,  2502,   948,   236,    11,   951,   203,
      88,   954,   152,   249,  2997,   530,   169,  3636,   358,   249,
    3003,   361,   461,   344,  1897,   574,   575,  3646,    55,    56,
     373,   290,   291,   349,  2626,   294,   295,    64,   451,   452,
     219,   454,  2626,  3026,   384,   385,  3029,   387,   382,  1376,
    3669,   526,  3671,   420,  1381,   483,  1383,   236,   574,   575,
     344,  1388,   215,   575,   217,   214,    88,  1394,    47,  1396,
     249,   224,   175,   267,  1401,  1402,   263,  1404,    47,   462,
     463,   575,   465,   423,   467,   574,   575,  2679,   324,  1416,
     574,   575,  1419,   344,   324,  2679,   574,   575,  1425,  1426,
    1427,  1428,  1401,  1402,   516,  1404,  1979,  1980,  1435,  1436,
    1437,   574,   575,  2705,   344,   263,  1402,  1416,  1404,   567,
    1419,  2705,   574,   575,   574,   575,  1453,  2000,  1427,  1428,
     150,   325,     3,  2235,   253,  1462,  1435,  1436,  1437,   292,
     334,   219,   573,   337,   338,   324,   426,    18,   436,  1435,
    1436,  1437,  1479,  2522,   307,   574,   575,   506,   236,   312,
    3284,   229,   172,  1490,   287,   344,   466,   507,   574,   575,
    1904,   249,  1906,  1907,   120,  1502,   516,   574,   575,   466,
     416,  1508,   483,   393,   252,   466,   416,   574,   575,   574,
     575,  1490,  1346,  1347,  1348,  1349,  1350,   219,   263,   352,
     574,   575,   574,   575,  2243,   358,   574,   575,   361,  1508,
     574,   575,   574,   575,   236,  1981,   142,    88,    78,    12,
      13,  1955,  1956,   575,   574,   575,  2586,   249,   574,  1604,
     346,   384,   385,  2256,   387,   471,   429,   416,    15,    16,
    1567,   471,   574,   575,   479,    34,   324,   542,   401,  1576,
      55,    56,   574,   575,   574,   575,    52,  1991,   399,   205,
     574,   575,  3446,   152,   332,   333,   344,   574,   575,   573,
     423,   579,  3430,   211,   145,  2009,   575,  1604,   574,   575,
     574,   575,   574,   575,   542,  1612,  3336,   145,  1615,   574,
     575,  2789,   471,   553,    87,   489,   575,   491,   169,   564,
     494,   172,   324,   574,   575,   573,   164,   580,   145,   146,
     504,   100,   573,  1612,   570,  2907,   510,   263,   107,   513,
     573,  2097,   115,  2907,   195,   573,   184,   395,   573,  2105,
     201,   574,   575,   574,   575,     3,   129,   575,   416,   573,
     198,   287,   573,   214,   573,  2079,   573,   184,   219,   573,
      18,   573,  2086,   573,   507,   226,    23,    24,   151,   574,
     575,   198,  2860,   516,   573,   236,   574,   575,   573,   158,
     163,   565,   566,   574,   575,   573,  2294,   166,   249,   489,
     448,   573,   253,   574,   575,   243,   244,   573,    55,    56,
      57,   262,   573,   471,   416,   232,   573,    64,   573,   192,
     573,    68,   574,   575,   574,   575,   573,   244,   574,   575,
      77,  2335,   573,   271,   203,   574,   575,   574,   575,   573,
      88,   573,   575,   573,   217,   580,  2335,   373,   581,    96,
     223,  2343,   574,   575,   271,   381,  2309,   574,   575,   574,
     575,   574,   575,   573,   111,   574,   575,   114,   573,   471,
      47,  1778,   573,   324,   574,   575,  1342,  1343,   573,  1344,
    1345,  2683,  2684,   409,   573,  2279,   573,  2787,   573,   262,
    1289,  1290,   330,   344,  3154,  3155,   143,   145,   267,  2635,
    2636,   352,  2605,  2606,  2897,  2898,   573,   573,   573,   573,
     573,   328,   573,  2227,   562,   563,   573,   573,   573,   445,
     573,   573,   573,   374,   172,   575,   573,   573,   548,   573,
     573,  2325,   573,   371,   573,   573,   573,   573,   573,   573,
     466,   573,   575,   573,   573,  2398,   573,   195,   573,  2889,
     573,   573,  2405,   201,   573,   573,   325,   483,   573,   485,
     573,   573,   573,   573,   573,   416,   483,   573,   337,   338,
     217,   219,  1879,   287,   573,   573,   573,   224,   226,   573,
     573,   573,   573,   579,   573,   436,   573,   573,   236,   258,
    1897,  1898,   573,   573,   573,   573,   573,  1904,   573,  1906,
    1907,   249,   375,   573,   573,   253,   573,   573,   573,   573,
     573,   573,   573,   573,   262,   573,   573,   573,   573,   573,
     471,   394,   573,   573,   287,   573,   573,   400,   573,   573,
    2649,   573,   573,   406,   573,   573,  1943,   498,   575,   575,
     575,   498,   575,   575,   575,   292,   229,   489,  1955,  1956,
     172,   567,   230,   481,   160,   172,   575,   430,  1965,   523,
     307,   575,   363,   447,  1971,   516,   573,  1974,   441,   442,
    1977,  3468,   574,  2434,   575,   145,   324,   145,   529,   530,
    2939,  1988,  1989,  2397,  1991,   145,   145,   145,   145,   145,
    1997,  1998,   145,   145,   145,   546,   344,   548,   145,   145,
    2007,   145,  2009,   145,   352,   478,  2013,  2014,   145,   575,
     525,   358,   574,    45,   361,   179,   344,    64,    12,   574,
     489,   175,   491,   574,   575,   494,   374,   489,  2007,   574,
     581,   125,     9,   574,   545,   504,   580,   384,   385,   574,
     387,   510,  3539,   574,   513,   252,  2053,  2054,   573,   575,
     566,   524,   390,   526,   546,   218,   192,  3554,   580,  3556,
     175,   574,   445,   381,   436,   575,   575,   172,   416,    45,
     461,  2774,  2079,   461,  2053,   461,   423,   461,   429,  2086,
     461,    67,   498,   122,   484,   484,    23,    24,   436,   237,
    3362,  3245,  2099,   122,   237,    45,   565,   566,   575,   530,
     580,  3598,    18,   575,  3601,   575,   574,   574,   574,   574,
     574,   574,  3609,   574,  3269,  3270,  3271,  3272,    55,    56,
      57,   574,   574,   471,   575,   575,   575,    64,    13,   574,
     567,    68,    12,    13,   574,   175,   575,   575,  2145,   574,
      77,   574,   578,   575,   574,   437,  3643,   575,   575,   574,
     574,   580,   575,   575,   575,   575,   575,  3654,   575,    96,
     507,   574,   574,  3660,   575,   575,   575,   574,   516,   516,
     575,   575,   574,   262,   111,   498,   574,   114,   575,   575,
     575,   573,   530,   498,   574,  3682,  3683,   563,   575,  3686,
    2893,   580,   574,   498,   574,   574,   573,   575,   546,   574,
     548,  3473,    87,   574,   574,   573,   143,    87,   574,   574,
     574,   498,   574,   573,   575,   574,   574,   574,   574,  3259,
    2227,   575,   575,   575,  2638,   575,   574,   575,   575,   574,
     115,   574,   574,   581,   575,   115,   575,   574,   489,   575,
    2654,   575,   574,   574,   129,   575,   575,   574,   574,   129,
     574,  2258,   574,   574,   550,  2262,   258,  2264,  2265,  2266,
    2267,   580,   575,   573,   349,   175,   151,   175,  2275,   175,
     226,   151,  2279,   175,   580,  2282,   233,   580,   163,   548,
     217,   338,   575,   163,   236,  2883,   355,   224,   236,  2296,
    2297,  2298,   303,    96,    96,   238,  2275,   238,   573,   580,
     573,   489,  2309,   573,   352,   567,   574,   192,  2315,   574,
    2317,   225,   192,  3585,   338,   252,   338,   574,  2325,   574,
     574,  3585,   175,   175,   175,   338,   560,   141,   574,   574,
       7,   580,   217,   580,   574,   574,   580,   217,   223,   574,
     567,   573,    19,   223,  3616,    22,   344,   214,   175,   575,
     574,   580,    29,   524,   229,   292,   250,    64,   275,   236,
     236,   344,    39,   575,   238,   238,   575,    18,  3640,   344,
     307,    18,    49,   574,    18,   573,  3640,   262,   574,  2386,
     574,   253,   262,   574,   573,  2938,   573,   227,   227,   574,
    2397,  3069,   574,  2400,   574,   574,   574,   574,  3151,  3152,
    3153,   575,   574,   132,   580,   574,   247,   574,   574,   574,
      87,   430,  3567,   574,   195,   438,   355,   145,   580,   560,
     575,   358,   111,   573,   361,   574,   236,  2434,   236,   574,
     107,   108,   111,   110,  2441,   574,   574,  2444,   369,   574,
     574,  2448,  2449,   575,   121,  2452,   574,   384,   385,  3194,
     387,   574,   574,  3006,   574,  2462,   575,   575,   575,   575,
     574,   574,   574,   574,   574,  2444,   273,   274,   275,   276,
     277,   278,   574,   574,   281,   282,   283,   284,   285,   286,
     575,   288,   574,  2462,   574,   573,   423,   574,   574,   573,
     375,   574,   574,   574,   574,   375,   574,  3175,   574,   574,
     574,   580,   575,   575,   574,   338,   574,   574,  2922,   394,
    3188,  3214,  3215,   574,   394,   400,   574,   338,   573,   575,
     400,   406,   574,   574,   574,   574,   406,   432,   573,   575,
     574,   573,   575,   574,   338,    41,  2982,   575,   573,   573,
     573,   338,  3095,   574,   574,   430,   574,   574,   574,   381,
     430,   548,   226,   574,   574,   580,   441,   442,   574,   574,
     574,   441,   442,   575,    45,   201,   575,   310,   390,   489,
     507,  2985,   236,   573,   489,   530,   530,   573,   573,   516,
     338,   338,  3327,  3468,   573,    32,   573,   338,   541,   396,
     397,  3005,   541,   478,   524,   111,   238,   238,   478,   337,
     574,   338,   338,   338,   338,   338,   548,   575,   509,  3494,
    3495,   573,   575,  3069,   574,   574,   574,   310,   154,  2626,
    2627,   489,  2629,   574,   489,   489,   238,   574,   574,    66,
     575,  2638,  3230,    16,   574,   530,   573,  2644,  3341,   524,
     574,   526,   574,   530,   524,   574,   526,  2654,   574,  3534,
    3535,   574,   574,   574,  3539,  2662,   574,   536,   334,   172,
     338,   573,   575,   574,   349,   574,   338,   574,  3221,  3554,
     574,  3556,  2679,   485,   574,   101,   102,   103,   104,   105,
     524,   574,   574,   574,  2691,   574,   574,   255,  3573,   575,
     574,  2698,   575,   574,   276,   573,    58,  3582,  2705,   349,
      58,   374,   573,    45,  2711,   574,    45,   138,   574,  3123,
      45,   574,   574,  3598,   574,   145,  3601,   574,     5,  3175,
     575,   349,   349,  3401,  3609,   394,   574,   134,   575,   413,
      45,    45,  3188,   410,    45,   121,  3621,   424,   574,    16,
     578,   280,   573,   420,   545,   582,   175,   424,   174,   545,
     214,  3636,   429,   145,   574,   226,   141,   434,  3643,  3437,
    3438,  3646,  3440,   581,   338,   574,   560,  3181,   573,  3654,
     213,   545,   141,   109,   269,  3660,   575,   128,  2785,   456,
     206,   207,   208,   209,  3669,   255,  3671,   582,   581,   561,
     436,   581,   575,   141,   560,   199,   473,  3682,  3683,   575,
     141,  3686,  3480,   581,  3482,  3483,   483,   561,   172,   172,
     487,   172,   404,   560,   111,   547,   493,   536,   495,   496,
     173,    23,    24,   500,   501,  1594,  1825,   688,  3560,  3225,
    3344,  3218,  3664,   510,  3695,  3668,  3595,   514,  3551,  3542,
    3595,  3558,   519,   520,  3052,   522,   523,   524,   525,  1153,
     404,  1094,  3146,    55,    56,    57,  2054,  2781,  1563,  2711,
    2698,  1529,    64,  1567,  2016,  1969,    68,  2734,  3173,  3337,
    2734,  2767,  2968,  3005,  3014,    77,   302,  2884,   304,   305,
     306,   558,  3389,  2699,  2654,  3398,  3589,  3165,   314,  3313,
    1166,  3232,  3188,  1497,    96,  2012,  1874,   574,  1427,  1072,
    2907,  1149,  2275,  1888,  1856,   582,   583,   468,   697,   111,
     587,   681,   114,   612,  3279,  2922,  2892,   594,  1442,  2893,
    3095,  1339,  3413,  2669,  2087,  3300,  1341,  1244,  1194,  2248,
    3144,  2705,  3589,  3123,  1878,  1852,  1893,  2907,  2621,  2620,
    3616,   143,  2679,  3473,   458,  3401,   963,   624,   734,   986,
    1171,   515,   449,  1487,   380,   991,  2963,  2611,  3475,  1393,
    3375,  3444,  3514,  3640,  3007,  2626,  1448,  2327,  2662,  2933,
    3131,  1419,   441,   595,   956,  3267,  3273,  1158,  2985,  2262,
     442,  3437,  3438,   599,  3440,  3091,  1004,   994,   730,   485,
    1315,  2052,  3049,    -1,    -1,  2778,    -1,    -1,  3005,    -1,
      -1,   427,   428,    -1,    -1,   682,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   690,    -1,   217,   693,    -1,    -1,   696,
     697,    -1,   224,  3030,  3480,  3032,  3482,  3483,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3042,    -1,    -1,    -1,    -1,
      -1,  3048,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   732,    -1,   734,    -1,    -1,
      -1,    -1,    -1,  3042,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3095,    -1,
     292,    -1,  3583,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   307,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3123,    -1,   544,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   555,
     556,    -1,    -1,    -1,    -1,    -1,  3143,    -1,    -1,    -1,
      -1,  3148,  3149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3162,   358,    -1,    -1,   361,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3181,    -1,    -1,    -1,    -1,    -1,
      -1,  3672,   384,   385,    -1,   387,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3612,    -1,
      -1,    -1,    -1,    -1,  3695,   882,    -1,   884,    -1,    -1,
      -1,    -1,  3219,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    -1,    -1,  3232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3693,    -1,   916,
      -1,    -1,    -1,    -1,    -1,   922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   959,    -1,   961,    -1,   963,    -1,    -1,    -1,
      -1,    -1,    -1,  3300,    -1,    -1,    -1,    -1,   975,   976,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   985,   986,
     570,    -1,    -1,    -1,   516,    -1,    -1,    -1,    -1,   996,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1004,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3344,    -1,    -1,
      -1,  1018,  1019,  1020,  1021,    -1,    -1,    -1,    -1,    -1,
      -1,  1028,    -1,  1030,    -1,  3362,  3363,    -1,    -1,  1036,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3382,    -1,  3384,    -1,  3386,
      -1,  1058,    -1,    -1,  3363,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1104,  3435,    -1,
    1107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     700,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3468,    -1,    -1,    -1,    -1,  3473,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1156,
      -1,  1158,  1159,  1160,  3491,  1162,    -1,  3494,  3495,  3496,
      -1,    -1,    -1,    -1,  1171,    -1,  1173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3524,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3534,  3535,    -1,
    1207,    -1,  3539,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   801,    -1,    -1,    -1,    -1,    -1,  3554,    -1,  3556,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3573,    -1,    -1,    -1,
    1247,    -1,    -1,    -1,    -1,  3582,    -1,    -1,  3585,    -1,
      -1,    -1,    -1,    -1,  3591,    -1,    -1,    -1,    -1,    -1,
      -1,  3598,    -1,  3600,  3601,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3609,    -1,    -1,  3612,    -1,    -1,    -1,  3616,
      -1,    -1,    -1,    -1,  3621,    -1,   876,    -1,    -1,    -1,
     880,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1305,  3636,
      -1,    -1,    -1,  3640,    -1,  3642,  3643,    -1,    -1,  3646,
      -1,  3648,    -1,  1320,    -1,    -1,    -1,  3654,    -1,    -1,
      -1,    -1,    -1,  3660,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3669,    -1,  3671,  3672,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3682,  3683,    -1,    -1,  3686,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3695,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1376,
      -1,    -1,    -1,    -1,  1381,    -1,  1383,    -1,    -1,    -1,
      -1,  1388,    -1,    -1,    -1,    -1,    -1,  1394,    -1,  1396,
      -1,    -1,    -1,    -1,  1401,  1402,    -1,  1404,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1416,
      -1,    -1,  1419,    -1,  1004,    -1,    -1,    -1,  1425,  1426,
    1427,  1428,    -1,  1013,    -1,    -1,    -1,    -1,  1435,  1436,
    1437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1462,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1479,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1490,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1502,    -1,    -1,    -1,    -1,
      -1,  1508,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1567,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1576,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1175,  1176,  1177,    -1,    -1,
      -1,    -1,    -1,    -1,  1184,  1185,    -1,  1604,  1188,    -1,
    1190,  1191,  1192,  1193,    -1,  1612,    -1,  1197,  1615,    -1,
    1200,  1201,    -1,  1203,    -1,  1205,  1206,    -1,  1208,  1209,
    1210,  1211,  1212,    -1,  1214,    -1,  1216,  1217,  1218,    -1,
    1220,  1221,  1222,  1223,    -1,  1225,  1226,    -1,  1228,    -1,
      -1,  1231,  1232,  1233,    -1,  1235,  1236,  1237,  1238,    -1,
    1240,  1241,  1242,  1243,    -1,    -1,    -1,    -1,    -1,  1249,
    1250,    -1,  1252,  1253,  1254,  1255,  1256,    -1,    -1,    -1,
      -1,  1261,    -1,  1263,  1264,  1265,  1266,  1267,    -1,    -1,
    1270,  1271,  1272,  1273,  1274,  1275,    -1,  1277,  1278,    -1,
      -1,  1281,  1282,  1283,    -1,  1285,    -1,  1287,    -1,    -1,
      -1,  1291,    -1,  1293,  1294,    -1,    -1,    -1,    -1,  1299,
      -1,    -1,    -1,    -1,     3,    -1,    -1,  1307,  1308,  1309,
      -1,    -1,    -1,    -1,    13,    14,  1316,    -1,    -1,  1319,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    26,    -1,    28,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    47,    48,
      -1,    -1,    -1,    -1,    53,    -1,    -1,    -1,    57,    58,
      -1,  1778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    -1,    -1,    -1,    -1,    -1,  1378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,    -1,  1422,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1879,    -1,    -1,    -1,    -1,    -1,    -1,   168,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1897,  1898,    -1,    -1,    -1,    -1,    -1,  1904,    -1,  1906,
    1907,    -1,    -1,   192,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,    -1,  1943,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1955,  1956,
     239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1965,    -1,
      -1,    -1,    -1,    -1,  1971,    -1,    -1,  1974,   257,    -1,
    1977,    -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,
       6,  1988,  1989,    -1,  1991,    -1,    -1,    13,  1578,    -1,
    1997,  1998,    -1,    -1,    -1,    -1,    -1,    23,    24,    -1,
    2007,    -1,  2009,    -1,    -1,    -1,  2013,  2014,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    53,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,  2053,  2054,    -1,    -1,
      -1,    77,    -1,    -1,    -1,    -1,    -1,    83,    -1,   348,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,  2079,    -1,    -1,    -1,    -1,    -1,    -1,  2086,
      -1,   370,    -1,    -1,    -1,   111,    -1,    -1,   114,    -1,
     379,    -1,  2099,    -1,    -1,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,
     399,   137,   401,   402,    -1,    -1,   405,   143,    -1,   408,
      -1,   410,    -1,    -1,    -1,    -1,   415,    -1,   417,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,  2145,    -1,
      -1,   430,    -1,   169,    -1,    -1,    -1,   436,    -1,    -1,
      -1,    -1,   441,    -1,    -1,    -1,   445,    -1,    -1,    -1,
    1750,  1751,  1752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   465,  1767,    -1,    -1,
     469,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   217,    -1,    -1,    -1,    -1,    -1,    -1,   224,    -1,
      -1,    -1,  1792,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   505,    -1,    -1,    -1,
    2227,    -1,    -1,    -1,    -1,  1815,    -1,    -1,    -1,    -1,
      -1,    -1,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,
     529,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2258,    -1,    -1,    -1,  2262,    -1,  2264,  2265,  2266,
    2267,    -1,    -1,   552,    -1,    -1,   292,    -1,  2275,    -1,
      -1,    -1,  2279,    -1,    -1,  2282,    -1,    -1,    -1,    -1,
      -1,   307,    -1,    -1,   573,    -1,   312,    -1,    -1,  2296,
    2297,  2298,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2309,    -1,    -1,    -1,    -1,    -1,  2315,    -1,
    2317,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2325,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   352,    -1,    -1,    -1,
      -1,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   384,   385,
      -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   401,    -1,    -1,    -1,  2386,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2397,    -1,    -1,  2400,    -1,    -1,    -1,   423,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2434,    -1,    -1,
      -1,    -1,    -1,    -1,  2441,    -1,    -1,  2444,    -1,    -1,
      -1,  2448,  2449,    -1,    -1,  2452,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2462,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2066,    -1,    -1,  2069,
      -1,   507,  2072,  2073,    -1,    -1,    -1,    -1,    -1,    -1,
     516,    -1,    -1,    -1,    -1,  2085,    -1,    -1,  2088,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2101,    -1,  2103,    -1,    -1,    -1,  2107,    -1,  2109,
    2110,    -1,    -1,    -1,  2114,    -1,  2116,  2117,    -1,  2119,
      -1,    -1,  2122,    -1,  2124,  2125,    -1,    -1,    -1,    -1,
    2130,  2131,    -1,    -1,  2134,    -1,  2136,    -1,  2138,    -1,
    2140,    -1,  2142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2153,  2154,    -1,    -1,  2157,    -1,  2159,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2167,  2168,    -1,
    2170,    -1,  2172,    -1,    -1,  2175,  2176,  2177,    -1,  2179,
      -1,    -1,    -1,    -1,  2184,  2185,  2186,  2187,    -1,    -1,
      -1,    -1,  2192,  2193,  2194,    -1,  2196,    -1,  2198,    -1,
    2200,    -1,  2202,    -1,  2204,    -1,    -1,    -1,    -1,  2626,
    2627,  2211,  2629,  2213,    -1,    -1,  2216,  2217,    -1,    -1,
      -1,  2638,    -1,    -1,    -1,    -1,    -1,  2644,  2228,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2654,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2662,    -1,  2247,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2679,    -1,    -1,    -1,    -1,    -1,    -1,  2269,
      -1,    -1,    -1,    -1,  2691,    -1,    -1,    -1,    -1,    -1,
      -1,  2698,    13,    14,    -1,    -1,    -1,    -1,  2705,    -1,
      -1,    -1,    -1,    -1,  2711,    26,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    47,    48,  2318,    -1,
      -1,    -1,    53,  2323,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2367,  2785,    -1,
      -1,    -1,    -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,
      -1,  2381,    -1,    -1,   115,   116,   117,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   192,    -1,    -1,    -1,    -1,    -1,  2884,   199,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,  2477,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2907,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2922,    -1,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,    -1,
      -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2963,    -1,    -1,    -1,
    2550,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2560,    -1,  2562,    -1,  2564,    -1,    -1,    -1,  2985,    -1,
    2570,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3005,    -1,
      -1,    -1,    -1,    -1,    -1,  2595,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3030,    -1,  3032,    -1,   348,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3042,    -1,    -1,    -1,    -1,
      -1,  3048,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   370,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2663,    -1,    -1,    -1,    -1,   399,    -1,
     401,   402,    -1,    -1,   405,    -1,    -1,   408,  3095,   410,
      -1,    -1,    -1,    -1,   415,    -1,   417,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   426,    -1,    -1,    -1,   430,
      -1,    -1,    -1,    -1,    -1,   436,  3123,    -1,    -1,    -1,
     441,    -1,    -1,    -1,   445,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3143,    -1,    -1,    -1,
      -1,  3148,  3149,    -1,   465,    -1,    -1,    -1,   469,    -1,
      -1,    -1,    -1,    -1,    -1,  3162,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3181,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   505,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,    -1,
      -1,    -1,  3219,    -1,    -1,    -1,    -1,    -1,  2808,    -1,
      -1,    -1,    -1,    -1,    -1,  3232,    -1,    -1,  2818,    -1,
      -1,   552,    -1,    -1,  2824,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2833,  2834,    -1,    -1,    -1,    -1,  2839,
      -1,    -1,   573,  2843,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2856,    -1,    -1,    -1,
      -1,    -1,  2862,    -1,    -1,  2865,  2866,    -1,  2868,  2869,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2882,  3300,    -1,    31,    32,    -1,    -1,    -1,
      -1,    37,    -1,    39,    -1,    41,    42,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3362,  3363,    -1,  2948,  2949,
      -1,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,  2959,
      -1,    -1,   108,    -1,    -1,  3382,    -1,  3384,    -1,  3386,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   127,  3399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3435,   165,
      -1,   167,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3473,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3491,    -1,    -1,    -1,    -1,  3496,
      -1,   227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3524,    -1,    -1,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3118,   265,
     266,    -1,   268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3585,    -1,
      -1,   317,   318,   319,  3591,    -1,    -1,   323,    -1,    -1,
     326,    -1,    -1,  3600,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   339,   340,  3612,    -1,    -1,    -1,  3616,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   365,
      -1,   367,    -1,  3640,    -1,  3642,    -1,    -1,    -1,    -1,
      -1,  3648,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3241,    -1,    -1,    -1,   391,    -1,  3247,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3672,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3695,    -1,
      -1,    -1,    -1,  3283,    -1,    -1,    -1,    -1,   434,    -1,
     436,    -1,    -1,  3293,    -1,  3295,    -1,    -1,    -1,    -1,
     446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   490,   491,    -1,    -1,   494,   495,
     496,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3366,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3424,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3447,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3529,
    3530,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3547,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3557,    -1,    -1,
      -1,    -1,    -1,  3563,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,  3605,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,  3622,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    80,    81,  3673,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,   245,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,
     469,   470,    -1,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   483,   484,    -1,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
     499,   500,    -1,   502,   503,   504,   505,   506,   507,   508,
      -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,   518,
     519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,   531,   532,   533,   534,   535,   536,    -1,    -1,
     539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,
      -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,
      -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,
     579,   580,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,   344,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,   467,   468,   469,   470,    -1,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     483,   484,    -1,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,   508,    -1,   510,   511,   512,
     513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,
     533,   534,   535,   536,    -1,    -1,   539,   540,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,
      -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,
     573,    -1,    -1,   576,   577,    -1,   579,   580,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,   430,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
     467,   468,   469,   470,    -1,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,   508,    -1,   510,   511,   512,   513,    -1,   515,    -1,
      -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,   531,   532,   533,   534,   535,   536,
      -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,
      -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,
      -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,
     577,    -1,   579,   580,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,   467,   468,   469,   470,
      -1,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,   508,    -1,   510,
     511,   512,   513,    -1,   515,    -1,    -1,   518,   519,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
     531,   532,   533,   534,   535,   536,    -1,    -1,   539,   540,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,
     571,    -1,   573,   574,    -1,   576,   577,    -1,   579,   580,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,   467,   468,   469,   470,    -1,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,   508,    -1,   510,   511,   512,   513,    -1,
     515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,   531,   532,   533,   534,
     535,   536,    -1,    -1,   539,   540,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,
      -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,
     565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,   574,
      -1,   576,   577,    -1,   579,   580,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,
     469,   470,    -1,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   483,   484,    -1,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,   508,
      -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,   518,
     519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,   531,   532,   533,   534,   535,   536,    -1,    -1,
     539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,
      -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,
      -1,    -1,   571,    -1,   573,   574,    -1,   576,   577,    -1,
     579,   580,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,   467,   468,   469,   470,    -1,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     483,   484,    -1,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,   508,    -1,   510,   511,   512,
     513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,
     533,   534,   535,   536,    -1,    -1,   539,   540,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,
      -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,
     573,   574,    -1,   576,   577,    -1,   579,   580,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
     467,   468,   469,   470,    -1,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,   508,    -1,   510,   511,   512,   513,    -1,   515,    -1,
      -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,   531,   532,   533,   534,   535,   536,
      -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,
      -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,
      -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,
     577,    -1,   579,   580,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,   175,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,   467,   468,   469,   470,
      -1,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,   508,    -1,   510,
     511,   512,   513,    -1,   515,    -1,    -1,   518,   519,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
     531,   532,   533,   534,   535,   536,    -1,    -1,   539,   540,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,
     571,    -1,   573,    -1,    -1,   576,   577,    -1,   579,   580,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
     175,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,   467,   468,   469,   470,    -1,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,   508,    -1,   510,   511,   512,   513,    -1,
     515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,   531,   532,   533,   534,
     535,   536,    -1,    -1,   539,   540,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,
      -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,
     565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,
      -1,   576,   577,    -1,   579,   580,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,
     469,   470,    -1,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   483,   484,    -1,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,   508,
      -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,   518,
     519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,   531,   532,   533,   534,   535,   536,    -1,    -1,
     539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,
      -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,
      -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,
     579,   580,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,   467,   468,   469,   470,    -1,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     483,   484,    -1,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,   508,    -1,   510,   511,   512,
     513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,
     533,   534,   535,   536,    -1,    -1,   539,   540,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,
      -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,
     573,    -1,    -1,   576,   577,    -1,   579,   580,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
     467,   468,   469,   470,    -1,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,   508,    -1,   510,   511,   512,   513,    -1,   515,    -1,
      -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,   531,   532,   533,   534,   535,   536,
      -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,
      -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,
      -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,
     577,    -1,   579,   580,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,    -1,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,   467,   468,   469,   470,
      -1,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,   508,    -1,   510,
     511,   512,   513,    -1,   515,    -1,    -1,   518,   519,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
     531,   532,   533,   534,   535,   536,    -1,    -1,   539,   540,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,
     571,    -1,   573,    -1,    -1,   576,   577,    -1,   579,   580,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,   467,   468,   469,   470,    -1,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,   508,    -1,   510,   511,   512,   513,    -1,
     515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,   531,   532,   533,   534,
     535,   536,    -1,    -1,   539,   540,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,
      -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,
     565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,
      -1,   576,   577,    -1,   579,   580,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,
     469,   470,    -1,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   483,   484,    -1,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,   508,
      -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,   518,
     519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,   531,   532,   533,   534,   535,   536,    -1,    -1,
     539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,
      -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,
      -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,
     579,   580,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    -1,    78,    79,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,   178,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,   217,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,   238,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,   252,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,   430,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,   450,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   580,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    -1,    78,    79,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,   178,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,   217,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,   238,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
     450,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,    -1,   556,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     580,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,   430,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   574,    -1,    23,
      24,    25,    26,   580,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    -1,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,    -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
     574,    17,    -1,    -1,    20,   579,   580,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
     226,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,
     556,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   580,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    -1,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,   567,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   580,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    -1,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,    -1,   556,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   573,    -1,    17,    -1,    -1,    20,    -1,
     580,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   579,   580,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    -1,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,    -1,   556,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   580,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    -1,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,    -1,   556,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,   580,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    -1,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,
      -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,
     478,   479,   480,   481,    -1,   483,   484,    -1,   486,   487,
      -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,
     508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,
      -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,
      -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   580,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    -1,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
      -1,   556,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   580,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,   251,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,     5,   556,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,   579,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,   251,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,     5,   556,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,   579,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,   251,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,     5,   556,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,   579,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,   561,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,   575,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    -1,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
      -1,   556,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   567,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    -1,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   567,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    -1,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,    -1,   556,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,   567,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    -1,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,
     469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,
     479,   480,   481,    -1,   483,   484,    -1,   486,   487,    -1,
      -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,   508,
      -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,
      -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,
     539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,    -1,    -1,   556,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,   567,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,   135,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,   559,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,   545,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,   559,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,   545,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,   559,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,    -1,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,    -1,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,    -1,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,   166,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
     267,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,   332,   333,    -1,   335,    -1,
      -1,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,   452,   453,   454,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,   510,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,   145,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    91,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    18,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    82,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,   153,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,   175,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,   372,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    -1,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    -1,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,    -1,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,    -1,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    30,    -1,
      32,    33,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    55,    56,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    65,   551,    67,    -1,    -1,    -1,   556,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,   143,    -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   216,   217,    -1,    -1,   220,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   373,   374,    -1,    -1,   377,   378,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   445,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   485,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   539,    -1,    -1,
      -1,   543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   436,   441,   445,   465,   469,   505,   521,   524,   529,
     552,   573,   584,   585,   586,   587,   588,   589,   591,   596,
     598,   603,   621,   782,   800,   803,   811,   813,   815,   818,
     823,   825,   830,   833,   838,   842,   850,   851,   999,  1001,
    1007,  1010,  1035,  1043,  1054,  1060,  1074,  1077,  1080,  1086,
    1090,  1094,  1097,  1098,  1143,  1160,  1166,  1168,  1175,  1177,
    1202,  1208,  1209,  1210,  1211,  1249,    11,    94,   179,   214,
     374,   796,  1230,  1231,   258,   336,   832,   483,   485,  1162,
    1203,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    78,    80,    81,    86,    89,    96,    97,   100,   105,
     106,   112,   114,   120,   122,   123,   124,   128,   131,   132,
     133,   137,   141,   142,   143,   144,   147,   149,   150,   151,
     154,   156,   159,   160,   163,   164,   165,   168,   173,   174,
     177,   179,   186,   187,   190,   191,   193,   199,   200,   202,
     205,   209,   210,   211,   212,   215,   216,   220,   224,   228,
     230,   231,   233,   234,   241,   243,   247,   250,   256,   258,
     261,   263,   273,   274,   275,   276,   277,   278,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   290,   291,   292,
     294,   295,   299,   300,   301,   302,   303,   306,   307,   310,
     312,   314,   317,   318,   319,   320,   321,   322,   323,   326,
     327,   329,   330,   331,   335,   340,   341,   343,   345,   346,
     347,   358,   359,   360,   361,   363,   365,   367,   370,   371,
     373,   375,   376,   377,   378,   380,   381,   382,   383,   384,
     385,   386,   387,   392,   393,   396,   397,   398,   400,   402,
     403,   406,   408,   409,   410,   412,   413,   417,   418,   420,
     421,   423,   424,   425,   426,   428,   429,   433,   434,   435,
     438,   442,   443,   444,   445,   447,   448,   449,   456,   457,
     459,   462,   465,   466,   469,   470,   472,   473,   474,   478,
     479,   480,   481,   483,   484,   486,   487,   490,   491,   492,
     493,   494,   500,   502,   505,   506,   507,   508,   511,   512,
     515,   520,   523,   525,   527,   528,   536,   539,   542,   543,
     544,   549,   551,   552,   556,   609,  1133,  1137,  1141,  1142,
     287,  1162,  1162,   549,  1204,    94,   178,   450,   486,   517,
     527,   607,   700,   701,   702,   774,  1044,  1000,    94,   179,
     217,   374,   486,   501,   527,   542,  1006,  1137,   832,   608,
     580,  1131,  1132,  1137,   597,  1008,  1095,    96,   217,   485,
    1162,   832,  1137,  1091,   426,   527,  1162,   832,  1011,  1087,
    1162,   608,  1204,  1137,   853,   855,   856,   349,  1145,  1061,
     465,   469,   445,   500,   445,   485,  1055,  1167,  1036,  1137,
      28,    70,   141,   370,   392,   417,   465,  1251,   430,   573,
     852,     0,     3,   370,   156,  1078,  1131,  1137,   145,   788,
    1137,   609,   609,   485,   112,  1227,  1162,   814,  1204,   839,
     840,  1131,   622,   580,   498,   816,   826,    16,  1205,   213,
     703,   608,   354,  1225,  1227,  1228,  1229,  1230,   485,   701,
     217,   214,   270,   382,  1052,  1053,   917,   918,   213,  1005,
    1005,  1137,  1005,  1005,   608,  1005,  1162,   592,  1081,    12,
      13,    87,   115,   129,   151,   163,   192,   217,   223,   262,
     375,   394,   400,   406,   430,   441,   442,   478,   524,   526,
    1178,  1180,  1182,  1183,  1137,   347,    61,   390,   580,   251,
     489,  1134,  1137,  1139,   113,   204,   270,  1013,    77,   381,
    1096,  1099,   226,  1131,  1161,  1162,   175,    32,   287,  1066,
    1092,  1137,   608,   834,  1162,   113,   270,  1014,  1042,   287,
     381,   445,  1088,  1089,   812,    12,  1176,  1180,   498,  1205,
     854,    12,   125,   204,   455,   456,   457,   458,   459,   460,
     471,   860,   861,   862,  1144,    30,    33,    55,    56,    65,
      67,    85,    87,    95,   143,   147,   177,   179,   191,   193,
     216,   217,   220,   237,   258,   263,   287,   320,   329,   347,
     373,   374,   377,   378,   435,   445,   470,   485,   543,   748,
     773,  1062,  1066,  1067,  1069,  1151,   805,   806,   805,   805,
     548,   804,   805,  1004,  1131,  1162,  1042,    34,   203,   489,
    1119,  1135,  1250,  1250,  1250,  1250,  1250,   855,   852,   574,
    1137,  1076,  1075,   301,   487,   512,   784,   786,   785,  1131,
     145,   461,  1232,   824,  1003,  1004,   229,   575,   846,   847,
     573,   623,  1137,   599,  1003,  1003,    52,   335,   335,   399,
    1206,   332,   333,   889,  1137,    91,  1139,  1140,  1193,  1194,
     405,    10,   374,   501,   715,  1226,  1232,  1233,  1241,  1243,
    1227,  1230,   703,  1137,   175,  1045,  1049,  1050,  1137,  1052,
       7,    20,    22,    25,    29,    32,    34,    35,    36,    38,
      51,    55,    56,    62,    65,    73,    74,    80,    83,    84,
      85,    90,    91,    93,    94,    98,    99,   100,   105,   107,
     110,   111,   118,   119,   136,   139,   140,   152,   155,   157,
     158,   162,   166,   171,   176,   180,   181,   182,   183,   185,
     186,   188,   189,   190,   194,   196,   197,   203,   209,   213,
     223,   225,   242,   246,   249,   254,   256,   259,   264,   267,
     272,   279,   289,   293,   302,   306,   308,   309,   313,   314,
     315,   316,   317,   318,   319,   325,   332,   333,   334,   337,
     338,   343,   361,   362,   364,   365,   366,   367,   368,   380,
     388,   404,   405,   416,   419,   422,   424,   428,   467,   468,
     473,   475,   476,   477,   482,   491,   492,   493,   494,   503,
     504,   505,   510,   513,   518,   519,   527,   531,   532,   533,
     534,   535,   540,   544,   554,   556,   561,   565,   566,   571,
     573,   576,   577,   579,   580,   871,   874,   877,   878,   879,
     880,   881,   882,   883,   884,   885,   886,   890,   893,   894,
     896,   903,   907,   919,  1118,  1120,  1122,  1123,  1127,  1129,
    1133,  1135,  1137,   152,  1137,   609,   344,   609,   609,  1140,
    1192,  1003,  1005,   530,   593,   120,   205,   263,   287,   373,
     381,   409,   445,   466,   483,  1082,  1083,  1162,   373,  1181,
     420,   420,   486,   527,   542,   349,  1185,   483,  1187,    60,
     445,  1184,    95,   542,  1186,   344,   575,    18,   145,   959,
     960,  1169,  1137,   796,   871,    75,   175,   270,  1100,  1105,
      47,   175,  1131,  1163,  1164,   831,   579,   590,  1134,   263,
     835,  1140,   836,   837,  1131,   819,   226,  1004,  1015,  1016,
      47,   575,  1003,  1181,   344,   426,  1207,  1206,   516,  1212,
    1213,   567,   864,   865,   866,   862,  1146,  1147,  1148,   263,
     150,   436,   252,   546,  1073,   506,   573,    94,   179,   374,
     485,   542,  1073,   710,  1139,   253,   978,   980,    63,   466,
     172,   466,   466,   466,   287,   483,    63,   466,    12,    40,
      81,    86,   231,   300,   359,   449,   480,  1056,  1057,  1058,
     205,   466,   466,   506,   978,  1073,   175,   229,  1070,   263,
     142,    66,   376,   483,   502,   466,   539,   802,   398,   462,
     807,   808,   801,    78,   796,   575,   346,  1253,   479,  1254,
     236,   412,  1252,   574,  1213,  1215,  1216,  1217,   850,  1079,
    1119,  1137,   111,   697,   698,   699,   708,   709,   756,   616,
     616,   783,  1140,   429,   542,  1003,   498,   575,   111,   841,
    1137,   840,   217,   238,   771,   772,   848,   624,   625,   871,
     273,   274,   275,   276,   277,   278,   281,   282,   283,   284,
     285,   286,   288,   396,   397,   600,   601,   602,   156,   382,
     817,    54,   156,   159,   172,   299,   382,   827,   828,   829,
      52,   399,   152,   606,   573,   870,   579,   211,   575,   866,
     866,   866,   542,  1233,  1131,   507,   530,   775,  1049,  1131,
    1137,   575,  1047,   580,  1051,   573,   573,   573,   573,   573,
     894,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   870,   870,   573,   870,   573,
     573,   573,   513,   573,  1118,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   871,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   920,   921,   922,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     877,   573,   870,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   870,   573,  1118,   573,
     573,   573,  1118,   573,   573,    34,   203,   489,   573,   573,
     573,   870,   870,   870,   573,   573,   573,   573,   573,   573,
     871,   924,   894,   894,   894,   430,   573,   871,  1220,  1137,
     908,  1137,   553,   872,   875,   145,   146,   184,   198,   232,
     244,   271,   328,   891,   229,   252,   395,   448,   562,   563,
     889,   564,   439,   440,   565,   566,   126,   313,   567,   568,
     569,   570,   894,   101,   102,   103,   104,   105,   174,   206,
     207,   208,   209,   302,   304,   305,   306,   314,   380,   427,
     428,   544,   555,   556,   956,   957,    64,   353,   575,  1135,
     573,   580,  1131,   575,    49,   411,   797,  1003,   579,   594,
     595,    47,   548,   575,  1084,   483,   573,  1195,  1195,  1195,
    1195,   179,   374,   485,  1179,  1183,  1137,   164,   330,  1137,
    1170,  1171,  1015,   287,   258,  1104,   843,   287,   960,   575,
    1003,  1139,    27,   498,  1093,   575,   498,   575,   498,  1003,
    1016,  1012,  1089,   175,   575,   179,   374,  1179,  1137,    12,
     125,  1219,   575,   857,   868,   871,  1125,  1137,   575,   191,
     258,   345,   435,  1149,  1150,  1153,  1154,   229,  1071,  1134,
     871,   567,   703,   609,   609,  1131,  1131,  1063,   267,   338,
     510,   981,   982,  1120,   609,  1073,  1140,   172,  1068,  1070,
     609,  1073,   230,   481,   160,   172,  1059,   575,  1068,  1131,
    1070,  1068,  1068,  1073,  1073,   523,   809,   575,   809,   447,
     430,   573,   577,   927,   928,   929,   930,   939,   940,   948,
    1119,   363,  1255,   352,   974,   980,  1218,   699,    64,   748,
      68,    80,   241,   311,   335,   389,   461,   618,   620,     6,
      13,    23,    24,    53,    57,    68,    77,    83,    96,   114,
     123,   124,   129,   137,   143,   169,   215,   217,   224,   292,
     307,   312,   352,   358,   361,   384,   385,   387,   401,   423,
     507,   516,   705,   707,   708,   709,   789,   790,   791,   970,
     112,   228,  1131,   827,  1134,  1004,   573,   574,   575,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   575,   525,   828,   697,   574,  1139,
      45,  1194,   609,   609,   179,  1131,   604,    44,   200,   425,
     776,   776,   344,  1048,  1046,   580,  1050,   175,   567,  1137,
     960,   871,   871,   871,    12,   125,   913,   961,   107,   166,
     203,   267,   338,   510,   984,   913,   913,   913,   871,   871,
     917,   917,   871,   917,   871,   871,   871,   871,   125,   913,
     961,   871,   574,   871,   871,   871,   871,   871,  1127,  1137,
     871,   871,   871,   871,   871,   573,  1220,   871,   956,   871,
     871,   871,   574,   871,   871,   871,   871,   917,   871,   871,
      97,   100,   491,   494,   958,   871,   125,   910,  1118,   871,
     871,   871,   574,   871,   871,   871,   871,   917,   871,   871,
     871,   871,   921,     9,   923,  1127,   125,   913,   871,   871,
     125,   913,   871,   871,   871,   871,   871,   917,   917,   917,
     871,   871,   871,   871,   871,   871,   917,   881,   871,   574,
     871,   871,   871,   871,   871,   574,   871,   871,   913,   913,
     871,   871,   871,   125,   913,   871,   871,   957,   957,   871,
      43,   245,   499,   871,   871,  1118,   574,   871,   574,   913,
    1128,  1129,  1137,   913,   871,   871,   871,   545,   926,  1223,
    1223,   574,   575,   574,   871,   579,   909,  1139,   580,   874,
     873,   876,   880,   158,   337,   504,   520,   889,    12,    17,
     880,   892,   573,   894,   881,   252,   881,   882,   229,   252,
     395,   562,   883,   884,   884,   885,   893,   885,   893,   886,
     886,   886,   886,   886,   894,   566,  1139,   894,   871,   895,
    1137,  1002,  1140,   797,  1139,   575,   390,  1083,  1003,  1085,
    1137,  1196,  1197,   567,  1131,  1137,  1191,  1191,  1191,   145,
     164,   184,   198,   243,   244,   271,   330,   371,  1172,  1174,
     546,   962,  1009,   218,   844,   845,  1131,   270,   390,   550,
    1165,  1164,   827,   871,  1134,  1140,  1140,   837,  1131,   156,
     382,   528,   820,   821,   822,   430,   436,   535,   536,   573,
     693,  1017,  1020,  1134,   192,  1191,  1191,  1191,  1214,   865,
     175,   226,   858,   859,   973,   974,   995,   867,   580,  1147,
     111,   500,  1137,  1156,   321,   361,   579,   748,  1155,  1134,
     175,  1072,   574,  1137,   263,   466,  1065,   341,   575,   445,
    1073,  1137,   381,   978,  1058,  1073,  1068,  1131,  1073,  1073,
     602,   810,   808,   947,  1137,    88,   219,   236,   249,   324,
     416,   471,   938,   436,   575,  1131,   947,   575,   172,  1256,
      45,   978,   145,   437,  1026,  1027,  1027,  1134,   461,   461,
     461,   461,   461,   429,    67,    79,   178,   450,   720,   723,
     724,   769,   771,   795,   795,  1027,  1027,   795,  1027,  1027,
    1027,   498,   122,  1027,   237,   484,   170,   372,   771,   795,
     237,  1027,   484,   122,  1027,  1027,  1027,   795,    45,  1027,
    1027,  1027,  1027,  1027,    18,   145,   498,   799,  1027,  1027,
    1027,   705,   575,   573,   580,   719,   725,  1130,  1137,   787,
     372,   954,  1137,   871,   984,  1134,  1134,   107,   166,   267,
     338,   510,   985,  1134,   984,  1134,  1134,  1134,  1134,  1134,
     984,  1134,  1134,   984,   601,   361,   489,  1245,     8,    27,
     685,   609,  1234,   252,   573,   687,   704,   706,   707,  1131,
     530,   962,  1137,   928,   580,  1051,   575,   574,   574,   575,
     913,   574,   914,   575,   574,   574,   574,    18,   574,   530,
     574,   574,   574,   574,   575,   575,   530,   575,   575,   904,
     574,   567,   574,   575,   575,   574,   574,   575,   574,   580,
     574,   575,   574,   575,   575,   575,   574,   575,   574,   575,
     175,   575,   575,   574,   575,   574,   575,   575,   574,   575,
     574,   574,   575,   574,   575,   575,   575,   906,   575,   574,
     575,   575,   574,   575,   575,   574,   575,   574,   575,   574,
     575,   575,   575,   574,   573,   575,   913,   574,   574,   574,
     913,   574,   574,   575,   575,   574,   574,   575,   574,   575,
     574,   574,   574,   574,   574,   574,   574,   575,   575,   574,
     575,   574,   229,   574,   574,   575,   575,   575,   574,   575,
     575,   574,   574,   574,   575,   175,   575,   575,   913,   574,
     574,   574,   575,   575,   575,   574,   175,   871,   175,   871,
     175,   871,   175,   574,   575,   575,   574,   574,   574,   574,
     574,   575,   574,   575,   574,   871,   545,   559,   925,   853,
    1222,  1220,   917,   578,   191,   258,   435,  1152,   437,  1137,
     351,   354,   887,    15,    16,   888,   158,   337,   504,   520,
     573,   871,  1220,   149,   966,   881,    16,   573,   894,   881,
     881,   956,   956,   871,   898,   899,   900,   573,   580,   595,
     262,   574,   575,   580,   580,   498,   498,   498,  1173,   963,
     979,   980,  1017,   489,  1136,   575,   846,   550,   258,   498,
     821,   694,  1018,   573,  1023,  1028,  1023,   574,   693,  1019,
    1124,  1125,  1128,  1137,  1021,   349,   175,   175,   175,   851,
     130,   928,   996,   172,   262,   863,   995,   979,   859,    18,
     869,  1134,  1137,   567,  1137,   580,   233,   580,  1026,    32,
     111,   749,   750,  1026,  1139,   172,  1026,   579,  1139,    32,
     111,   751,   752,  1139,   985,  1064,   147,   543,   982,   982,
     548,   338,   962,  1068,   575,   942,   947,   927,   236,   236,
     355,   949,   236,   249,   416,   949,   939,   927,  1038,  1039,
    1128,   927,   960,   944,   945,   984,   303,   975,   111,   753,
     755,  1139,   750,    96,    96,   112,   228,   779,  1130,   772,
     772,    58,   170,   372,   517,   722,   770,   721,   722,   779,
    1130,   985,   984,  1130,   984,  1134,  1134,   748,  1027,   984,
     238,   238,  1130,  1130,   710,  1027,   164,   243,   335,   713,
     985,   985,  1130,   971,   972,  1128,   111,   984,  1134,   984,
     984,   383,   386,   712,   984,  1131,    71,    72,   111,   133,
     165,   393,   711,   710,   573,   791,   717,   718,   719,   720,
    1137,     8,   164,   798,   394,   721,   761,   726,   580,   573,
    1235,   574,   575,   489,   573,   115,   223,   524,   686,  1244,
    1235,  1131,   252,   688,   693,   717,   214,   405,   690,  1106,
     575,   706,   605,   928,   973,   962,   960,   225,   871,   871,
     574,   871,   871,    32,    56,    97,   100,   108,   326,   443,
     494,   522,   915,   749,   917,   871,   749,   915,   871,   917,
     574,   893,   893,  1135,  1137,   871,   871,   917,  1135,   871,
     871,   871,   917,   338,   871,   871,   871,   871,   871,   871,
     871,   917,   917,   338,   871,   871,   917,   871,   871,   871,
     871,   917,   871,   881,  1127,   574,   574,   871,   871,   871,
     871,   871,   871,   871,   871,   871,   871,   871,   871,   917,
     225,   871,   871,   871,   871,   574,   871,   871,   871,   871,
     175,   871,   175,   871,   175,   871,   871,   338,   871,   871,
     560,   871,   871,   141,  1224,   574,   574,   580,   580,   580,
    1139,   871,   874,   877,  1220,   574,   575,   574,   894,   880,
     871,  1220,   966,    16,   574,   866,   901,   902,   916,   917,
    1137,  1197,   567,   567,  1193,  1193,  1193,   573,   871,   344,
    1033,  1101,   845,   214,   849,  1140,   860,  1024,  1025,  1128,
    1029,   575,   573,  1020,   574,   574,   575,   580,  1212,   175,
    1193,  1193,  1193,   962,   962,   131,   356,   991,   992,   997,
     524,   229,  1134,  1137,   580,  1137,   250,  1137,    12,    32,
     111,   344,   871,  1159,    64,   754,   871,  1140,   343,   361,
     489,  1158,  1152,  1026,   978,   275,  1073,   602,  1215,   943,
     249,   236,   939,   949,   949,   236,   344,   344,   530,   575,
    1037,  1026,   169,   214,   529,   950,   860,   871,   976,  1126,
     871,   238,   238,   772,   779,   775,   129,   436,   792,   750,
    1134,   779,   797,  1134,   793,   575,    19,   116,   977,  1003,
     574,   575,  1137,  1131,    31,    32,    37,    39,    41,    42,
      56,    97,   100,   108,   127,   144,   165,   167,   186,   187,
     227,   256,   265,   266,   268,   296,   297,   298,   317,   318,
     319,   323,   326,   339,   340,   365,   367,   391,   434,   436,
     446,   490,   491,   494,   495,   496,   497,   537,   538,   556,
     727,   730,   731,   732,   733,   734,   735,   736,  1137,  1137,
    1236,    18,  1137,  1246,   344,   413,   573,   610,    18,  1131,
     574,   574,    18,   696,   706,   573,   962,   253,   983,   871,
     574,   574,   574,   573,   742,   742,   573,   737,   738,   742,
     227,   227,   574,   574,   574,   574,   574,   574,   575,   905,
     956,   956,   574,   574,   574,   574,   574,   574,   575,   574,
     574,   574,   574,   574,   575,   574,   574,   574,   574,   574,
     912,   974,   575,   575,   575,   574,   574,   574,   574,   575,
     574,   574,   574,   575,   229,   548,   897,   574,   574,   574,
     574,   574,   574,   574,   574,   574,   575,   574,   574,   574,
     871,   574,   172,   574,   574,   575,   575,   574,   575,   575,
     574,   871,   574,   871,   574,   871,   574,   574,   575,   574,
     574,   871,   560,  1221,   580,   780,   574,   917,   574,   575,
     574,   880,   871,   575,   574,   407,  1198,  1198,  1198,   111,
     871,  1031,  1032,   132,  1106,   247,   864,   575,  1026,  1030,
    1031,  1028,  1022,  1020,  1124,  1137,  1193,   979,   195,   967,
    1136,  1136,   579,   993,   994,  1139,   438,   567,   390,   403,
     433,  1157,   755,  1026,   573,   573,  1156,   871,   145,   574,
     929,   355,   927,   939,   236,   236,   927,   939,   932,   931,
     933,  1039,   962,  1032,   771,   951,   951,   951,   864,   575,
     977,   779,   775,   573,   111,   111,   725,   754,   727,   972,
     574,   718,   762,   573,   573,   742,   737,   369,   728,   737,
     737,    20,    32,    46,   515,   748,   757,    56,   537,   731,
     733,   757,   757,    56,   538,   538,   541,   737,   729,   742,
     742,   757,   573,   742,    23,    64,    68,   111,   337,   344,
     372,   434,   517,   744,   745,   746,   760,   889,   541,   573,
     757,    32,   573,   758,   573,   573,   742,   573,   738,   743,
     580,   574,   575,  1237,  1238,   221,   229,   357,   630,   631,
     632,   633,   866,   108,   227,   391,   472,   716,   611,  1237,
     574,   689,   704,   573,   693,   777,   778,  1137,   982,   956,
     338,   757,   338,   871,   574,   574,   574,   871,   871,   432,
     911,   338,   871,   871,   871,   871,    41,   381,   574,   871,
     956,   871,   871,   871,   871,   871,   574,   574,   574,   338,
     871,  1212,  1137,   574,   917,   867,   902,    59,   234,   331,
     463,   474,   551,  1189,  1190,   548,  1199,  1199,  1199,   574,
     575,  1034,   226,   695,  1025,  1032,   574,  1215,    45,   201,
     964,   998,  1139,   575,   310,    69,   511,   390,  1158,   489,
     489,  1026,  1134,   960,   236,   344,   935,   939,   939,   344,
     937,   871,   871,   573,   973,   952,   946,  1126,   573,   573,
     777,   100,   491,   494,   565,   566,  1121,  1122,   798,   744,
     289,   344,   573,   763,   765,   766,   767,   338,   338,   443,
     522,   557,   739,   740,   741,   573,   739,   739,   758,    20,
     515,   748,   759,   758,   749,   757,   541,   739,   573,   757,
     338,   739,   753,  1134,   334,   747,  1121,   524,   111,   238,
     746,   238,   337,   338,   338,   338,   338,   739,   338,   739,
    1137,  1137,   548,  1240,   430,   573,  1239,   574,   575,   628,
    1131,   509,   626,   627,   629,  1137,  1240,  1215,   690,   693,
     691,   574,   575,   977,   573,   574,   574,   574,   575,   574,
     574,   575,   574,  1119,   574,   575,   574,   575,   574,   574,
     310,   154,   574,   574,   574,   574,   574,   574,   574,   575,
    1224,   574,   869,   489,   489,   489,    16,  1188,   192,   290,
     291,   294,   295,  1200,  1201,  1032,   238,  1102,   714,   859,
     979,   968,  1126,   965,   973,    66,  1107,   994,   574,   574,
    1159,    16,   927,   934,   530,   936,   530,   955,  1137,   983,
     573,   714,   977,   777,   777,   574,  1123,  1123,   794,   177,
     360,   444,   115,   524,   764,  1137,   767,   574,   574,   741,
     781,  1119,   749,   758,   781,   574,   870,   334,   536,   574,
     574,   574,   574,    50,    58,   258,   866,   866,  1247,   632,
    1137,   172,  1134,   574,   575,   628,   574,  1212,   778,   338,
     338,   871,   913,   871,   917,  1189,   349,   984,   984,   984,
     984,  1201,   524,   485,   863,   548,   575,   969,   977,   871,
     979,   138,   148,   350,   488,  1108,  1109,   255,  1110,   276,
     344,   871,   573,   871,   573,   574,   575,   953,   954,   574,
     574,   798,    49,   335,   411,   436,   768,   768,   574,   575,
     574,   575,   574,   870,   757,   758,   757,   758,    58,   349,
      58,   853,   852,   617,   727,   866,   612,   629,   727,   692,
     977,   574,   574,   574,   575,   574,   574,   574,  1040,  1041,
    1128,  1131,    89,   418,  1126,   374,   986,    45,    45,   138,
      45,  1109,   464,   488,  1111,  1112,   145,   941,   955,   955,
    1137,   574,   761,     5,   111,   337,   765,  1137,   757,  1119,
     757,   349,   349,   574,   121,   618,   619,   889,  1248,   134,
     413,  1215,   871,   575,  1026,  1103,   977,  1137,  1119,  1119,
      45,  1119,    45,    45,  1112,   985,   871,   574,   574,  1215,
     121,    61,   161,   213,   235,   248,   347,   414,   561,   649,
     650,   653,   662,   663,   666,   677,  1133,  1138,  1142,   424,
     613,   574,  1041,  1032,  1107,   987,  1119,  1119,  1119,    16,
     578,  1137,   175,   330,   655,   652,  1138,  1138,  1137,   651,
     664,   667,   586,    28,   269,   404,   547,   680,   582,  1242,
     727,  1110,   573,   280,   175,  1137,   657,   658,   871,   871,
     545,   669,   673,   681,   635,   649,   635,   682,   678,   649,
     614,   214,  1113,   866,   988,   989,   990,   145,   226,   141,
     871,   665,   674,   559,   673,   676,   636,   141,   649,   581,
     523,   871,   680,   617,   338,   573,  1114,   871,   574,   575,
     984,   654,   213,   560,   545,   668,   670,   871,   635,   141,
     109,   634,   637,   269,   581,   684,   128,   679,  1138,   615,
     255,   574,   579,  1115,  1116,  1128,   436,  1117,   990,   656,
    1137,   659,   671,   670,   676,   675,   561,    82,   153,   642,
     647,  1137,   141,   649,   581,   871,   683,   649,  1139,   574,
     575,  1040,   575,   635,   871,   141,   560,   199,   575,   638,
      76,    92,   581,   141,   635,  1116,  1137,   660,   672,   561,
     635,   172,  1137,   727,   172,   172,   404,   141,   135,   559,
     661,   560,   639,   111,   648,   453,   644,   984,   640,   641,
     547,   657,   635,   635,   452,   454,   643,   644,   646,   889,
    1137,   871,   536,   645,   586,   575,   649,   173,  1135,   646
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1075 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1088 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1148 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1168 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1182 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1189 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1198 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1210 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1224 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              YYABORT;
        }
    break;

  case 66:
#line 1236 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           YYABORT;
         }
       }
    break;

  case 67:
#line 1244 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1254 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1260 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1269 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1274 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1279 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1284 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1289 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1293 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1298 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1302 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1306 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1310 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1314 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1323 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1327 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1343 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1347 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1358 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 (using_update_log ?
						  TL_READ_NO_INSERT:
						  TL_READ)))
	    YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	  lex->name=0;
	}
    break;

  case 89:
#line 1378 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1380 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1392 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-9].key_type), (yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1400 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1405 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1412 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1418 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1420 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1427 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1442 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str));
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1457 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str));
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1475 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[-2].num);
	    lex->udf.dl=(yyvsp[0].lex_str).str;
	  }
    break;

  case 101:
#line 1494 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(YYTHD);
	    sp->init(lex);
            sp->init_sp_name(YYTHD, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= YYTHD->client_capabilities & CLIENT_MULTI_QUERIES;
	    YYTHD->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lex->tok_start+1;
	  }
    break;

  case 102:
#line 1531 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_param_end= lex->tok_start;
	  }
    break;

  case 103:
#line 1537 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1545 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[0].num),
                                          &sp->m_return_field_def))
              YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1557 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lex->tok_start;
	  }
    break;

  case 106:
#line 1564 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1586 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1587 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1591 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1592 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1598 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 112:
#line 1600 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1602 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1604 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1606 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1608 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1610 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1615 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1616 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1617 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1622 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1626 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1633 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1641 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1657 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 130:
#line 1661 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 135:
#line 1679 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1699 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1736 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1761 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 143:
#line 1762 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 144:
#line 1763 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 145:
#line 1764 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 146:
#line 1768 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1773 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1779 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 151:
#line 1783 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 152:
#line 1809 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 153:
#line 1817 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 154:
#line 1865 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 155:
#line 1879 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	    sp->m_flags|= sp_head::IN_HANDLER;
	  }
    break;

  case 156:
#line 1892 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);
	    sp->m_flags&= ~sp_head::IN_HANDLER;
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    ctx->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 157:
#line 1919 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 158:
#line 1942 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 1951 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 1973 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 1974 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 1980 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= 1;
	    }
	  }
    break;

  case 163:
#line 2001 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
	        (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= (yyvsp[-2].num) + 1;
	    }
	  }
    break;

  case 164:
#line 2025 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 165:
#line 2031 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 166:
#line 2045 "sql_yacc.yy"
    {}
    break;

  case 167:
#line 2046 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2051 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 169:
#line 2055 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	  }
    break;

  case 170:
#line 2064 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 171:
#line 2069 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 172:
#line 2074 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 173:
#line 2082 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 174:
#line 2097 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 175:
#line 2114 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 176:
#line 2115 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 177:
#line 2119 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->reset_lex(YYTHD);
	    lex->sphead->m_tmp_query= lex->tok_start;
	  }
    break;

  case 178:
#line 2126 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lex->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lex->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(YYTHD->mem_root,
                                           (char *)sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(YYTHD);
          }
    break;

  case 179:
#line 2165 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 180:
#line 2167 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 181:
#line 2188 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 182:
#line 2190 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 184:
#line 2193 "sql_yacc.yy"
    {}
    break;

  case 185:
#line 2194 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 186:
#line 2200 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 187:
#line 2206 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 188:
#line 2235 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2263 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 190:
#line 2278 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2293 "sql_yacc.yy"
    { }
    break;

  case 192:
#line 2295 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 196:
#line 2319 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 197:
#line 2340 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2362 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 199:
#line 2364 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 200:
#line 2378 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 201:
#line 2389 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 207:
#line 2409 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 208:
#line 2415 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2426 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 210:
#line 2434 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 211:
#line 2442 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 216:
#line 2460 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 217:
#line 2464 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2473 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 219:
#line 2481 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 220:
#line 2485 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2492 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 222:
#line 2500 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 224:
#line 2513 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 225:
#line 2531 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 226:
#line 2550 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 227:
#line 2551 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 228:
#line 2556 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context();
	  }
    break;

  case 229:
#line 2568 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).hndlrs));
	    if ((yyvsp[-2].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 230:
#line 2584 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 231:
#line 2593 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 232:
#line 2595 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 233:
#line 2609 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 234:
#line 2619 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 235:
#line 2621 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 236:
#line 2637 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 237:
#line 2639 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 238:
#line 2644 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 239:
#line 2646 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 240:
#line 2648 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 241:
#line 2652 "sql_yacc.yy"
    {}
    break;

  case 242:
#line 2653 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2655 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[0].table)))
              YYABORT;
            if ((yyvsp[0].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[0].table)->db.str), &((yyvsp[0].table)->db.length)))
            {
              YYABORT;
            }
          }
    break;

  case 244:
#line 2667 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[-1].table)))
              YYABORT;
            if ((yyvsp[-1].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[-1].table)->db.str), &((yyvsp[-1].table)->db.length)))
            {
              YYABORT;
            }
          }
    break;

  case 245:
#line 2681 "sql_yacc.yy"
    {}
    break;

  case 246:
#line 2682 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 247:
#line 2682 "sql_yacc.yy"
    {}
    break;

  case 248:
#line 2686 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2688 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 250:
#line 2688 "sql_yacc.yy"
    {}
    break;

  case 251:
#line 2690 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 252:
#line 2690 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2695 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 254:
#line 2711 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 255:
#line 2715 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 256:
#line 2725 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2726 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2729 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2730 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2733 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2734 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2737 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2738 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2741 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 265:
#line 2742 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 266:
#line 2745 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 267:
#line 2746 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 268:
#line 2749 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 269:
#line 2752 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 270:
#line 2753 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 278:
#line 2769 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 279:
#line 2770 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2771 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 281:
#line 2772 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 282:
#line 2773 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 283:
#line 2774 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 284:
#line 2775 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 285:
#line 2776 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 286:
#line 2778 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                yyerror(ER(ER_SYNTAX_ERROR));
                YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 287:
#line 2793 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2798 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 289:
#line 2799 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 290:
#line 2800 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 291:
#line 2802 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    YYABORT;
	  }
    break;

  case 292:
#line 2807 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    YYABORT;
	  }
    break;

  case 293:
#line 2812 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    YYABORT;
	  }
    break;

  case 294:
#line 2817 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 297:
#line 2833 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 298:
#line 2834 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 299:
#line 2835 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 300:
#line 2836 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 301:
#line 2841 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 302:
#line 2858 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2874 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 304:
#line 2883 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 305:
#line 2884 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 306:
#line 2885 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 307:
#line 2886 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 308:
#line 2887 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 309:
#line 2888 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 310:
#line 2891 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 311:
#line 2892 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 2893 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 313:
#line 2896 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 314:
#line 2897 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 315:
#line 2898 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 316:
#line 2901 "sql_yacc.yy"
    {}
    break;

  case 318:
#line 2905 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_FUNCTION; }
    break;

  case 319:
#line 2906 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_AGGREGATE; }
    break;

  case 320:
#line 2909 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 321:
#line 2910 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 322:
#line 2911 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 323:
#line 2912 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 329:
#line 2927 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 330:
#line 2934 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-5].key_type), (yyvsp[-4].simple_string), (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 2942 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-6].simple_string);
            Key *key= new Key((yyvsp[-5].key_type), key_name, (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 2950 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string) : (yyvsp[-7].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[0].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 2967 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 2971 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 338:
#line 2986 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 339:
#line 2987 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].simple_string); }
    break;

  case 340:
#line 2991 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].simple_string); }
    break;

  case 341:
#line 2996 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 342:
#line 3004 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[-3].lex_str).str,
				(enum enum_field_types) (yyvsp[-1].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    YYABORT;
	}
    break;

  case 343:
#line 3017 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 344:
#line 3018 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 345:
#line 3019 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 346:
#line 3020 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 347:
#line 3022 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 348:
#line 3024 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 349:
#line 3026 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 350:
#line 3028 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 351:
#line 3030 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 352:
#line 3032 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 353:
#line 3035 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 354:
#line 3038 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 355:
#line 3041 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 356:
#line 3044 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 357:
#line 3046 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 358:
#line 3049 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 359:
#line 3052 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 360:
#line 3053 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 361:
#line 3054 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 362:
#line 3056 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 363:
#line 3068 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 364:
#line 3069 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 365:
#line 3071 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 366:
#line 3074 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[0].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            YYABORT;
#endif
          }
    break;

  case 367:
#line 3085 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 368:
#line 3087 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 369:
#line 3089 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 370:
#line 3091 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 371:
#line 3092 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 372:
#line 3093 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 373:
#line 3094 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 374:
#line 3095 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 375:
#line 3097 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 376:
#line 3099 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 377:
#line 3101 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 378:
#line 3102 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 379:
#line 3103 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 380:
#line 3104 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 381:
#line 3105 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 382:
#line 3106 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 383:
#line 3108 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 384:
#line 3116 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 385:
#line 3117 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 386:
#line 3118 "sql_yacc.yy"
    { Lex->length= (char*)"21";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 387:
#line 3121 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 388:
#line 3122 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 389:
#line 3123 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 390:
#line 3124 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 391:
#line 3125 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 392:
#line 3129 "sql_yacc.yy"
    {}
    break;

  case 393:
#line 3133 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3134 "sql_yacc.yy"
    {}
    break;

  case 395:
#line 3138 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3139 "sql_yacc.yy"
    {}
    break;

  case 397:
#line 3143 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3144 "sql_yacc.yy"
    {}
    break;

  case 399:
#line 3145 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3146 "sql_yacc.yy"
    {}
    break;

  case 401:
#line 3147 "sql_yacc.yy"
    {}
    break;

  case 402:
#line 3151 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 403:
#line 3152 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 404:
#line 3153 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 405:
#line 3154 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 406:
#line 3155 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 407:
#line 3158 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 408:
#line 3160 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 409:
#line 3161 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 410:
#line 3165 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 411:
#line 3166 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 412:
#line 3167 "sql_yacc.yy"
    {}
    break;

  case 413:
#line 3171 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[-3].lex_str).str; lex->dec=(yyvsp[-1].lex_str).str;
	}
    break;

  case 414:
#line 3177 "sql_yacc.yy"
    {}
    break;

  case 415:
#line 3178 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3181 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3182 "sql_yacc.yy"
    {}
    break;

  case 418:
#line 3185 "sql_yacc.yy"
    {}
    break;

  case 419:
#line 3186 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 420:
#line 3187 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 421:
#line 3190 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 422:
#line 3191 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str; }
    break;

  case 423:
#line 3194 "sql_yacc.yy"
    {}
    break;

  case 424:
#line 3195 "sql_yacc.yy"
    {}
    break;

  case 425:
#line 3198 "sql_yacc.yy"
    {}
    break;

  case 426:
#line 3199 "sql_yacc.yy"
    {}
    break;

  case 427:
#line 3202 "sql_yacc.yy"
    {}
    break;

  case 429:
#line 3206 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 430:
#line 3207 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 431:
#line 3208 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[0].item); }
    break;

  case 432:
#line 3210 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 433:
#line 3211 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 434:
#line 3213 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 435:
#line 3219 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 436:
#line 3225 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 437:
#line 3231 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 438:
#line 3236 "sql_yacc.yy"
    { Lex->comment= (yyvsp[0].lex_str); }
    break;

  case 439:
#line 3238 "sql_yacc.yy"
    {
	    if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name,Lex->charset->csname);
	      YYABORT;
	    }
	    else
	    {
	      Lex->charset=(yyvsp[0].charset);
	    }
	  }
    break;

  case 440:
#line 3253 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 441:
#line 3254 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[0].item); }
    break;

  case 442:
#line 3258 "sql_yacc.yy"
    {}
    break;

  case 443:
#line 3259 "sql_yacc.yy"
    {}
    break;

  case 444:
#line 3264 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 445:
#line 3271 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 446:
#line 3275 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 447:
#line 3276 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 448:
#line 3281 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))) &&
	      !((yyval.charset)=get_old_charset_by_name((yyvsp[0].lex_str).str)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 449:
#line 3289 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 450:
#line 3293 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 451:
#line 3294 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 452:
#line 3298 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_name((yyvsp[0].lex_str).str,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 453:
#line 3307 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 454:
#line 3308 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset); }
    break;

  case 455:
#line 3312 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 456:
#line 3313 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 457:
#line 3316 "sql_yacc.yy"
    {}
    break;

  case 458:
#line 3317 "sql_yacc.yy"
    {}
    break;

  case 459:
#line 3320 "sql_yacc.yy"
    { Lex->charset=NULL; }
    break;

  case 460:
#line 3321 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 461:
#line 3322 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin; }
    break;

  case 462:
#line 3324 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    YYABORT;
	  }
	}
    break;

  case 463:
#line 3332 "sql_yacc.yy"
    { Lex->charset=(yyvsp[-1].charset); }
    break;

  case 464:
#line 3333 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 465:
#line 3336 "sql_yacc.yy"
    { }
    break;

  case 466:
#line 3337 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 467:
#line 3340 "sql_yacc.yy"
    { Lex->charset= NULL; }
    break;

  case 468:
#line 3341 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 469:
#line 3343 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    YYABORT;
	  }
	}
    break;

  case 470:
#line 3351 "sql_yacc.yy"
    { Lex->charset=(yyvsp[0].charset); }
    break;

  case 473:
#line 3360 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->fk_delete_opt= lex->fk_update_opt= lex->fk_match_option= 0;
	  lex->ref_list.empty();
	}
    break;

  case 474:
#line 3366 "sql_yacc.yy"
    {
	  (yyval.table)=(yyvsp[-2].table);
	}
    break;

  case 475:
#line 3371 "sql_yacc.yy"
    {}
    break;

  case 476:
#line 3372 "sql_yacc.yy"
    {}
    break;

  case 477:
#line 3375 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 478:
#line 3376 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 479:
#line 3380 "sql_yacc.yy"
    {}
    break;

  case 480:
#line 3381 "sql_yacc.yy"
    {}
    break;

  case 481:
#line 3384 "sql_yacc.yy"
    {}
    break;

  case 482:
#line 3385 "sql_yacc.yy"
    {}
    break;

  case 483:
#line 3388 "sql_yacc.yy"
    { Lex->fk_delete_opt= (yyvsp[0].num); }
    break;

  case 484:
#line 3389 "sql_yacc.yy"
    { Lex->fk_update_opt= (yyvsp[0].num); }
    break;

  case 485:
#line 3390 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_FULL; }
    break;

  case 486:
#line 3391 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_PARTIAL; }
    break;

  case 487:
#line 3392 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_SIMPLE; }
    break;

  case 488:
#line 3395 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_RESTRICT; }
    break;

  case 489:
#line 3396 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_CASCADE; }
    break;

  case 490:
#line 3397 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_SET_NULL; }
    break;

  case 491:
#line 3398 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_NO_ACTION; }
    break;

  case 492:
#line 3399 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_DEFAULT;  }
    break;

  case 493:
#line 3402 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 494:
#line 3403 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT; }
    break;

  case 495:
#line 3405 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
	    my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    YYABORT;
#endif
	  }
    break;

  case 496:
#line 3416 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 497:
#line 3417 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 498:
#line 3420 "sql_yacc.yy"
    {}
    break;

  case 499:
#line 3421 "sql_yacc.yy"
    {}
    break;

  case 500:
#line 3424 "sql_yacc.yy"
    {}
    break;

  case 502:
#line 3429 "sql_yacc.yy"
    {}
    break;

  case 503:
#line 3430 "sql_yacc.yy"
    {}
    break;

  case 504:
#line 3431 "sql_yacc.yy"
    {}
    break;

  case 505:
#line 3434 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 506:
#line 3435 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 507:
#line 3436 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT;}
    break;

  case 508:
#line 3438 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    YYABORT;
#endif
	  }
    break;

  case 509:
#line 3450 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_UNDEF; }
    break;

  case 510:
#line 3451 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 511:
#line 3452 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 512:
#line 3455 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 513:
#line 3457 "sql_yacc.yy"
    {
	    (yyval.key_alg)= HA_KEY_ALG_RTREE;
	  }
    break;

  case 514:
#line 3460 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 515:
#line 3463 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 516:
#line 3464 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 517:
#line 3467 "sql_yacc.yy"
    { (yyval.key_part)=new key_part_spec((yyvsp[0].lex_str).str); }
    break;

  case 518:
#line 3469 "sql_yacc.yy"
    {
          int key_part_len= atoi((yyvsp[-1].lex_str).str);
          if (!key_part_len)
          {
            my_error(ER_KEY_PART_0, MYF(0), (yyvsp[-3].lex_str).str);
          }
          (yyval.key_part)=new key_part_spec((yyvsp[-3].lex_str).str,(uint) key_part_len);
        }
    break;

  case 519:
#line 3479 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 520:
#line 3480 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].lex_str).str; }
    break;

  case 521:
#line 3483 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 522:
#line 3484 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 523:
#line 3487 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 524:
#line 3488 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 525:
#line 3496 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex= thd->lex;
	  lex->sql_command= SQLCOM_ALTER_TABLE;
	  lex->name= 0;
	  lex->duplicates= DUP_ERROR; 
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING))
	    YYABORT;
	  lex->col_list.empty();
          lex->select_lex.init_order();
	  lex->select_lex.db=
            ((TABLE_LIST*) lex->select_lex.table_list.first)->db;
          lex->name=0;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.db_type= DB_TYPE_DEFAULT;
	  lex->create_info.default_table_charset= NULL;
	  lex->create_info.row_type= ROW_TYPE_NOT_USED;
          lex->alter_info.reset();
	}
    break;

  case 526:
#line 3517 "sql_yacc.yy"
    {}
    break;

  case 527:
#line 3519 "sql_yacc.yy"
    {
            Lex->create_info.default_table_charset= NULL;
            Lex->create_info.used_fields= 0;
          }
    break;

  case 528:
#line 3524 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            THD *thd= Lex->thd;
	    lex->sql_command=SQLCOM_ALTER_DB;
	    lex->name= (yyvsp[-2].simple_string);
            if (lex->name == NULL && thd->copy_db_to(&lex->name, NULL))
              YYABORT;
	  }
    break;

  case 529:
#line 3533 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "PROCEDURE");
	      YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 530:
#line 3544 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_PROCEDURE;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 531:
#line 3551 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "FUNCTION");
	      YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 532:
#line 3562 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_FUNCTION;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 533:
#line 3570 "sql_yacc.yy"
    {
	    THD *thd= YYTHD;
	    LEX *lex= thd->lex;
	    lex->sql_command= SQLCOM_CREATE_VIEW;
	    lex->create_view_mode= VIEW_ALTER;
	    /* first table in list is target VIEW name */
	    lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL, TL_OPTION_UPDATING);
	  }
    break;

  case 534:
#line 3579 "sql_yacc.yy"
    {}
    break;

  case 535:
#line 3583 "sql_yacc.yy"
    { (yyval.simple_string)= 0; }
    break;

  case 536:
#line 3584 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].lex_str).str; }
    break;

  case 538:
#line 3587 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= DISCARD_TABLESPACE; }
    break;

  case 539:
#line 3588 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= IMPORT_TABLESPACE; }
    break;

  case 542:
#line 3594 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->change=0;
	  lex->alter_info.flags|= ALTER_ADD_COLUMN;
	}
    break;

  case 543:
#line 3601 "sql_yacc.yy"
    { }
    break;

  case 544:
#line 3603 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_ADD_INDEX;
	  }
    break;

  case 545:
#line 3607 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_ADD_COLUMN | ALTER_ADD_INDEX;
          }
    break;

  case 546:
#line 3611 "sql_yacc.yy"
    {
	     LEX *lex=Lex;
	     lex->change= (yyvsp[0].lex_str).str;
	     lex->alter_info.flags|= ALTER_CHANGE_COLUMN;
	  }
    break;

  case 548:
#line 3618 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->length=lex->dec=0; lex->type=0;
            lex->default_value= lex->on_update_value= 0;
            lex->comment=null_lex_str;
	    lex->charset= NULL;
	    lex->alter_info.flags|= ALTER_CHANGE_COLUMN;
          }
    break;

  case 549:
#line 3627 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (add_field_to_list(lex->thd,(yyvsp[-3].lex_str).str,
                                  (enum enum_field_types) (yyvsp[-1].num),
                                  lex->length,lex->dec,lex->type,
                                  lex->default_value, lex->on_update_value,
                                  &lex->comment,
				  (yyvsp[-3].lex_str).str, &lex->interval_list, lex->charset,
				  lex->uint_geom_type))
	       YYABORT;
          }
    break;

  case 551:
#line 3640 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::COLUMN,
                                                               (yyvsp[-1].lex_str).str));
	    lex->alter_info.flags|= ALTER_DROP_COLUMN;
	  }
    break;

  case 552:
#line 3647 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_DROP_INDEX;
          }
    break;

  case 553:
#line 3651 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::KEY,
				               primary_key_name));
	    lex->alter_info.flags|= ALTER_DROP_INDEX;
	  }
    break;

  case 554:
#line 3658 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::KEY,
					                       (yyvsp[0].lex_str).str));
	    lex->alter_info.flags|= ALTER_DROP_INDEX;
	  }
    break;

  case 555:
#line 3665 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->alter_info.keys_onoff= DISABLE;
	    lex->alter_info.flags|= ALTER_KEYS_ONOFF;
          }
    break;

  case 556:
#line 3671 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->alter_info.keys_onoff= ENABLE;
	    lex->alter_info.flags|= ALTER_KEYS_ONOFF;
          }
    break;

  case 557:
#line 3677 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.alter_list.push_back(new Alter_column((yyvsp[-3].lex_str).str,(yyvsp[0].item)));
	    