#!/bin/sh
# @(#)cc-config.sh	1.6 05/07/14 Copyright 2002 J. Schilling
###########################################################################
# Written 2002 by J. Schilling
###########################################################################
# Configuration script called to verify system default C-compiler.
# It tries to fall back to GCC if the system default could not be found.
###########################################################################
#@@C@@
###########################################################################

#
# Usage:
#	sh ./conf/cc-config.sh cc incs/Dcc.<platform>
#
if [ $# -lt 2 ]; then
	echo 'Usage: sh ./conf/cc-config.sh [-echo] cc incs/Dcc.<platform>'
	echo 'Options:'
	echo '	-echo	Do not write into incs/Dcc.<platform> but echo to stdout'
	echo
	echo 'The "cc" parameter is the name of the preferred C-compiler'
	exit 1
fi

echo=echo
if [ ".$1" = .-echo ]; then
	echo=:
	shift
fi

#
# Try to make sure all error messages are in english.
#
LC_ALL=C
LANG=C

CC=$1
${echo} "Trying to find $CC"

#
# Check if we are on SunOS-5.x and /usr/ucb is in PATH before /opt/SUNWspro/bin
# /usr/ucb/cc will not work correctly to compile things on Solaris.
#
# This check will also catch the case where no Sun C-compiler is installed and
# calling cc results in the message:
#	/usr/ucb/cc:  language optional software package not installed
#
xos=`echo "$2" | grep sunos5 `
if [ -n "$xos" ]; then
	#
	# On Solaris, the type builtin is working.
	#
	xcc=`type "$CC" | grep /usr/ucb/cc`
	if [ -n "$xcc" ]; then
		#
		# We did find /usr/ucb/cc
		#
		echo											1>&2
		echo 'Warning:' "$xcc"									1>&2
		echo '         You should not have "/usr/ucb" in your PATH if you like to compile.'	1>&2
		echo '         If you did install a C-compiler in /opt/SUNWspro/bin, abort'		1>&2
		echo '         fix your PATH and start again.'						1>&2
		echo '         Otherwise GCC will be used.'						1>&2
		echo											1>&2
		sleep 60
		CC=do-no-use-ucb-cc
	fi
fi

#
# There are old shells that don't support the 'type' builtin.
# For this reason it is not a simple task to find out whether
# this compiler exists and works.
#
# First try to run the default C-compiler without args
#
eval "$CC > /dev/null 2>&1" 2> /dev/null
if [ $? = 0 ]; then
	${echo} "Found $CC"
	${echo} "Creating empty '$2'"
	if [ ${echo} = echo ]; then
		:> $2
	else
		echo "$1"
	fi
	exit
fi

#
# Now try to run the default C-compiler and check whether it creates
# any output (usually an error message).
#
# This test will fail if the shell does redirect the error message
# "cc: not found". All shells I tested (except ksh) send this message to
# the stderr stream the shell itself is attached to and only redirects the
# output from the command. As there may no output if there is no binary,
# this prooves the existence of the default compiler.
#
ccout=`eval "$CC 2>&1" 2>/dev/null`
ret=$?

nf=`echo "$ccout" | grep 'not found' `
if [ $ret = 127 -a -n "$nf" ]; then
	#
	# ksh redirects even the error message from the shell, but we
	# see that there is no executable because the exit code is 127
	# we detect "command not found" if exit code is 127 and
	# the message contains 'not found'
	#
	ccout=""
fi

if [ -n "$ccout" ]; then
	${echo} "Found $CC"
	${echo} "Creating empty '$2'"
	if [ ${echo} = echo ]; then
		:> $2
	else
		echo "$1"
	fi
	exit
fi

#
# If the current default is gcc, try cc.
# If the current default is cc, try gcc.
#
if [ ".$CC" = ".gcc" ]; then
	XCC=cc
	${echo} 'Trying to find cc'
	ccout=`"eval cc -c tt.$$.c 2>&1" 2> /dev/null`
	ret=$?
	nf=`echo "$ccout" | grep 'not found' `
	if [ $ret = 127 -a -n "$nf" ]; then
		#
		# ksh redirects even the error message from the shell, but we
		# see that there is no executable because the exit code is 127
		# we detect "command not found" if exit code is 127 and
		# the message contains 'not found'
		#
		ccout=""
	fi
	if [ -n "$ccout" ]; then
		CC=cc
	fi
else
	XCC=gcc
	${echo} 'Trying to find GCC'
	eval "gcc -v" 2> /dev/null && CC=gcc
fi

if [ ".$CC" = ".$1" ]; then
	${echo} "$XCC not found, keeping current global default"
	${echo} "Creating empty '$2'"
	if [ ${echo} = echo ]; then
		:> $2
	else
		echo "$1"
	fi
else
	${echo} "Found $CC"
	${echo} "Making $CC the default compiler in '$2'"
	if [ ${echo} = echo ]; then
		echo DEFCCOM=$CC > $2
	else
		echo "$CC"
	fi
fi
