// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

#ifndef QVALUE3DAXIS_H
#define QVALUE3DAXIS_H

#if 0
#  pragma qt_class(QValue3DAxis)
#endif

#include <QtGraphs/qabstract3daxis.h>
#include <QtGraphs/qvalue3daxisformatter.h>

QT_BEGIN_NAMESPACE

class QValue3DAxisPrivate;

class QT_TECH_PREVIEW_API Q_GRAPHS_EXPORT QValue3DAxis : public QAbstract3DAxis
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(QValue3DAxis)
    Q_PROPERTY(int segmentCount READ segmentCount WRITE setSegmentCount NOTIFY segmentCountChanged)
    Q_PROPERTY(int subSegmentCount READ subSegmentCount WRITE setSubSegmentCount NOTIFY
                   subSegmentCountChanged)
    Q_PROPERTY(QString labelFormat READ labelFormat WRITE setLabelFormat NOTIFY labelFormatChanged)
    Q_PROPERTY(
        QValue3DAxisFormatter *formatter READ formatter WRITE setFormatter NOTIFY formatterChanged)
    Q_PROPERTY(bool reversed READ reversed WRITE setReversed NOTIFY reversedChanged)

public:
    explicit QValue3DAxis(QObject *parent = nullptr);
    ~QValue3DAxis() override;

    void setSegmentCount(int count);
    int segmentCount() const;

    void setSubSegmentCount(int count);
    int subSegmentCount() const;

    void setLabelFormat(const QString &format);
    QString labelFormat() const;

    void setFormatter(QValue3DAxisFormatter *formatter);
    QValue3DAxisFormatter *formatter() const;

    void setReversed(bool enable);
    bool reversed() const;

    void recalculate();
    int gridSize();
    int subGridSize();
    float gridPositionAt(int gridLine);
    float subGridPositionAt(int gridLine);
    float labelPositionAt(int index);
    float positionAt(float x);
    QString stringForValue(float x);

Q_SIGNALS:
    void segmentCountChanged(int count);
    void subSegmentCountChanged(int count);
    void labelFormatChanged(const QString &format);
    void formatterChanged(QValue3DAxisFormatter *formatter);
    void reversedChanged(bool enable);
    void formatterDirty();

private:
    Q_DISABLE_COPY(QValue3DAxis)
    friend class QQuickGraphsItem;
    friend class QQuickGraphsBars;
    friend class QQuickGraphsScatter;
    friend class QQuickGraphsSurface;
    friend class QValue3DAxisFormatterPrivate;
};

QT_END_NAMESPACE

#endif
