#!/usr/bin/env python
# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from shiboken_paths import init_paths
init_paths()

from sample import Base1, MDerived1


class VisibilityChangeTest(unittest.TestCase):

    def testVisibilityChange(self):
        b1 = Base1()
        b1.publicMethod()  # ok...
        d1 = MDerived1()
        self.assertRaises(TypeError, d1.publicMethod)


if __name__ == '__main__':
    unittest.main()
