/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLRenderSharedExponent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSWebGLRenderSharedExponentPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLRenderSharedExponentPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLRenderSharedExponentPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLRenderSharedExponentPrototype>(vm)) JSWebGLRenderSharedExponentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLRenderSharedExponentPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLRenderSharedExponentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLRenderSharedExponentPrototype, JSWebGLRenderSharedExponentPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSWebGLRenderSharedExponentPrototype::s_info = { "WebGLRenderSharedExponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLRenderSharedExponentPrototype) };

void JSWebGLRenderSharedExponentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLRenderSharedExponent::s_info = { "WebGLRenderSharedExponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLRenderSharedExponent) };

JSWebGLRenderSharedExponent::JSWebGLRenderSharedExponent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLRenderSharedExponent>&& impl)
    : JSDOMWrapper<WebGLRenderSharedExponent>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLRenderSharedExponent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLRenderSharedExponent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLRenderSharedExponentPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLRenderSharedExponentPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLRenderSharedExponent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLRenderSharedExponent>(vm, globalObject);
}

void JSWebGLRenderSharedExponent::destroy(JSC::JSCell* cell)
{
    JSWebGLRenderSharedExponent* thisObject = static_cast<JSWebGLRenderSharedExponent*>(cell);
    thisObject->JSWebGLRenderSharedExponent::~JSWebGLRenderSharedExponent();
}

JSC::GCClient::IsoSubspace* JSWebGLRenderSharedExponent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLRenderSharedExponent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLRenderSharedExponent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLRenderSharedExponent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLRenderSharedExponent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLRenderSharedExponent = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLRenderSharedExponent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLRenderSharedExponent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLRenderSharedExponentOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLRenderSharedExponent = jsCast<JSWebGLRenderSharedExponent*>(handle.slot()->asCell());
    auto& owner = jsWebGLRenderSharedExponent->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLRenderSharedExponent"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLRenderSharedExponentOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLRenderSharedExponent = static_cast<JSWebGLRenderSharedExponent*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLRenderSharedExponent->protectedWrapped().ptr(), jsWebGLRenderSharedExponent);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLRenderSharedExponent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25WebGLRenderSharedExponentE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLRenderSharedExponent>, void>> static inline void verifyVTable(WebGLRenderSharedExponent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLRenderSharedExponent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25WebGLRenderSharedExponentE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLRenderSharedExponent has subclasses. If WebGLRenderSharedExponent has subclasses that get passed
        // to toJS() we currently require WebGLRenderSharedExponent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLRenderSharedExponent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLRenderSharedExponent>(impl.ptr());
#endif
    return createWrapper<WebGLRenderSharedExponent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLRenderSharedExponent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLRenderSharedExponent* JSWebGLRenderSharedExponent::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLRenderSharedExponent*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
