/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRsaOtherPrimesInfo.h"

#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<RsaOtherPrimesInfo>> convertDictionary<RsaOtherPrimesInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    RsaOtherPrimesInfo result;
    JSValue dValue;
    if (isNullOrUndefined)
        dValue = jsUndefined();
    else {
        dValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "d"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (dValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "d"_s, "RsaOtherPrimesInfo"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto dConversionResult = convert<IDLDOMString>(lexicalGlobalObject, dValue);
    if (UNLIKELY(dConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.d = dConversionResult.releaseReturnValue();
    JSValue rValue;
    if (isNullOrUndefined)
        rValue = jsUndefined();
    else {
        rValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "r"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (rValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "r"_s, "RsaOtherPrimesInfo"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto rConversionResult = convert<IDLDOMString>(lexicalGlobalObject, rValue);
    if (UNLIKELY(rConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.r = rConversionResult.releaseReturnValue();
    JSValue tValue;
    if (isNullOrUndefined)
        tValue = jsUndefined();
    else {
        tValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "t"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (tValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "t"_s, "RsaOtherPrimesInfo"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto tConversionResult = convert<IDLDOMString>(lexicalGlobalObject, tValue);
    if (UNLIKELY(tConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.t = tConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RsaOtherPrimesInfo& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto dValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.d);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "d"_s), dValue);
    auto rValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.r);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "r"_s), rValue);
    auto tValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.t);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "t"_s), tValue);
    return result;
}

} // namespace WebCore
