/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSNumericBaseType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CSSNumericBaseType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("length"),
        MAKE_STATIC_STRING_IMPL("angle"),
        MAKE_STATIC_STRING_IMPL("time"),
        MAKE_STATIC_STRING_IMPL("frequency"),
        MAKE_STATIC_STRING_IMPL("resolution"),
        MAKE_STATIC_STRING_IMPL("flex"),
        MAKE_STATIC_STRING_IMPL("percent"),
    };
    static_assert(static_cast<size_t>(CSSNumericBaseType::Length) == 0, "CSSNumericBaseType::Length is not 0 as expected");
    static_assert(static_cast<size_t>(CSSNumericBaseType::Angle) == 1, "CSSNumericBaseType::Angle is not 1 as expected");
    static_assert(static_cast<size_t>(CSSNumericBaseType::Time) == 2, "CSSNumericBaseType::Time is not 2 as expected");
    static_assert(static_cast<size_t>(CSSNumericBaseType::Frequency) == 3, "CSSNumericBaseType::Frequency is not 3 as expected");
    static_assert(static_cast<size_t>(CSSNumericBaseType::Resolution) == 4, "CSSNumericBaseType::Resolution is not 4 as expected");
    static_assert(static_cast<size_t>(CSSNumericBaseType::Flex) == 5, "CSSNumericBaseType::Flex is not 5 as expected");
    static_assert(static_cast<size_t>(CSSNumericBaseType::Percent) == 6, "CSSNumericBaseType::Percent is not 6 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CSSNumericBaseType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CSSNumericBaseType> parseEnumerationFromString<CSSNumericBaseType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, CSSNumericBaseType> mappings[] = {
        { "angle", CSSNumericBaseType::Angle },
        { "flex", CSSNumericBaseType::Flex },
        { "frequency", CSSNumericBaseType::Frequency },
        { "length", CSSNumericBaseType::Length },
        { "percent", CSSNumericBaseType::Percent },
        { "resolution", CSSNumericBaseType::Resolution },
        { "time", CSSNumericBaseType::Time },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CSSNumericBaseType> parseEnumeration<CSSNumericBaseType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CSSNumericBaseType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<CSSNumericBaseType>()
{
    return "\"length\", \"angle\", \"time\", \"frequency\", \"resolution\", \"flex\", \"percent\""_s;
}

} // namespace WebCore
