/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.properties.PropertiesPanel;
import org.graalvm.visualvm.core.properties.PropertiesProvider;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class GeneralPropertiesProvider
extends PropertiesProvider<DataSource> {
    GeneralPropertiesProvider() {
        super(NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"CAP_GeneralProperties"), NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"DESCR_GeneralProperties"), Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public PropertiesPanel createPanel(DataSource dataSource) {
        DataSourceDescriptor<DataSource> descriptor = DataSourceDescriptorFactory.getDescriptor(dataSource);
        PropertiesPanel panel = new PropertiesPanel();
        panel.setLayout(new GridBagLayout());
        Image icon = descriptor.getIcon();
        if (icon == null) {
            icon = ImageUtilities.loadImage((String)"org/graalvm/visualvm/core/ui/resources/empty.png");
        }
        JButton iconButton = new JButton(new ImageIcon(icon));
        iconButton.setDisabledIcon(iconButton.getIcon());
        iconButton.setEnabled(false);
        iconButton.setMargin(new Insets(3, 3, 3, 3));
        Dimension size = iconButton.getPreferredSize();
        size.height = size.width = Math.min(size.width, size.height);
        iconButton.setPreferredSize(size);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 5, 8);
        panel.add((Component)iconButton, c);
        JTextField nameField = new JTextField(descriptor.getName());
        nameField.setEditable(false);
        size = nameField.getPreferredSize();
        size.width = 1;
        nameField.setPreferredSize(size);
        nameField.setMinimumSize(size);
        nameField.setCaretPosition(0);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)nameField, c);
        JLabel descriptionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)descriptionLabel, (String)NbBundle.getMessage(GeneralPropertiesProvider.class, (String)"LBL_GeneralDescr"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(2, 0, 3, 0);
        panel.add((Component)descriptionLabel, c);
        JTextArea descriptionArea = new JTextArea(descriptor.getDescription()){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if ("".equals(this.getText())) {
                    size.width = 0;
                    size.height = 0;
                }
                return size;
            }
        };
        descriptionLabel.setLabelFor(descriptionArea);
        descriptionArea.setEditable(false);
        descriptionArea.setRows(4);
        descriptionArea.setCaretPosition(0);
        descriptionArea.setBackground(nameField.getBackground());
        descriptionArea.setOpaque(true);
        descriptionArea.setLineWrap(true);
        descriptionArea.setWrapStyleWord(true);
        JScrollPane descriptionScroll = new JScrollPane(descriptionArea, 20, 31);
        size = descriptionScroll.getPreferredSize();
        descriptionScroll.getViewport().setPreferredSize(size);
        descriptionScroll.getViewport().setMinimumSize(size);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)descriptionScroll, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 10;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)Spacer.create(), c);
        return panel;
    }

    @Override
    public boolean supportsDataSource(DataSource dataSource) {
        return dataSource != null && DataSourceDescriptorFactory.getDescriptor(dataSource).providesProperties();
    }

    @Override
    public void propertiesDefined(PropertiesPanel panel, DataSource dataSource) {
    }

    @Override
    public void propertiesChanged(PropertiesPanel panel, DataSource dataSource) {
    }

    @Override
    public void propertiesCancelled(PropertiesPanel panel, DataSource dataSource) {
    }
}

