﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/servicediscovery/ServiceDiscovery_EXPORTS.h>
#include <aws/servicediscovery/model/DnsConfigChange.h>
#include <aws/servicediscovery/model/HealthCheckConfig.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ServiceDiscovery {
namespace Model {

/**
 * <p>A complex type that contains changes to an existing service.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ServiceChange">AWS
 * API Reference</a></p>
 */
class ServiceChange {
 public:
  AWS_SERVICEDISCOVERY_API ServiceChange() = default;
  AWS_SERVICEDISCOVERY_API ServiceChange(Aws::Utils::Json::JsonView jsonValue);
  AWS_SERVICEDISCOVERY_API ServiceChange& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SERVICEDISCOVERY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A description for the service.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  ServiceChange& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the Route 53 DNS records that you want Cloud Map to create
   * when you register an instance.</p>
   */
  inline const DnsConfigChange& GetDnsConfig() const { return m_dnsConfig; }
  inline bool DnsConfigHasBeenSet() const { return m_dnsConfigHasBeenSet; }
  template <typename DnsConfigT = DnsConfigChange>
  void SetDnsConfig(DnsConfigT&& value) {
    m_dnsConfigHasBeenSet = true;
    m_dnsConfig = std::forward<DnsConfigT>(value);
  }
  template <typename DnsConfigT = DnsConfigChange>
  ServiceChange& WithDnsConfig(DnsConfigT&& value) {
    SetDnsConfig(std::forward<DnsConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> <i>Public DNS and HTTP namespaces only.</i> Settings for an optional health
   * check. If you specify settings for a health check, Cloud Map associates the
   * health check with the records that you specify in <code>DnsConfig</code>.</p>
   */
  inline const HealthCheckConfig& GetHealthCheckConfig() const { return m_healthCheckConfig; }
  inline bool HealthCheckConfigHasBeenSet() const { return m_healthCheckConfigHasBeenSet; }
  template <typename HealthCheckConfigT = HealthCheckConfig>
  void SetHealthCheckConfig(HealthCheckConfigT&& value) {
    m_healthCheckConfigHasBeenSet = true;
    m_healthCheckConfig = std::forward<HealthCheckConfigT>(value);
  }
  template <typename HealthCheckConfigT = HealthCheckConfig>
  ServiceChange& WithHealthCheckConfig(HealthCheckConfigT&& value) {
    SetHealthCheckConfig(std::forward<HealthCheckConfigT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  DnsConfigChange m_dnsConfig;

  HealthCheckConfig m_healthCheckConfig;
  bool m_descriptionHasBeenSet = false;
  bool m_dnsConfigHasBeenSet = false;
  bool m_healthCheckConfigHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServiceDiscovery
}  // namespace Aws
