﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/cloudformation/model/StackSetOperationSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
class ListStackSetOperationsResult {
 public:
  AWS_CLOUDFORMATION_API ListStackSetOperationsResult() = default;
  AWS_CLOUDFORMATION_API ListStackSetOperationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API ListStackSetOperationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A list of <code>StackSetOperationSummary</code> structures that contain
   * summary information about operations for the specified StackSet.</p>
   */
  inline const Aws::Vector<StackSetOperationSummary>& GetSummaries() const { return m_summaries; }
  template <typename SummariesT = Aws::Vector<StackSetOperationSummary>>
  void SetSummaries(SummariesT&& value) {
    m_summariesHasBeenSet = true;
    m_summaries = std::forward<SummariesT>(value);
  }
  template <typename SummariesT = Aws::Vector<StackSetOperationSummary>>
  ListStackSetOperationsResult& WithSummaries(SummariesT&& value) {
    SetSummaries(std::forward<SummariesT>(value));
    return *this;
  }
  template <typename SummariesT = StackSetOperationSummary>
  ListStackSetOperationsResult& AddSummaries(SummariesT&& value) {
    m_summariesHasBeenSet = true;
    m_summaries.emplace_back(std::forward<SummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the request doesn't return all results, <code>NextToken</code> is set to a
   * token. To retrieve the next set of results, call
   * <code>ListOperationResults</code> again and assign that token to the request
   * object's <code>NextToken</code> parameter. If there are no remaining results,
   * <code>NextToken</code> is set to <code>null</code>.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListStackSetOperationsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ListStackSetOperationsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<StackSetOperationSummary> m_summaries;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_summariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
