/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.proxies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.proxies.ProxiesParamProxy;

public class ProxiesParam
extends AbstractParam {
    private static final Logger logger = LogManager.getLogger(ProxiesParam.class);
    private static final String PROXIES_BASE_KEY = "proxies";
    private static final String ALL_PROXIES_KEY = "proxies.all";
    private static final String PROXY_ADDRESS_KEY = "address";
    private static final String PROXY_ENABLED_KEY = "enabled";
    private static final String PROXY_PORT_KEY = "port";
    private static final String PROXY_ANY_LOCAL_KEY = "anylocal";
    private static final String PROXY_REM_UNSUPPORTED = "remunsupported";
    private static final String PROXY_DECODE_KEY = "decode";
    private static final String PROXY_BEHIND_NAT_KEY = "behindnat";
    private static final String CONFIRM_REMOVE_PROXY_KEY = "proxies.confirmRemoveProxy";
    private List<ProxiesParamProxy> proxies = null;
    private boolean confirmRemoveProxy = true;

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_PROXIES_KEY);
            this.proxies = new ArrayList<ProxiesParamProxy>(fields.size() + 1);
            for (HierarchicalConfiguration sub : fields) {
                this.proxies.add(new ProxiesParamProxy(sub.getString(PROXY_ADDRESS_KEY), sub.getInt(PROXY_PORT_KEY), sub.getBoolean(PROXY_ENABLED_KEY, true), sub.getBoolean(PROXY_ANY_LOCAL_KEY), sub.getBoolean(PROXY_REM_UNSUPPORTED, true), sub.getBoolean(PROXY_DECODE_KEY, true), sub.getBoolean(PROXY_BEHIND_NAT_KEY, false)));
            }
        }
        catch (ConversionException e) {
            logger.error("Error while loading proxies: " + e.getMessage(), (Throwable)e);
        }
        this.confirmRemoveProxy = this.getBoolean(CONFIRM_REMOVE_PROXY_KEY, true);
    }

    public ProxiesParamProxy getMainProxy() {
        ProxyParam mainProxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
        ProxiesParamProxy mainProxy = new ProxiesParamProxy(mainProxyParam.getRawProxyIP(), mainProxyParam.getProxyPort(), true);
        mainProxy.setAlwaysDecodeGzip(mainProxyParam.isAlwaysDecodeGzip());
        mainProxy.setBehindNat(mainProxyParam.isBehindNat());
        mainProxy.setProxyIpAnyLocalAddress(mainProxyParam.isProxyIpAnyLocalAddress());
        mainProxy.setRemoveUnsupportedEncodings(mainProxyParam.isRemoveUnsupportedEncodings());
        return mainProxy;
    }

    public String[] getSecurityProtocolsEnabled() {
        return Model.getSingleton().getOptionsParam().getProxyParam().getSecurityProtocolsEnabled();
    }

    public void setSecurityProtocolsEnabled(String[] protocols) {
        Model.getSingleton().getOptionsParam().getProxyParam().setSecurityProtocolsEnabled(protocols);
    }

    public List<ProxiesParamProxy> getProxies() {
        ArrayList<ProxiesParamProxy> list = new ArrayList<ProxiesParamProxy>(this.proxies.size() + 1);
        for (ProxiesParamProxy proxy : this.proxies) {
            list.add(new ProxiesParamProxy(proxy));
        }
        return list;
    }

    public void setMainProxy(ProxiesParamProxy proxy) {
        ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
        proxyParam.setProxyIp(proxy.getAddress());
        proxyParam.setProxyPort(proxy.getPort());
        proxyParam.setAlwaysDecodeGzip(proxy.isAlwaysDecodeGzip());
        proxyParam.setBehindNat(proxy.isBehindNat());
        proxyParam.setRemoveUnsupportedEncodings(proxy.isRemoveUnsupportedEncodings());
    }

    public void setProxies(List<ProxiesParamProxy> proxies) {
        this.proxies = new ArrayList<ProxiesParamProxy>(proxies);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_PROXIES_KEY);
        int size = proxies.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "proxies.all(" + i + ").";
            ProxiesParamProxy proxy = proxies.get(i);
            this.getConfig().setProperty(elementBaseKey + PROXY_ADDRESS_KEY, (Object)proxy.getAddress());
            this.getConfig().setProperty(elementBaseKey + PROXY_PORT_KEY, (Object)proxy.getPort());
            this.getConfig().setProperty(elementBaseKey + PROXY_ENABLED_KEY, (Object)proxy.isEnabled());
            this.getConfig().setProperty(elementBaseKey + PROXY_ANY_LOCAL_KEY, (Object)proxy.isProxyIpAnyLocalAddress());
            this.getConfig().setProperty(elementBaseKey + PROXY_REM_UNSUPPORTED, (Object)proxy.isRemoveUnsupportedEncodings());
            this.getConfig().setProperty(elementBaseKey + PROXY_DECODE_KEY, (Object)proxy.isAlwaysDecodeGzip());
            this.getConfig().setProperty(elementBaseKey + PROXY_BEHIND_NAT_KEY, (Object)proxy.isBehindNat());
        }
    }

    public void addProxy(ProxiesParamProxy proxy) {
        this.proxies.add(proxy);
        this.setProxies(this.proxies);
    }

    public void removeProxy(String address, int port) {
        if (address == null || address.isEmpty()) {
            return;
        }
        Iterator<ProxiesParamProxy> it = this.proxies.iterator();
        while (it.hasNext()) {
            ProxiesParamProxy proxy = it.next();
            if (!address.equals(proxy.getAddress()) || proxy.getPort() != port) continue;
            it.remove();
            break;
        }
        this.setProxies(this.proxies);
    }

    public boolean isConfirmRemoveProxy() {
        return this.confirmRemoveProxy;
    }

    public void setConfirmRemoveProxy(boolean confirmRemove) {
        this.confirmRemoveProxy = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_PROXY_KEY, (Object)this.confirmRemoveProxy);
    }
}

