/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow;

import java.util.ArrayList;
import java.util.Locale;
import org.sunflow.SunflowAPI;
import org.sunflow.core.Camera;
import org.sunflow.core.Geometry;
import org.sunflow.core.Instance;
import org.sunflow.core.LightSource;
import org.sunflow.core.Modifier;
import org.sunflow.core.Options;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.RenderObject;
import org.sunflow.core.Scene;
import org.sunflow.core.Shader;
import org.sunflow.core.Tesselatable;
import org.sunflow.system.UI;
import org.sunflow.util.FastHashMap;

final class RenderObjectMap {
    private FastHashMap<String, RenderObjectHandle> renderObjects = new FastHashMap();
    private boolean rebuildInstanceList = false;
    private boolean rebuildLightList = false;

    RenderObjectMap() {
    }

    final boolean has(String string) {
        return this.renderObjects.containsKey(string);
    }

    final void remove(String string) {
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        if (renderObjectHandle == null) {
            UI.printWarning(UI.Module.API, "Unable to remove \"%s\" - object was not defined yet", new Object[0]);
            return;
        }
        UI.printDetailed(UI.Module.API, "Removing object \"%s\"", string);
        this.renderObjects.remove(string);
        switch (renderObjectHandle.type) {
            case SHADER: {
                Shader shader = renderObjectHandle.getShader();
                for (FastHashMap.Entry<String, RenderObjectHandle> entry : this.renderObjects) {
                    Instance instance = entry.getValue().getInstance();
                    if (instance == null) continue;
                    UI.printWarning(UI.Module.API, "Removing shader \"%s\" from instance \"%s\"", string, entry.getKey());
                    instance.removeShader(shader);
                }
                break;
            }
            case MODIFIER: {
                Modifier modifier = renderObjectHandle.getModifier();
                for (FastHashMap.Entry<String, RenderObjectHandle> entry : this.renderObjects) {
                    Instance instance = entry.getValue().getInstance();
                    if (instance == null) continue;
                    UI.printWarning(UI.Module.API, "Removing modifier \"%s\" from instance \"%s\"", string, entry.getKey());
                    instance.removeModifier(modifier);
                }
                break;
            }
            case GEOMETRY: {
                Geometry geometry = renderObjectHandle.getGeometry();
                for (FastHashMap.Entry<String, RenderObjectHandle> entry : this.renderObjects) {
                    Instance instance = entry.getValue().getInstance();
                    if (instance == null || !instance.hasGeometry(geometry)) continue;
                    UI.printWarning(UI.Module.API, "Removing instance \"%s\" because it referenced geometry \"%s\"", entry.getKey(), string);
                    this.remove(entry.getKey());
                }
                break;
            }
            case INSTANCE: {
                this.rebuildInstanceList = true;
                break;
            }
            case LIGHT: {
                this.rebuildLightList = true;
                break;
            }
        }
    }

    final boolean update(String string, ParameterList parameterList, SunflowAPI sunflowAPI) {
        boolean bl;
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        if (renderObjectHandle == null) {
            UI.printError(UI.Module.API, "Unable to update \"%s\" - object was not defined yet", string);
            bl = false;
        } else {
            UI.printDetailed(UI.Module.API, "Updating %s object \"%s\"", renderObjectHandle.typeName(), string);
            bl = renderObjectHandle.update(parameterList, sunflowAPI);
            if (!bl) {
                UI.printError(UI.Module.API, "Unable to update \"%s\" - removing", string);
                this.remove(string);
            } else {
                switch (renderObjectHandle.type) {
                    case GEOMETRY: 
                    case INSTANCE: {
                        this.rebuildInstanceList = true;
                        break;
                    }
                    case LIGHT: {
                        this.rebuildLightList = true;
                        break;
                    }
                }
            }
        }
        return bl;
    }

    final void updateScene(Scene scene) {
        if (this.rebuildInstanceList) {
            UI.printInfo(UI.Module.API, "Building scene instance list for rendering ...", new Object[0]);
            int n = 0;
            int n2 = 0;
            for (FastHashMap.Entry<String, RenderObjectHandle> entry : this.renderObjects) {
                Instance instance = entry.getValue().getInstance();
                if (instance == null) continue;
                instance.updateBounds();
                if (instance.getBounds() == null) {
                    ++n;
                    continue;
                }
                if (!instance.getBounds().isEmpty()) {
                    ++n2;
                    continue;
                }
                UI.printWarning(UI.Module.API, "Ignoring empty instance: \"%s\"", entry.getKey());
            }
            Instance[] instanceArray = new Instance[n];
            Instance[] instanceArray2 = new Instance[n2];
            n2 = 0;
            n = 0;
            for (FastHashMap.Entry entry : this.renderObjects) {
                Instance instance = ((RenderObjectHandle)entry.getValue()).getInstance();
                if (instance == null) continue;
                if (instance.getBounds() == null) {
                    instanceArray[n] = instance;
                    ++n;
                    continue;
                }
                if (instance.getBounds().isEmpty()) continue;
                instanceArray2[n2] = instance;
                ++n2;
            }
            scene.setInstanceLists(instanceArray2, instanceArray);
            this.rebuildInstanceList = false;
        }
        if (this.rebuildLightList) {
            UI.printInfo(UI.Module.API, "Building scene light list for rendering ...", new Object[0]);
            ArrayList<LightSource> arrayList = new ArrayList<LightSource>();
            for (FastHashMap.Entry<String, RenderObjectHandle> entry : this.renderObjects) {
                LightSource lightSource = entry.getValue().getLight();
                if (lightSource == null) continue;
                arrayList.add(lightSource);
            }
            scene.setLightList(arrayList.toArray(new LightSource[arrayList.size()]));
            this.rebuildLightList = false;
        }
    }

    final void put(String string, Shader shader) {
        this.renderObjects.put(string, new RenderObjectHandle(shader));
    }

    final void put(String string, Modifier modifier) {
        this.renderObjects.put(string, new RenderObjectHandle(modifier));
    }

    final void put(String string, PrimitiveList primitiveList) {
        this.renderObjects.put(string, new RenderObjectHandle(primitiveList));
    }

    final void put(String string, Tesselatable tesselatable) {
        this.renderObjects.put(string, new RenderObjectHandle(tesselatable));
    }

    final void put(String string, Instance instance) {
        this.renderObjects.put(string, new RenderObjectHandle(instance));
    }

    final void put(String string, LightSource lightSource) {
        this.renderObjects.put(string, new RenderObjectHandle(lightSource));
    }

    final void put(String string, Camera camera) {
        this.renderObjects.put(string, new RenderObjectHandle(camera));
    }

    final void put(String string, Options options) {
        this.renderObjects.put(string, new RenderObjectHandle(options));
    }

    final Geometry lookupGeometry(String string) {
        if (string == null) {
            return null;
        }
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        return renderObjectHandle == null ? null : renderObjectHandle.getGeometry();
    }

    final Instance lookupInstance(String string) {
        if (string == null) {
            return null;
        }
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        return renderObjectHandle == null ? null : renderObjectHandle.getInstance();
    }

    final Camera lookupCamera(String string) {
        if (string == null) {
            return null;
        }
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        return renderObjectHandle == null ? null : renderObjectHandle.getCamera();
    }

    final Options lookupOptions(String string) {
        if (string == null) {
            return null;
        }
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        return renderObjectHandle == null ? null : renderObjectHandle.getOptions();
    }

    final Shader lookupShader(String string) {
        if (string == null) {
            return null;
        }
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        return renderObjectHandle == null ? null : renderObjectHandle.getShader();
    }

    final Modifier lookupModifier(String string) {
        if (string == null) {
            return null;
        }
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        return renderObjectHandle == null ? null : renderObjectHandle.getModifier();
    }

    final LightSource lookupLight(String string) {
        if (string == null) {
            return null;
        }
        RenderObjectHandle renderObjectHandle = this.renderObjects.get(string);
        return renderObjectHandle == null ? null : renderObjectHandle.getLight();
    }

    private static final class RenderObjectHandle {
        private final RenderObject obj;
        private final RenderObjectType type;

        private RenderObjectHandle(Shader shader) {
            this.obj = shader;
            this.type = RenderObjectType.SHADER;
        }

        private RenderObjectHandle(Modifier modifier) {
            this.obj = modifier;
            this.type = RenderObjectType.MODIFIER;
        }

        private RenderObjectHandle(Tesselatable tesselatable) {
            this.obj = new Geometry(tesselatable);
            this.type = RenderObjectType.GEOMETRY;
        }

        private RenderObjectHandle(PrimitiveList primitiveList) {
            this.obj = new Geometry(primitiveList);
            this.type = RenderObjectType.GEOMETRY;
        }

        private RenderObjectHandle(Instance instance) {
            this.obj = instance;
            this.type = RenderObjectType.INSTANCE;
        }

        private RenderObjectHandle(LightSource lightSource) {
            this.obj = lightSource;
            this.type = RenderObjectType.LIGHT;
        }

        private RenderObjectHandle(Camera camera) {
            this.obj = camera;
            this.type = RenderObjectType.CAMERA;
        }

        private RenderObjectHandle(Options options) {
            this.obj = options;
            this.type = RenderObjectType.OPTIONS;
        }

        private boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
            return this.obj.update(parameterList, sunflowAPI);
        }

        private String typeName() {
            return this.type.name().toLowerCase(Locale.ENGLISH);
        }

        private Shader getShader() {
            return this.type == RenderObjectType.SHADER ? (Shader)this.obj : null;
        }

        private Modifier getModifier() {
            return this.type == RenderObjectType.MODIFIER ? (Modifier)this.obj : null;
        }

        private Geometry getGeometry() {
            return this.type == RenderObjectType.GEOMETRY ? (Geometry)this.obj : null;
        }

        private Instance getInstance() {
            return this.type == RenderObjectType.INSTANCE ? (Instance)this.obj : null;
        }

        private LightSource getLight() {
            return this.type == RenderObjectType.LIGHT ? (LightSource)this.obj : null;
        }

        private Camera getCamera() {
            return this.type == RenderObjectType.CAMERA ? (Camera)this.obj : null;
        }

        private Options getOptions() {
            return this.type == RenderObjectType.OPTIONS ? (Options)this.obj : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RenderObjectType {
        UNKNOWN,
        SHADER,
        MODIFIER,
        GEOMETRY,
        INSTANCE,
        LIGHT,
        CAMERA,
        OPTIONS;

    }
}

