/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby runtime2) {
        RubyModule module = runtime2.defineModule("Marshal");
        module.defineAnnotatedMethods(RubyMarshal.class);
        module.defineConstant("MAJOR_VERSION", runtime2.newFixnum(4));
        module.defineConstant("MINOR_VERSION", runtime2.newFixnum(8));
        return module;
    }

    @JRubyMethod(required=1, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime2 = context.runtime;
        IRubyObject objectToDump = args2[0];
        IRubyObject io2 = null;
        int depthLimit = -1;
        if (args2.length >= 2) {
            IRubyObject arg1 = args2[1];
            if (RubyMarshal.sites((ThreadContext)context).respond_to_write.respondsTo(context, arg1, arg1)) {
                io2 = arg1;
            } else if (arg1 instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)arg1).getLongValue();
            } else {
                throw runtime2.newTypeError("Instance of IO needed");
            }
            if (args2.length == 3) {
                depthLimit = (int)args2[2].convertToInteger().getLongValue();
            }
        }
        try {
            if (io2 != null) {
                RubyMarshal.dumpToStream(runtime2, objectToDump, RubyMarshal.outputStream(context, io2), depthLimit);
                return io2;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            boolean taint2 = RubyMarshal.dumpToStream(runtime2, objectToDump, stringOutput, depthLimit);
            RubyString result2 = RubyString.newString(runtime2, new ByteList(stringOutput.toByteArray(), false));
            if (taint2) {
                result2.setTaint(true);
            }
            return result2;
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    @Deprecated
    public static IRubyObject dump(IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        return RubyMarshal.dump(recv2.getRuntime().getCurrentContext(), recv2, args2, unusedBlock);
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime2 = context.runtime;
        IRubyObject in = args2[0];
        IRubyObject proc2 = args2.length == 2 ? args2[1] : context.nil;
        IRubyObject str = in.checkStringType();
        try {
            InputStream rawInput;
            boolean tainted;
            if (str != context.nil) {
                tainted = in.isTaint();
                ByteList bytes2 = ((RubyString)str).getByteList();
                rawInput = new ByteArrayInputStream(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
            } else if (RubyMarshal.sites((ThreadContext)context).respond_to_getc.respondsTo(context, in, in) && RubyMarshal.sites((ThreadContext)context).respond_to_read.respondsTo(context, in, in)) {
                tainted = true;
                rawInput = RubyMarshal.inputStream(context, in);
            } else {
                throw runtime2.newTypeError("instance of IO needed");
            }
            return new UnmarshalStream(runtime2, rawInput, proc2, tainted).unmarshalObject();
        }
        catch (EOFException e) {
            if (str != context.nil) {
                throw runtime2.newArgumentError("marshal data too short");
            }
            throw runtime2.newEOFError();
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    private static InputStream inputStream(ThreadContext context, IRubyObject in) {
        RubyMarshal.setBinmodeIfPossible(context, in);
        return new IOInputStream(in, false);
    }

    private static OutputStream outputStream(ThreadContext context, IRubyObject out) {
        RubyMarshal.setBinmodeIfPossible(context, out);
        return new IOOutputStream(out, true, false);
    }

    private static boolean dumpToStream(Ruby runtime2, IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(runtime2, rawOutput, depthLimit);
        output.dumpObject(object);
        return output.isTainted();
    }

    private static void setBinmodeIfPossible(ThreadContext context, IRubyObject io2) {
        if (RubyMarshal.sites((ThreadContext)context).respond_to_binmode.respondsTo(context, io2, io2)) {
            RubyMarshal.sites((ThreadContext)context).binmode.call(context, io2, io2);
        }
    }

    public static IRubyObject undumpable(ThreadContext context, RubyObject self2) {
        throw context.runtime.newTypeError("can't dump " + self2.type());
    }

    private static JavaSites.MarshalSites sites(ThreadContext context) {
        return context.sites.Marshal;
    }
}

