/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http.util;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.plugins.inputs.http.util.SslBuilder;

public class SslSimpleBuilder
implements SslBuilder {
    private static final Logger logger = LogManager.getLogger(SslSimpleBuilder.class);
    private static final String[] DEFAULT_CIPHERS = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
    private static final String[] DEFAULT_CIPHERS_LIMITED = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
    private String[] ciphers = SslSimpleBuilder.getDefaultCiphers();
    private File sslKeyFile;
    private File sslCertificateFile;
    private String[] certificateAuthorities;
    private String passPhrase;
    private String[] supportedCiphers = ((SSLServerSocketFactory)SSLServerSocketFactory.getDefault()).getSupportedCipherSuites();

    public SslSimpleBuilder(String sslCertificateFilePath, String sslKeyFilePath, String pass) throws FileNotFoundException {
        this.sslCertificateFile = new File(sslCertificateFilePath);
        this.sslKeyFile = new File(sslKeyFilePath);
        this.passPhrase = pass;
    }

    public SslSimpleBuilder setCipherSuites(String[] ciphersSuite) throws IllegalArgumentException {
        for (String cipher : ciphersSuite) {
            if (!Arrays.asList(this.supportedCiphers).contains(cipher)) {
                if (!SslSimpleBuilder.isUnlimitedJCEAvailable()) {
                    logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed");
                }
                throw new IllegalArgumentException("Cipher `" + cipher + "` is not available");
            }
            logger.debug("Cipher is supported: {}", (Object)cipher);
        }
        this.ciphers = ciphersSuite;
        return this;
    }

    public SslSimpleBuilder setCertificateAuthorities(String[] cert) {
        this.certificateAuthorities = cert;
        return this;
    }

    @Override
    public SslContext build() throws IOException, NoSuchAlgorithmException, CertificateException {
        SslContextBuilder builder = SslContextBuilder.forServer((File)this.sslCertificateFile, (File)this.sslKeyFile, (String)this.passPhrase);
        if (logger.isDebugEnabled()) {
            logger.debug("Available ciphers: " + Arrays.toString(this.supportedCiphers));
            logger.debug("Ciphers:  " + Arrays.toString(this.ciphers));
        }
        builder.ciphers(Arrays.asList(this.ciphers));
        if (this.requireClientAuth()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Certificate Authorities: " + Arrays.toString(this.certificateAuthorities));
            }
            builder.trustManager(this.loadCertificateCollection(this.certificateAuthorities));
        }
        return builder.build();
    }

    private X509Certificate[] loadCertificateCollection(String[] certificates) throws IOException, CertificateException {
        logger.debug("Load certificates collection");
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList collections = new ArrayList();
        for (int i = 0; i < certificates.length; ++i) {
            String certificate = certificates[i];
            logger.debug("Loading certificates from file " + certificate);
            try (FileInputStream in = new FileInputStream(certificate);){
                List certificatesChains = (List)certificateFactory.generateCertificates(in);
                collections.addAll(certificatesChains);
                continue;
            }
        }
        return collections.toArray(new X509Certificate[collections.size()]);
    }

    private boolean requireClientAuth() {
        return this.certificateAuthorities != null;
    }

    public static String[] getDefaultCiphers() {
        if (SslSimpleBuilder.isUnlimitedJCEAvailable()) {
            return DEFAULT_CIPHERS;
        }
        logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed - max key length is 128 bits");
        return DEFAULT_CIPHERS_LIMITED;
    }

    public static boolean isUnlimitedJCEAvailable() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("AES not available", (Throwable)e);
            return false;
        }
    }
}

