#
# Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
#n but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program (see COPYING); if not, check with
# http://www.gnu.org/copyleft/gpl.html.
#
# Author: Francis J. Lacoste <flacoste@logreport.org>

package Lire::DlfAnalysers::SQLQueryType;

use strict;

use base qw/Lire::DlfCategoriser/;

sub new {
    return bless {}, shift;
}

sub name {
    return "querytype";
}

sub title {
    return "SQL QueryType Categoriser";
}

sub description {
    return <<EOD
<para>This DlfCategoriser will fill the <structfield>querytype</structfield>
field of the <structname>database-querytype</structname> extended schema.</para>
EOD
}

sub src_schema {
    return "database";
}

sub dst_schema {
    return "database-querytype";
}

sub initialise {
    my ( $self, $config ) = @_;

    return;
}

sub categorise {
    my ( $self, $dlf ) = @_;

    return unless defined $dlf->{'query'};

    my ($type) = $dlf->{'query'} =~ /^\s*([a-zA-Z]+)/;
    $dlf->{'querytype'} = uc $type
      if defined $type;

    return;
}

# keep perl happy
1;

