/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import io.opentracing.contrib.concurrent.TracedExecutorService;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TracedScheduledExecutorService
extends TracedExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;

    public TracedScheduledExecutorService(ScheduledExecutorService delegate, Tracer tracer) {
        this(delegate, tracer, true);
    }

    public TracedScheduledExecutorService(ScheduledExecutorService delegate, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(delegate, tracer, traceWithActiveSpanOnly);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        Scope scope = this.createScope("schedule");
        try {
            ScheduledFuture<?> scheduledFuture = this.delegate.schedule(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer), delay, timeUnit);
            return scheduledFuture;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ScheduledFuture<T> schedule(Callable<T> callable, long delay, TimeUnit timeUnit) {
        Scope scope = this.createScope("schedule");
        try {
            ScheduledFuture scheduledFuture = this.delegate.schedule(this.tracer.activeSpan() == null ? callable : new TracedCallable(callable, this.tracer), delay, timeUnit);
            return scheduledFuture;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        Scope scope = this.createScope("scheduleAtFixedRate");
        try {
            ScheduledFuture<?> scheduledFuture = this.delegate.scheduleAtFixedRate(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer), initialDelay, period, timeUnit);
            return scheduledFuture;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit) {
        Scope scope = this.createScope("scheduleWithFixedDelay");
        try {
            ScheduledFuture<?> scheduledFuture = this.delegate.scheduleWithFixedDelay(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer), initialDelay, delay, timeUnit);
            return scheduledFuture;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

