/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.OneTimeUseType;

public class SAMLConditionsParser
implements ParserNamespaceSupport {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute notAfterAttribute;
        StartElement conditionsElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)conditionsElement, (String)JBossSAMLConstants.CONDITIONS.get());
        ConditionsType conditions = new ConditionsType();
        String assertionNS = JBossSAMLURIConstants.ASSERTION_NSURI.get();
        QName notBeforeQName = new QName("", JBossSAMLConstants.NOT_BEFORE.get());
        QName notBeforeQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_BEFORE.get());
        QName notAfterQName = new QName("", JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        QName notAfterQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        Attribute notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQName);
        if (notBeforeAttribute == null) {
            notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQNameWithNS);
        }
        if ((notAfterAttribute = conditionsElement.getAttributeByName(notAfterQName)) == null) {
            notAfterAttribute = conditionsElement.getAttributeByName(notAfterQNameWithNS);
        }
        if (notBeforeAttribute != null) {
            String notBeforeValue = StaxParserUtil.getAttributeValue((Attribute)notBeforeAttribute);
            conditions.setNotBefore(XMLTimeUtil.parse(notBeforeValue));
        }
        if (notAfterAttribute != null) {
            String notAfterValue = StaxParserUtil.getAttributeValue((Attribute)notAfterAttribute);
            conditions.setNotOnOrAfter(XMLTimeUtil.parse(notAfterValue));
        }
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement nextEndElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches((EndElement)nextEndElement, (String)JBossSAMLConstants.CONDITIONS.get())) {
                    nextEndElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + StaxParserUtil.getEndElementName((EndElement)nextEndElement));
            }
            String tag = null;
            if (xmlEvent instanceof StartElement) {
                StartElement peekedElement = (StartElement)xmlEvent;
                tag = StaxParserUtil.getStartElementName((StartElement)peekedElement);
            }
            if (JBossSAMLConstants.AUDIENCE_RESTRICTION.get().equals(tag)) {
                AudienceRestrictionType audienceRestriction = this.getAudienceRestriction(xmlEventReader);
                conditions.addCondition(audienceRestriction);
                continue;
            }
            if (JBossSAMLConstants.ONE_TIME_USE.get().equals(tag)) {
                StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                OneTimeUseType oneTimeUseCondition = new OneTimeUseType();
                conditions.addCondition(oneTimeUseCondition);
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                StaxParserUtil.matches((EndElement)endElement, (String)JBossSAMLConstants.ONE_TIME_USE.get());
                continue;
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::location=" + xmlEvent.getLocation());
        }
        return conditions;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.CONDITIONS.get());
    }

    private AudienceRestrictionType getAudienceRestriction(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement audienceElement;
        StartElement audienceRestElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.matches((StartElement)audienceRestElement, (String)JBossSAMLConstants.AUDIENCE_RESTRICTION.get());
        AudienceRestrictionType audience = new AudienceRestrictionType();
        while (xmlEventReader.hasNext() && StaxParserUtil.matches((StartElement)(audienceElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader)), (String)JBossSAMLConstants.AUDIENCE.get())) {
            if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                throw new ParsingException("PL00066: Parser : Expected start tag:audienceValue");
            }
            String audienceValue = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
            audience.addAudience(URI.create(audienceValue));
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (!(xmlEvent instanceof EndElement)) continue;
            EndElement endElement = (EndElement)xmlEvent;
            if (StaxParserUtil.matches((EndElement)endElement, (String)JBossSAMLConstants.AUDIENCE_RESTRICTION.get())) {
                StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                break;
            }
            throw new RuntimeException("PL00061: Parser: Unknown End Element:" + StaxParserUtil.getEndElementName((EndElement)endElement));
        }
        return audience;
    }
}

