/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class URLResourceLoader
extends ResourceLoader {
    private String[] roots = null;
    protected HashMap templateRoots = null;
    private int timeout = -1;

    @Override
    public void init(ExtProperties configuration) {
        this.log.trace("URLResourceLoader: initialization starting.");
        this.roots = configuration.getStringArray("root");
        if (this.log.isDebugEnabled()) {
            for (String root : this.roots) {
                this.log.debug("URLResourceLoader: adding root '{}'", (Object)root);
            }
        }
        this.timeout = configuration.getInt("timeout", -1);
        this.templateRoots = new HashMap();
        this.log.trace("URLResourceLoader: initialization complete.");
    }

    @Override
    public synchronized Reader getResourceReader(String name, String encoding) throws ResourceNotFoundException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ResourceNotFoundException("URLResourceLoader: No template name provided");
        }
        Reader reader = null;
        Throwable exception = null;
        for (String root : this.roots) {
            InputStream rawStream = null;
            try {
                URL u = new URL(root + name);
                URLConnection conn = u.openConnection();
                conn.setConnectTimeout(this.timeout);
                conn.setReadTimeout(this.timeout);
                rawStream = conn.getInputStream();
                reader = this.buildReader(rawStream, encoding);
                if (reader == null) continue;
                this.log.debug("URLResourceLoader: Found '{}' at '{}'", (Object)name, (Object)root);
                this.templateRoots.put(name, root);
                break;
            }
            catch (IOException ioe) {
                if (rawStream != null) {
                    try {
                        rawStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.log.debug("URLResourceLoader: Exception when looking for '{}' at '{}'", new Object[]{name, root, ioe});
                if (exception != null) continue;
                exception = ioe;
            }
        }
        if (reader == null) {
            String msg = exception == null ? "URLResourceLoader: Resource '" + name + "' not found." : exception.getMessage();
            throw new ResourceNotFoundException(msg);
        }
        return reader;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        long fileLastModified = this.getLastModified(resource);
        return fileLastModified == 0L || fileLastModified != resource.getLastModified();
    }

    @Override
    public long getLastModified(Resource resource) {
        String name = resource.getName();
        String root = (String)this.templateRoots.get(name);
        try {
            URL u = new URL(root + name);
            URLConnection conn = u.openConnection();
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            return conn.getLastModified();
        }
        catch (IOException ioe) {
            String msg = "URLResourceLoader: '" + name + "' is no longer reachable at '" + root + "'";
            this.log.error(msg, (Throwable)ioe);
            throw new ResourceNotFoundException(msg, ioe);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }
}

