/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.util.MethodInfoHelper;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.metadata.ejb.jboss.ejb3.TransactionTimeoutMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;

public class TransactionAttributeMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public TransactionAttributeMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        this.processTransactionAttributeAnnotation(applicationClasses, deploymentReflectionIndex, componentClass, null, componentConfiguration);
        this.processTransactionTimeoutAnnotation(applicationClasses, deploymentReflectionIndex, componentClass, null, componentConfiguration);
    }

    private void processTransactionAttributeAnnotation(EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MethodIntf methodIntf, EJBComponentDescription componentConfiguration) {
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, TransactionAttribute.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            String className = methodIntf == null ? (String)entry.getKey() : null;
            componentConfiguration.getTransactionAttributes().setAttribute(methodIntf, className, (TransactionAttributeType)((List)entry.getValue()).get(0));
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            String[] parameterTypes = MethodInfoHelper.getCanonicalParameterTypes((Method)entry.getKey());
            componentConfiguration.getTransactionAttributes().setAttribute(methodIntf, (TransactionAttributeType)((List)entry.getValue()).get(0), ((Method)entry.getKey()).getDeclaringClass().getName(), ((Method)entry.getKey()).getName(), parameterTypes);
        }
    }

    private void processTransactionTimeoutAnnotation(EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MethodIntf methodIntf, EJBComponentDescription componentConfiguration) {
        String className;
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, TransactionTimeout.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            className = methodIntf == null ? (String)entry.getKey() : null;
            componentConfiguration.getTransactionTimeouts().setAttribute(methodIntf, className, (Integer)((List)entry.getValue()).get(0));
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            className = ((Method)entry.getKey()).getDeclaringClass().getName();
            String[] parameterTypes = MethodInfoHelper.getCanonicalParameterTypes((Method)entry.getKey());
            componentConfiguration.getTransactionTimeouts().setAttribute(methodIntf, (Integer)((List)entry.getValue()).get(0), className, ((Method)entry.getKey()).getName(), parameterTypes);
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        EjbJarMetaData ejbJarMetadata = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetadata != null) {
            boolean wildcardAttributeSet = false;
            boolean wildcardTimeoutSet = false;
            ContainerTransactionMetaData global = null;
            AssemblyDescriptorMetaData assemblyDescriptor = ejbJarMetadata.getAssemblyDescriptor();
            if (assemblyDescriptor != null) {
                ContainerTransactionsMetaData containerTransactions;
                ContainerTransactionsMetaData globalTransactions = assemblyDescriptor.getContainerTransactionsByEjbName("*");
                if (globalTransactions != null) {
                    if (globalTransactions.size() > 1) {
                        throw EjbLogger.ROOT_LOGGER.mustOnlyBeSingleContainerTransactionElementWithWildcard();
                    }
                    global = (ContainerTransactionMetaData)globalTransactions.iterator().next();
                    for (Iterator method : global.getMethods()) {
                        if (method.getMethodName().equals("*")) continue;
                        throw EjbLogger.ROOT_LOGGER.wildcardContainerTransactionElementsMustHaveWildcardMethodName();
                    }
                }
                if ((containerTransactions = assemblyDescriptor.getContainerTransactionsByEjbName(componentDescription.getEJBName())) != null) {
                    for (ContainerTransactionMetaData containerTx : containerTransactions) {
                        TransactionAttributeType txAttr = containerTx.getTransAttribute();
                        Integer timeout = TransactionAttributeMergingProcessor.timeout(containerTx);
                        MethodsMetaData methods = containerTx.getMethods();
                        for (MethodMetaData method : methods) {
                            String methodName = method.getMethodName();
                            MethodIntf defaultMethodIntf = componentDescription instanceof MessageDrivenComponentDescription ? MethodIntf.MESSAGE_ENDPOINT : MethodIntf.BEAN;
                            MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf(), defaultMethodIntf);
                            if (methodName.equals("*")) {
                                if (txAttr != null) {
                                    wildcardAttributeSet = true;
                                    componentDescription.getTransactionAttributes().setAttribute(methodIntf, null, txAttr);
                                }
                                if (timeout == null) continue;
                                wildcardTimeoutSet = true;
                                componentDescription.getTransactionTimeouts().setAttribute(methodIntf, null, timeout);
                                continue;
                            }
                            MethodParametersMetaData methodParams = method.getMethodParams();
                            if (methodParams == null) {
                                if (txAttr != null) {
                                    componentDescription.getTransactionAttributes().setAttribute(methodIntf, txAttr, methodName);
                                }
                                if (timeout == null) continue;
                                componentDescription.getTransactionTimeouts().setAttribute(methodIntf, timeout, methodName);
                                continue;
                            }
                            if (txAttr != null) {
                                componentDescription.getTransactionAttributes().setAttribute(methodIntf, txAttr, null, methodName, this.getMethodParams(methodParams));
                            }
                            if (timeout == null) continue;
                            componentDescription.getTransactionTimeouts().setAttribute(methodIntf, timeout, null, methodName, this.getMethodParams(methodParams));
                        }
                    }
                }
            }
            if (global != null) {
                if (!wildcardAttributeSet && global.getTransAttribute() != null) {
                    for (MethodMetaData method : global.getMethods()) {
                        MethodIntf defaultMethodIntf = componentDescription instanceof MessageDrivenComponentDescription ? MethodIntf.MESSAGE_ENDPOINT : MethodIntf.BEAN;
                        MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf(), defaultMethodIntf);
                        componentDescription.getTransactionAttributes().setAttribute(methodIntf, null, global.getTransAttribute());
                    }
                }
                Integer timeout = TransactionAttributeMergingProcessor.timeout(global);
                if (!wildcardTimeoutSet && timeout != null) {
                    for (Iterator method : global.getMethods()) {
                        MethodIntf defaultMethodIntf = componentDescription instanceof MessageDrivenComponentDescription ? MethodIntf.MESSAGE_ENDPOINT : MethodIntf.BEAN;
                        MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf(), defaultMethodIntf);
                        componentDescription.getTransactionTimeouts().setAttribute(methodIntf, null, timeout);
                    }
                }
            }
        }
    }

    private static Integer timeout(ContainerTransactionMetaData containerTransaction) {
        List transactionTimeouts = containerTransaction.getAny(TransactionTimeoutMetaData.class);
        if (transactionTimeouts == null || transactionTimeouts.isEmpty()) {
            return null;
        }
        TransactionTimeoutMetaData transactionTimeout = (TransactionTimeoutMetaData)transactionTimeouts.get(0);
        TimeUnit unit = transactionTimeout.getUnit() == null ? TimeUnit.SECONDS : transactionTimeout.getUnit();
        return (int)unit.toSeconds(transactionTimeout.getTimeout());
    }
}

