/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.partialimport.AbstractPartialImport;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public class ClientsPartialImport
extends AbstractPartialImport<ClientRepresentation> {
    private static Set<String> INTERNAL_CLIENTS = Collections.unmodifiableSet(new HashSet(Constants.defaultClients));
    private static Logger logger = Logger.getLogger(ClientsPartialImport.class);

    @Override
    public List<ClientRepresentation> getRepList(PartialImportRepresentation partialImportRep) {
        List clients = partialImportRep.getClients();
        if (clients == null || clients.size() == 0) {
            return clients;
        }
        ArrayList<ClientRepresentation> ret = new ArrayList<ClientRepresentation>();
        for (ClientRepresentation c : clients) {
            if (!ClientsPartialImport.isInternalClient(c.getClientId())) {
                ret.add(c);
                continue;
            }
            logger.debugv("Internal client {0} will not be processed", (Object)c.getClientId());
        }
        return ret;
    }

    @Override
    public String getName(ClientRepresentation clientRep) {
        return clientRep.getClientId();
    }

    @Override
    public String getModelId(RealmModel realm, KeycloakSession session, ClientRepresentation clientRep) {
        return realm.getClientByClientId(this.getName(clientRep)).getId();
    }

    @Override
    public boolean exists(RealmModel realm, KeycloakSession session, ClientRepresentation clientRep) {
        return realm.getClientByClientId(this.getName(clientRep)) != null;
    }

    @Override
    public String existsMessage(RealmModel realm, ClientRepresentation clientRep) {
        return "Client id '" + this.getName(clientRep) + "' already exists";
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CLIENT;
    }

    @Override
    public void remove(RealmModel realm, KeycloakSession session, ClientRepresentation clientRep) {
        ClientModel clientModel = realm.getClientByClientId(this.getName(clientRep));
        realm.removeClient(clientModel.getId());
    }

    @Override
    public void create(RealmModel realm, KeycloakSession session, ClientRepresentation clientRep) {
        clientRep.setId(KeycloakModelUtils.generateId());
        List mappers = clientRep.getProtocolMappers();
        if (mappers != null) {
            for (ProtocolMapperRepresentation mapper : mappers) {
                mapper.setId(KeycloakModelUtils.generateId());
            }
        }
        RepresentationToModel.createClient((KeycloakSession)session, (RealmModel)realm, (ClientRepresentation)clientRep, (boolean)true);
    }

    public static boolean isInternalClient(String clientId) {
        if (clientId != null && clientId.endsWith("-realm")) {
            return true;
        }
        return INTERNAL_CLIENTS.contains(clientId);
    }
}

