/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public abstract class MarshalledValueSessionAttributesFactoryConfiguration<V, C extends Marshallability, L>
implements SessionAttributesFactoryConfiguration<V, MarshalledValue<V, C>> {
    private final Immutability immutability;
    private final Marshaller<V, MarshalledValue<V, C>> marshaller;

    protected MarshalledValueSessionAttributesFactoryConfiguration(SessionManagerFactoryConfiguration<C, L> configuration) {
        MarshalledValueFactory factory = configuration.getMarshalledValueFactory();
        Marshallability context = configuration.getMarshallingContext();
        this.immutability = configuration.getImmutability();
        this.marshaller = new MarshalledValueMarshaller(factory, context);
    }

    @Override
    public Marshaller<V, MarshalledValue<V, C>> getMarshaller() {
        return this.marshaller;
    }

    @Override
    public Immutability getImmutability() {
        return this.immutability;
    }
}

