﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/states/SFN_EXPORTS.h>
#include <aws/states/SFNRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace SFN
{
namespace Model
{

  /**
   */
  class DescribeStateMachineRequest : public SFNRequest
  {
  public:
    AWS_SFN_API DescribeStateMachineRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DescribeStateMachine"; }

    AWS_SFN_API Aws::String SerializePayload() const override;

    AWS_SFN_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline const Aws::String& GetStateMachineArn() const{ return m_stateMachineArn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline bool StateMachineArnHasBeenSet() const { return m_stateMachineArnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline void SetStateMachineArn(const Aws::String& value) { m_stateMachineArnHasBeenSet = true; m_stateMachineArn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline void SetStateMachineArn(Aws::String&& value) { m_stateMachineArnHasBeenSet = true; m_stateMachineArn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline void SetStateMachineArn(const char* value) { m_stateMachineArnHasBeenSet = true; m_stateMachineArn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline DescribeStateMachineRequest& WithStateMachineArn(const Aws::String& value) { SetStateMachineArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline DescribeStateMachineRequest& WithStateMachineArn(Aws::String&& value) { SetStateMachineArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the state machine for which you want the
     * information.</p> <p>If you specify a state machine version ARN, this API returns
     * details about that version. The version ARN is a combination of state machine
     * ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.</p>
     */
    inline DescribeStateMachineRequest& WithStateMachineArn(const char* value) { SetStateMachineArn(value); return *this;}

  private:

    Aws::String m_stateMachineArn;
    bool m_stateMachineArnHasBeenSet = false;
  };

} // namespace Model
} // namespace SFN
} // namespace Aws
