#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 parameterized-utils
version:              2.1.1
visibility:           public
id:                   parameterized-utils-2.1.1-IECqcNRFA5P5fPD4nO8ccj
key:                  parameterized-utils-2.1.1-IECqcNRFA5P5fPD4nO8ccj
license:              BSD-3-Clause
copyright:            ©2016-2020 Galois, Inc.
maintainer:           jhendrix@galois.com, kquick@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  7e54963ea0369303df5e31c22111c5c0
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.HashTable
    Data.Parameterized.List Data.Parameterized.Map
    Data.Parameterized.NatRepr Data.Parameterized.Nonce
    Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-8.10.2/site-local/parameterized-utils-2.1.1
library-dirs:         /usr/lib/ghc-8.10.2/site-local/parameterized-utils-2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/parameterized-utils-2.1.1
hs-libraries:         HSparameterized-utils-2.1.1-IECqcNRFA5P5fPD4nO8ccj
depends:
    base-4.14.1.0 base-orphans-0.8.4-JVJ8ttw51H7Dc3tJYgx6uK
    constraints-0.12-H3dOrOj5Vcf5IqfGrhhKSt containers-0.6.2.1
    deepseq-1.4.4.0 ghc-prim-0.6.1
    hashable-1.3.0.0-uTeBoAQZ7BHIL2DWfxNGp
    hashtables-1.2.4.1-BfXmxhS5YKX2zU6JABdVFr
    lens-4.19.2-FQSWopadCrSGUy92aBXgCm mtl-2.2.2
    template-haskell-2.16.0.0 text-1.2.3.2
    th-abstraction-0.4.0.0-EowzxylgIS6DLmPFoxbMpZ
    vector-0.12.1.2-IO5RJnkQnAxDAG50LdixTd

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

