﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace IoTSiteWise
{
namespace Model
{
  enum class LoggingLevel
  {
    NOT_SET,
    ERROR_,
    INFO,
    OFF
  };

namespace LoggingLevelMapper
{
AWS_IOTSITEWISE_API LoggingLevel GetLoggingLevelForName(const Aws::String& name);

AWS_IOTSITEWISE_API Aws::String GetNameForLoggingLevel(LoggingLevel value);
} // namespace LoggingLevelMapper
} // namespace Model
} // namespace IoTSiteWise
} // namespace Aws
