/*
 * Decompiled with CFR 0.152.
 */
package hughai.unitdata;

import com.springrts.ai.oo.clb.MoveData;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Resource;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.utils.Formatting;
import hughai.utils.LogFile;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;

public class BuildTable {
    UnitDef[] availableunittypes;
    private HashMap<String, UnitDef> UnitDefByName = new HashMap();
    private HashMap<Integer, UnitDef> UnitDefById = new HashMap();
    private int largestUnitDefId = 0;
    CSAI CSAI;
    OOAICallback aicallback;
    LogFile logfile;
    String modname;

    public BuildTable(PlayerObjects playerObjects) {
        this.CSAI = playerObjects.getCSAI();
        this.aicallback = this.CSAI.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.modname = this.aicallback.getMod().getHumanName();
        this.logfile.WriteLine("calling GetUnitDefList... ");
        List list = this.aicallback.getUnitDefs();
        this.availableunittypes = list.toArray(new UnitDef[0]);
        this.logfile.WriteLine("... done");
        if (!this.LoadCache(this.modname)) {
            this.CSAI.sendTextMessage("Creating new cachefile for mod " + this.modname);
            this.GenerateBuildTable(this.modname);
            this.SaveCache(this.modname);
        }
    }

    public UnitDef getUnitDefByName(String string) {
        UnitDef unitDef = this.UnitDefByName.get(string.toLowerCase());
        if (unitDef == null) {
            this.CSAI.sendTextMessage("No unit named '" + string + "'.  Please check the build table in the AI's directory for allowed unit names in this mod.");
            return null;
        }
        return unitDef;
    }

    public UnitDef getUnitDefByUnitDefId(int n) {
        return this.UnitDefById.get(n);
    }

    void GenerateBuildTable(String string) {
        try {
            this.logfile.WriteLine("Generating indexes mod " + string);
            PrintWriter printWriter = new PrintWriter(this.CSAI.getAIDirectoryPath() + "buildtable_" + this.CSAI.Team + ".txt");
            for (UnitDef unitDef : this.availableunittypes) {
                String string2 = unitDef.getUnitDefId() + " " + unitDef.getName() + " " + unitDef.getHumanName() + " size: " + unitDef.getXSize() + "," + unitDef.getZSize();
                MoveData moveData = unitDef.getMoveData();
                if (moveData != null) {
                    string2 = string2 + " maxSlope: " + moveData.getMaxSlope() + " depth " + moveData.getDepth() + " slopeMod " + moveData.getSlopeMod() + " getDepthMod(-10): " + moveData.getDepthMod(-10.0f) + " movefamily: " + moveData.getSpeedModClass();
                }
                printWriter.println(string2);
                if (!this.UnitDefByName.containsKey(unitDef.getName().toLowerCase())) {
                    int n = unitDef.getUnitDefId();
                    this.UnitDefByName.put(unitDef.getName().toLowerCase(), unitDef);
                    this.UnitDefById.put(n, unitDef);
                    if (n <= this.largestUnitDefId) continue;
                    this.largestUnitDefId = n;
                    continue;
                }
                this.logfile.WriteLine("Warning: duplicate name: " + unitDef.getName().toLowerCase());
                printWriter.println("Warning: duplicate name: " + unitDef.getName().toLowerCase());
            }
            printWriter.close();
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    void SaveCache(String string) {
    }

    boolean LoadCache(String string) {
        return false;
    }

    public UnitDef GetBiggestMexUnit() {
        this.logfile.WriteLine("Entering GetBiggestMexUnit()");
        int n = 0;
        int n2 = 0;
        this.logfile.WriteLine("Scanning unitdef list...");
        UnitDef unitDef = null;
        for (UnitDef unitDef2 : this.availableunittypes) {
            int n3;
            if (!(unitDef2.getExtractsResource((Resource)this.aicallback.getResources().get(0)) > 0.0f) || (n3 = unitDef2.getXSize() * unitDef2.getZSize()) <= n2) continue;
            n = unitDef2.getUnitDefId();
            n2 = n3;
            unitDef = unitDef2;
        }
        this.logfile.WriteLine("Leaving GetBiggestMexUnit(), it's unittypeid is " + n);
        return unitDef;
    }

    public int getLargestUnitDefId() {
        return this.largestUnitDefId;
    }
}

