/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.authtoken.jwt;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionDecryptionUtil {
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;

    public EncryptionDecryptionUtil(String secret) {
        this.encryptCipher = EncryptionDecryptionUtil.createCipherFromSecret(secret, CipherMode.ENCRYPT);
        this.decryptCipher = EncryptionDecryptionUtil.createCipherFromSecret(secret, CipherMode.DECRYPT);
    }

    public String encrypt(String data) {
        byte[] encryptedBytes = EncryptionDecryptionUtil.processWithCipher(data.getBytes(StandardCharsets.UTF_8), this.encryptCipher);
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public String decrypt(String encryptedString) {
        byte[] decodedBytes = Base64.getDecoder().decode(encryptedString);
        return new String(EncryptionDecryptionUtil.processWithCipher(decodedBytes, this.decryptCipher), StandardCharsets.UTF_8);
    }

    private static Cipher createCipherFromSecret(String secret, CipherMode mode) {
        try {
            byte[] decodedKey = Base64.getDecoder().decode(secret);
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec originalKey = new SecretKeySpec(Arrays.copyOf(decodedKey, 16), "AES");
            cipher.init(mode.opmode, originalKey);
            return cipher;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating cipher from secret in mode " + mode.name(), e);
        }
    }

    private static byte[] processWithCipher(byte[] data, Cipher cipher) {
        try {
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing data with cipher", e);
        }
    }

    private static enum CipherMode {
        ENCRYPT(1),
        DECRYPT(2);

        private final int opmode;

        private CipherMode(int opmode) {
            this.opmode = opmode;
        }
    }
}

