/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.opensearch._types.analysis.IcuNormalizationMode;
import org.opensearch.client.opensearch._types.analysis.IcuNormalizationType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IcuAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, IcuAnalyzer> {
    @Nonnull
    private final IcuNormalizationType method;
    @Nonnull
    private final IcuNormalizationMode mode;
    public static final JsonpDeserializer<IcuAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuAnalyzer::setupIcuAnalyzerDeserializer);

    private IcuAnalyzer(Builder builder) {
        this.method = ApiTypeHelper.requireNonNull(builder.method, this, "method");
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
    }

    public static IcuAnalyzer of(Function<Builder, ObjectBuilder<IcuAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.IcuAnalyzer;
    }

    @Nonnull
    public final IcuNormalizationType method() {
        return this.method;
    }

    @Nonnull
    public final IcuNormalizationMode mode() {
        return this.mode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_analyzer");
        generator.writeKey("method");
        this.method.serialize(generator, mapper);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIcuAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::method, IcuNormalizationType._DESERIALIZER, "method");
        op.add(Builder::mode, IcuNormalizationMode._DESERIALIZER, "mode");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.mode.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcuAnalyzer other = (IcuAnalyzer)o;
        return this.method.equals(other.method) && this.mode.equals(other.mode);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IcuAnalyzer> {
        private IcuNormalizationType method;
        private IcuNormalizationMode mode;

        public Builder() {
        }

        private Builder(IcuAnalyzer o) {
            this.method = o.method;
            this.mode = o.mode;
        }

        private Builder(Builder o) {
            this.method = o.method;
            this.mode = o.mode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder method(IcuNormalizationType value) {
            this.method = value;
            return this;
        }

        @Nonnull
        public final Builder mode(IcuNormalizationMode value) {
            this.mode = value;
            return this;
        }

        @Override
        @Nonnull
        public IcuAnalyzer build() {
            this._checkSingleUse();
            return new IcuAnalyzer(this);
        }
    }
}

