/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.neuralsearch.sparse.common.ArrayIterator;
import org.opensearch.neuralsearch.sparse.common.CombinedIterator;
import org.opensearch.neuralsearch.sparse.common.DocWeightIterator;
import org.opensearch.neuralsearch.sparse.common.IteratorWrapper;
import org.opensearch.neuralsearch.sparse.data.DocWeight;
import org.opensearch.neuralsearch.sparse.data.SparseVector;

public class DocumentCluster
implements Accountable {
    private SparseVector summary;
    private final int[] docIds;
    private final byte[] weights;
    private boolean shouldNotSkip;

    public DocumentCluster(SparseVector summary, List<DocWeight> docs, boolean shouldNotSkip) {
        this.summary = summary;
        ArrayList<DocWeight> docsCopy = new ArrayList<DocWeight>(docs);
        docsCopy.sort(Comparator.comparingInt(DocWeight::getDocID));
        int size = docsCopy.size();
        this.docIds = new int[size];
        this.weights = new byte[size];
        for (int i = 0; i < size; ++i) {
            DocWeight docWeight = (DocWeight)docsCopy.get(i);
            this.docIds[i] = docWeight.getDocID();
            this.weights[i] = docWeight.getWeight();
        }
        this.shouldNotSkip = shouldNotSkip;
    }

    public int size() {
        return this.docIds == null ? 0 : this.docIds.length;
    }

    public Iterator<DocWeight> iterator() {
        return new CombinedIterator<Integer, Byte, DocWeight>(new ArrayIterator.IntArrayIterator(this.docIds), new ArrayIterator.ByteArrayIterator(this.weights), DocWeight::new);
    }

    public DocWeightIterator getDisi() {
        return new DocWeightIterator(){
            final IteratorWrapper<DocWeight> wrapper;
            {
                this.wrapper = new IteratorWrapper<DocWeight>(DocumentCluster.this.iterator());
            }

            @Override
            public byte weight() {
                return this.wrapper.getCurrent().getWeight();
            }

            public int docID() {
                if (this.wrapper.getCurrent() == null) {
                    return -1;
                }
                return this.wrapper.getCurrent().getDocID();
            }

            public int nextDoc() {
                if (this.wrapper.hasNext()) {
                    return this.wrapper.next().getDocID();
                }
                return Integer.MAX_VALUE;
            }

            public int advance(int target) {
                throw new UnsupportedOperationException("advance in this iterator is not supported!");
            }

            public long cost() {
                throw new UnsupportedOperationException("cost in this iterator is not supported!");
            }
        };
    }

    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        sizeInBytes += RamUsageEstimator.shallowSizeOfInstance(DocumentCluster.class);
        if (this.docIds != null) {
            sizeInBytes += RamUsageEstimator.sizeOf((int[])this.docIds);
            sizeInBytes += RamUsageEstimator.sizeOf((byte[])this.weights);
        }
        if (this.summary != null) {
            sizeInBytes += this.summary.ramBytesUsed();
        }
        return sizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<SparseVector> children = new ArrayList<SparseVector>();
        if (this.summary != null) {
            children.add(this.summary);
        }
        return Collections.unmodifiableList(children);
    }

    @Generated
    public SparseVector getSummary() {
        return this.summary;
    }

    @Generated
    public int[] getDocIds() {
        return this.docIds;
    }

    @Generated
    public byte[] getWeights() {
        return this.weights;
    }

    @Generated
    public boolean isShouldNotSkip() {
        return this.shouldNotSkip;
    }

    @Generated
    public void setSummary(SparseVector summary) {
        this.summary = summary;
    }

    @Generated
    public void setShouldNotSkip(boolean shouldNotSkip) {
        this.shouldNotSkip = shouldNotSkip;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentCluster)) {
            return false;
        }
        DocumentCluster other = (DocumentCluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShouldNotSkip() != other.isShouldNotSkip()) {
            return false;
        }
        SparseVector this$summary = this.getSummary();
        SparseVector other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary)) {
            return false;
        }
        if (!Arrays.equals(this.getDocIds(), other.getDocIds())) {
            return false;
        }
        return Arrays.equals(this.getWeights(), other.getWeights());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentCluster;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShouldNotSkip() ? 79 : 97);
        SparseVector $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDocIds());
        result = result * 59 + Arrays.hashCode(this.getWeights());
        return result;
    }
}

