/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class McpStatelessSyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpStatelessSyncServer.class);
    private final McpStatelessAsyncServer asyncServer;
    private final boolean immediateExecution;

    McpStatelessSyncServer(McpStatelessAsyncServer asyncServer, boolean immediateExecution) {
        this.asyncServer = asyncServer;
        this.immediateExecution = immediateExecution;
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.asyncServer.getServerCapabilities();
    }

    public McpSchema.Implementation getServerInfo() {
        return this.asyncServer.getServerInfo();
    }

    public Mono<Void> closeGracefully() {
        return this.asyncServer.closeGracefully();
    }

    public void close() {
        this.asyncServer.close();
    }

    public void addTool(McpStatelessServerFeatures.SyncToolSpecification toolSpecification) {
        this.asyncServer.addTool(McpStatelessServerFeatures.AsyncToolSpecification.fromSync(toolSpecification, this.immediateExecution)).block();
    }

    public void removeTool(String toolName) {
        this.asyncServer.removeTool(toolName).block();
    }

    public void addResource(McpStatelessServerFeatures.SyncResourceSpecification resourceSpecification) {
        this.asyncServer.addResource(McpStatelessServerFeatures.AsyncResourceSpecification.fromSync(resourceSpecification, this.immediateExecution)).block();
    }

    public void removeResource(String resourceUri) {
        this.asyncServer.removeResource(resourceUri).block();
    }

    public void addPrompt(McpStatelessServerFeatures.SyncPromptSpecification promptSpecification) {
        this.asyncServer.addPrompt(McpStatelessServerFeatures.AsyncPromptSpecification.fromSync(promptSpecification, this.immediateExecution)).block();
    }

    public void removePrompt(String promptName) {
        this.asyncServer.removePrompt(promptName).block();
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.asyncServer.setProtocolVersions(protocolVersions);
    }
}

