/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch.indices.IndexSettingsMergePolicyName;
import org.opensearch.client.opensearch.indices.IndexSettingsMergeTieredPolicy;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class IndexSettingsMergePolicy
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<IndexSettingsMergePolicy> _DESERIALIZER = JsonpDeserializer.lazy(IndexSettingsMergePolicy::buildIndexSettingsMergePolicyDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private IndexSettingsMergePolicy(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private IndexSettingsMergePolicy(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static IndexSettingsMergePolicy of(Function<Builder, ObjectBuilder<IndexSettingsMergePolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isName() {
        return this._kind == Kind.Name;
    }

    public IndexSettingsMergePolicyName name() {
        return (IndexSettingsMergePolicyName)TaggedUnionUtils.get(this, Kind.Name);
    }

    public boolean isTieredPolicyConfig() {
        return this._kind == Kind.TieredPolicyConfig;
    }

    public IndexSettingsMergeTieredPolicy tieredPolicyConfig() {
        return (IndexSettingsMergeTieredPolicy)TaggedUnionUtils.get(this, Kind.TieredPolicyConfig);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<IndexSettingsMergePolicy> buildIndexSettingsMergePolicyDeserializer() {
        return new UnionDeserializer.Builder<IndexSettingsMergePolicy, Kind, Object>(IndexSettingsMergePolicy::new, false).addMember(Kind.Name, IndexSettingsMergePolicyName._DESERIALIZER).addMember(Kind.TieredPolicyConfig, IndexSettingsMergeTieredPolicy._DESERIALIZER).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSettingsMergePolicy other = (IndexSettingsMergePolicy)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexSettingsMergePolicy> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(IndexSettingsMergePolicy o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<IndexSettingsMergePolicy> name(IndexSettingsMergePolicyName v) {
            this._kind = Kind.Name;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IndexSettingsMergePolicy> tieredPolicyConfig(IndexSettingsMergeTieredPolicy v) {
            this._kind = Kind.TieredPolicyConfig;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IndexSettingsMergePolicy> tieredPolicyConfig(Function<IndexSettingsMergeTieredPolicy.Builder, ObjectBuilder<IndexSettingsMergeTieredPolicy>> fn) {
            return this.tieredPolicyConfig(fn.apply(new IndexSettingsMergeTieredPolicy.Builder()).build());
        }

        @Override
        public IndexSettingsMergePolicy build() {
            this._checkSingleUse();
            return new IndexSettingsMergePolicy(this);
        }
    }

    public static enum Kind {
        Name,
        TieredPolicyConfig;

    }
}

