/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.stats.upload;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.geospatial.stats.upload.UploadMetric;

public final class UploadStats
implements Writeable,
ToXContentObject {
    private static final UploadStats instance = new UploadStats();
    private final Set<UploadMetric> metrics = new HashSet<UploadMetric>();
    private final CounterMetric totalAPICount = new CounterMetric();

    public static UploadStats getInstance() {
        return instance;
    }

    UploadStats() {
    }

    public static UploadStats fromStreamInput(StreamInput input) throws IOException {
        Objects.requireNonNull(input, "StreamInput cannot be null");
        UploadStats instance = new UploadStats();
        instance.totalAPICount.inc(input.readVLong());
        instance.metrics.addAll(input.readSet(UploadMetric.UploadMetricBuilder::fromStreamInput));
        return instance;
    }

    public void addMetric(UploadMetric newMetric) {
        Objects.requireNonNull(newMetric, "metric cannot be null");
        if (this.metrics.contains(newMetric)) {
            throw new IllegalArgumentException(newMetric.getMetricID() + " already exists");
        }
        if (newMetric.getUploadCount() < 1L) {
            throw new IllegalArgumentException("metric should have at least 1 upload");
        }
        this.metrics.add(newMetric);
    }

    public void incrementAPICount() {
        this.totalAPICount.inc();
    }

    public long getTotalAPICount() {
        return this.totalAPICount.count();
    }

    public List<UploadMetric> getMetrics() {
        return List.copyOf(this.metrics);
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeVLong(this.getTotalAPICount());
        output.writeCollection(this.metrics);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELDS.REQUEST_COUNT.toString(), this.getTotalAPICount());
        builder.startArray(FIELDS.METRICS.toString());
        for (UploadMetric metric : this.metrics) {
            builder.startObject();
            metric.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public static enum FIELDS {
        METRICS,
        REQUEST_COUNT;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

