/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.mqtt5.QOS;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class ConnAckPacket {
    private boolean sessionPresent;
    private ConnectReasonCode reasonCode;
    private Long sessionExpiryIntervalSeconds;
    private Integer receiveMaximum;
    private QOS maximumQOS;
    private Boolean retainAvailable;
    private Long maximumPacketSize;
    private String assignedClientIdentifier;
    private Integer topicAliasMaximum;
    private String reasonString;
    private List<UserProperty> userProperties;
    private Boolean wildcardSubscriptionsAvailable;
    private Boolean subscriptionIdentifiersAvailable;
    private Boolean sharedSubscriptionsAvailable;
    private Integer serverKeepAlive;
    private String responseInformation;
    private String serverReference;

    public boolean getSessionPresent() {
        return this.sessionPresent;
    }

    public ConnectReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public Long getSessionExpiryIntervalSeconds() {
        return this.sessionExpiryIntervalSeconds;
    }

    public Long getSessionExpiryInterval() {
        return this.getSessionExpiryIntervalSeconds();
    }

    public Integer getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public QOS getMaximumQOS() {
        return this.maximumQOS;
    }

    public Boolean getRetainAvailable() {
        return this.retainAvailable;
    }

    public Long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public String getAssignedClientIdentifier() {
        return this.assignedClientIdentifier;
    }

    public Integer getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public String getReasonString() {
        return this.reasonString;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public Boolean getWildcardSubscriptionsAvailable() {
        return this.wildcardSubscriptionsAvailable;
    }

    public Boolean getSubscriptionIdentifiersAvailable() {
        return this.subscriptionIdentifiersAvailable;
    }

    public Boolean getSharedSubscriptionsAvailable() {
        return this.sharedSubscriptionsAvailable;
    }

    public Integer getServerKeepAliveSeconds() {
        return this.serverKeepAlive;
    }

    public Integer getServerKeepAlive() {
        return this.getServerKeepAliveSeconds();
    }

    public String getResponseInformation() {
        return this.responseInformation;
    }

    public String getServerReference() {
        return this.serverReference;
    }

    private void nativeAddMaximumQOS(int QOSValue) {
        this.maximumQOS = QOS.getEnumValueFromInteger(QOSValue);
    }

    private void nativeAddReasonCode(int reasonCode) {
        this.reasonCode = ConnectReasonCode.getEnumValueFromInteger(reasonCode);
    }

    public static enum ConnectReasonCode {
        SUCCESS(0),
        UNSPECIFIED_ERROR(128),
        MALFORMED_PACKET(129),
        PROTOCOL_ERROR(130),
        IMPLEMENTATION_SPECIFIC_ERROR(131),
        UNSUPPORTED_PROTOCOL_VERSION(132),
        CLIENT_IDENTIFIER_NOT_VALID(133),
        BAD_USERNAME_OR_PASSWORD(134),
        NOT_AUTHORIZED(135),
        SERVER_UNAVAILABLE(136),
        SERVER_BUSY(137),
        BANNED(138),
        BAD_AUTHENTICATION_METHOD(140),
        TOPIC_NAME_INVALID(144),
        PACKET_TOO_LARGE(149),
        QUOTA_EXCEEDED(151),
        PAYLOAD_FORMAT_INVALID(153),
        RETAIN_NOT_SUPPORTED(154),
        QOS_NOT_SUPPORTED(155),
        USE_ANOTHER_SERVER(156),
        SERVER_MOVED(157),
        CONNECTION_RATE_EXCEEDED(159);

        private int reasonCode;
        private static Map<Integer, ConnectReasonCode> enumMapping;

        private ConnectReasonCode(int code) {
            this.reasonCode = code;
        }

        public int getValue() {
            return this.reasonCode;
        }

        public static ConnectReasonCode getEnumValueFromInteger(int value) {
            ConnectReasonCode enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal ConnectReasonCode");
        }

        private static Map<Integer, ConnectReasonCode> buildEnumMapping() {
            return Stream.of(ConnectReasonCode.values()).collect(Collectors.toMap(ConnectReasonCode::getValue, Function.identity()));
        }

        static {
            enumMapping = ConnectReasonCode.buildEnumMapping();
        }
    }
}

