/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.replication.task.CrossClusterReplicationTask;
import org.opensearch.replication.task.IndexCloseListener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/replication/task/IndexCloseListener;", "Lorg/opensearch/index/shard/IndexEventListener;", "()V", "tasks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lorg/opensearch/replication/task/CrossClusterReplicationTask;", "addCloseListener", "", "indexOrShardId", "task", "beforeIndexRemoved", "indexService", "Lorg/opensearch/index/IndexService;", "reason", "Lorg/opensearch/indices/cluster/IndicesClusterStateService$AllocatedIndices$IndexRemovalReason;", "beforeIndexShardClosed", "shardId", "Lorg/opensearch/core/index/shard/ShardId;", "indexShard", "Lorg/opensearch/index/shard/IndexShard;", "indexSettings", "Lorg/opensearch/common/settings/Settings;", "removeCloseListener", "opensearch-cross-cluster-replication"})
public final class IndexCloseListener
implements IndexEventListener {
    @NotNull
    public static final IndexCloseListener INSTANCE = new IndexCloseListener();
    @NotNull
    private static final ConcurrentHashMap<Object, Set<CrossClusterReplicationTask>> tasks = new ConcurrentHashMap();

    private IndexCloseListener() {
    }

    public final void addCloseListener(@NotNull Object indexOrShardId, @NotNull CrossClusterReplicationTask task) {
        Intrinsics.checkNotNullParameter((Object)indexOrShardId, (String)"indexOrShardId");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        if (!(indexOrShardId instanceof String || indexOrShardId instanceof ShardId)) {
            boolean bl = false;
            String string = "Can't register a close listener for " + indexOrShardId + ". Only Index or ShardIds are allowed.";
            throw new IllegalArgumentException(string.toString());
        }
        tasks.computeIfAbsent(indexOrShardId, arg_0 -> IndexCloseListener.addCloseListener$lambda$1(addCloseListener.2.INSTANCE, arg_0)).add(task);
    }

    public final void removeCloseListener(@NotNull Object indexOrShardId, @NotNull CrossClusterReplicationTask task) {
        Intrinsics.checkNotNullParameter((Object)indexOrShardId, (String)"indexOrShardId");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        tasks.computeIfPresent(indexOrShardId, (arg_0, arg_1) -> IndexCloseListener.removeCloseListener$lambda$2((Function2)new Function2<Object, Set<CrossClusterReplicationTask>, Set<CrossClusterReplicationTask>>(task){
            final /* synthetic */ CrossClusterReplicationTask $task;
            {
                this.$task = $task;
                super(2);
            }

            @Nullable
            public final Set<CrossClusterReplicationTask> invoke(@NotNull Object object, @NotNull Set<CrossClusterReplicationTask> v) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(v, (String)"v");
                v.remove((Object)((Object)this.$task));
                return v.isEmpty() ? null : v;
            }
        }, arg_0, arg_1));
    }

    public void beforeIndexShardClosed(@NotNull ShardId shardId, @Nullable IndexShard indexShard, @NotNull Settings indexSettings) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        Intrinsics.checkNotNullParameter((Object)indexSettings, (String)"indexSettings");
        super.beforeIndexShardClosed(shardId, indexShard, indexSettings);
        Set<CrossClusterReplicationTask> tasksToCancel = tasks.remove(shardId);
        if (tasksToCancel != null) {
            for (CrossClusterReplicationTask task : tasksToCancel) {
                task.onIndexShardClosed(shardId, indexShard, indexSettings);
            }
        }
    }

    public void beforeIndexRemoved(@NotNull IndexService indexService, @NotNull IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        Intrinsics.checkNotNullParameter((Object)indexService, (String)"indexService");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super.beforeIndexRemoved(indexService, reason);
        Set<CrossClusterReplicationTask> tasksToCancel = tasks.remove(indexService.index().getName());
        if (tasksToCancel != null) {
            for (CrossClusterReplicationTask task : tasksToCancel) {
                task.onIndexRemoved(indexService, reason);
            }
        }
    }

    private static final Set addCloseListener$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set removeCloseListener$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0, p1);
    }
}

