/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.execution.TaskSelectionResult;
import org.jspecify.annotations.Nullable;

public class TaskNameResolver {
    public boolean tryFindUnqualifiedTaskCheaply(String name, ProjectInternal project) {
        for (Project project1 : project.getAllprojects()) {
            if (!project1.getTasks().getNames().contains(name)) continue;
            return true;
        }
        return false;
    }

    public @Nullable TaskSelectionResult selectWithName(final String taskName, ProjectState project, boolean includeSubProjects) {
        if (includeSubProjects) {
            LinkedHashSet<Task> tasks = new LinkedHashSet<Task>();
            new MultiProjectTaskSelectionResult(taskName, project, false).collectTasks(tasks);
            if (!tasks.isEmpty()) {
                return new FixedTaskSelectionResult(tasks);
            }
        } else {
            final ProjectInternal mutableProject = project.getMutableModel();
            TaskNameResolver.discoverTasks(mutableProject);
            if (TaskNameResolver.hasTask(taskName, mutableProject)) {
                return new TaskSelectionResult(){

                    @Override
                    public void collectTasks(Collection<? super Task> tasks) {
                        tasks.add(TaskNameResolver.getExistingTask(mutableProject, taskName));
                    }
                };
            }
        }
        return null;
    }

    public Map<String, TaskSelectionResult> selectAll(ProjectState project, boolean includeSubProjects) {
        LinkedHashMap<String, TaskSelectionResult> selected = new LinkedHashMap<String, TaskSelectionResult>();
        if (includeSubProjects) {
            LinkedHashSet<String> taskNames = new LinkedHashSet<String>();
            TaskNameResolver.collectTaskNames(project, taskNames);
            for (String taskName : taskNames) {
                selected.put(taskName, new MultiProjectTaskSelectionResult(taskName, project, true));
            }
        } else {
            ProjectInternal mutableProject = project.getMutableModel();
            TaskNameResolver.discoverTasks(mutableProject);
            for (String taskName : mutableProject.getTasks().getNames()) {
                selected.put(taskName, new SingleProjectTaskSelectionResult(taskName, mutableProject.getTasks()));
            }
        }
        return selected;
    }

    private static void discoverTasks(ProjectInternal project) {
        try {
            project.getTasks().discoverTasks();
        }
        catch (Throwable e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project.getDisplayName()), e);
        }
    }

    private static boolean hasTask(String taskName, ProjectInternal project) {
        return project.getTasks().getNames().contains(taskName) || project.getTasks().findByName(taskName) != null;
    }

    private static TaskInternal getExistingTask(ProjectInternal project, String taskName) {
        try {
            return (TaskInternal)project.getTasks().getByName(taskName);
        }
        catch (Throwable e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project.getDisplayName()), e);
        }
    }

    private static void collectTaskNames(ProjectState project, Set<String> result) {
        ProjectInternal mutableProject = project.getMutableModel();
        TaskNameResolver.discoverTasks(mutableProject);
        result.addAll(mutableProject.getTasks().getNames());
        for (ProjectState subProject : project.getChildProjects()) {
            TaskNameResolver.collectTaskNames(subProject, result);
        }
    }

    private static class MultiProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final ProjectState project;
        private final String taskName;
        private final boolean discovered;

        MultiProjectTaskSelectionResult(String taskName, ProjectState project, boolean discovered) {
            this.project = project;
            this.taskName = taskName;
            this.discovered = discovered;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            this.collect(this.project, tasks);
        }

        private void collect(ProjectState project, Collection<? super Task> tasks) {
            ProjectInternal mutableProject = project.getMutableModel();
            if (!this.discovered) {
                TaskNameResolver.discoverTasks(mutableProject);
            }
            if (TaskNameResolver.hasTask(this.taskName, mutableProject)) {
                TaskInternal task = TaskNameResolver.getExistingTask(mutableProject, this.taskName);
                tasks.add(task);
                if (task.getImpliesSubProjects()) {
                    return;
                }
            }
            for (ProjectState subProject : project.getChildProjects()) {
                this.collect(subProject, tasks);
            }
        }
    }

    private static class FixedTaskSelectionResult
    implements TaskSelectionResult {
        private final Collection<Task> tasks;

        FixedTaskSelectionResult(Collection<Task> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.addAll(this.tasks);
        }
    }

    private static class SingleProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final TaskContainer taskContainer;
        private final String taskName;

        SingleProjectTaskSelectionResult(String taskName, TaskContainer tasksContainer) {
            this.taskContainer = tasksContainer;
            this.taskName = taskName;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.add((Task)this.taskContainer.getByName(this.taskName));
        }
    }
}

